/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.assurance.evidences;

import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.date.SimpleDate;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.assurance.evidences.PersonalNumber;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.assurance.evidences.ReferenceNumber;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.assurance.evidences.VouchType;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.assurance.evidences.Voucher;
import com.dataiku.dss.shadelibazure.net.minidev.json.JSONObject;
import java.util.Objects;

public class Attestation {
    private final VouchType type;
    private final ReferenceNumber referenceNumber;
    private final PersonalNumber personalNumber;
    private final SimpleDate dateOfIssuance;
    private final SimpleDate dateOfExpiry;
    private final Voucher voucher;

    public Attestation(VouchType type, ReferenceNumber referenceNumber, PersonalNumber personalNumber, SimpleDate dateOfIssuance, SimpleDate dateOfExpiry, Voucher voucher) {
        Objects.requireNonNull(type);
        this.type = type;
        this.referenceNumber = referenceNumber;
        this.personalNumber = personalNumber;
        this.dateOfIssuance = dateOfIssuance;
        this.dateOfExpiry = dateOfExpiry;
        this.voucher = voucher;
    }

    public VouchType getType() {
        return this.type;
    }

    public ReferenceNumber getReferenceNumber() {
        return this.referenceNumber;
    }

    public PersonalNumber getPersonalNumber() {
        return this.personalNumber;
    }

    public SimpleDate getDateOfIssuance() {
        return this.dateOfIssuance;
    }

    public SimpleDate getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public Voucher getVoucher() {
        return this.voucher;
    }

    public JSONObject toJSONObject() {
        JSONObject voucherObject;
        JSONObject o = new JSONObject();
        o.put("type", this.getType().getValue());
        if (this.getReferenceNumber() != null) {
            o.put("reference_number", this.getReferenceNumber().getValue());
        }
        if (this.getPersonalNumber() != null) {
            o.put("personal_number", this.getPersonalNumber().getValue());
        }
        if (this.getDateOfIssuance() != null) {
            o.put("date_of_issuance", this.getDateOfIssuance().toISO8601String());
        }
        if (this.getDateOfExpiry() != null) {
            o.put("date_of_expiry", this.getDateOfExpiry().toISO8601String());
        }
        if (this.getVoucher() != null && !(voucherObject = this.getVoucher().toJSONObject()).isEmpty()) {
            o.put("voucher", voucherObject);
        }
        return o;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attestation)) {
            return false;
        }
        Attestation that = (Attestation)o;
        return this.getType().equals(that.getType()) && Objects.equals(this.getReferenceNumber(), that.getReferenceNumber()) && Objects.equals(this.getPersonalNumber(), that.getPersonalNumber()) && Objects.equals(this.getDateOfIssuance(), that.getDateOfIssuance()) && Objects.equals(this.getDateOfExpiry(), that.getDateOfExpiry()) && Objects.equals(this.getVoucher(), that.getVoucher());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getReferenceNumber(), this.getPersonalNumber(), this.getDateOfIssuance(), this.getDateOfExpiry(), this.getVoucher());
    }

    public static Attestation parse(JSONObject jsonObject) throws ParseException {
        try {
            VouchType type = new VouchType(JSONObjectUtils.getString(jsonObject, "type"));
            ReferenceNumber referenceNumber = null;
            if (jsonObject.get("reference_number") != null) {
                referenceNumber = new ReferenceNumber(JSONObjectUtils.getString(jsonObject, "reference_number"));
            }
            PersonalNumber personalNumber = null;
            if (jsonObject.get("personal_number") != null) {
                personalNumber = new PersonalNumber(JSONObjectUtils.getString(jsonObject, "personal_number"));
            }
            SimpleDate dateOfIssuance = null;
            if (jsonObject.get("date_of_issuance") != null) {
                dateOfIssuance = SimpleDate.parseISO8601String(JSONObjectUtils.getString(jsonObject, "date_of_issuance"));
            }
            SimpleDate dateOfExpiry = null;
            if (jsonObject.get("date_of_expiry") != null) {
                dateOfExpiry = SimpleDate.parseISO8601String(JSONObjectUtils.getString(jsonObject, "date_of_expiry"));
            }
            Voucher voucher = null;
            if (jsonObject.get("voucher") != null) {
                voucher = Voucher.parse(JSONObjectUtils.getJSONObject(jsonObject, "voucher"));
            }
            return new Attestation(type, referenceNumber, personalNumber, dateOfIssuance, dateOfExpiry, voucher);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), e);
        }
    }
}

