/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Fuseable;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InnerOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InternalFluxOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.core.scheduler.Scheduler;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuple2;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuples;
import java.util.concurrent.TimeUnit;

final class FluxElapsed<T>
extends InternalFluxOperator<T, Tuple2<Long, T>>
implements Fuseable {
    final Scheduler scheduler;

    FluxElapsed(Flux<T> source2, Scheduler scheduler) {
        super(source2);
        this.scheduler = scheduler;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super Tuple2<Long, T>> actual) {
        return new ElapsedSubscriber(actual, this.scheduler);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_ON) {
            return this.scheduler;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class ElapsedSubscriber<T>
    implements InnerOperator<T, Tuple2<Long, T>>,
    Fuseable.QueueSubscription<Tuple2<Long, T>> {
        final CoreSubscriber<? super Tuple2<Long, T>> actual;
        final Scheduler scheduler;
        Subscription s;
        Fuseable.QueueSubscription<T> qs;
        long lastTime;

        ElapsedSubscriber(CoreSubscriber<? super Tuple2<Long, T>> actual, Scheduler scheduler) {
            this.actual = actual;
            this.scheduler = scheduler;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.RUN_ON) {
                return this.scheduler;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.lastTime = this.scheduler.now(TimeUnit.MILLISECONDS);
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public CoreSubscriber<? super Tuple2<Long, T>> actual() {
            return this.actual;
        }

        @Override
        public void onNext(T t) {
            if (t == null) {
                this.actual.onNext(null);
                return;
            }
            this.actual.onNext(this.snapshot(t));
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        public int requestFusion(int requestedMode) {
            Fuseable.QueueSubscription qs = Operators.as(this.s);
            if (qs != null) {
                this.qs = qs;
                return qs.requestFusion(requestedMode);
            }
            return 0;
        }

        Tuple2<Long, T> snapshot(T data) {
            long now = this.scheduler.now(TimeUnit.MILLISECONDS);
            long last = this.lastTime;
            this.lastTime = now;
            long delta = now - last;
            return Tuples.of(delta, data);
        }

        @Override
        @Nullable
        public Tuple2<Long, T> poll() {
            Object data = this.qs.poll();
            if (data != null) {
                return this.snapshot(data);
            }
            return null;
        }

        @Override
        public int size() {
            return this.qs.size();
        }

        @Override
        public boolean isEmpty() {
            return this.qs.isEmpty();
        }

        @Override
        public void clear() {
            this.qs.clear();
        }
    }
}

