/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Fuseable;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.FluxNameFuseable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InternalFluxOperator;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuple2;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuples;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class FluxName<T>
extends InternalFluxOperator<T, T> {
    final String name;
    final Set<Tuple2<String, String>> tags;

    static <T> Flux<T> createOrAppend(Flux<T> source2, String name) {
        Objects.requireNonNull(name, "name");
        if (source2 instanceof FluxName) {
            FluxName s = (FluxName)source2;
            return new FluxName<T>(s.source, name, s.tags);
        }
        if (source2 instanceof FluxNameFuseable) {
            FluxNameFuseable s = (FluxNameFuseable)source2;
            return new FluxNameFuseable(s.source, name, s.tags);
        }
        if (source2 instanceof Fuseable) {
            return new FluxNameFuseable<T>(source2, name, null);
        }
        return new FluxName<T>(source2, name, null);
    }

    static <T> Flux<T> createOrAppend(Flux<T> source2, String tagName, String tagValue) {
        Objects.requireNonNull(tagName, "tagName");
        Objects.requireNonNull(tagValue, "tagValue");
        Set<Tuple2<String, String>> tags = Collections.singleton(Tuples.of(tagName, tagValue));
        if (source2 instanceof FluxName) {
            FluxName s = (FluxName)source2;
            if (s.tags != null) {
                tags = new HashSet<Tuple2<String, String>>(tags);
                tags.addAll(s.tags);
            }
            return new FluxName<T>(s.source, s.name, tags);
        }
        if (source2 instanceof FluxNameFuseable) {
            FluxNameFuseable s = (FluxNameFuseable)source2;
            if (s.tags != null) {
                tags = new HashSet<Tuple2<String, String>>(tags);
                tags.addAll(s.tags);
            }
            return new FluxNameFuseable(s.source, s.name, tags);
        }
        if (source2 instanceof Fuseable) {
            return new FluxNameFuseable<T>(source2, null, tags);
        }
        return new FluxName<T>(source2, null, tags);
    }

    FluxName(Flux<? extends T> source2, @Nullable String name, @Nullable Set<Tuple2<String, String>> tags) {
        super(source2);
        this.name = name;
        this.tags = tags;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return actual;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.NAME) {
            return this.name;
        }
        if (key == Scannable.Attr.TAGS && this.tags != null) {
            return this.tags.stream();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

