/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.Disposable;
import com.dataiku.dss.shadelibazure.reactor.core.Exceptions;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InnerConsumer;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;

final class LambdaMonoSubscriber<T>
implements InnerConsumer<T>,
Disposable {
    final Consumer<? super T> consumer;
    final Consumer<? super Throwable> errorConsumer;
    final Runnable completeConsumer;
    final Consumer<? super Subscription> subscriptionConsumer;
    final Context initialContext;
    volatile Subscription subscription;
    static final AtomicReferenceFieldUpdater<LambdaMonoSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(LambdaMonoSubscriber.class, Subscription.class, "subscription");

    LambdaMonoSubscriber(@Nullable Consumer<? super T> consumer, @Nullable Consumer<? super Throwable> errorConsumer, @Nullable Runnable completeConsumer, @Nullable Consumer<? super Subscription> subscriptionConsumer, @Nullable Context initialContext) {
        this.consumer = consumer;
        this.errorConsumer = errorConsumer;
        this.completeConsumer = completeConsumer;
        this.subscriptionConsumer = subscriptionConsumer;
        this.initialContext = initialContext == null ? Context.empty() : initialContext;
    }

    LambdaMonoSubscriber(@Nullable Consumer<? super T> consumer, @Nullable Consumer<? super Throwable> errorConsumer, @Nullable Runnable completeConsumer, @Nullable Consumer<? super Subscription> subscriptionConsumer) {
        this(consumer, errorConsumer, completeConsumer, subscriptionConsumer, null);
    }

    @Override
    public Context currentContext() {
        return this.initialContext;
    }

    @Override
    public final void onSubscribe(Subscription s) {
        if (Operators.validate(this.subscription, s)) {
            this.subscription = s;
            if (this.subscriptionConsumer != null) {
                try {
                    this.subscriptionConsumer.accept(s);
                }
                catch (Throwable t) {
                    Exceptions.throwIfFatal(t);
                    s.cancel();
                    this.onError(t);
                }
            } else {
                s.request(Long.MAX_VALUE);
            }
        }
    }

    @Override
    public final void onComplete() {
        Subscription s = S.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            return;
        }
        if (this.completeConsumer != null) {
            try {
                this.completeConsumer.run();
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t, this.initialContext);
            }
        }
    }

    @Override
    public final void onError(Throwable t) {
        Subscription s = S.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            Operators.onErrorDropped(t, this.initialContext);
            return;
        }
        this.doError(t);
    }

    void doError(Throwable t) {
        if (this.errorConsumer != null) {
            this.errorConsumer.accept(t);
        } else {
            Operators.onErrorDropped(Exceptions.errorCallbackNotImplemented(t), this.initialContext);
        }
    }

    @Override
    public final void onNext(T x) {
        Subscription s = S.getAndSet(this, Operators.cancelledSubscription());
        if (s == Operators.cancelledSubscription()) {
            Operators.onNextDropped(x, this.initialContext);
            return;
        }
        if (this.consumer != null) {
            try {
                this.consumer.accept(x);
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                s.cancel();
                this.doError(t);
            }
        }
        if (this.completeConsumer != null) {
            try {
                this.completeConsumer.run();
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t, this.initialContext);
            }
        }
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.subscription;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return Integer.MAX_VALUE;
        }
        if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
            return this.isDisposed();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }

    @Override
    public boolean isDisposed() {
        return this.subscription == Operators.cancelledSubscription();
    }

    @Override
    public void dispose() {
        Subscription s = S.getAndSet(this, Operators.cancelledSubscription());
        if (s != null && s != Operators.cancelledSubscription()) {
            s.cancel();
        }
    }
}

