/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

final class MonoToCompletableFuture<T>
extends CompletableFuture<T>
implements CoreSubscriber<T> {
    final AtomicReference<Subscription> ref = new AtomicReference();
    final boolean cancelSourceOnNext;

    MonoToCompletableFuture(boolean sourceCanEmitMoreThanOnce) {
        this.cancelSourceOnNext = sourceCanEmitMoreThanOnce;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Subscription s;
        boolean cancelled = super.cancel(mayInterruptIfRunning);
        if (cancelled && (s = (Subscription)this.ref.getAndSet(null)) != null) {
            s.cancel();
        }
        return cancelled;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (Operators.validate(this.ref.getAndSet(s), s)) {
            s.request(Long.MAX_VALUE);
        } else {
            s.cancel();
        }
    }

    @Override
    public void onNext(T t) {
        Subscription s = this.ref.getAndSet(null);
        if (s != null) {
            this.complete(t);
            if (this.cancelSourceOnNext) {
                s.cancel();
            }
        } else {
            Operators.onNextDropped(t, this.currentContext());
        }
    }

    @Override
    public void onError(Throwable t) {
        if (this.ref.getAndSet(null) != null) {
            this.completeExceptionally(t);
        }
    }

    @Override
    public void onComplete() {
        if (this.ref.getAndSet(null) != null) {
            this.complete(null);
        }
    }

    @Override
    public Context currentContext() {
        return Context.empty();
    }
}

