/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http;

import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Counter;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.DistributionSummary;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Timer;
import com.dataiku.dss.shadelibazure.reactor.netty.Metrics;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.MeterKey;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.MicrometerChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.HttpMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.util.MapUtils;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MicrometerHttpMetricsRecorder
extends MicrometerChannelMetricsRecorder
implements HttpMetricsRecorder {
    protected static final String DATA_RECEIVED_TIME_DESCRIPTION = "Time spent in consuming incoming data";
    protected static final String DATA_SENT_TIME_DESCRIPTION = "Time spent in sending outgoing data";
    protected static final String RESPONSE_TIME_DESCRIPTION = "Total time for the request/response";
    protected final ConcurrentMap<MeterKey, Timer> dataReceivedTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    protected final ConcurrentMap<MeterKey, Timer> dataSentTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    protected final ConcurrentMap<MeterKey, Timer> responseTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    private final ConcurrentMap<MeterKey, DistributionSummary> dataReceivedCache = new ConcurrentHashMap<MeterKey, DistributionSummary>();
    private final ConcurrentMap<MeterKey, DistributionSummary> dataSentCache = new ConcurrentHashMap<MeterKey, DistributionSummary>();
    private final ConcurrentMap<MeterKey, Counter> errorsCache = new ConcurrentHashMap<MeterKey, Counter>();

    protected MicrometerHttpMetricsRecorder(String name, String protocol) {
        super(name, protocol);
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, String uri, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, null, null);
        DistributionSummary dataReceived = MapUtils.computeIfAbsent(this.dataReceivedCache, meterKey, key -> MicrometerHttpMetricsRecorder.filter(DistributionSummary.builder((String)(this.name() + ".data.received")).baseUnit("bytes").description("Amount of the data received, in bytes").tags(new String[]{"remote.address", address, "uri", uri}).register(Metrics.REGISTRY)));
        if (dataReceived != null) {
            dataReceived.record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, String uri, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, null, null);
        DistributionSummary dataSent = MapUtils.computeIfAbsent(this.dataSentCache, meterKey, key -> MicrometerHttpMetricsRecorder.filter(DistributionSummary.builder((String)(this.name() + ".data.sent")).baseUnit("bytes").description("Amount of the data sent, in bytes").tags(new String[]{"remote.address", address, "uri", uri}).register(Metrics.REGISTRY)));
        if (dataSent != null) {
            dataSent.record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress, String uri) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, null, null);
        Counter errors = MapUtils.computeIfAbsent(this.errorsCache, meterKey, key -> MicrometerHttpMetricsRecorder.filter(Counter.builder((String)(this.name() + ".errors")).description("Number of errors that occurred").tags(new String[]{"remote.address", address, "uri", uri}).register(Metrics.REGISTRY)));
        if (errors != null) {
            errors.increment();
        }
    }
}

