/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBufHolder;
import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelDuplexHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPromise;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpRequest;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponse;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponseStatus;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.LastHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http2.Http2StreamChannel;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Future;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.GenericFutureListener;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

abstract class AbstractHttpServerMetricsHandler
extends ChannelDuplexHandler {
    private static final Logger log = Loggers.getLogger(AbstractHttpServerMetricsHandler.class);
    boolean channelActivated;
    boolean channelOpened;
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final Function<String, String> methodTagValue;
    final Function<String, String> uriTagValue;
    static final Set<String> STANDARD_METHODS;
    static final String UNKNOWN_METHOD = "UNKNOWN";
    static final Function<String, String> DEFAULT_METHOD_TAG_VALUE;

    protected AbstractHttpServerMetricsHandler(@Nullable Function<String, String> methodTagValue, @Nullable Function<String, String> uriTagValue) {
        this.methodTagValue = methodTagValue == null ? DEFAULT_METHOD_TAG_VALUE : methodTagValue;
        this.uriTagValue = uriTagValue;
    }

    protected AbstractHttpServerMetricsHandler(AbstractHttpServerMetricsHandler copy) {
        this.channelActivated = copy.channelActivated;
        this.channelOpened = copy.channelOpened;
        this.dataReceived = copy.dataReceived;
        this.dataReceivedTime = copy.dataReceivedTime;
        this.dataSent = copy.dataSent;
        this.dataSentTime = copy.dataSentTime;
        this.methodTagValue = copy.methodTagValue;
        this.uriTagValue = copy.uriTagValue;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        block3: {
            if (!(ctx.channel() instanceof Http2StreamChannel) && this.recorder() instanceof MicrometerHttpServerMetricsRecorder) {
                try {
                    this.channelOpened = true;
                    this.recorder().recordServerConnectionOpened(ctx.channel().localAddress());
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                }
            }
        }
        ctx.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        block4: {
            if (!(ctx.channel() instanceof Http2StreamChannel) && this.recorder() instanceof MicrometerHttpServerMetricsRecorder) {
                try {
                    if (this.channelOpened) {
                        this.channelOpened = false;
                        this.recorder().recordServerConnectionClosed(ctx.channel().localAddress());
                    }
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                }
            }
        }
        this.recordInactiveConnectionOrStream(ctx.channel());
        ctx.fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        try {
            if (msg instanceof HttpResponse) {
                if (((HttpResponse)msg).status().equals(HttpResponseStatus.CONTINUE)) {
                    return;
                }
                this.dataSentTime = System.nanoTime();
            }
            this.dataSent += this.extractProcessedDataFromBuffer(msg);
            if (msg instanceof LastHttpContent) {
                promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                    block3: {
                        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
                        if (channelOps instanceof HttpServerOperations) {
                            HttpServerOperations ops = (HttpServerOperations)channelOps;
                            try {
                                this.recordWrite(ops, this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path), this.methodTagValue.apply(ops.method().name()), ops.status().codeAsText().toString());
                            }
                            catch (RuntimeException e) {
                                if (!log.isWarnEnabled()) break block3;
                                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                            }
                        }
                    }
                    this.recordInactiveConnectionOrStream(ctx.channel());
                    this.dataSent = 0L;
                }));
            }
        }
        catch (RuntimeException e) {
            if (log.isWarnEnabled()) {
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        finally {
            ctx.write(msg, promise);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block7: {
            try {
                if (msg instanceof HttpRequest) {
                    this.dataReceivedTime = System.nanoTime();
                    this.channelActivated = true;
                    if (ctx.channel() instanceof Http2StreamChannel) {
                        this.recordOpenStream(ctx.channel().localAddress());
                    } else {
                        this.recordActiveConnection(ctx.channel().localAddress());
                    }
                }
                this.dataReceived += this.extractProcessedDataFromBuffer(msg);
                if (msg instanceof LastHttpContent) {
                    ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
                    if (channelOps instanceof HttpServerOperations) {
                        HttpServerOperations ops = (HttpServerOperations)channelOps;
                        this.recordRead(ops, this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path), this.methodTagValue.apply(ops.method().name()));
                    }
                    this.dataReceived = 0L;
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block7;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        block3: {
            try {
                ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
                if (channelOps instanceof HttpServerOperations) {
                    HttpServerOperations ops = (HttpServerOperations)channelOps;
                    this.recordException(ops, this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path));
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireExceptionCaught(cause);
    }

    protected abstract HttpServerMetricsRecorder recorder();

    private long extractProcessedDataFromBuffer(Object msg) {
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        return 0L;
    }

    protected void recordException(HttpServerOperations ops, String path) {
        this.recorder().incrementErrorsCount(ops.remoteSocketAddress(), path);
    }

    protected void recordRead(HttpServerOperations ops, String path, String method) {
        this.recorder().recordDataReceivedTime(path, method, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordDataReceived(ops.remoteSocketAddress(), path, this.dataReceived);
    }

    protected void recordWrite(HttpServerOperations ops, String path, String method, String status) {
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - this.dataSentTime);
        this.recorder().recordDataSentTime(path, method, status, dataSentTimeDuration);
        if (this.dataReceivedTime != 0L) {
            this.recorder().recordResponseTime(path, method, status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        } else {
            this.recorder().recordResponseTime(path, method, status, dataSentTimeDuration);
        }
        this.recorder().recordDataSent(ops.remoteSocketAddress(), path, this.dataSent);
    }

    protected void recordActiveConnection(SocketAddress localAddress) {
        this.recorder().recordServerConnectionActive(localAddress);
    }

    protected void recordInactiveConnection(SocketAddress localAddress) {
        this.recorder().recordServerConnectionInactive(localAddress);
    }

    protected void recordOpenStream(SocketAddress localAddress) {
        this.recorder().recordStreamOpened(localAddress);
    }

    protected void recordClosedStream(SocketAddress localAddress) {
        this.recorder().recordStreamClosed(localAddress);
    }

    void recordInactiveConnectionOrStream(Channel channel) {
        block5: {
            if (this.channelActivated) {
                this.channelActivated = false;
                try {
                    if (channel instanceof Http2StreamChannel) {
                        this.recordClosedStream(channel.localAddress());
                    } else {
                        this.recordInactiveConnection(channel.localAddress());
                    }
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn(ReactorNetty.format(channel, "Exception caught while recording metrics."), e);
                }
            }
        }
    }

    static {
        HashSet<String> standardMethods = new HashSet<String>();
        standardMethods.add("GET");
        standardMethods.add("HEAD");
        standardMethods.add("POST");
        standardMethods.add("PUT");
        standardMethods.add("PATCH");
        standardMethods.add("DELETE");
        standardMethods.add("OPTIONS");
        standardMethods.add("TRACE");
        standardMethods.add("CONNECT");
        STANDARD_METHODS = Collections.unmodifiableSet(standardMethods);
        DEFAULT_METHOD_TAG_VALUE = m -> STANDARD_METHODS.contains(m) ? m : UNKNOWN_METHOD;
    }
}

