/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPipeline;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.ByteToMessageDecoder;
import com.dataiku.dss.shadelibazure.io.netty.handler.ssl.SslHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.NonSslRedirectHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.tcp.SslProvider;
import java.net.SocketAddress;
import java.util.List;
import javax.annotation.Nullable;

final class NonSslRedirectDetector
extends ByteToMessageDecoder {
    private static final int SSL_RECORD_HEADER_LENGTH = 5;
    private final SslProvider sslProvider;
    private final SocketAddress remoteAddress;
    private final boolean sslDebug;

    public NonSslRedirectDetector(SslProvider sslProvider, @Nullable SocketAddress remoteAddress, boolean sslDebug) {
        this.sslProvider = sslProvider;
        this.remoteAddress = remoteAddress;
        this.sslDebug = sslDebug;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 5) {
            return;
        }
        ChannelPipeline pipeline = ctx.pipeline();
        if (SslHandler.isEncrypted(in)) {
            this.sslProvider.addSslHandler(ctx.channel(), this.remoteAddress, this.sslDebug);
        } else {
            pipeline.addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.nonSslRedirectHandler", new NonSslRedirectHandler());
        }
        pipeline.remove(this);
    }
}

