/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.udp;

import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.util.NetUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpServer;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpServerConfig;
import java.net.InetSocketAddress;
import java.util.Collections;

final class UdpServerBind
extends UdpServer {
    static final UdpServerBind INSTANCE;
    final UdpServerConfig config;
    static final int DEFAULT_PORT;

    UdpServerBind() {
        this.config = new UdpServerConfig(Collections.singletonMap(ChannelOption.AUTO_READ, false), () -> new InetSocketAddress(NetUtil.LOCALHOST, DEFAULT_PORT));
    }

    UdpServerBind(UdpServerConfig config) {
        this.config = config;
    }

    @Override
    public Mono<? extends Connection> bind() {
        UdpServerConfig conf = this.configuration();
        ConnectionObserver observer = this.config.defaultConnectionObserver().then(this.config.connectionObserver());
        Mono<? extends Connection> mono = ConnectionProvider.newConnection().acquire(conf, observer, null, null);
        if (conf.doOnBind() != null) {
            mono = mono.doOnSubscribe(s -> conf.doOnBind().accept(conf));
        }
        return mono;
    }

    @Override
    public UdpServerConfig configuration() {
        return this.config;
    }

    @Override
    protected UdpServer duplicate() {
        return new UdpServerBind(new UdpServerConfig(this.config));
    }

    static {
        int port;
        INSTANCE = new UdpServerBind();
        String portStr = null;
        try {
            portStr = System.getenv("PORT");
            port = portStr != null ? Integer.parseInt(portStr) : 12012;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid environment variable [PORT=" + portStr + "].", e);
        }
        DEFAULT_PORT = port;
    }
}

