/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.delta;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.nimbusds.jose.util.Base64;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.internal.data.StructRow;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeltaReaderUtils {
    private static DateTimeFormatter dateFormatter = ISODateTimeFormat.dateHourMinuteSecondMillis().withZoneUTC();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.delta.reader.utils");

    private static String isoFormatReadableByDateFormat(long ts) {
        return dateFormatter.print(ts) + "Z";
    }

    private static String isoFormatReadableByDatetimeNoTzFormat(long ts) {
        return ISODateTimeFormat.dateHourMinuteSecondMillis().withZoneUTC().print(ts).replace("T", " ");
    }

    private static String isoFormatReadableByDateOnlyFormat(int epochDays) {
        return LocalDate.ofEpochDay(epochDays).format(java.time.format.DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static DeltaToDSSCellReader buildReader(int idx, StructField field, ColumnFactory columnFactory, SchemaColumn sc) {
        String name = field.getName();
        Column column = columnFactory.column(name);
        DeltaToDSSValueReader reader = DeltaReaderUtils.buildNonNullReader(idx, field, sc);
        return (deltaRow, dssRow) -> {
            Object value;
            Object object = value = deltaRow.isNullAt(idx) ? null : reader.convert(deltaRow);
            if (value == null) {
                dssRow.delete(column);
            } else if (value instanceof String) {
                dssRow.put(column, (String)value);
            } else if (value instanceof Number) {
                Number n = (Number)value;
                if (n instanceof Double || n instanceof Float) {
                    dssRow.put(column, n.doubleValue());
                } else {
                    dssRow.put(column, n.longValue());
                }
            } else if (value instanceof Boolean) {
                dssRow.put(column, ((Boolean)value).booleanValue());
            } else {
                dssRow.put(column, JSON.json((Object)value));
            }
        };
    }

    private static List<Object> nonNullArrayToObjects(ArrayValue array, DeltaToDSSValueConverter arrayContentConverter) {
        ColumnVector vector = array.getElements();
        ArrayList<Object> out = new ArrayList<Object>();
        for (int j = 0; j < vector.getSize(); ++j) {
            out.add(arrayContentConverter.convert(vector, j));
        }
        return out;
    }

    private static Map<Object, Object> nonNullMapToObjects(MapValue map, DeltaToDSSValueConverter mapKeysConverter, DeltaToDSSValueConverter mapValuesConverter) {
        ColumnVector keys = map.getKeys();
        ColumnVector values = map.getValues();
        HashMap<Object, Object> out = new HashMap<Object, Object>();
        for (int j = 0; j < keys.getSize(); ++j) {
            out.put(mapKeysConverter.convert(keys, j), mapValuesConverter.convert(values, j));
        }
        return out;
    }

    private static DeltaToDSSValueConverter buildConverter(DataType dataType, SchemaColumn sc) {
        if (dataType instanceof BooleanType) {
            return (v, i) -> v.isNullAt(i) ? null : Boolean.valueOf(v.getBoolean(i));
        }
        if (dataType instanceof ByteType) {
            return (v, i) -> v.isNullAt(i) ? null : Byte.valueOf(v.getByte(i));
        }
        if (dataType instanceof ShortType) {
            return (v, i) -> v.isNullAt(i) ? null : Short.valueOf(v.getShort(i));
        }
        if (dataType instanceof IntegerType) {
            return (v, i) -> v.isNullAt(i) ? null : Integer.valueOf(v.getInt(i));
        }
        if (dataType instanceof LongType) {
            return (v, i) -> v.isNullAt(i) ? null : Long.valueOf(v.getLong(i));
        }
        if (dataType instanceof FloatType) {
            return (v, i) -> v.isNullAt(i) ? null : Float.valueOf(v.getFloat(i));
        }
        if (dataType instanceof DoubleType) {
            return (v, i) -> v.isNullAt(i) ? null : Double.valueOf(v.getDouble(i));
        }
        if (dataType instanceof DecimalType) {
            return (v, i) -> v.isNullAt(i) ? null : v.getDecimal(i);
        }
        if (dataType instanceof StringType) {
            return (v, i) -> v.isNullAt(i) ? null : v.getString(i);
        }
        if (dataType instanceof DateType) {
            if (sc != null && sc.getType() == Type.DATE) {
                return (v, i) -> {
                    if (v.isNullAt(i)) {
                        return null;
                    }
                    return DeltaReaderUtils.isoFormatReadableByDateOnlyFormat(v.getInt(i)) + "T00:00:00.000Z";
                };
            }
            return (v, i) -> {
                if (v.isNullAt(i)) {
                    return null;
                }
                return DeltaReaderUtils.isoFormatReadableByDateOnlyFormat(v.getInt(i));
            };
        }
        if (dataType instanceof TimestampType) {
            return (v, i) -> {
                if (v.isNullAt(i)) {
                    return null;
                }
                return DeltaReaderUtils.isoFormatReadableByDateFormat(v.getLong(i) / 1000L);
            };
        }
        if (dataType instanceof TimestampNTZType) {
            return (v, i) -> {
                if (v.isNullAt(i)) {
                    return null;
                }
                return DeltaReaderUtils.isoFormatReadableByDatetimeNoTzFormat(v.getLong(i) / 1000L);
            };
        }
        if (dataType instanceof BinaryType) {
            return (v, i) -> {
                if (v.isNullAt(i)) {
                    return null;
                }
                byte[] bytes = v.getBinary(i);
                return Base64.encode((byte[])bytes).toString();
            };
        }
        if (dataType instanceof ArrayType) {
            DataType arrayContentType = ((ArrayType)dataType).getElementType();
            DeltaToDSSValueConverter arrayContentConverter = DeltaReaderUtils.buildConverter(arrayContentType, sc != null ? sc.arrayContent : null);
            return (v, i) -> {
                if (v.isNullAt(i)) {
                    return null;
                }
                return DeltaReaderUtils.nonNullArrayToObjects(v.getArray(i), arrayContentConverter);
            };
        }
        if (dataType instanceof MapType) {
            DataType mapKeysType = ((MapType)dataType).getKeyType();
            DataType mapValuesType = ((MapType)dataType).getValueType();
            DeltaToDSSValueConverter mapKeysConverter = DeltaReaderUtils.buildConverter(mapKeysType, sc != null ? sc.mapKeys : null);
            DeltaToDSSValueConverter mapValuesConverter = DeltaReaderUtils.buildConverter(mapValuesType, sc != null ? sc.mapValues : null);
            return (v, i) -> {
                if (v.isNullAt(i)) {
                    return null;
                }
                return DeltaReaderUtils.nonNullMapToObjects(v.getMap(i), mapKeysConverter, mapValuesConverter);
            };
        }
        if (dataType instanceof StructType) {
            HashMap<String, DeltaToDSSValueReader> fieldConverters = new HashMap<String, DeltaToDSSValueReader>();
            HashMap<String, Integer> fieldIndices = new HashMap<String, Integer>();
            List subFields = ((StructType)dataType).fields();
            for (int j = 0; j < subFields.size(); ++j) {
                StructField field = (StructField)subFields.get(j);
                fieldIndices.put(field.getName(), j);
                SchemaColumn subSc = sc != null && sc.objectFields != null ? sc.objectFields.stream().filter(c -> c.getName().equals(field.getName())).findFirst().orElseGet(() -> null) : null;
                fieldConverters.put(field.getName(), DeltaReaderUtils.buildNonNullReader(j, field, subSc));
            }
            return (v, i) -> {
                if (v.isNullAt(i)) {
                    return null;
                }
                StructRow record = StructRow.fromStructVector((ColumnVector)v, (int)i);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                for (Map.Entry e : fieldConverters.entrySet()) {
                    String fieldName = (String)e.getKey();
                    int fieldIdx = (Integer)fieldIndices.get(fieldName);
                    if (record.isNullAt(fieldIdx)) continue;
                    ret.put(fieldName, ((DeltaToDSSValueReader)e.getValue()).convert((io.delta.kernel.data.Row)record));
                }
                return ret;
            };
        }
        logger.warn((Object)("Unreadable type " + String.valueOf(dataType)));
        return (v, i) -> null;
    }

    private static DeltaToDSSValueReader buildNonNullReader(int idx, StructField field, SchemaColumn sc) {
        DataType dataType = field.getDataType();
        String name = field.getName();
        if (dataType instanceof BooleanType) {
            return deltaRow -> deltaRow.getBoolean(idx);
        }
        if (dataType instanceof ByteType) {
            return deltaRow -> deltaRow.getByte(idx);
        }
        if (dataType instanceof ShortType) {
            return deltaRow -> deltaRow.getShort(idx);
        }
        if (dataType instanceof IntegerType) {
            return deltaRow -> deltaRow.getInt(idx);
        }
        if (dataType instanceof LongType) {
            return deltaRow -> deltaRow.getLong(idx);
        }
        if (dataType instanceof FloatType) {
            return deltaRow -> Float.valueOf(deltaRow.getFloat(idx));
        }
        if (dataType instanceof DoubleType) {
            return deltaRow -> deltaRow.getDouble(idx);
        }
        if (dataType instanceof DecimalType) {
            return deltaRow -> {
                BigDecimal dec = deltaRow.getDecimal(idx);
                int scale = ((DecimalType)dataType).getScale();
                if (dec.scale() == 0 && scale > 0) {
                    return dec.scaleByPowerOfTen(-scale).doubleValue();
                }
                return dec.doubleValue();
            };
        }
        if (dataType instanceof DateType) {
            if (sc != null && sc.getType() == Type.DATE) {
                return deltaRow -> {
                    int epochDays = deltaRow.getInt(idx);
                    return DeltaReaderUtils.isoFormatReadableByDateOnlyFormat(epochDays) + "T00:00:00.000Z";
                };
            }
            return deltaRow -> {
                int epochDays = deltaRow.getInt(idx);
                return DeltaReaderUtils.isoFormatReadableByDateOnlyFormat(epochDays);
            };
        }
        if (dataType instanceof TimestampType) {
            return deltaRow -> {
                long timestamp = deltaRow.getLong(idx);
                return DeltaReaderUtils.isoFormatReadableByDateFormat(timestamp / 1000L);
            };
        }
        if (dataType instanceof TimestampNTZType) {
            return deltaRow -> {
                long timestamp = deltaRow.getLong(idx);
                return DeltaReaderUtils.isoFormatReadableByDatetimeNoTzFormat(timestamp / 1000L);
            };
        }
        if (dataType instanceof StringType) {
            return deltaRow -> deltaRow.getString(idx);
        }
        if (dataType instanceof BinaryType) {
            return deltaRow -> {
                byte[] bytes = deltaRow.getBinary(idx);
                return Base64.encode((byte[])bytes).toString();
            };
        }
        if (dataType instanceof ArrayType) {
            DataType arrayContentType = ((ArrayType)dataType).getElementType();
            DeltaToDSSValueConverter arrayContentConverter = DeltaReaderUtils.buildConverter(arrayContentType, sc != null ? sc.arrayContent : null);
            return deltaRow -> DeltaReaderUtils.nonNullArrayToObjects(deltaRow.getArray(idx), arrayContentConverter);
        }
        if (dataType instanceof MapType) {
            DataType mapKeysType = ((MapType)dataType).getKeyType();
            DataType mapValuesType = ((MapType)dataType).getValueType();
            DeltaToDSSValueConverter mapKeysConverter = DeltaReaderUtils.buildConverter(mapKeysType, sc != null ? sc.mapKeys : null);
            DeltaToDSSValueConverter mapValuesConverter = DeltaReaderUtils.buildConverter(mapValuesType, sc != null ? sc.mapValues : null);
            return deltaRow -> DeltaReaderUtils.nonNullMapToObjects(deltaRow.getMap(idx), mapKeysConverter, mapValuesConverter);
        }
        if (dataType instanceof StructType) {
            HashMap<String, DeltaToDSSValueReader> fieldConverters = new HashMap<String, DeltaToDSSValueReader>();
            HashMap<String, Integer> fieldIndices = new HashMap<String, Integer>();
            List subFields = ((StructType)dataType).fields();
            for (int j = 0; j < subFields.size(); ++j) {
                StructField subField = (StructField)subFields.get(j);
                fieldIndices.put(subField.getName(), j);
                SchemaColumn subSc = sc != null && sc.objectFields != null ? sc.objectFields.stream().filter(c -> c.getName().equals(field.getName())).findFirst().orElseGet(() -> null) : null;
                fieldConverters.put(subField.getName(), DeltaReaderUtils.buildNonNullReader(j, subField, subSc));
            }
            return deltaRow -> {
                io.delta.kernel.data.Row row = deltaRow.getStruct(idx);
                HashMap<String, Object> ret = new HashMap<String, Object>();
                for (Map.Entry e : fieldConverters.entrySet()) {
                    String fieldName = (String)e.getKey();
                    int fieldIdx = (Integer)fieldIndices.get(fieldName);
                    if (row.isNullAt(fieldIdx)) continue;
                    ret.put(fieldName, ((DeltaToDSSValueReader)e.getValue()).convert(row));
                }
                return ret;
            };
        }
        logger.warn((Object)("Unreadable type " + String.valueOf(dataType) + " for column " + name));
        return deltaRow -> null;
    }

    public static interface DeltaToDSSValueReader {
        public Object convert(io.delta.kernel.data.Row var1);
    }

    public static interface DeltaToDSSCellReader {
        public void convert(io.delta.kernel.data.Row var1, Row var2);
    }

    public static interface DeltaToDSSValueConverter {
        public Object convert(ColumnVector var1, int var2);
    }
}

