/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hive.udf.arrays;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class UDAFCollectToArray
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] tis) throws SemanticException {
        if (tis.length != 1) {
            throw new UDFArgumentTypeException(tis.length - 1, "Exactly one argument is expected.");
        }
        return new CollectToArrayEvaluator();
    }

    public static class CollectToArrayEvaluator
    extends GenericUDAFEvaluator {
        private ObjectInspector originalDataOI;
        private StandardListObjectInspector listOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.originalDataOI = parameters[0];
            } else if (m == GenericUDAFEvaluator.Mode.PARTIAL2 || m == GenericUDAFEvaluator.Mode.FINAL) {
                this.listOI = (StandardListObjectInspector)parameters[0];
                this.originalDataOI = this.listOI.getListElementObjectInspector();
            }
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.originalDataOI));
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer ab) throws HiveException {
            ((ArrayAggregationBuffer)ab).container.clear();
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new ArrayAggregationBuffer();
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer ab, Object[] parameters) throws HiveException {
            assert (parameters.length == 1);
            Object p = parameters[0];
            if (p != null) {
                ArrayAggregationBuffer agg = (ArrayAggregationBuffer)ab;
                agg.container.add(ObjectInspectorUtils.copyToStandardObject((Object)p, (ObjectInspector)this.originalDataOI));
            }
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer ab) throws HiveException {
            ArrayAggregationBuffer agg = (ArrayAggregationBuffer)ab;
            ArrayList<Object> ret = new ArrayList<Object>();
            ret.addAll(agg.container);
            return ret;
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer ab, Object p) throws HiveException {
            ArrayAggregationBuffer agg = (ArrayAggregationBuffer)ab;
            ArrayList partialResult = (ArrayList)this.listOI.getList(p);
            for (Object o : partialResult) {
                agg.container.add(ObjectInspectorUtils.copyToStandardObject(o, (ObjectInspector)this.originalDataOI));
            }
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer ab) throws HiveException {
            ArrayAggregationBuffer agg = (ArrayAggregationBuffer)ab;
            ArrayList<Object> ret = new ArrayList<Object>();
            ret.addAll(agg.container);
            return ret;
        }

        static class ArrayAggregationBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            ArrayList<Object> container = new ArrayList();

            ArrayAggregationBuffer() {
            }
        }
    }
}

