/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hive.udf.strings;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="string_subsequence", value="array<string> _FUNC_(string, sep, N, MAX) - split a string according to sep, generate all subsequences of size <= N up to MAX elements, and generate all corresponing strings joined by sep")
public class UDFStringSubSequences
extends GenericUDTF {
    private ObjectInspectorConverters.Converter[] converters;
    StringObjectInspector stringOI;
    WritableConstantIntObjectInspector intOI;
    private final Object[] forwardObj = new Object[1];
    protected ArrayList<String> buffer = new ArrayList();
    protected Joiner joiner = Joiner.on((String)" ");
    protected int count = 0;
    protected int max;

    public StructObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 4) {
            throw new IllegalArgumentException("Missing parameters, 4 needed");
        }
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        this.converters[0] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        this.converters[1] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[1], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        this.converters[2] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[2], (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        this.converters[3] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[3], (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<WritableStringObjectInspector> fieldOIs = new ArrayList<WritableStringObjectInspector>();
        fieldNames.add("col1");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    protected void forwardBuffer() throws HiveException {
        Text t = new Text(this.joiner.join(this.buffer));
        this.forwardObj[0] = t;
        this.forward(this.forwardObj);
        ++this.count;
    }

    protected void enumerateSubSequenceStartAt(int start, int n, String[] elts) throws HiveException {
        if (this.count >= this.max) {
            return;
        }
        this.buffer.add(elts[start]);
        this.forwardBuffer();
        if (this.buffer.size() < n) {
            for (int j = start + 1; j < n && j < elts.length; ++j) {
                this.enumerateSubSequenceStartAt(j, n, elts);
            }
        }
        this.buffer.remove(this.buffer.size() - 1);
    }

    protected void enumerateSubSequence(int n, String[] elts) throws HiveException {
        for (int i = 0; i < elts.length; ++i) {
            this.enumerateSubSequenceStartAt(i, n, elts);
        }
    }

    public void process(Object[] objects) throws HiveException {
        if (objects.length < 4) {
            return;
        }
        this.count = 0;
        this.buffer.clear();
        Text text = (Text)this.converters[0].convert(objects[0]);
        Text sep = (Text)this.converters[1].convert(objects[1]);
        IntWritable n = (IntWritable)this.converters[2].convert(objects[2]);
        IntWritable max = (IntWritable)this.converters[3].convert(objects[3]);
        this.max = max.get();
        this.enumerateSubSequence(n.get(), text.toString().split(sep.toString()));
    }

    public void close() throws HiveException {
    }
}

