/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hive.udf.window;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public abstract class UDAFFirstOrLastOfGroupAccordingTo
extends AbstractGenericUDAFResolver {
    protected void checkParameters(GenericUDAFParameterInfo info) throws SemanticException {
        if (info.getParameterObjectInspectors().length != 2) {
            throw new UDFArgumentException("Two arguments are required");
        }
        if (info.getParameterObjectInspectors()[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + info.getParameterObjectInspectors()[0].getTypeName() + " was passed in");
        }
        if (info.getParameterObjectInspectors()[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + info.getParameterObjectInspectors()[1].getTypeName() + " was passed in");
        }
    }

    public static abstract class BaseEvaluator
    extends GenericUDAFEvaluator {
        private ObjectInspector outColOI;
        private ObjectInspector sortColOI;
        private StructObjectInspector soi;
        StructField outField;
        StructField sortField;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                if (parameters.length != 2) {
                    throw new UDFArgumentException("It sucks " + parameters.length);
                }
                this.outColOI = (PrimitiveObjectInspector)parameters[0];
                this.sortColOI = (PrimitiveObjectInspector)parameters[1];
            } else {
                if (parameters.length != 1) {
                    throw new UDFArgumentException("It sucks " + parameters.length);
                }
                this.soi = (StructObjectInspector)parameters[0];
                this.outField = this.soi.getStructFieldRef("out");
                this.outColOI = this.outField.getFieldObjectInspector();
                this.sortField = this.soi.getStructFieldRef("sort");
                this.sortColOI = this.sortField.getFieldObjectInspector();
            }
            if (m == GenericUDAFEvaluator.Mode.FINAL || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                return this.outColOI;
            }
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add(ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.outColOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
            foi.add(ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.sortColOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
            ArrayList<String> fname = new ArrayList<String>();
            fname.add("out");
            fname.add("sort");
            return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            UDAFFOGATBuffer o = new UDAFFOGATBuffer();
            return o;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
            UDAFFOGATBuffer bbuf = (UDAFFOGATBuffer)buf;
            bbuf.outColKeptValue = null;
            bbuf.sortColKeptValue = null;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer buf, Object[] args) throws HiveException {
            UDAFFOGATBuffer bbuf = (UDAFFOGATBuffer)buf;
            Object outColVal = args[0];
            Object sortColVal = args[1];
            this.updateBuf(bbuf, outColVal, sortColVal);
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer buf, Object toMerge) throws HiveException {
            UDAFFOGATBuffer bbuf = (UDAFFOGATBuffer)buf;
            Object out = this.soi.getStructFieldData(toMerge, this.outField);
            Object sort = this.soi.getStructFieldData(toMerge, this.sortField);
            this.updateBuf(bbuf, out, sort);
        }

        protected abstract boolean needUpdate(int var1);

        private void updateBuf(UDAFFOGATBuffer bbuf, Object outColVal, Object sortColVal) {
            if (bbuf.sortColKeptValue == null) {
                bbuf.sortColKeptValue = ObjectInspectorUtils.copyToStandardObject((Object)sortColVal, (ObjectInspector)this.sortColOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                bbuf.outColKeptValue = ObjectInspectorUtils.copyToStandardObject((Object)outColVal, (ObjectInspector)this.outColOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            } else {
                int cmp = ObjectInspectorUtils.compare((Object)sortColVal, (ObjectInspector)this.sortColOI, (Object)bbuf.sortColKeptValue, (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.sortColOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
                if (this.needUpdate(cmp)) {
                    bbuf.sortColKeptValue = ObjectInspectorUtils.copyToStandardObject((Object)sortColVal, (ObjectInspector)this.sortColOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                    bbuf.outColKeptValue = ObjectInspectorUtils.copyToStandardObject((Object)outColVal, (ObjectInspector)this.outColOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                }
            }
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
            UDAFFOGATBuffer bbuf = (UDAFFOGATBuffer)buf;
            return bbuf.outColKeptValue;
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
            UDAFFOGATBuffer bbuf = (UDAFFOGATBuffer)buf;
            Object[] out = new Object[]{bbuf.outColKeptValue, bbuf.sortColKeptValue};
            return out;
        }

        static class UDAFFOGATBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            Object outColKeptValue;
            Object sortColKeptValue;

            UDAFFOGATBuffer() {
            }
        }
    }
}

