/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.remoterun.RemoteRunEnvHelper;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.ProxyUtils;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ApplicationConfigurator
extends DKUApp {
    private static boolean isInSparkDriver = false;
    public static final String INSTALL_DIR_PLUGINS_VAR = "${dku.install.dir.plugins}";
    protected static Logger logger = Logger.getLogger(ApplicationConfigurator.class);
    private static String productShortName_;
    private static DSSGitModel.GitMode gitMode;
    private static DSSGitModel.PluginGitMode pluginGitMode;

    public static void autoconfigure() {
        ApplicationConfigurator.ensureCorrectJavaVersionForDev();
        String dipHome = System.getenv("DIP_HOME");
        String installDir = System.getenv("DKUINSTALLDIR");
        if (dipHome != null && installDir != null) {
            ApplicationConfigurator.setBaseFolder((String)dipHome, (String)installDir);
            ProxyUtils.registerProxyAuthenticator(ApplicationConfigurator::getProxySettings);
        }
    }

    public static File getPreInstalledPluginsFolder() {
        if (StringUtils.isBlank((String)System.getenv("DSS_DEV"))) {
            return ApplicationConfigurator.getResourceFile((String)"plugins");
        }
        return ApplicationConfigurator.getInstallFile((String[])new String[]{"plugins"});
    }

    public static void autoconfigureEnv() {
        String dipHome = RemoteRunEnvHelper.getEnv("DIP_HOME");
        String installDir = RemoteRunEnvHelper.getEnv("DKUINSTALLDIR");
        if (dipHome != null && installDir != null) {
            ApplicationConfigurator.setBaseFolder((String)dipHome, (String)installDir);
        }
    }

    public static void configureFromEnvNoConfig() {
        String dipHome = RemoteRunEnvHelper.getEnv("DIP_HOME");
        String installDir = RemoteRunEnvHelper.getEnv("DKUINSTALLDIR");
        if (dipHome != null && installDir != null) {
            ApplicationConfigurator.configureNoConfig((String)dipHome, (String)installDir);
        }
    }

    public static File getDatabaseFile(String dbName) {
        if (baseFolderF == null) {
            throw new Error("DIP configuration not initialized, look for previous error");
        }
        if (StringUtils.isBlank((String)dbName)) {
            throw new IllegalArgumentException("Empty database name");
        }
        return new File(baseFolderF, "databases/" + dbName);
    }

    public static String productShortName() {
        if (productShortName_ != null) {
            return productShortName_;
        }
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettings();
        productShortName_ = gs.whiteLabeling == null ? "DSS" : gs.whiteLabeling.productShortName;
        return productShortName_;
    }

    public static boolean isSingleUser() {
        return ApplicationConfigurator.getParams().getBoolParam("singleUser", false);
    }

    public static boolean isAutomation() {
        return "automation".equals(RemoteRunEnvHelper.getEnv("DKU_NODE_TYPE"));
    }

    public static GeneralSettingsDAO.GeneralSettings getGeneralSettings() {
        GeneralSettingsDAO.GeneralSettings generalSettings;
        block9: {
            RelFile f = RelFile.global((String)"general-settings.json");
            TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
            assert (transactionService != null);
            Transaction t = transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);
            try {
                generalSettings = (GeneralSettingsDAO.GeneralSettings)t.readObjectDefault(f, GeneralSettingsDAO.GeneralSettings.class);
                if (t == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
            t.close();
        }
        return generalSettings;
    }

    public static GeneralSettingsDAO.GeneralSettings getGeneralSettingsUnsafeAutoTXN() {
        try {
            GeneralSettingsDAO bean = (GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class);
            SpringUtils.getInstance().autowire((Object)bean);
            return bean.getUnsafeAutoTXN();
        }
        catch (IOException e) {
            throw new Error("failed to get general settings", e);
        }
    }

    @Nonnull
    public static ProxySettings getProxySettings() {
        if (!ApplicationConfigurator.isInSparkDriver() && ApplicationConfigurator.getNodeType() != DSSNodeType.API) {
            PasswordEncryptionService cryptoService = SpringUtils.getInstance().hasBean(PasswordEncryptionService.class) ? (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class) : null;
            return ApplicationConfigurator.getProxySettings(cryptoService);
        }
        return new ProxySettings();
    }

    @Nonnull
    public static ProxySettings getProxySettings(PasswordEncryptionService cryptoService) {
        try {
            ProxySettings proxySettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().proxySettings.deepCopy();
            if (cryptoService != null) {
                proxySettings.decryptFields(cryptoService);
            }
            return proxySettings;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static PortRangeParams getPortRangeParams() {
        if (!FeatureFlags.isEnabled((String)"portRangeLimitation")) {
            return new PortRangeParams();
        }
        if (SpringUtils.getInstance().hasBean(GeneralSettingsDAO.class)) {
            try {
                return ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafeAutoTXN().dssPortRange;
            }
            catch (IOException e) {
                logger.warn((Object)"Error getting dssPortRange: using default instead.", (Throwable)e);
                return new PortRangeParams();
            }
        }
        return new PortRangeParams();
    }

    public static DSSNodeType getNodeType() {
        if (ApplicationConfigurator.isDevLambdaServer()) {
            return DSSNodeType.API;
        }
        String nodeType = RemoteRunEnvHelper.getEnv("DKU_NODE_TYPE");
        if (nodeType == null) {
            return DSSNodeType.DESIGN;
        }
        switch (nodeType.toLowerCase()) {
            case "design": {
                return DSSNodeType.DESIGN;
            }
            case "automation": {
                return DSSNodeType.AUTOMATION;
            }
            case "api": {
                return DSSNodeType.API;
            }
        }
        throw new Error("Unknown node type " + nodeType);
    }

    public static boolean isDevLambdaServer() {
        return !StringUtils.isBlank((String)RemoteRunEnvHelper.getEnv("DKU_LAMBDA_DEVSERVER"));
    }

    public static synchronized DSSGitModel.GitMode getGitMode() {
        if (gitMode == null) {
            String gitModeStr = DKUApp.getIniValue((String)"git", (String)"mode");
            if (gitModeStr == null) {
                throw new Error("'mode' not found in 'git' section of install.ini");
            }
            gitMode = DSSGitModel.GitMode.valueOf(gitModeStr.toUpperCase());
        }
        return gitMode;
    }

    public static synchronized DSSGitModel.PluginGitMode getPluginGitMode() {
        if (pluginGitMode == null) {
            String pluginGitModeStr = DKUApp.getIniValue((String)"git", (String)"plugindev-mode", (String)DSSGitModel.PluginGitMode.PLUGIN.toString());
            pluginGitMode = DSSGitModel.PluginGitMode.valueOf(pluginGitModeStr.toUpperCase());
        }
        return pluginGitMode;
    }

    public static boolean isInSparkDriver() {
        return isInSparkDriver;
    }

    public static void setInSparkDriver(boolean isInSparkDriver) {
        ApplicationConfigurator.isInSparkDriver = isInSparkDriver;
    }

    public static enum DSSNodeType {
        DESIGN,
        AUTOMATION,
        API;

    }
}

