/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.activity.UsageSummaryBuilderUtils;
import com.dataiku.dip.activity.UsageSummaryModel;
import com.dataiku.dip.activity.filterutils.FilterReportBuilder;
import com.dataiku.dip.activity.filterutils.FilterTraverser;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.InfraStage;
import com.dataiku.dip.apideployer.datamodel.config.PublishedItem;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsDAO;
import com.dataiku.dip.apideployer.deployments.FileBasedDeploymentsDAO;
import com.dataiku.dip.apideployer.deployments.ProjectDeploymentsDAO;
import com.dataiku.dip.apideployer.infra.ApiNodeInfrasDAO;
import com.dataiku.dip.apideployer.infra.AutomationNodeInfrasDAO;
import com.dataiku.dip.apideployer.infra.FilesBasedDeploymentInfrasDAO;
import com.dataiku.dip.apideployer.published.AbstractPublishedItemsService;
import com.dataiku.dip.apideployer.published.FileBasedPublishedItemsDAO;
import com.dataiku.dip.apideployer.published.PublishedAPIServicesDAO;
import com.dataiku.dip.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.apideployer.published.PublishedProjectsDAO;
import com.dataiku.dip.apideployer.published.PublishedProjectsService;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.PythonPluginClustersService;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.codestudio.blocks.BlockBasedCodeStudioTemplateParams;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.ProjectFolder;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomJavaPolicyHooksService;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.dao.CodeStudioObjectsDAO;
import com.dataiku.dip.dao.CodeStudioTemplatesDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dao.UserLastActivity;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.dashboards.DashboardsDAO;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.datacollections.AbstractDataCollectionItem;
import com.dataiku.dip.datacollections.DataCollectionDataset;
import com.dataiku.dip.datacollections.DataCollectionsService;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataquality.DataQualityTemplate;
import com.dataiku.dip.dataquality.DataQualityTemplatesDAO;
import com.dataiku.dip.datasets.fs.plugin.CustomJavaFSProvidersService;
import com.dataiku.dip.datasets.fs.plugin.CustomPythonFSProvidersService;
import com.dataiku.dip.eda.worksheets.WorksheetsDAO;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.models.Worksheet;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.experimenttracking.ExperimentTrackingService;
import com.dataiku.dip.export.CustomJavaExportersService;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.featurestore.FeatureStoreService;
import com.dataiku.dip.formats.custom.CustomJavaFormatsService;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksCRUDService;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.online.LLMCostLimitingCountersRepository;
import com.dataiku.dip.llm.online.LLMCostLimitingQuotasRepository;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.llm.retrieval.RAGLLMSettings;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.meanings.MeaningsDAO;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.mec.ModelComparison;
import com.dataiku.dip.mec.ModelComparisonsCRUDService;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.metrics.checks.CustomPythonChecksService;
import com.dataiku.dip.metrics.probes.CustomPythonProbesService;
import com.dataiku.dip.metrics.probes.CustomSQLProbesService;
import com.dataiku.dip.plugins.CustomJavaDatasetsService;
import com.dataiku.dip.plugins.CustomPythonDatasetsService;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.populardatasets.PopularDatasetsService;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.projects.apps.CustomAppTemplatesService;
import com.dataiku.dip.projects.apps.LoadedCustomAppTemplate;
import com.dataiku.dip.projectstandards.ProjectStandardsService;
import com.dataiku.dip.recipes.ParamsWithVariablesExpansionLoopConfig;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipesService;
import com.dataiku.dip.recipes.eda.StatsTestRecipeMeta;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.llm_evaluation.LLMEvaluationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.rag_embedding.RAGEmbeddingRecipePayloadParams;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.runnables.CustomJavaRunnablesService;
import com.dataiku.dip.scheduler.runnables.CustomPythonRunnablesService;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.PythonPluginStepsService;
import com.dataiku.dip.scheduler.triggers.PythonPluginTriggersService;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.DSSCustomUserAuthenticatorDelegator;
import com.dataiku.dip.security.auth.DSSCustomUserSupplierDelegator;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.WelcomeEmailService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorsService;
import com.dataiku.dip.sql.CustomJavaDialectsService;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.theming.dao.DSSVisualizationThemeDAO;
import com.dataiku.dip.theming.model.DSSBuiltinThemesRegistry;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDeployerComputationService;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.webapps.plugins.CustomWebAppsService;
import com.dataiku.dip.webapps.plugins.LoadedCustomWebApp;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.ArticlesDAO;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class GlobalUsageSummaryBuilder {
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private SearchNotebooksDAO searchNotebooksDAO;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private LambdaServicesDAO lambdaServicesDAO;
    @Autowired
    private MeaningsDAO meaningsDAO;
    @Autowired
    private InsightsDAO insightsDAO;
    @Autowired
    private APIServiceDeploymentsDAO apiServiceDeploymentsDAO;
    @Autowired
    private ProjectDeploymentsDAO projectDeploymentsDAO;
    @Autowired
    private DashboardsDAO dashboardsDAO;
    @Autowired
    private ApiNodeInfrasDAO apiNodeInfrasDAO;
    @Autowired
    private AutomationNodeInfrasDAO automationNodeInfrasDAO;
    @Autowired
    private ArticlesDAO articlesDAO;
    @Autowired
    private WorksheetsDAO worksheetsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PublishedAPIServicesDAO apiServicesDAO;
    @Autowired
    private PublishedAPIServicesService publishedAPIServicesService;
    @Autowired
    private PublishedProjectsDAO bundlesDAO;
    @Autowired
    private PublishedProjectsService publishedProjectsService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private UsersService usersService;
    @Autowired
    private ProjectFoldersService projectFoldersService;
    @Autowired
    private ProjectStandardsService projectStandardsService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private ModelComparisonsCRUDService modelComparisonsCRUDService;
    @Autowired
    private PromptStudioDAO promptStudiosDAO;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private LLMCostLimitingQuotasRepository llmCostLimitingQuotas;
    @Autowired
    private LLMCostLimitingCountersRepository llmCostLimitingCounters;
    @Autowired
    private LabelingTasksCRUDService labelingTasksCRUDService;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private CodeStudioObjectsDAO codeStudioObjectsDAO;
    @Autowired
    private CodeStudioTemplatesDAO codeStudioTemplatesDAO;
    @Autowired
    private WebAppsDAO webAppsDAO;
    @Autowired
    private FeatureStoreService featureStoreService;
    @Autowired
    private ClustersDAO clustersDAO;
    @Autowired
    private IPluginsRegistryService pluginsService;
    @Autowired
    private CustomPythonDatasetsService customPythonDatasetsService;
    @Autowired
    private CustomJavaDatasetsService customJavaDatasetsService;
    @Autowired
    private CustomPythonProbesService customPythonProbesService;
    @Autowired
    private CustomPythonChecksService customPythonChecksService;
    @Autowired
    private CustomSQLProbesService customSQLProbesService;
    @Autowired
    private CustomCodeRecipesService customCodeRecipesService;
    @Autowired
    private CustomPythonFormatsService customPythonFormatsService;
    @Autowired
    private CustomJavaFormatsService customJavaFormatsService;
    @Autowired
    private CustomPythonExportersService customPythonExporterService;
    @Autowired
    private CustomJavaExportersService customJavaExporterService;
    @Autowired
    private PythonPluginStepsService pythonPluginStepsService;
    @Autowired
    private PythonPluginTriggersService pythonPluginTriggersService;
    @Autowired
    private CustomPythonRunnablesService customPythonRunnablesService;
    @Autowired
    private CustomJavaRunnablesService customJavaRunnablesService;
    @Autowired
    private CustomWebAppsService customWebAppsService;
    @Autowired
    private CustomPythonFSProvidersService customPythonFSProvidersService;
    @Autowired
    private CustomJavaFSProvidersService customJavaFSProvidersService;
    @Autowired
    private CustomJavaDialectsService customJavaDialectsService;
    @Autowired
    private CustomJythonProcessorsService customJythonStepsService;
    @Autowired
    private PythonPluginClustersService pythonPluginClustersService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private CustomJavaPolicyHooksService customJavaPolicyHooksService;
    @Autowired
    private CustomAppTemplatesService customAppTemplatesService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private ExperimentTrackingService experimentTrackingService;
    @Autowired
    private DesignNodeCodeEnvsService designNodeEnvsService;
    @Autowired
    private AutomationNodeCodeEnvsService automationNodeEnvsService;
    @Autowired
    private SavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    private DataCollectionsService dataCollectionsService;
    @Autowired
    private PopularDatasetsService popularDatasetsService;
    @Autowired
    private UnifiedMonitoringDeployerComputationService unifiedMonitoringDeployerComputationService;
    @Autowired
    private DSSCustomUserAuthenticatorDelegator dssCustomUserAuthenticatorDelegator;
    @Autowired
    private DSSCustomUserSupplierDelegator dssCustomUserSupplierDelegate;
    @Autowired
    private DataQualityTemplatesDAO dataQualityTemplatesDAO;
    @Autowired
    private WelcomeEmailService welcomeEmailService;
    @Autowired
    private DSSVisualizationThemeDAO dssVisualizationThemeDAO;
    @Autowired
    private DSSBuiltinThemesRegistry builtinThemesRegistry;
    private ApplicationInstanceInfoByAppId applicationInstanceInfoByAppId;
    private CodeStudioTemplateInfoById codeStudioTemplateInfoById;
    private UsageSummaryBuilderUtils usbu = new UsageSummaryBuilderUtils();
    Set<String> inputDatasets = new HashSet<String>();
    Set<String> outputDatasets = new HashSet<String>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.usage");
    private static final String pythonBaseEnvVersion = GlobalUsageSummaryBuilder.getPythonBaseEnvVersion();

    public GlobalUsageSummaryBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public ApplicationInstanceInfoByAppId getApplicationInstanceInfoByAppId() {
        return this.applicationInstanceInfoByAppId;
    }

    public CodeStudioTemplateInfoById getCodeStudioTemplateInfoById() {
        return this.codeStudioTemplateInfoById;
    }

    private UsageSummaryModel.ProjectMonitoringReport buildProjectMonitoringReport(SerializedProject sp, UsageSummaryModel.MonitoringReport ret) {
        UsageSummaryModel.ProjectMonitoringReport projectSpecific = new UsageSummaryModel.ProjectMonitoringReport();
        String projectKey = sp.projectKey;
        try {
            for (SerializedRecipe sr : this.recipesDAO.listUnsafe(projectKey)) {
                boolean veLoopEnabled;
                String recipePayload;
                StatsTestRecipePayloadParams payloadParams;
                ++ret.recipes.all;
                ++projectSpecific.recipes.all;
                Object recipeType = sr.type;
                if (StatsTestRecipeMeta.META.getType().equals(sr.type) && (payloadParams = (StatsTestRecipePayloadParams)JSON.parse((String)(recipePayload = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name)), StatsTestRecipePayloadParams.class)) != null) {
                    recipeType = sr.type + "-" + payloadParams.getType();
                }
                this.inc(ret.recipes.byType, (String)recipeType);
                this.inc(projectSpecific.recipes.byType, (String)recipeType);
                if (sr.params instanceof ParamsWithVariablesExpansionLoopConfig && (veLoopEnabled = ((ParamsWithVariablesExpansionLoopConfig)((Object)sr.params)).getVariablesExpansionLoopConfig().isEnabled())) {
                    this.inc(ret.recipes.repeatingByType, (String)recipeType);
                }
                for (SerializedRecipe.InputRole irole : sr.getInputsUnsafe().values()) {
                    for (SerializedRecipe.RecipeInput rinput : irole.items) {
                        for (SerializedRecipe.SDep dep : rinput.deps) {
                            this.inc(ret.recipes.pdepByType, dep.func);
                            this.inc(projectSpecific.recipes.pdepByType, dep.func);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize recipes of " + projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
                this.usbu.summarizeDataset(ret.datasets, projectKey, sd, this.inputDatasets, this.outputDatasets);
                this.usbu.summarizeDataset(projectSpecific.datasets, projectKey, sd, this.inputDatasets, this.outputDatasets);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize datasets of " + projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (AnalysisCoreParams.AnalysisListItem ah : this.analysisCRUDService.listHeadsUnsafe(projectKey, null)) {
                ++ret.analysis.nbAnalyses;
                ++projectSpecific.analysis.nbAnalyses;
                try {
                    AnalysisCoreParams acp = this.analysisCRUDService.getCoreOrNullUnsafe(projectKey, ah.id);
                    if (acp == null) continue;
                    for (AnalysisCRUDService.MLTaskHead head : this.analysisCRUDService.listMLTasks(projectKey, acp.id, false)) {
                        if (head.taskType == MLTask.MLTaskType.PREDICTION) {
                            ++ret.analysis.nbPredMLTasks;
                            ++projectSpecific.analysis.nbPredMLTasks;
                            continue;
                        }
                        if (head.taskType != MLTask.MLTaskType.CLUSTERING) continue;
                        ++ret.analysis.nbClustMLTasks;
                        ++projectSpecific.analysis.nbClustMLTasks;
                    }
                    for (ProcessorScriptStep step : ScriptUtils.getProcessorsFromSteps(acp.script.steps)) {
                        this.inc(ret.analysis.processorsByType, step.type);
                        this.inc(projectSpecific.analysis.processorsByType, step.type);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to summarize analysis " + ah.id + " of " + projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize analyses : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (LabelingTask task : this.labelingTasksCRUDService.listAllUnsafe(projectKey)) {
                ++projectSpecific.labelingTasks.nbLabelingTasks;
                ++ret.labelingTasks.nbLabelingTasks;
                this.inc(projectSpecific.labelingTasks.nbLabelingTasksByTpe, task.type.toString());
                this.inc(ret.labelingTasks.nbLabelingTasksByTpe, task.type.toString());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize labeling tasks usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        this.buildNotebookSummaryReport(ret.notebooks, projectSpecific.notebooks, projectKey);
        this.buildScenarioSummaryReport(ret.scenarios, projectSpecific.scenarios, projectKey);
        this.buildApiServiceSummaryReport(ret.apiServices, projectSpecific.apiServices, projectKey);
        HashSet<String> dashboardInsights = new HashSet<String>();
        this.buildDashboardSummaryReport(ret.dashboards, projectSpecific.dashboards, projectKey, dashboardInsights);
        this.buildInsightsSummaryReport(ret.insights, projectSpecific.insights, projectKey, dashboardInsights);
        try {
            ret.workspaces.all = this.workspacesService.listWorkspaceKeys().size();
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize workspaces of " + projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        this.usbu.summarizeGlobalChartsUsage(ret.charts, projectSpecific.charts, projectKey);
        return projectSpecific;
    }

    private void buildNotebookSummaryReport(UsageSummaryModel.NotebooksSummaryReport notebooksGlobalReport, UsageSummaryModel.NotebooksSummaryReport notebooksProjectReport, String projectKey) {
        try {
            for (SQLNotebook sQLNotebook : this.sqlNotebooksDAO.listUnsafe(projectKey)) {
                ++notebooksGlobalReport.nbSqlNotebooks;
                this.inc(notebooksGlobalReport.notebooksByType, sQLNotebook.language.toString());
                ++notebooksProjectReport.nbSqlNotebooks;
                this.inc(notebooksProjectReport.notebooksByType, sQLNotebook.language.toString());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize SQL notebooks usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (SearchNotebook searchNotebook : this.searchNotebooksDAO.listUnsafe(projectKey)) {
                ++notebooksGlobalReport.nbSearchNotebooks;
                this.inc(notebooksGlobalReport.notebooksByType, searchNotebook.language);
                ++notebooksProjectReport.nbSearchNotebooks;
                this.inc(notebooksProjectReport.notebooksByType, searchNotebook.language);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize Search notebooks usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (JupyterService.JupyterNotebookListEntry jupyterNotebookListEntry : this.jupyterService.listUnsafe(DSSAuthCtx.newNone(), projectKey)) {
                ++notebooksGlobalReport.nbJupyterNotebooks;
                this.inc(notebooksGlobalReport.notebooksByType, jupyterNotebookListEntry.language);
                ++notebooksProjectReport.nbJupyterNotebooks;
                this.inc(notebooksProjectReport.notebooksByType, jupyterNotebookListEntry.language);
                if (jupyterNotebookListEntry.gitReference == null) continue;
                ++notebooksGlobalReport.nbJupyterNotebooksOnGit;
                ++notebooksProjectReport.nbJupyterNotebooksOnGit;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize jupyter usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private void buildScenarioSummaryReport(UsageSummaryModel.ScenariosSummaryReport scenariosGlobalReport, UsageSummaryModel.ScenariosSummaryReport scenariosProjectReport, String projectKey) {
        try {
            for (Scenario sc : this.scenariosDAO.listUnsafe(projectKey)) {
                this.usbu.summarizeScenario(scenariosGlobalReport, sc);
                this.usbu.summarizeScenario(scenariosProjectReport, sc);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize scenarios usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private void buildInsightsSummaryReport(UsageSummaryModel.InsightsSummaryReport insightGlobalReport, UsageSummaryModel.InsightsSummaryReport insightProjectReport, String projectKey, Set<String> dashboardInsights) {
        try {
            for (Insight insight : this.insightsDAO.listUnsafe(projectKey)) {
                this.usbu.summarizeInsights(insight, dashboardInsights, Arrays.asList(insightGlobalReport, insightProjectReport));
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize insights usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private void buildDashboardSummaryReport(UsageSummaryModel.DashboardsSummaryReport dashboardsGlobalReport, UsageSummaryModel.DashboardsSummaryReport dashboardsProjectReport, String projectKey, Set<String> dashboardInsights) {
        try {
            for (Dashboard dashboard : this.dashboardsDAO.listUnsafe(projectKey)) {
                this.usbu.summarizeDashboards(dashboard, Arrays.asList(dashboardsProjectReport, dashboardsGlobalReport), projectKey, dashboardInsights);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize dashboards usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private void buildApiServiceSummaryReport(UsageSummaryModel.APIServicesSummaryReport apiServicesGlobalReport, UsageSummaryModel.APIServicesSummaryReport apiServicesProjectReport, String projectKey) {
        try {
            for (LambdaService sc : this.lambdaServicesDAO.listUnsafe(projectKey)) {
                this.usbu.summarizeAPIService(apiServicesGlobalReport, sc);
                this.usbu.summarizeAPIService(apiServicesProjectReport, sc);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize lambda usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private ProjectSummaryReport summarizeProject(SerializedProject sp, UsageSummaryModel.SummaryReport ret, FilterReportBuilder globalFilterReportBuilder, UsageSummaryBuilderUtils.VisualIfRuleAggregator globalShakerVisIfAggregator, UsageSummaryBuilderUtils.VisualIfRuleAggregator globalAnalysisVisIfAggregator) {
        ProjectSummaryReport projectSpecific = new ProjectSummaryReport();
        FilterTraverser filterTraverser = new FilterTraverser();
        FilterReportBuilder projectFilterReportBuilder = new FilterReportBuilder();
        String projectKey = sp.projectKey;
        logger.info((Object)("Summarizing project " + projectKey));
        this.inc(ret.projectByAppType, sp.projectAppType.name());
        if (sp.projectAppType == SerializedProject.ProjectAppType.APP_TEMPLATE) {
            try {
                AppManifest manifest = this.appsService.getManifestFromProjectUnsafe(TransactionContext.retrieveRead(), projectKey);
                this.usbu.summarizeAppManifest(ret.appManifests, manifest, this.applicationInstanceInfoByAppId);
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to summarize app manifest of " + projectKey), (Throwable)e);
            }
        }
        try {
            for (SerializedRecipe sr : this.recipesDAO.listUnsafe(projectKey)) {
                RecipePayloadParams params;
                String payloadStr;
                boolean veLoopEnabled;
                String recipePayload;
                StatsTestRecipePayloadParams payloadParams;
                ++ret.recipes.all;
                ++projectSpecific.recipes.all;
                Object recipeType = sr.type;
                if (StatsTestRecipeMeta.META.getType().equals(sr.type) && (payloadParams = (StatsTestRecipePayloadParams)JSON.parse((String)(recipePayload = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name)), StatsTestRecipePayloadParams.class)) != null) {
                    recipeType = sr.type + "-" + payloadParams.getType();
                }
                this.inc(ret.recipes.byType, (String)recipeType);
                this.inc(projectSpecific.recipes.byType, (String)recipeType);
                if (sr.params instanceof ParamsWithVariablesExpansionLoopConfig && (veLoopEnabled = ((ParamsWithVariablesExpansionLoopConfig)((Object)sr.params)).getVariablesExpansionLoopConfig().isEnabled())) {
                    this.inc(ret.recipes.repeatingByType, (String)recipeType);
                }
                for (SerializedRecipe.InputRole irole : sr.getInputsUnsafe().values()) {
                    for (SerializedRecipe.RecipeInput recipeInput : irole.items) {
                        for (SerializedRecipe.SDep dep : recipeInput.deps) {
                            this.inc(ret.recipes.pdepByType, dep.func);
                            this.inc(projectSpecific.recipes.pdepByType, dep.func);
                        }
                        if (recipeInput.ref == null) continue;
                        this.inputDatasets.add(DatasetLocUtils.resolveSmart(projectKey, recipeInput.ref).getFullName());
                    }
                }
                for (SerializedRecipe.OutputRole orole : sr.getOutputsUnsafe().values()) {
                    for (SerializedRecipe.RecipeOutput recipeOutput : orole.items) {
                        this.outputDatasets.add(DatasetLocUtils.resolveSmart(projectKey, recipeOutput.ref).getFullName());
                    }
                }
                UsageSummaryBuilderUtils.VisualIfRuleAggregator shakerVisIfAggregator = new UsageSummaryBuilderUtils.VisualIfRuleAggregator();
                if ("shaker".equals(sr.type)) {
                    try {
                        ++ret.shakerRecipes.nbRecipes;
                        ++projectSpecific.shakerRecipes.nbRecipes;
                        payloadStr = this.recipesDAO.getPayloadOrNull(projectKey, sr.name);
                        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)payloadStr, SerializedShakerScript.class);
                        for (ProcessorScriptStep step : ScriptUtils.getProcessorsFromSteps(sss.steps)) {
                            this.inc(ret.shakerRecipes.processorsByType, step.type);
                            this.inc(projectSpecific.shakerRecipes.processorsByType, step.type);
                        }
                        this.usbu.gatherVisualIfRules(globalShakerVisIfAggregator, sss);
                        this.usbu.gatherVisualIfRules(shakerVisIfAggregator, sss);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to summarize shaker usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    }
                }
                projectSpecific.shakerRecipes.visualIfProcessor = shakerVisIfAggregator.toSummary();
                filterTraverser.traverseFilters(projectFilterReportBuilder, sr);
                this.summarizeJoinRecipeUsage(ret, sr, projectSpecific, projectKey);
                if ("nlp_llm_evaluation".equals(sr.type)) {
                    try {
                        ++ret.llmEvaluationRecipes.nbRecipes;
                        ++projectSpecific.llmEvaluationRecipes.nbRecipes;
                        payloadStr = this.recipesDAO.getPayloadOrNull(projectKey, sr.name);
                        params = (LLMEvaluationRecipePayloadParams)JSON.parse((String)payloadStr, LLMEvaluationRecipePayloadParams.class);
                        for (String metricName : params.metrics) {
                            this.inc(ret.llmEvaluationRecipes.metricsByType, metricName);
                            this.inc(projectSpecific.llmEvaluationRecipes.metricsByType, metricName);
                        }
                        this.inc(ret.llmEvaluationRecipes.metricsByType, "custom", params.customMetrics.size());
                        this.inc(projectSpecific.llmEvaluationRecipes.metricsByType, "custom", params.customMetrics.size());
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to summarize llm evaluation recipe usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    }
                }
                if (!"nlp_llm_rag_embedding".equals(sr.type)) continue;
                try {
                    ++ret.ragEmbeddingRecipe.nbRecipes;
                    ++projectSpecific.ragEmbeddingRecipe.nbRecipes;
                    payloadStr = this.recipesDAO.getPayloadOrNull(projectKey, sr.name);
                    params = (RAGEmbeddingRecipePayloadParams)JSON.parse((String)payloadStr, RAGEmbeddingRecipePayloadParams.class);
                    this.inc(ret.ragEmbeddingRecipe.vectorStoreUpdateMethod, String.valueOf((Object)((RAGEmbeddingRecipePayloadParams)params).vectorStoreUpdateMethod));
                    this.inc(projectSpecific.ragEmbeddingRecipe.vectorStoreUpdateMethod, String.valueOf((Object)((RAGEmbeddingRecipePayloadParams)params).vectorStoreUpdateMethod));
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to summarize embedding recipe usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize recipes of " + projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (DatasetExploreSettings exploreSettings : this.exploresService.listExploresForProjectUnsafe(projectKey)) {
                filterTraverser.traverseFilters(projectFilterReportBuilder, exploreSettings);
            }
        }
        catch (Throwable t2) {
            logger.warn((Object)("Failed to add explore filter usage:" + ExceptionUtils.getMessageWithCauses((Throwable)t2)));
        }
        try {
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
                this.usbu.summarizeDataset(ret.datasets, projectKey, sd, this.inputDatasets, this.outputDatasets);
                this.usbu.summarizeDataset(projectSpecific.datasets, projectKey, sd, this.inputDatasets, this.outputDatasets);
                this.usbu.summarizeRules(ret.rules, sd);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize datasets of " + projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (Object se : this.streamingEndpointsDAO.listUnsafe(projectKey)) {
                this.usbu.summarizeStreamingEndpoint(ret.streamingEndpoints, projectKey, (StreamingEndpoint)se, this.inputDatasets, this.outputDatasets);
                this.usbu.summarizeStreamingEndpoint(projectSpecific.streamingEndpoints, projectKey, (StreamingEndpoint)se, this.inputDatasets, this.outputDatasets);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize streaming endpoints of " + projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        UsageSummaryBuilderUtils.VisualIfRuleAggregator analysisVisIfAggregator = new UsageSummaryBuilderUtils.VisualIfRuleAggregator();
        try {
            for (AnalysisCoreParams.AnalysisListItem ah : this.analysisCRUDService.listHeadsUnsafe(projectKey, null)) {
                ++ret.analysis.nbAnalyses;
                ++projectSpecific.analysis.nbAnalyses;
                try {
                    AnalysisCoreParams acp = this.analysisCRUDService.getCoreOrNullUnsafe(projectKey, ah.id);
                    if (acp == null) continue;
                    filterTraverser.traverseFilters(projectFilterReportBuilder, acp);
                    this.usbu.gatherVisualIfRules(analysisVisIfAggregator, acp.script);
                    this.usbu.gatherVisualIfRules(globalAnalysisVisIfAggregator, acp.script);
                    for (AnalysisCRUDService.MLTaskHead head : this.analysisCRUDService.listMLTasks(projectKey, acp.id, false)) {
                        if (head.taskType == MLTask.MLTaskType.PREDICTION) {
                            ++ret.analysis.nbPredMLTasks;
                            ++projectSpecific.analysis.nbPredMLTasks;
                            try {
                                MLTaskLoc mLTaskLoc = new MLTaskLoc(projectKey, acp.id, head.mlTaskId);
                                PredictionMLTask mlTask = this.analysisCRUDService.getPMLTaskUnsafe(mLTaskLoc);
                                filterTraverser.traverseFilters(projectFilterReportBuilder, mlTask);
                            }
                            catch (Throwable throwable) {
                                logger.warn((Object)("Error while summarizing mlTask filters: " + ExceptionUtils.getMessageWithCauses((Throwable)throwable)));
                            }
                            continue;
                        }
                        if (head.taskType != MLTask.MLTaskType.CLUSTERING) continue;
                        ++ret.analysis.nbClustMLTasks;
                        ++projectSpecific.analysis.nbClustMLTasks;
                    }
                    for (ProcessorScriptStep step : ScriptUtils.getProcessorsFromSteps(acp.script.steps)) {
                        this.inc(ret.analysis.processorsByType, step.type);
                        this.inc(projectSpecific.analysis.processorsByType, step.type);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to summarize analysis " + ah.id + " of " + projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize analyses of " + projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        projectSpecific.analysis.visualIfProcessor = analysisVisIfAggregator.toSummary();
        try {
            for (ModelEvaluationStore mes : this.modelEvaluationStoresCRUDService.listUnsafe(projectKey)) {
                List<ModelEvaluationStoresCRUDService.ModelEvaluationHeader> sample = this.modelEvaluationStoresCRUDService.listEvaluations(mes, null, 1);
                boolean isLLM = !sample.isEmpty() && sample.get(0).isLLM();
                boolean isTimeseries = !sample.isEmpty() && sample.get(0).isTimeseries();
                int n = this.modelEvaluationStoresCRUDService.listRunIds(mes).size();
                ++ret.modelEvaluationStores.nbMES;
                ret.modelEvaluationStores.nbME += n;
                if (isLLM) {
                    ++ret.modelEvaluationStores.nbLLMMES;
                    ret.modelEvaluationStores.nbLLMME += n;
                    continue;
                }
                if (isTimeseries) {
                    ++ret.modelEvaluationStores.nbTimeseriesMES;
                    ret.modelEvaluationStores.nbTimeseriesME += n;
                    continue;
                }
                ++ret.modelEvaluationStores.nbTabularMES;
                ret.modelEvaluationStores.nbTabularME += n;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize model evaluation stores of " + projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (LabelingTask task : this.labelingTasksCRUDService.listAllUnsafe(projectKey)) {
                ++projectSpecific.labelingTasks.nbLabelingTasks;
                ++ret.labelingTasks.nbLabelingTasks;
                this.inc(projectSpecific.labelingTasks.nbLabelingTasksByTpe, task.type.toString());
                this.inc(ret.labelingTasks.nbLabelingTasksByTpe, task.type.toString());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize labeling tasks usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.listUnsafe(projectKey)) {
                ++projectSpecific.retrievableKnowledge.nbKb;
                ++ret.retrievableKnowledge.nbKb;
                this.inc(projectSpecific.retrievableKnowledge.vectorStoreType, rk.vectorStoreType.toString());
                this.inc(ret.retrievableKnowledge.vectorStoreType, rk.vectorStoreType.toString());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize retrievable knowledge usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (SavedModel sm : this.savedModelsCRUDService.listUnsafe(projectKey)) {
                SavedModel.SavedModelInlineVersion activeSmiv;
                if (sm.savedModelType.savedModelHandlingType == SavedModel.SavedModelHandlingType.EXTERNAL_MLFLOW) {
                    File versionsFolder = MLPaths.savedModelVersionsFolder(sm);
                    if (!versionsFolder.isDirectory()) continue;
                    for (File f : versionsFolder.listFiles((FileFilter)DKUFileUtils.FileFilter.DIRECTORIES)) {
                        FullModelId fmi = new FullModelId(sm.projectKey, sm.id, f.getName());
                        if (!fmi.getSavedModelVersionID().equals(sm.activeVersion)) continue;
                        try {
                            String externalModelPredictionType;
                            MLFlowModelVersionInfo mlFlowImportedModelMetadata = fmi.getMLflowImportedModelMetadata();
                            String string = externalModelPredictionType = mlFlowImportedModelMetadata.predictionType != null ? mlFlowImportedModelMetadata.predictionType.toString() : "OTHER";
                            if (mlFlowImportedModelMetadata.isProxyModel()) {
                                this.inc(ret.externalModels.proxyModels.byPredictionType, externalModelPredictionType);
                                ++ret.externalModels.proxyModels.all;
                                if (mlFlowImportedModelMetadata.proxyModelVersionConfiguration == null) continue;
                                this.inc(ret.externalModels.proxyModels.byType, mlFlowImportedModelMetadata.proxyModelVersionConfiguration.proxyModelConfiguration.protocol);
                                continue;
                            }
                            this.inc(ret.externalModels.mlflowModels.byPredictionType, externalModelPredictionType);
                            ++ret.externalModels.mlflowModels.all;
                            boolean found = false;
                            for (SimpleKeyValue kv : mlFlowImportedModelMetadata.flavorsLabels) {
                                if (!kv.key.contains("version")) continue;
                                this.inc(ret.externalModels.mlflowModels.byFlavor, kv.key.split(":")[0]);
                                found = true;
                                break;
                            }
                            if (!found) {
                                for (SimpleKeyValue kv : mlFlowImportedModelMetadata.pyfuncLabels) {
                                    if (!kv.key.equals("python_function:loader_module")) continue;
                                    this.inc(ret.externalModels.mlflowModels.byFlavor, kv.value);
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            this.inc(ret.externalModels.mlflowModels.byFlavor, "Unknown");
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Failed to summarize MLFlow model " + sm.id + " of " + projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                        }
                    }
                    continue;
                }
                if (sm.savedModelType.savedModelHandlingType == SavedModel.SavedModelHandlingType.RETRIEVAL_AUGMENTED_LLM) {
                    activeSmiv = sm.getActiveSaveModelInlineVersion();
                    if (activeSmiv != null) {
                        ++projectSpecific.retrievalAugmentedLLM.nbRALLM;
                        ++ret.retrievalAugmentedLLM.nbRALLM;
                        RAGLLMSettings ragllmSettings = activeSmiv.ragllmSettings;
                        UsageSummaryBuilderUtils.iinc(projectSpecific.retrievalAugmentedLLM.allByMaxDocumentsCount, ragllmSettings.maxDocuments);
                        UsageSummaryBuilderUtils.iinc(ret.retrievalAugmentedLLM.allByMaxDocumentsCount, ragllmSettings.maxDocuments);
                        switch (ragllmSettings.searchType) {
                            case SIMILARITY: {
                                ++projectSpecific.retrievalAugmentedLLM.nbUseSimilarity;
                                ++ret.retrievalAugmentedLLM.nbUseSimilarity;
                                break;
                            }
                            case SIMILARITY_THRESHOLD: {
                                ++projectSpecific.retrievalAugmentedLLM.nbUseSimilarityThreshold;
                                ++ret.retrievalAugmentedLLM.nbUseSimilarityThreshold;
                                break;
                            }
                            case MMR: {
                                ++projectSpecific.retrievalAugmentedLLM.nbUseMMR;
                                ++ret.retrievalAugmentedLLM.nbUseMMR;
                                break;
                            }
                            case HYBRID: {
                                ++projectSpecific.retrievalAugmentedLLM.nbUseHybridSearch;
                                ++ret.retrievalAugmentedLLM.nbUseHybridSearch;
                                if (!ragllmSettings.useAdvancedReranking) break;
                                ++projectSpecific.retrievalAugmentedLLM.nbUseAdvancedReranking;
                                ++ret.retrievalAugmentedLLM.nbUseAdvancedReranking;
                            }
                        }
                        if (ragllmSettings.printSources) {
                            ++projectSpecific.retrievalAugmentedLLM.nbPrintSources;
                            ++ret.retrievalAugmentedLLM.nbPrintSources;
                            if (ragllmSettings.includeContentInSources) {
                                ++projectSpecific.retrievalAugmentedLLM.nbIncludeContentInSources;
                                ++ret.retrievalAugmentedLLM.nbIncludeContentInSources;
                            }
                            this.inc(projectSpecific.retrievalAugmentedLLM.outputFormatByType, ragllmSettings.outputFormat.toString());
                            this.inc(ret.retrievalAugmentedLLM.outputFormatByType, ragllmSettings.outputFormat.toString());
                            this.inc(projectSpecific.retrievalAugmentedLLM.retrievalSourceByType, ragllmSettings.retrievalSource.toString());
                            this.inc(ret.retrievalAugmentedLLM.retrievalSourceByType, ragllmSettings.retrievalSource.toString());
                        }
                        if (ragllmSettings.hasFaithfulnessGuardrailsEnabled()) {
                            ++projectSpecific.retrievalAugmentedLLM.nbUsingFaithfulnessGuardrails;
                            ++ret.retrievalAugmentedLLM.nbUsingFaithfulnessGuardrails;
                        }
                        if (!ragllmSettings.hasRelevancyGuardrailsEnabled()) continue;
                        ++projectSpecific.retrievalAugmentedLLM.nbUsingRelevancyGuardrails;
                        ++ret.retrievalAugmentedLLM.nbUsingRelevancyGuardrails;
                        continue;
                    }
                    logger.error((Object)("No active version available on sm RETRIEVAL_AUGMENTED_LLM" + projectKey + " : " + sm.getId()));
                    continue;
                }
                if (!sm.savedModelType.isAgent()) continue;
                activeSmiv = sm.getActiveSaveModelInlineVersion();
                if (activeSmiv != null) {
                    ++projectSpecific.agents.nbAgents;
                    ++ret.agents.nbAgents;
                    this.inc(projectSpecific.agents.byType, sm.savedModelType.toString());
                    this.inc(ret.agents.byType, sm.savedModelType.toString());
                    continue;
                }
                logger.error((Object)("No active version available on sm " + String.valueOf((Object)sm.savedModelType) + " " + projectKey + " : " + sm.getId()));
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize MLflow usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        this.buildNotebookSummaryReport(ret.notebooks, projectSpecific.notebooks, projectKey);
        this.buildScenarioSummaryReport(ret.scenarios, projectSpecific.scenarios, projectKey);
        this.buildApiServiceSummaryReport(ret.apiServices, projectSpecific.apiServices, projectKey);
        this.usbu.summarizeGlobalChartsUsage(ret.charts, projectSpecific.charts, projectKey);
        HashSet<String> dashboardInsights = new HashSet<String>();
        this.buildDashboardSummaryReport(ret.dashboards, projectSpecific.dashboards, projectKey, dashboardInsights);
        this.buildInsightsSummaryReport(ret.insights, projectSpecific.insights, projectKey, dashboardInsights);
        try {
            int articleCount = 0;
            int nonEmptyArticleCount = 0;
            for (Article article : this.articlesDAO.listUnsafe(projectKey)) {
                ++articleCount;
                if (!StringUtils.isNotBlank((String)this.articlesDAO.getPayloadOrNull(projectKey, article.id))) continue;
                ++nonEmptyArticleCount;
            }
            if (articleCount > 0) {
                ++ret.wikis.nbWikis;
                ret.wikis.nbArticles += articleCount;
                ret.wikis.nbNonEmptyArticles += nonEmptyArticleCount;
                ret.wikis.maxNbArticlePerWiki = Math.max(articleCount, ret.wikis.maxNbArticlePerWiki);
                ret.wikis.maxNbNonEmptyArticlePerWiki = Math.max(nonEmptyArticleCount, ret.wikis.maxNbNonEmptyArticlePerWiki);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize wikis usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            List libraryFiles;
            TransactionRef t4 = TransactionContext.retrieveRead();
            RelFile libDir = new RelFile(new String[]{"projects", projectKey, "lib"});
            if (t4.isDirectory(libDir) && (libraryFiles = t4.listRecursive(libDir)).size() > 4) {
                ret.libraries.nbFiles += libraryFiles.size() - 4;
            }
            DSSGitModel.ExternalLibraries el = (DSSGitModel.ExternalLibraries)t4.readObjectDefaultUnsafe(new RelFile(new String[]{"projects", projectKey, "lib", "external-libraries.json"}), DSSGitModel.ExternalLibraries.class);
            ret.libraries.nbGitRefs += el.gitReferences.size();
            ret.libraries.nbPythonRoots += el.pythonPath.size();
            ret.libraries.nbRRoots += el.rsrcPath.size();
            ret.libraries.nbImports += el.getNonNullLibrariesFromProjects().size();
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize project libraries of " + projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (CodeStudioObject codeStudio : this.codeStudioObjectsDAO.listUnsafe(projectKey)) {
                ++ret.codeStudios.nbCodeStudios;
                ++projectSpecific.codeStudios.nbCodeStudios;
                Set<String> blockTypes = this.codeStudioTemplateInfoById.getOrDefault((Object)codeStudio.templateId, new CodeStudioTemplateInfo()).blockTypes;
                blockTypes.stream().forEach(t -> this.inc(ret.codeStudios.countByBlockType, (String)t));
                blockTypes.stream().forEach(t -> this.inc(projectSpecific.codeStudios.countByBlockType, (String)t));
            }
            for (WebApp webApp : this.webAppsDAO.listUnsafe(projectKey)) {
                if (!"CODE_STUDIO_AS_WEBAPP".equals(webApp.type)) continue;
                ++ret.codeStudios.nbCodeStudioWebapps;
                ++projectSpecific.codeStudios.nbCodeStudioWebapps;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize Code Studios usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (Worksheet worksheet : this.worksheetsDAO.listUnsafe(projectKey)) {
                filterTraverser.traverseFilters(projectFilterReportBuilder, worksheet);
                ++ret.worksheets.nbWorksheets;
                ++projectSpecific.worksheets.nbWorksheets;
                ret.worksheets.nbCards += worksheet.rootCard.cards.size();
                projectSpecific.worksheets.nbCards += worksheet.rootCard.cards.size();
                for (Card card : worksheet.rootCard.cards) {
                    if (card.splitBy != null) {
                        ++ret.worksheets.nbCardsWithSplit;
                        ++projectSpecific.worksheets.nbCardsWithSplit;
                    }
                    this.inc(ret.worksheets.nbCardsPerType, JSON.getType((Object)((Object)card)));
                    this.inc(projectSpecific.worksheets.nbCardsPerType, JSON.getType((Object)((Object)card)));
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize EDA usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (ModelComparison mec : this.modelComparisonsCRUDService.listUnsafe(projectKey)) {
                ++ret.mecs.nbModelComparisons;
                ret.mecs.nbComparedModels += mec.comparedModels.size();
                if (mec.modelTaskType.isPrediction()) {
                    this.inc(ret.mecs.nbComparisonPerPredictionType, mec.modelTaskType.toString());
                }
                this.inc(ret.mecs.nbComparisonPerModelTaskType, mec.modelTaskType.toString());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize MEC usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            for (PromptStudio ps2 : this.promptStudiosDAO.listUnsafe(projectKey)) {
                ++ret.promptStudios.nbPromptStudios;
                ret.promptStudios.nbPrompts += ps2.prompts.size();
                for (PromptStudio.PromptStudioPrompt prompt : ps2.prompts) {
                    LLMStructuredRef lLMStructuredRef = LLMStructuredRef.decodeId(prompt.llmId);
                    this.inc(ret.promptStudios.nbPromptsPerLLMType, lLMStructuredRef.type.toString());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize Prompt Studio usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        sp.exposedObjects.objects.forEach(exposedObject -> {
            boolean isDataset;
            boolean bl = isDataset = exposedObject.type == ITaggingService.TaggableType.DATASET;
            if (exposedObject.quickSharingEnabled) {
                ++ret.exposedObjects.quickSharedObjects;
                ret.exposedObjects.quickSharedDatasets = ret.exposedObjects.quickSharedDatasets + (isDataset ? 1 : 0);
            } else {
                ++ret.exposedObjects.managedSharedObjects;
                ret.exposedObjects.managedSharedDatasets = ret.exposedObjects.managedSharedDatasets + (isDataset ? 1 : 0);
            }
        });
        globalFilterReportBuilder.add(projectFilterReportBuilder);
        projectSpecific.filters = projectFilterReportBuilder.toFilterSummaryReport();
        return projectSpecific;
    }

    private void summarizeJoinRecipeUsage(UsageSummaryModel.SummaryReport globalSummaryReport, SerializedRecipe serializedRecipe, ProjectSummaryReport projectSummaryReport, String projectKey) {
        if (serializedRecipe == null || serializedRecipe.type == null || !serializedRecipe.type.contains("join")) {
            return;
        }
        try {
            UsageSummaryModel.JoinRecipeSummaryReport.JoinRecipeSubSummary projectSummaryReportRecipeEntry;
            UsageSummaryModel.JoinRecipeSummaryReport.JoinRecipeSubSummary globalSummaryReportRecipeEntry;
            switch (serializedRecipe.type) {
                case "join": {
                    globalSummaryReportRecipeEntry = globalSummaryReport.joinRecipes.join;
                    projectSummaryReportRecipeEntry = projectSummaryReport.joinRecipes.join;
                    break;
                }
                case "fuzzyjoin": {
                    globalSummaryReportRecipeEntry = globalSummaryReport.joinRecipes.fuzzyjoin;
                    projectSummaryReportRecipeEntry = projectSummaryReport.joinRecipes.fuzzyjoin;
                    break;
                }
                case "geojoin": {
                    globalSummaryReportRecipeEntry = globalSummaryReport.joinRecipes.geojoin;
                    projectSummaryReportRecipeEntry = projectSummaryReport.joinRecipes.geojoin;
                    break;
                }
                default: {
                    logger.error((Object)("Unexpected join recipe type: " + serializedRecipe.type));
                    return;
                }
            }
            ++globalSummaryReportRecipeEntry.nbRecipes;
            ++projectSummaryReportRecipeEntry.nbRecipes;
            String payload = this.recipesDAO.getPayloadOrNull(projectKey, serializedRecipe.name);
            JoinRecipePayloadParams params = (JoinRecipePayloadParams)JSON.parse((String)payload, JoinRecipePayloadParams.class);
            for (JoinRecipePayloadParams.JoinDesc join : params.joins) {
                if (join == null) continue;
                this.inc(globalSummaryReportRecipeEntry.type, String.valueOf((Object)join.type));
                this.inc(projectSummaryReportRecipeEntry.type, String.valueOf((Object)join.type));
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize join recipe usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private void summarizeWorkspaces(UsageSummaryModel.SummaryReport ret) {
        try {
            List<String> workspaceKeys;
            try (Transaction ignored = this.transactionService.beginRead();){
                workspaceKeys = this.workspacesService.listWorkspaceKeys();
            }
            ret.workspaces.all = workspaceKeys.size();
            for (String workspaceKey : workspaceKeys) {
                Transaction ignored = this.transactionService.beginRead();
                try {
                    try {
                        Workspace workspace = this.workspacesService.getRawWorkspaceUnsafe(workspaceKey);
                        if (workspace == null) continue;
                        this.usbu.summarizeWorkspace(ret.workspaces, workspace);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to summarize Workspace usage for workspace " + workspaceKey + ". Cause:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    }
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize Workspaces usage. Cause:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private CodeStudioTemplateInfoById summarizeCodeStudioTemplates(UsageSummaryModel.SummaryReport ret) {
        CodeStudioTemplateInfoById infoById = new CodeStudioTemplateInfoById();
        try {
            List<CodeStudioTemplate> templates;
            try (Transaction ignored = this.transactionService.beginRead();){
                templates = this.codeStudioTemplatesDAO.listUnsafe();
            }
            ret.codeStudioTemplates.nbCodeStudioTemplates = templates.size();
            for (CodeStudioTemplate template : templates) {
                this.inc(ret.codeStudioTemplates.countByType, template.type);
                CodeStudioTemplateInfo templateInfo = new CodeStudioTemplateInfo();
                if ("block_based".equals(template.type)) {
                    try {
                        BlockBasedCodeStudioTemplateParams params = template.getParamsAs(BlockBasedCodeStudioTemplateParams.class);
                        for (CodeStudioBlock block : params.blocks) {
                            this.inc(ret.codeStudioTemplates.blockCountByType, block.type);
                            templateInfo.blockTypes.add(block.type);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Can't summarize Code Studio template " + template.id), (Throwable)e);
                    }
                }
                infoById.put(template.id, templateInfo);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize Code Studio template usage. Cause:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        return infoById;
    }

    private void summarizeLLMCostLimiting(UsageSummaryModel.SummaryReport ret) {
        try {
            for (GeneralSettingsDAO.LLMCostLimitingQuota quota : this.llmCostLimitingQuotas.getAvailableQuotas()) {
                UsageSummaryModel.LLMCostLimitingQuotaReport quotaReport = new UsageSummaryModel.LLMCostLimitingQuotaReport();
                quotaReport.isFallback = quota.isFallback();
                quotaReport.resetPeriod = quota.periodicity.aggregationType.toString();
                quotaReport.rollingPeriods = quota.rollingPeriods;
                quotaReport.isSetToZero = quota.costLimit == 0.0;
                quotaReport.isBlocking = quota.blockingLimit;
                quotaReport.hasAlerts = GlobalUsageSummaryBuilder.alertsFullySetUpForQuota(quota);
                quotaReport.hasFilters = false;
                LLMCostLimitingCountersRepository.AggregatedDataWithDetails counter = this.llmCostLimitingCounters.getAggregatedDataWithDetails(quota, false);
                quotaReport.isCurrentlyBlocked = quotaReport.isBlocking && counter.accruedCost >= quota.costLimit;
                quotaReport.hasAllowedQueries = counter.allowedQueries > 0;
                boolean bl = quotaReport.hasBlockedQueries = counter.blockedQueries > 0;
                if (!quotaReport.isFallback) {
                    GeneralSettingsDAO.CustomLLMCostLimitingQuota customQuota = (GeneralSettingsDAO.CustomLLMCostLimitingQuota)quota;
                    if (customQuota.filter.enabled) {
                        quotaReport.hasFilters = true;
                        this.reportFilterDimensions(quotaReport.nbClausesByFilterDimension, customQuota.filter);
                    }
                }
                ret.llmCostLimiting.quotas.add(quotaReport);
                this.aggregateQuotaSummary(ret.llmCostLimiting, quotaReport);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize LLM Cost Limiting usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private static boolean alertsFullySetUpForQuota(GeneralSettingsDAO.LLMCostLimitingQuota quota) {
        return quota.costLimit > 0.0 && quota.emailChannelId != null && !quota.reportingActions.isEmpty() && !quota.reportingTargets.isEmpty();
    }

    private void reportFilterDimensions(Map<String, Integer> filterDimensionCounter, FilterDesc filter) {
        if (filter.uiData != null) {
            for (FilterDesc.FilterUiCondition condition : filter.uiData.conditions) {
                if (condition.subCondition != null) {
                    this.reportFilterDimensions(filterDimensionCounter, condition.subCondition);
                    continue;
                }
                this.inc(filterDimensionCounter, condition.input);
            }
        }
    }

    private void aggregateQuotaSummary(UsageSummaryModel.LLMCostLimitingSummaryReport report, UsageSummaryModel.LLMCostLimitingQuotaReport quotaReport) {
        ++report.nbQuotas;
        if (quotaReport.isBlocking) {
            ++report.nbBlockingQuotas;
        }
        if (quotaReport.isSetToZero) {
            if (quotaReport.isBlocking) {
                ++report.nbBlockingQuotasSetToZero;
            } else {
                ++report.nbNonBlockingQuotasSetToZero;
            }
        }
        this.inc(report.nbQuotasByResetPeriodDimension, quotaReport.resetPeriod);
        if (quotaReport.isFallback && (quotaReport.hasAllowedQueries || quotaReport.hasBlockedQueries)) {
            report.hasFallbackQuotaQueries = true;
        }
        if (quotaReport.hasFilters) {
            ++report.nbQuotasWithFilters;
            for (String filterDimension : quotaReport.nbClausesByFilterDimension.keySet()) {
                this.inc(report.nbQuotasByFilterDimension, filterDimension);
            }
        }
        if (quotaReport.hasAllowedQueries) {
            ++report.nbQuotasWithAllowedQueries;
        }
        if (quotaReport.hasBlockedQueries) {
            ++report.nbQuotasWithBlockedQueries;
        }
        if (quotaReport.isCurrentlyBlocked) {
            ++report.nbQuotasCurrentlyBlocked;
        }
        if (quotaReport.hasAlerts) {
            ++report.nbQuotasWithAlerts;
        }
    }

    private void summarizeLLMRateLimiting(UsageSummaryModel.SummaryReport ret) {
        try {
            GeneralSettingsDAO.RateLimitingSettings userSettings;
            try (Transaction t = this.transactionService.beginRead();){
                userSettings = this.generalSettingsDAO.read().generativeAISettings.rateLimitingSettings;
            }
            for (GeneralSettingsDAO.RateLimitingProviderSettings providerConfig : userSettings.perProviderSettings.values()) {
                boolean hasCustomEntry = false;
                if (providerConfig.completionDefault != null && !providerConfig.completionDefault.managed) {
                    ++ret.llmRateLimiting.nbCustomCompletionDefault;
                    hasCustomEntry = true;
                }
                if (providerConfig.embeddingDefault != null && !providerConfig.embeddingDefault.managed) {
                    ++ret.llmRateLimiting.nbCustomEmbeddingDefault;
                    hasCustomEntry = true;
                }
                if (providerConfig.imageGenerationDefault != null && !providerConfig.imageGenerationDefault.managed) {
                    ++ret.llmRateLimiting.nbCustomImageGenerationDefault;
                    hasCustomEntry = true;
                }
                for (GeneralSettingsDAO.RateLimitingConfig modelConfig : providerConfig.perModelConfigs.values()) {
                    if (modelConfig.managed) continue;
                    ++ret.llmRateLimiting.nbCustomModels;
                    hasCustomEntry = true;
                }
                if (!hasCustomEntry) continue;
                ++ret.llmRateLimiting.nbProvidersWithCustomEntries;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarize LLM Rate Limiting usage:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private void addDeploymentAndInfraUsage(UsageSummaryModel.DeployerSummaryReport report, GeneralSettingsDAO.DeployerServerSettings serverSettings) {
        AbstractPublishedItemsService publishedItemService;
        FileBasedPublishedItemsDAO publishedItemsDAO;
        FilesBasedDeploymentInfrasDAO infrasDAO;
        FileBasedDeploymentsDAO deploymentsDAO;
        boolean isAPIDeployerInstance = report instanceof UsageSummaryModel.APIDeployerSummaryReport;
        if (isAPIDeployerInstance) {
            deploymentsDAO = this.apiServiceDeploymentsDAO;
            infrasDAO = this.apiNodeInfrasDAO;
            publishedItemsDAO = this.apiServicesDAO;
            publishedItemService = this.publishedAPIServicesService;
        } else {
            deploymentsDAO = this.projectDeploymentsDAO;
            infrasDAO = this.automationNodeInfrasDAO;
            publishedItemsDAO = this.bundlesDAO;
            publishedItemService = this.publishedProjectsService;
        }
        try {
            List publishedItems;
            DSSAuthCtx authCtx = DSSAuthCtx.fakeAdminForTests("dss-internal");
            HashMap<Pair, Integer> deployedApiServiceWithOpenAPICounter = new HashMap<Pair, Integer>();
            UsageSummaryModel.AutomationNodeInfraPolicies policies = new UsageSummaryModel.AutomationNodeInfraPolicies();
            try (Transaction t = this.transactionService.beginRead();){
                HashMap<String, AbstractDeploymentInfra> infraMap = new HashMap<String, AbstractDeploymentInfra>();
                HashMap<String, Integer> deploymentCountsPerStage = new HashMap<String, Integer>();
                String othersStageName = "__OTHERS__";
                for (AbstractDeploymentInfra infrastructure : infrasDAO.list()) {
                    String infraType = JSON.getType((Object)infrastructure);
                    this.inc(report.nbInfrasByType, infraType);
                    if (Objects.equals(infraType, AbstractDeploymentInfra.InfraType.DATABRICKS.toString())) {
                        DatabricksAPIDeploymentInfra dbxInfrastructure = (DatabricksAPIDeploymentInfra)infrastructure;
                        this.inc(report.nbDatabricksInfrasByModelStorageType, dbxInfrastructure.usesUnityCatalog ? "UNITY_CATALOG" : "WORKSPACE_MODEL_REGISTRY");
                    }
                    this.inc(report.nbHooksByType, "PREDEPLOY", infrastructure.deploymentHookSettings.preDeploymentHooks.size());
                    this.inc(report.nbHooksByType, "POSTDEPLOY", infrastructure.deploymentHookSettings.postDeploymentHooks.size());
                    infraMap.put(infrastructure.id, infrastructure);
                    if (isAPIDeployerInstance) continue;
                    AbstractProjectDeploymentInfra automInfra = (AbstractProjectDeploymentInfra)infrastructure;
                    String propagation = "permissionsPropagation" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, automInfra.permissionsPropagationPolicy.name());
                    this.inc(policies.permissionsPropagationByType, propagation);
                    if (automInfra.setDeployAsUser) {
                        ++policies.deployAsUser;
                    }
                    if (!automInfra.overrideRunAsUser) continue;
                    ++policies.runAsUser;
                }
                for (AbstractDeployment deployment : deploymentsDAO.list()) {
                    AbstractAPIServiceDeployment depl;
                    String version;
                    String stage = ((AbstractDeploymentInfra)infraMap.get((Object)deployment.infraId)).stage;
                    if (!serverSettings.stageExists(stage)) {
                        stage = othersStageName;
                    }
                    if (isAPIDeployerInstance && (version = (depl = (AbstractAPIServiceDeployment)deployment).getOpenAPISettingsGenerationIfIsUsedOrNull()) != null) {
                        Pair serviceIdAndVersion = new Pair((Object)depl.getPublishedItemId(), (Object)version);
                        Integer count = (Integer)deployedApiServiceWithOpenAPICounter.get(serviceIdAndVersion);
                        if (count == null) {
                            count = 0;
                        }
                        deployedApiServiceWithOpenAPICounter.put(serviceIdAndVersion, count + 1);
                    }
                    this.inc(deploymentCountsPerStage, stage);
                    this.inc(report.nbDeploymentsByType, JSON.getType((Object)deployment));
                }
                for (InfraStage stage : serverSettings.stages) {
                    Integer stageCounts = (Integer)deploymentCountsPerStage.get(stage.id);
                    if (stageCounts == null) {
                        stageCounts = 0;
                    }
                    report.nbDeploymentsByStage.add(stageCounts);
                }
                Integer othersStageCount = (Integer)deploymentCountsPerStage.get(othersStageName);
                if (othersStageCount != null) {
                    report.nbDeploymentsByStage.add(othersStageCount);
                }
                publishedItems = publishedItemsDAO.list();
            }
            if (isAPIDeployerInstance) {
                int nbDeploymentsWithOpenAPI = 0;
                for (Map.Entry entry : deployedApiServiceWithOpenAPICounter.entrySet()) {
                    PublishedApiServicePackageInfo ppi = this.publishedAPIServicesService.getPublishedPackageOrNull_Check_NT((String)((Pair)entry.getKey()).first, (String)((Pair)entry.getKey()).second, authCtx);
                    if (ppi == null || !ppi.hasOpenAPIDoc) continue;
                    nbDeploymentsWithOpenAPI += ((Integer)entry.getValue()).intValue();
                }
                ((UsageSummaryModel.APIDeployerSummaryReport)report).nbDeploymentsWithOpenAPI = nbDeploymentsWithOpenAPI;
            } else {
                ((UsageSummaryModel.ProjectDeployerSummaryReport)report).nbInfraPoliciesByOption = policies;
            }
            this.addPublishedItemsUsage(report, publishedItems, publishedItemService, authCtx);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to build report for " + (isAPIDeployerInstance ? "API" : "project") + " deployer : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private void addPublishedItemsUsage(UsageSummaryModel.DeployerSummaryReport report, List<PublishedItem> publishedItems, AbstractPublishedItemsService<? extends AbstractDeployment, ? extends AbstractPublishedItemBasicInfo, ? extends AbstractDeploymentInfra> publishedItemService, DSSAuthCtx authCtx) throws UnauthorizedException, IOException {
        HashMap<String, Long> nodeLastPublishByInstallId = new HashMap<String, Long>();
        for (PublishedItem publishedItem : publishedItems) {
            AbstractPublishedItemLightStatus lightStatus = publishedItemService.getPublishedItemLightStatusUnsafe_NT_Check(publishedItem.id, authCtx);
            report.addNumberOfPackages(lightStatus.packages.size());
            for (PublishedPackageInfo publishedPackage : lightStatus.packages) {
                if (publishedPackage.designNodeInfo == null || !StringUtils.isNotEmpty((String)publishedPackage.designNodeInfo.installId)) continue;
                nodeLastPublishByInstallId.merge(publishedPackage.designNodeInfo.installId, publishedPackage.publishedOn, Long::max);
            }
        }
        report.sourceDesignNodes = nodeLastPublishByInstallId.entrySet().stream().map(e -> new UsageSummaryModel.DeployerSourceNode((String)e.getKey(), DKUDateUtils.isoFormatLocal((long)((Long)e.getValue())))).collect(Collectors.toSet());
    }

    private void summarizeConnections(UsageSummaryModel.SummaryReport ret) {
        try {
            Map<Object, Object> connections = new HashMap();
            try (Transaction ignored = this.transactionService.beginRead();){
                connections = ConnectionsDAO.get().listUnsafe();
            }
            ret.connections.all = connections.size();
            for (DSSConnection dSSConnection : connections.values()) {
                this.inc(ret.connections.connectionsByType, dSSConnection.type);
                if (!(dSSConnection instanceof AbstractLLMConnection)) continue;
                AbstractLLMConnection lconn = (AbstractLLMConnection)dSSConnection;
                AbstractLLMConnection.AbstractLLMConnectionParams params = lconn.getLLMConnectionParams();
                UsageSummaryModel.LLMConnectionSummary lcs = new UsageSummaryModel.LLMConnectionSummary();
                lcs.type = dSSConnection.getType();
                lconn.fillModelsForGlobalSummaryReport(lcs);
                List<GuardrailsPipelineSettings.GuardrailsPipelineElement> gr = params.guardrailsPipelineSettings.guardrails;
                if (gr.stream().anyMatch(g -> "ForbiddenTermsDetector".equals(g.type))) {
                    lcs.queryForbiddenTermsDetection = true;
                    ++ret.connections.llmQueryForbiddenTermsDetection;
                }
                if (gr.stream().anyMatch(g -> "PIIDetector".equals(g.type))) {
                    lcs.queryPIIDetection = true;
                    ++ret.connections.llmQueryPIIDetection;
                }
                if (gr.stream().anyMatch(g -> "ToxicityDetector".equals(g.type))) {
                    lcs.queryToxicityDetection = true;
                    ++ret.connections.llmQueryToxicityDetection;
                }
                if (gr.stream().anyMatch(g -> "PromptInjectionDetector".equals(g.type))) {
                    lcs.promptInjectionDetection = true;
                    ++ret.connections.llmPromptInjectionDetection;
                }
                ret.connections.llmConnections.add(lcs);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to summarize connections for usage summary report", (Throwable)e);
        }
    }

    private void summarizeClusters(UsageSummaryModel.SummaryReport ret) {
        try {
            List<Cluster> clusters;
            try (Transaction ignored = this.transactionService.beginRead();){
                clusters = this.clustersDAO.listUnsafe();
            }
            ret.clusters.all = clusters.size();
            block25: for (Cluster cluster : clusters) {
                switch (cluster.type) {
                    case "manual": {
                        this.inc(ret.clusters.clustersByType, "manual_" + String.valueOf((Object)cluster.architecture));
                        continue block25;
                    }
                    case "pycluster_gke-clusters_create-gke-cluster": {
                        this.inc(ret.clusters.clustersByType, "gke_create");
                        continue block25;
                    }
                    case "pycluster_gke-clusters_attach-gke-cluster": {
                        this.inc(ret.clusters.clustersByType, "gke_attach");
                        continue block25;
                    }
                    case "pycluster_aks-clusters_create-aks-cluster": {
                        this.inc(ret.clusters.clustersByType, "aks_create");
                        continue block25;
                    }
                    case "pycluster_aks-clusters_attach-aks-cluster": {
                        this.inc(ret.clusters.clustersByType, "aks_attach");
                        continue block25;
                    }
                    case "pycluster_eks-clusters_create-eks-cluster": {
                        this.inc(ret.clusters.clustersByType, "eks_create");
                        continue block25;
                    }
                    case "pycluster_eks-clusters_attach-eks-cluster": {
                        this.inc(ret.clusters.clustersByType, "eks_attach");
                        continue block25;
                    }
                }
                this.inc(ret.clusters.clustersByType, "custom_" + String.valueOf((Object)cluster.architecture));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to summarize clusters for usage summary report", (Throwable)e);
        }
    }

    public UsageSummaryModel.MonitoringReportWithProjects buildGlobalMonitoringReport() throws IOException {
        List<UserDefinedMeaning> meanings;
        List<SerializedProject> serializedProjects;
        UsageSummaryModel.MonitoringReportWithProjects ret = new UsageSummaryModel.MonitoringReportWithProjects();
        try (Transaction ignored = this.transactionService.beginRead();){
            serializedProjects = this.projectsService.listAllUnsafe();
            meanings = this.meaningsDAO.listUnsafe();
        }
        ret.projects = serializedProjects.size();
        for (UserDefinedMeaning meaning : meanings) {
            ++ret.udms.nbUDM;
            if (meaning.detectable) {
                ++ret.udms.nbUDM;
                this.inc(ret.udms.detectableByType, meaning.type.toString());
            }
            this.inc(ret.udms.udmByType, meaning.type.toString());
        }
        for (SerializedProject sp : serializedProjects) {
            try {
                Transaction ignored = this.transactionService.beginRead();
                try {
                    UsageSummaryModel.ProjectMonitoringReport report = this.buildProjectMonitoringReport(sp, ret);
                    report.projectKey = sp.projectKey;
                    report.projectName = sp.name;
                    ret.projectsSummaries.add(report);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to build report for " + sp.projectKey + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        return ret;
    }

    public UsageSummaryModel.SummaryReport buildGlobalSummary(boolean withPerProject) throws Exception {
        Map<String, UserLastActivity> usersActivity;
        List<UsersDAO.User> users;
        List<UserDefinedMeaning> meanings;
        List<SerializedProject> serializedProjects;
        UsageSummaryModel.SummaryReport ret = withPerProject ? new SummaryReportWithProjects() : new UsageSummaryModel.SummaryReport();
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        HashMap<String, ProjectFolder> projectFolders = new HashMap<String, ProjectFolder>();
        try (Transaction t = this.transactionService.beginRead();){
            for (ProjectFolder pf : this.projectFoldersService.listAll_Uncheck()) {
                projectFolders.put(pf.id, pf);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to retrieve project folders : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        ret.projectFolders.nbProjectFolders = projectFolders.size();
        for (ProjectFolder pf : projectFolders.values()) {
            boolean hasParent;
            int depth = 0;
            ProjectFolder cPf = pf;
            boolean bl = hasParent = StringUtils.isNotBlank((String)pf.parentId) && projectFolders.containsKey(pf.parentId);
            if (!hasParent) {
                ret.projectFolders.nbProjectsInRoot = pf.projectKeys.size();
            }
            while (StringUtils.isNotBlank((String)cPf.parentId) && projectFolders.containsKey(cPf.parentId)) {
                cPf = (ProjectFolder)projectFolders.get(cPf.parentId);
                ++depth;
            }
            ret.projectFolders.maxDepth = Math.max(ret.projectFolders.maxDepth, depth);
            ret.projectFolders.nbProjectsTotal += pf.projectKeys.size();
        }
        this.addDeploymentAndInfraUsage(ret.apiDeployer, gs.apiDeployerServerSettings);
        this.addDeploymentAndInfraUsage(ret.projectDeployer, gs.projectDeployerServerSettings);
        ret.nodeType = ApplicationConfigurator.getNodeType();
        ret.deploymentMode = DKUApp.getDeploymentMode();
        ret.cloudStacksCloud = DKUApp.getCloudStacksCloud();
        try (Object t = this.transactionService.beginRead();){
            ret.licenseLimits = this.licenseEnforcementService.getLimitsStatus();
            serializedProjects = this.projectsService.listAllUnsafe();
            meanings = this.meaningsDAO.listUnsafe();
            users = this.usersDAO.listUsersUnsafe();
            usersActivity = this.usersService.getAllUsersActivity(true);
        }
        this.applicationInstanceInfoByAppId = this.buildApplicationInstanceInfoByAppId(serializedProjects);
        for (UsersDAO.User user : users) {
            try {
                String loginHash = DigestUtils.md5Hex((String)user.login.toLowerCase(Locale.ENGLISH));
                Object mapsWhereToAddTheUser = new ArrayList<Map<String, List<String>>>();
                Pair<LicenseEnforcementService.TrialTokenStatus, String> p = UsersService.computeTrialStatusAndResultingUserProfile(gs, user);
                if (!user.enabled) {
                    mapsWhereToAddTheUser.add(ret.licenseProfileDetails.disabledByLogin);
                } else if (((LicenseEnforcementService.TrialTokenStatus)p.first).valid) {
                    mapsWhereToAddTheUser.add(ret.licenseProfileDetails.validTrialsByLogin);
                } else {
                    mapsWhereToAddTheUser.add(ret.licenseProfileDetails.byLogin);
                }
                if (((LicenseEnforcementService.TrialTokenStatus)p.first).exists && ((LicenseEnforcementService.TrialTokenStatus)p.first).expired) {
                    mapsWhereToAddTheUser.add(ret.licenseProfileDetails.expiredTrialsByLogin);
                }
                if (((LicenseEnforcementService.TrialTokenStatus)p.first).exists && ((LicenseEnforcementService.TrialTokenStatus)p.first).illegal) {
                    mapsWhereToAddTheUser.add(ret.licenseProfileDetails.illegalTrialsByLogin);
                }
                ret.userDetailedReport.inc(user.sourceType);
                Iterator iterator = mapsWhereToAddTheUser.iterator();
                while (iterator.hasNext()) {
                    ArrayList<String> profileList;
                    Map map = (Map)iterator.next();
                    String resultingProfile = (String)p.second;
                    if (resultingProfile == null) {
                        resultingProfile = "unknown";
                    }
                    if ((profileList = (ArrayList<String>)map.get(resultingProfile)) == null) {
                        profileList = new ArrayList<String>();
                        map.put(resultingProfile, profileList);
                    }
                    profileList.add(loginHash);
                }
                UserLastActivity activity = usersActivity.get(user.login);
                if (activity == null) continue;
                ret.userActivity.put(loginHash, activity.lastSessionActivity);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to increment counters for user '" + user.login + "' in the global report computation : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        for (UserDefinedMeaning userDefinedMeaning : meanings) {
            ++ret.udms.nbUDM;
            if (userDefinedMeaning.detectable) {
                ++ret.udms.nbUDM;
                this.inc(ret.udms.detectableByType, userDefinedMeaning.type.toString());
            }
            this.inc(ret.udms.udmByType, userDefinedMeaning.type.toString());
        }
        try {
            for (InstalledPluginDesc installedPluginDesc : this.pluginsService.getLoadedPlugins()) {
                ret.plugins.pluginIds.add(installedPluginDesc.desc.id);
            }
            File customJSFile = ApplicationConfigurator.getFile((String)"local/custom.js");
            if (customJSFile.isFile()) {
                ret.plugins.nbCustomJS = 1;
            }
            ret.plugins.nbPythonDatasets = this.customPythonDatasetsService.list().size();
            ret.plugins.nbJavaDatasets = this.customJavaDatasetsService.list().size();
            ret.plugins.nbRecipes = this.customCodeRecipesService.list().size();
            ret.plugins.nbPythonProbes = this.customPythonProbesService.list().size();
            ret.plugins.nbPythonChecks = this.customPythonChecksService.list().size();
            ret.plugins.nbSQLProbes = this.customSQLProbesService.list().size();
            ret.plugins.nbPythonFormats = this.customPythonFormatsService.list().size();
            ret.plugins.nbJavaFormats = this.customJavaFormatsService.list().size();
            ret.plugins.nbPythonExporters = this.customPythonExporterService.list().size();
            ret.plugins.nbJavaExporters = this.customJavaExporterService.list().size();
            ret.plugins.nbPythonScenarioSteps = this.pythonPluginStepsService.list().size();
            ret.plugins.nbPythonScenarioTriggers = this.pythonPluginTriggersService.list().size();
            ret.plugins.nbPythonRunnables = this.customPythonRunnablesService.list().size();
            ret.plugins.nbJavaRunnables = this.customJavaRunnablesService.list().size();
            ret.plugins.nbPythonFSProviders = this.customPythonFSProvidersService.list().size();
            ret.plugins.nbJavaFSProviders = this.customJavaFSProvidersService.list().size();
            ret.plugins.nbSQLDialects = this.customJavaDialectsService.list().size();
            ret.plugins.nbJythonProcessors = this.customJythonStepsService.list().size();
            ret.plugins.nbPythonClusters = this.pythonPluginClustersService.list().size();
            ret.plugins.nbCustomFields = this.customFieldsService.getCustomFieldsMap().size();
            ret.plugins.nbJavaPolicyHooks = this.customJavaPolicyHooksService.getPluginComponentRefs().size();
            for (LoadedCustomWebApp webapp : this.customWebAppsService.list()) {
                if (webapp.desc == null || webapp.desc.baseType == null) continue;
                switch (webapp.desc.baseType) {
                    case "STANDARD": {
                        ++ret.plugins.nbStandardWebapps;
                        break;
                    }
                    case "SHINY": {
                        ++ret.plugins.nbShinyWebapps;
                        break;
                    }
                    case "BOKEH": {
                        ++ret.plugins.nbBokehWebapps;
                        break;
                    }
                    case "DASH": {
                        ++ret.plugins.nbDashWebapps;
                    }
                }
            }
            for (LoadedCustomAppTemplate loadedCustomAppTemplate : this.customAppTemplatesService.list()) {
                Object applicationInstanceType;
                if (loadedCustomAppTemplate.isUsedAsRecipe()) {
                    ++ret.plugins.nbApplicationAsRecipes;
                    applicationInstanceType = ApplicationInstanceType.APPLICATION_AS_RECIPE_FROM_PLUGIN;
                } else {
                    ++ret.plugins.nbApplications;
                    applicationInstanceType = ApplicationInstanceType.APPLICATION_FROM_PLUGIN;
                }
                this.applicationInstanceInfoByAppId.setApplicationInstanceTypeIfExists(loadedCustomAppTemplate.getType(), (ApplicationInstanceType)((Object)applicationInstanceType));
            }
            ret.plugins.devExplicitCommit = gs.pluginDevExplicitCommit;
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to increment counters for plugins in the global report computation : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            ret.generalSettings.sso = gs.ssoSettings.enabled;
            if (ret.generalSettings.sso) {
                ret.generalSettings.ssoProtocol = gs.ssoSettings.protocol;
            }
            ret.generalSettings.ssoProvisioningEnabled = gs.ssoSettings.autoProvisionUsersAtLoginTime;
            ret.generalSettings.ldap = gs.ldapSettings.enabled;
            ret.generalSettings.ldapAuthEnabled = gs.ldapSettings.authenticationEnabled;
            ret.generalSettings.ldapProvisioningEnabled = gs.ldapSettings.autoImportUsers;
            ret.generalSettings.azureADSupplierEnabled = gs.azureADSettings.enabled;
            ret.generalSettings.azureADProvisioningEnabled = gs.azureADSettings.autoProvisionUsersAtLoginTime;
            ret.generalSettings.pamAuthenticatorEnabled = gs.pamSettings.enabled;
            ret.generalSettings.customAuthenticatorEnabled = this.dssCustomUserAuthenticatorDelegator.getAuthenticatorSettings().isAuthenticationEnabled();
            ret.generalSettings.customUserSupplierEnabled = this.dssCustomUserSupplierDelegate.getUserSupplierSettings().isEnabled();
            ret.generalSettings.enrichDSSUserFromLdapEnabled = false;
            ret.generalSettings.enableEmailAndDisplayNameModification = gs.security.enableEmailAndDisplayNameModification;
            ret.generalSettings.hashApiKeys = gs.security.hashApiKeys;
            ret.generalSettings.apiKeysLifetimeDays = gs.security.apiKeysLifetimeDays;
            ret.generalSettings.opalsEnabled = gs.opalsEnabled;
            ret.generalSettings.onboardingExperience = gs.onboardingExperience;
            ret.generalSettings.prepareAICompletionEnabled = gs.aiDrivenAnalyticsSettings.prepareAICompletionEnabled;
            ret.generalSettings.aiExplanationsEnabled = gs.aiDrivenAnalyticsSettings.aiExplanationsEnabled;
            ret.generalSettings.storiesAIEnabled = gs.aiDrivenAnalyticsSettings.storiesAIEnabled;
            ret.generalSettings.storiesVocalEnabled = gs.aiDrivenAnalyticsSettings.storiesAIEnabled && FeatureFlags.isEnabled((String)"storiesVocal");
            ret.generalSettings.mus = gs.impersonation.enabled;
            ret.generalSettings.hasDSSURL = StringUtils.isNotBlank((String)gs.studioExternalUrl);
            ret.generalSettings.hasAdminContact = StringUtils.isNotBlank((String)gs.studioAdminContact);
            ret.generalSettings.graphite = StringUtils.isNotBlank((String)gs.graphiteServerUrl);
            ret.generalSettings.hasDefaultK8sClusterId = StringUtils.isNotBlank((String)gs.defaultK8sClusterId);
            ret.generalSettings.cgroups = gs.cgroupSettings.enabled;
            ret.generalSettings.externalRuntimeDatabases = gs.internalDatabase.connection != null;
            ret.generalSettings.streaming = gs.streamingEnabled;
            ret.generalSettings.showProjectsGraphView = gs.showProjectsGraphView;
            GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
            ret.generalSettings.deployerMode = ref.mode;
            ret.generalSettings.portRangeLimitation = FeatureFlags.isEnabled((String)"portRangeLimitation") && gs.dssPortRange.enabled;
            ret.generalSettings.projectsAccessibilityMode = gs.projectVisibility.visibilityMode;
            ret.generalSettings.projectsAccessRequestMode = gs.projectVisibility.accessRequestsMode;
            ret.generalSettings.appsAccessibilityMode = gs.appVisibility.visibilityMode;
            ret.generalSettings.appsAccessRequestMode = gs.appVisibility.accessRequestsMode;
            ret.generalSettings.permissionsByEmailEnabled = gs.permissionsByEmailEnabled;
            ret.generalSettings.hasQuickSharingElementsEnabled = gs.quickSharingElementsEnabled;
            ret.generalSettings.objectSharingRequestsMode = gs.objectSharingRequestsMode;
            ret.generalSettings.trialBehavior = gs.licensingSettings.trialBehavior;
            ret.generalSettings.noneUsersCallToActionBehavior = gs.licensingSettings.noneUsersCallToActionBehavior;
            ret.generalSettings.userProfileForTrialsStartedByNoneUsers = gs.licensingSettings.userProfileForTrialsStartedByNoneUsers;
            ret.generalSettings.trialExpirationBehavior = gs.licensingSettings.trialExpirationBehavior;
            ret.generalSettings.trialExpirationTargetProfile = gs.licensingSettings.trialExpirationTargetProfile;
            ret.generalSettings.allowRequestAccessWithStartedTrial = gs.licensingSettings.allowRequestAccessWithStartedTrial;
            ret.generalSettings.hasSignUpMessage = StringUtils.isNotBlank((String)gs.licensingSettings.signUpMessage);
            ret.generalSettings.hasUpgradeProfileMessage = StringUtils.isNotBlank((String)gs.licensingSettings.upgradeProfileCallToActionMessage);
            ret.generalSettings.allowProfileUpgradeRequests = gs.licensingSettings.allowProfileUpgradeRequests;
            ret.generalSettings.welcomeEmailEnabled = gs.welcomeEmailSettings.enabled;
            ret.generalSettings.notificationEmailChannelEnabled = StringUtils.isNotBlank((String)gs.notifications.emailChannelId);
            ret.generalSettings.welcomeEmailsSentCount = this.welcomeEmailService.countWelcomeEmailsSent();
            ret.generalSettings.aiExplanationsUseLocal = gs.localAIServerSettings.isLocalAiAssistantEnabled(GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.aiExplanations);
            ret.generalSettings.prepareAICompletionUseLocal = gs.localAIServerSettings.isLocalAiAssistantEnabled(GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.prepareAICompletion);
            ret.generalSettings.aiGenerateSQLUseLocal = gs.localAIServerSettings.isLocalAiAssistantEnabled(GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.aiGenerateSQL);
            ret.generalSettings.storiesAIUseLocal = gs.localAIServerSettings.isLocalAiAssistantEnabled(GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.storiesAI);
            for (ContainerExecRuntimeConfig config : gs.containerSettings.executionConfigs) {
                if (config.type == null || config.workloadType == null) continue;
                this.inc(ret.generalSettings.containerConfigByTypeAndWorkload, String.format("%s_%s", new Object[]{config.type, config.workloadType}));
            }
            ret.generalSettings.hasDefaultExecutionConfig = StringUtils.isNotBlank((String)gs.containerSettings.defaultExecutionConfig);
            ret.generalSettings.hasDefaultExecutionConfigForVisualRecipesWorkloads = StringUtils.isNotBlank((String)gs.containerSettings.defaultExecutionConfigForVisualRecipesWorkloads);
            ret.generalSettings.hasDSSVisualizationThemeSet = StringUtils.isNotBlank((String)gs.selectedDSSVisualizationThemeId) && !this.builtinThemesRegistry.has(gs.selectedDSSVisualizationThemeId);
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to summarise the general settings usage in the global report computation : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            ret.experimentTracking.nbExperiments = this.experimentTrackingService.countAllExperiments();
        }
        catch (Throwable t2) {
            logger.error((Object)"Failed to summarize experiment tracking", t2);
        }
        this.summarizeWorkspaces(ret);
        this.codeStudioTemplateInfoById = this.summarizeCodeStudioTemplates(ret);
        ret.projectStandards = new UsageSummaryModel.ProjectStandardsSummaryReport();
        ret.projectStandards.nbChecksByScope = this.projectStandardsService.getScopesUnsafe().stream().collect(Collectors.toMap(s -> s.name, s -> s.checks.size()));
        try {
            ret.featureStore.nbFeatureGroups = this.featureStoreService.searchFeatureGroups((String)"", null, (AuthCtx)DSSAuthCtx.fakeAdminForTests((String)"dss-internal"), null).totalHits.value;
        }
        catch (Throwable t3) {
            logger.error((Object)"Failed to summarize feature store", t3);
        }
        t = this.transactionService.beginRead();
        try {
            for (DataQualityTemplate template : this.dataQualityTemplatesDAO.listUnsafe()) {
                this.usbu.summarizeDataQualityTemplate(ret.dataQualityTemplates, template);
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        this.summarizeLLMCostLimiting(ret);
        this.summarizeLLMRateLimiting(ret);
        ret.projects = serializedProjects.size();
        FilterReportBuilder globalFilterReportBuilder = new FilterReportBuilder();
        UsageSummaryBuilderUtils.VisualIfRuleAggregator visualIfRuleAggregator = new UsageSummaryBuilderUtils.VisualIfRuleAggregator();
        UsageSummaryBuilderUtils.VisualIfRuleAggregator globalAnalysisVisIfAggregator = new UsageSummaryBuilderUtils.VisualIfRuleAggregator();
        for (SerializedProject sp : serializedProjects) {
            try (Transaction t = this.transactionService.beginRead();){
                ProjectSummaryReport psum = this.summarizeProject(sp, ret, globalFilterReportBuilder, visualIfRuleAggregator, globalAnalysisVisIfAggregator);
                psum.projectKey = sp.projectKey;
                psum.projectName = sp.name;
                if (withPerProject) {
                    ret.projectsSummaries.add(psum);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to summarize project : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
            if (sp.settings.limitedVisibilityEnabled.isDisabled()) {
                ++ret.privateProjects;
                continue;
            }
            if (sp.settings.limitedVisibilityEnabled.isEnabled()) {
                ++ret.limitedVisibilityProjects;
                continue;
            }
            if (!sp.settings.limitedVisibilityEnabled.isInherited()) continue;
            ++ret.inheritedVisibilityProjects;
        }
        ret.filters = globalFilterReportBuilder.toFilterSummaryReport();
        ret.shakerRecipes.visualIfProcessor = visualIfRuleAggregator.toSummary();
        ret.analysis.visualIfProcessor = globalAnalysisVisIfAggregator.toSummary();
        this.summarizeApplicationInstances(ret);
        this.summarizeClusters(ret);
        this.summarizeConnections(ret);
        this.summarizePythonCodeEnvs(ret.pythonCodeEnvs);
        ret.dataCollections = this.summarizeDataCollections();
        try {
            ret.popularDatasets = this.popularDatasetsService.getReportData();
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to summarize popular datasets : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        ret.unifiedMonitoring = this.unifiedMonitoringDeployerComputationService.getReportData_NT();
        try (Transaction t = this.transactionService.beginRead();){
            ret.dssVisualizationThemeReport.counts = this.dssVisualizationThemeDAO.approximateCount();
        }
        return ret;
    }

    private void summarizeApplicationInstances(UsageSummaryModel.SummaryReport summaryReport) {
        try {
            block8: for (ApplicationInstanceInfo applicationInstanceInfo : this.applicationInstanceInfoByAppId.values()) {
                switch (applicationInstanceInfo.getApplicationInstanceType()) {
                    case APPLICATION_FROM_PROJECT: {
                        summaryReport.appInstances.projectApplicationInstances.applicationInstances += applicationInstanceInfo.instanceCount;
                        continue block8;
                    }
                    case APPLICATION_AS_RECIPE_FROM_PROJECT: {
                        summaryReport.appInstances.projectApplicationInstances.applicationAsRecipeInstances += applicationInstanceInfo.instanceCount;
                        continue block8;
                    }
                    case APPLICATION_FROM_PLUGIN: {
                        summaryReport.appInstances.pluginApplicationInstances.applicationInstances += applicationInstanceInfo.instanceCount;
                        continue block8;
                    }
                    case APPLICATION_AS_RECIPE_FROM_PLUGIN: {
                        summaryReport.appInstances.pluginApplicationInstances.applicationAsRecipeInstances += applicationInstanceInfo.instanceCount;
                        continue block8;
                    }
                }
                logger.infoV("Could not establish origin type for %d instances. The application used to generate the instances has been removed or converted back to a regular project.", new Object[]{applicationInstanceInfo.getInstanceCount()});
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to summarize application instances for usage summary report", (Throwable)e);
        }
    }

    public void summarizePythonCodeEnvs(UsageSummaryModel.PythonCodeEnvsSummaryReport codeEnvsSummaryReport) {
        codeEnvsSummaryReport.baseEnvVersion = pythonBaseEnvVersion;
        this.countDesignPythonCodeEnvs(codeEnvsSummaryReport);
        this.countAutomationPythonCodeEnvs(codeEnvsSummaryReport);
    }

    private boolean dataCollectionItemExists(AbstractDataCollectionItem item) {
        try {
            if (item instanceof DataCollectionDataset) {
                return this.datasetsDAO.exists(((DataCollectionDataset)item).reference.getProjectKey(), ((DataCollectionDataset)item).reference.getId());
            }
        }
        catch (IOException e) {
            logger.error((Object)"Unable to test data-collection item existence", (Throwable)e);
        }
        return false;
    }

    public UsageSummaryModel.DataCollectionsSummaryReport summarizeDataCollections() {
        UsageSummaryModel.DataCollectionsSummaryReport ret = new UsageSummaryModel.DataCollectionsSummaryReport();
        List<Object> items = new ArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            items = this.dataCollectionsService.listUnsafe().stream().map(collection -> collection.items.stream().filter(this::dataCollectionItemExists).collect(Collectors.toList())).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to summarize data collections : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        ret.dataCollectionGlobalCount = items.size();
        List itemCounts = items.stream().map(List::size).collect(Collectors.toList());
        ret.itemsGlobalCount = itemCounts.stream().reduce(0, Integer::sum);
        ret.itemsGlobalMax = itemCounts.stream().reduce(0, Integer::max);
        List datasetsCounts = items.stream().map(c2 -> c2.stream().filter(i -> i instanceof DataCollectionDataset).count()).map(Long::intValue).collect(Collectors.toList());
        ret.datasetsGlobalCount = datasetsCounts.stream().reduce(0, Integer::sum);
        ret.datasetsGlobalMax = datasetsCounts.stream().reduce(0, Integer::max);
        return ret;
    }

    private void countDesignPythonCodeEnvs(UsageSummaryModel.PythonCodeEnvsSummaryReport codeEnvsSummaryReport) {
        try {
            for (CodeEnvModel.CodeEnvListItem codeEnv : this.designNodeEnvsService.listCodeEnvs()) {
                GlobalUsageSummaryBuilder.addPythonCodeEnvToSummary(codeEnvsSummaryReport, codeEnv.pythonInterpreter);
            }
        }
        catch (Exception e) {
            logger.info((Object)("Unable to summarize code envs : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private void countAutomationPythonCodeEnvs(UsageSummaryModel.PythonCodeEnvsSummaryReport codeEnvsSummaryReport) {
        try {
            for (CodeEnvModel.CodeEnvListItem codeEnv : this.automationNodeEnvsService.listCodeEnvs()) {
                try {
                    CodeEnvModel.AutomationUIPythonEnv automationPythonEnv = this.automationNodeEnvsService.getPythonEnvForUI(codeEnv.envName, false);
                    if (automationPythonEnv.noVersion != null) {
                        GlobalUsageSummaryBuilder.addPythonCodeEnvToSummary(codeEnvsSummaryReport, ((CodeEnvModel.AutomationUIPythonEnvVersion)automationPythonEnv.noVersion).desc);
                        continue;
                    }
                    if (automationPythonEnv.currentVersion != null) {
                        GlobalUsageSummaryBuilder.addPythonCodeEnvToSummary(codeEnvsSummaryReport, ((CodeEnvModel.AutomationUIPythonEnvVersion)automationPythonEnv.currentVersion).desc);
                        continue;
                    }
                    for (CodeEnvModel.AutomationUIPythonEnvVersion pythonEnvVersion : automationPythonEnv.versions) {
                        GlobalUsageSummaryBuilder.addPythonCodeEnvToSummary(codeEnvsSummaryReport, pythonEnvVersion.desc);
                    }
                }
                catch (Exception e) {
                    logger.info((Object)("Unable to summarize code env " + codeEnv.envName + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)("Unable to summarize code envs : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private static void addPythonCodeEnvToSummary(UsageSummaryModel.PythonCodeEnvsSummaryReport codeEnvsSummaryReport, CodeEnvModel.PythonEnvDesc pythonDesc) {
        if (pythonDesc == null) {
            logger.warn((Object)"Bad code env, python desc is null. Will not be included in summary.");
            return;
        }
        GlobalUsageSummaryBuilder.addPythonCodeEnvToSummary(codeEnvsSummaryReport, pythonDesc.pythonInterpreter);
    }

    private static void addPythonCodeEnvToSummary(UsageSummaryModel.PythonCodeEnvsSummaryReport codeEnvsSummaryReport, StandardPythonInterpreter pythonInterpreter) {
        if (pythonInterpreter == null) {
            logger.warn((Object)"Bad code env, python interpreter is null. Will not be included in summary.");
            return;
        }
        String pythonVersion = pythonInterpreter.toString();
        Integer pythonVersionCount = codeEnvsSummaryReport.versionsCount.getOrDefault(pythonVersion, 0);
        codeEnvsSummaryReport.versionsCount.put(pythonVersion, pythonVersionCount + 1);
    }

    private static String getPythonBaseEnvVersion() {
        String pythonBin = System.getenv("DKUPYTHONBIN");
        if (pythonBin == null) {
            logger.error((Object)"DKUPYTHONBIN env variable is not set!");
            return null;
        }
        ProcessBuilder builder = new ProcessBuilder(new File(pythonBin).getAbsolutePath(), "-c", "import sysconfig;print(sysconfig.get_python_version())");
        try {
            return new String(DKUtils.execAndGetOutput((ProcessBuilder)builder, (String)"Could not get python version."), StandardCharsets.UTF_8).trim();
        }
        catch (InterruptedException e) {
            logger.error((Object)"Failed to get Python base env version. Interrupted while retrieving version.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get Python base env version.", (Throwable)e);
        }
        return "unknown";
    }

    private void inc(Map<String, Integer> countMap, String key) {
        this.inc(countMap, key, 1);
    }

    private void inc(Map<String, Integer> countMap, String key, int increment) {
        Integer prev = countMap.get(key);
        if (prev == null) {
            prev = 0;
        }
        countMap.put(key, prev + increment);
    }

    private ApplicationInstanceInfoByAppId buildApplicationInstanceInfoByAppId(List<SerializedProject> serializedProjects) {
        ApplicationInstanceInfoByAppId applicationInstancesInfoByAppId = new ApplicationInstanceInfoByAppId();
        for (SerializedProject serializedProject : serializedProjects) {
            boolean isNotApplicationInstance = !SerializedProject.ProjectAppType.APP_INSTANCE.equals((Object)serializedProject.projectAppType);
            if (isNotApplicationInstance || StringUtils.isBlank((String)serializedProject.generatingAppId)) continue;
            applicationInstancesInfoByAppId.computeIfAbsent(serializedProject.generatingAppId, s -> new ApplicationInstanceInfo()).increment();
        }
        return applicationInstancesInfoByAppId;
    }

    public static class ApplicationInstanceInfoByAppId
    extends HashMap<String, ApplicationInstanceInfo> {
        void setApplicationInstanceTypeIfExists(String applicationId, ApplicationInstanceType applicationInstanceType) {
            if (this.containsKey(applicationId)) {
                ((ApplicationInstanceInfo)this.get(applicationId)).setApplicationInstanceType(applicationInstanceType);
            }
        }

        int getInstanceCount(String applicationId) {
            if (!this.containsKey(applicationId)) {
                return 0;
            }
            return ((ApplicationInstanceInfo)this.get(applicationId)).getInstanceCount();
        }
    }

    public static class CodeStudioTemplateInfoById
    extends HashMap<String, CodeStudioTemplateInfo> {
    }

    public static class ProjectSummaryReport
    extends UsageSummaryModel.SummaryReport {
        public String projectKey;
        public String projectName;
    }

    static class CodeStudioTemplateInfo {
        public Set<String> blockTypes = Sets.newHashSet();

        CodeStudioTemplateInfo() {
        }
    }

    public static class SummaryReportWithProjects
    extends UsageSummaryModel.SummaryReport {
        public List<ProjectSummaryReport> projectsSummaries = new ArrayList<ProjectSummaryReport>();
    }

    static enum ApplicationInstanceType {
        APPLICATION_FROM_UNKNOWN_SOURCE,
        APPLICATION_FROM_PROJECT,
        APPLICATION_FROM_PLUGIN,
        APPLICATION_AS_RECIPE_FROM_PROJECT,
        APPLICATION_AS_RECIPE_FROM_PLUGIN;

    }

    static class ApplicationInstanceInfo {
        private int instanceCount;
        private ApplicationInstanceType applicationInstanceType = ApplicationInstanceType.APPLICATION_FROM_UNKNOWN_SOURCE;

        ApplicationInstanceInfo() {
        }

        void setApplicationInstanceType(ApplicationInstanceType applicationInstanceType) {
            this.applicationInstanceType = applicationInstanceType;
        }

        ApplicationInstanceType getApplicationInstanceType() {
            return this.applicationInstanceType;
        }

        public int getInstanceCount() {
            return this.instanceCount;
        }

        private void increment() {
            ++this.instanceCount;
        }
    }
}

