/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity;

import com.dataiku.dip.activity.GlobalUsageSummaryBuilder;
import com.dataiku.dip.activity.UsageSummaryBuilderUtils;
import com.dataiku.dip.activity.UsageSummaryModel;
import com.dataiku.dip.activity.filterutils.FilterReportBuilder;
import com.dataiku.dip.activity.filterutils.FilterTraverser;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.codestudio.blocks.BlockBasedCodeStudioTemplateParams;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.CodeStudioObjectsDAO;
import com.dataiku.dip.dao.CodeStudioTemplatesDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.dashboards.DashboardsDAO;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.eda.worksheets.WorksheetsDAO;
import com.dataiku.dip.eda.worksheets.models.Worksheet;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksCRUDService;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.recipes.ParamsWithVariablesExpansionLoopConfig;
import com.dataiku.dip.recipes.eda.StatsTestRecipeMeta;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.ArticlesDAO;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectUsageSummaryBuilder {
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private LambdaServicesDAO lambdaServicesDAO;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private SearchNotebooksDAO searchNotebooksDAO;
    @Autowired
    private LabelingTasksCRUDService labelingTasksCRUDService;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private InsightsDAO insightsDAO;
    @Autowired
    private DashboardsDAO dashboardsDAO;
    @Autowired
    private WorksheetsDAO worksheetsDAO;
    @Autowired
    private ArticlesDAO articlesDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private AppsService appsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private CodeStudioObjectsDAO codeStudioObjectsDAO;
    @Autowired
    private CodeStudioTemplatesDAO codeStudioTemplatesDAO;
    @Autowired
    private WebAppsDAO webAppsDAO;
    private FilterTraverser filterTraverser = new FilterTraverser();
    private UsageSummaryBuilderUtils usbu = new UsageSummaryBuilderUtils();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.usage");

    public ProjectUsageSummaryBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    /*
     * WARNING - void declaration
     */
    public UsageSummaryModel.ProjectDetailedReport makeDetailedProjectReport(String projectKey, @Nullable GlobalUsageSummaryBuilder.ApplicationInstanceInfoByAppId applicationInstanceInfoByAppId, @Nullable GlobalUsageSummaryBuilder.CodeStudioTemplateInfoById codeStudioTemplateInfoById) throws Exception {
        List libraryFiles;
        UsageSummaryModel.ProjectDetailedReport spr = new UsageSummaryModel.ProjectDetailedReport();
        spr.id = DigestUtils.md5Hex((String)projectKey);
        HashSet<String> inputObjects = new HashSet<String>();
        HashSet<String> outputObjects = new HashSet<String>();
        HashMap<String, Set<String>> sharedInputObjects = new HashMap<String, Set<String>>();
        for (Object sr : this.recipesDAO.listUnsafe(projectKey)) {
            for (SerializedRecipe.InputRole irole : ((SerializedRecipe)sr).getInputsUnsafe().values()) {
                for (SerializedRecipe.RecipeInput rinput : irole.items) {
                    DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, rinput.ref);
                    inputObjects.add(loc.getFullName());
                    if (loc.getProjectKey().equals(projectKey)) continue;
                    sharedInputObjects.computeIfAbsent(loc.getProjectKey(), pk -> new HashSet()).add(loc.getName());
                }
            }
            for (SerializedRecipe.OutputRole orole : ((SerializedRecipe)sr).getOutputsUnsafe().values()) {
                for (SerializedRecipe.RecipeOutput routput : orole.items) {
                    outputObjects.add(DatasetLocUtils.resolveSmart(projectKey, routput.ref).getFullName());
                }
            }
        }
        FilterReportBuilder filterReportBuilder = new FilterReportBuilder();
        spr.datasets = this.makeDatasets(projectKey, inputObjects, outputObjects, sharedInputObjects, filterReportBuilder);
        spr.recipes = this.makeRecipes(projectKey, filterReportBuilder);
        spr.shakerRecipes = this.makeShakerRecipes(projectKey);
        spr.charts = this.makeCharts(projectKey);
        spr.analysis = this.makeAnalysis(projectKey, filterReportBuilder);
        try {
            for (DatasetExploreSettings datasetExploreSettings : this.exploresService.listExploresForProjectUnsafe(projectKey)) {
                this.filterTraverser.traverseFilters(filterReportBuilder, datasetExploreSettings);
            }
        }
        catch (Throwable t2) {
            logger.warn((Object)("Failed to add explore filter usage:" + ExceptionUtils.getMessageWithCauses((Throwable)t2)));
        }
        try {
            for (Worksheet worksheet : this.worksheetsDAO.listUnsafe(projectKey)) {
                this.filterTraverser.traverseFilters(filterReportBuilder, worksheet);
            }
        }
        catch (Throwable t3) {
            logger.warn((Object)("Failed to add worksheet filter usage:" + ExceptionUtils.getMessageWithCauses((Throwable)t3)));
        }
        try {
            for (Scenario scenario : this.scenariosDAO.listUnsafe(projectKey)) {
                this.usbu.summarizeScenario(spr.scenarios, scenario);
            }
        }
        catch (Throwable t4) {
            logger.warn((Object)("Failed to summarize scenarios usage:" + ExceptionUtils.getMessageWithCauses((Throwable)t4)));
        }
        try {
            for (LambdaService lambdaService : this.lambdaServicesDAO.listUnsafe(projectKey)) {
                this.usbu.summarizeAPIService(spr.apiServices, lambdaService);
            }
        }
        catch (Throwable t5) {
            logger.warn((Object)("Failed to summarize lambdas usage:" + ExceptionUtils.getMessageWithCauses((Throwable)t5)));
        }
        try {
            for (SQLNotebook sQLNotebook : this.sqlNotebooksDAO.listUnsafe(projectKey)) {
                ++spr.notebooks.nbSqlNotebooks;
                this.inc(spr.notebooks.notebooksByType, sQLNotebook.language.toString());
            }
        }
        catch (Throwable t6) {
            logger.warn((Object)("Failed to summarize SQL notebooks usage:" + ExceptionUtils.getMessageWithCauses((Throwable)t6)));
        }
        try {
            for (SearchNotebook searchNotebook : this.searchNotebooksDAO.listUnsafe(projectKey)) {
                ++spr.notebooks.nbSearchNotebooks;
                this.inc(spr.notebooks.notebooksByType, searchNotebook.language);
            }
        }
        catch (Throwable t7) {
            logger.warn((Object)("Failed to summarize Search notebooks usage:" + ExceptionUtils.getMessageWithCauses((Throwable)t7)));
        }
        try {
            for (LabelingTask labelingTask : this.labelingTasksCRUDService.listAllUnsafe(projectKey)) {
                ++spr.labelingTasks.nbLabelingTasks;
                this.inc(spr.labelingTasks.nbLabelingTasksByTpe, labelingTask.type.toString());
            }
        }
        catch (Throwable t8) {
            logger.warn((Object)("Failed to summarize Labeling tasks:" + ExceptionUtils.getMessageWithCauses((Throwable)t8)));
        }
        try {
            for (JupyterService.JupyterNotebookListEntry jupyterNotebookListEntry : this.jupyterService.listUnsafe(DSSAuthCtx.newNone(), projectKey)) {
                ++spr.notebooks.nbJupyterNotebooks;
                this.inc(spr.notebooks.notebooksByType, jupyterNotebookListEntry.language);
            }
        }
        catch (Throwable t9) {
            logger.warn((Object)("Failed to summarize jupyter usage:" + ExceptionUtils.getMessageWithCauses((Throwable)t9)));
        }
        HashSet<String> dashboardInsights = new HashSet<String>();
        try {
            for (Dashboard dashboard : this.dashboardsDAO.listUnsafe(projectKey)) {
                this.usbu.summarizeDashboards(dashboard, Collections.singletonList(spr.dashboards), projectKey, dashboardInsights);
                this.filterTraverser.traverseFilters(filterReportBuilder, dashboard);
            }
        }
        catch (Throwable throwable) {
            logger.warn((Object)("Failed to summarize dashboards usage:" + ExceptionUtils.getMessageWithCauses((Throwable)throwable)));
        }
        try {
            for (Insight insight : this.insightsDAO.listUnsafe(projectKey)) {
                this.usbu.summarizeInsights(insight, dashboardInsights, Collections.singletonList(spr.insights));
                this.filterTraverser.traverseFilters(filterReportBuilder, insight);
            }
        }
        catch (Throwable throwable) {
            logger.warn((Object)("Failed to summarize insights usage:" + ExceptionUtils.getMessageWithCauses((Throwable)throwable)));
        }
        try {
            void var10_43;
            boolean bl = false;
            int nonEmptyArticleCount = 0;
            for (Article article : this.articlesDAO.listUnsafe(projectKey)) {
                ++var10_43;
                if (!StringUtils.isNotBlank((String)this.articlesDAO.getPayloadOrNull(projectKey, article.id))) continue;
                ++nonEmptyArticleCount;
            }
            if (var10_43 > 0) {
                spr.wiki.nbArticles = var10_43;
                spr.wiki.nbNonEmptyArticles = nonEmptyArticleCount;
            }
        }
        catch (Throwable throwable) {
            logger.warn((Object)("Failed to summarize wiki usage:" + ExceptionUtils.getMessageWithCauses((Throwable)throwable)));
        }
        TransactionRef transactionRef = TransactionContext.retrieveRead();
        RelFile libDir = new RelFile(new String[]{"projects", projectKey, "lib"});
        if (transactionRef.isDirectory(libDir) && (libraryFiles = transactionRef.listRecursive(libDir)).size() > 4) {
            spr.libraries.nbFiles += libraryFiles.size() - 4;
        }
        DSSGitModel.ExternalLibraries el = (DSSGitModel.ExternalLibraries)transactionRef.readObjectDefaultUnsafe(new RelFile(new String[]{"projects", projectKey, "lib", "external-libraries.json"}), DSSGitModel.ExternalLibraries.class);
        spr.libraries.nbGitRefs += el.gitReferences.size();
        spr.libraries.nbPythonRoots += el.pythonPath.size();
        spr.libraries.nbRRoots += el.rsrcPath.size();
        spr.libraries.nbImports += el.getNonNullLibrariesFromProjects().size();
        try {
            for (CodeStudioObject codeStudio : this.codeStudioObjectsDAO.listUnsafe(projectKey)) {
                ++spr.codeStudios.nbCodeStudios;
                Set<String> blockTypes = codeStudioTemplateInfoById == null ? this.getCodeStudioTemplateBlockTypes(codeStudio.templateId) : codeStudioTemplateInfoById.getOrDefault((Object)codeStudio.templateId, new GlobalUsageSummaryBuilder.CodeStudioTemplateInfo()).blockTypes;
                blockTypes.stream().forEach(t -> this.inc(spr.codeStudios.countByBlockType, (String)t));
            }
            for (WebApp webApp : this.webAppsDAO.listUnsafe(projectKey)) {
                if (!"CODE_STUDIO_AS_WEBAPP".equals(webApp.type)) continue;
                ++spr.codeStudios.nbCodeStudioWebapps;
            }
        }
        catch (Exception exception) {
            logger.warn((Object)("Failed to summarize Code Studios usage:" + ExceptionUtils.getMessageWithCauses((Throwable)exception)));
        }
        SerializedProject serializedProject = this.projectsDAO.getOrNullUnsafe(projectKey);
        if (serializedProject != null) {
            spr.sparkPipelinesEnabled = serializedProject.settings.flowBuildSettings.mergeSparkPipelines;
            spr.sqlPipelinesEnabled = serializedProject.settings.flowBuildSettings.mergeSqlPipelines;
            spr.hasExplicitContainer = serializedProject.settings.container.containerMode == ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER && StringUtils.isNotBlank((String)serializedProject.settings.container.containerConf);
            spr.hasExplicitContainerForVisualRecipesWorkloads = serializedProject.settings.containerForVisualRecipesWorkloads.containerMode == ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER && StringUtils.isNotBlank((String)serializedProject.settings.containerForVisualRecipesWorkloads.containerConf);
            spr.hasK8sClusterIdSet = StringUtils.isNotBlank((String)serializedProject.settings.k8sCluster.defaultClusterId) || StringUtils.isNotBlank((String)serializedProject.settings.k8sCluster.clusterId);
            spr.projectAppType = serializedProject.projectAppType;
            spr.sharingRequestsEnabled = serializedProject.settings.sharingRequestsEnabled;
            if (SerializedProject.ProjectAppType.APP_TEMPLATE.equals((Object)serializedProject.projectAppType)) {
                try {
                    AppManifest manifest = this.appsService.getManifestFromProjectUnsafe(TransactionContext.retrieveRead(), projectKey);
                    spr.useAsRecipe = manifest.useAsRecipeSettings != null;
                    spr.instanceCount = applicationInstanceInfoByAppId == null ? this.getInstancesByAppId(manifest.id) : applicationInstanceInfoByAppId.getInstanceCount(manifest.id);
                    spr.appLimitedVisibilityEnabled = manifest.limitedVisibilityEnabled;
                    spr.appAccessRequestEnabled = manifest.accessRequestsEnabled;
                }
                catch (Throwable t14) {
                    logger.warn((Object)("Unable to load app manifest of " + projectKey), t14);
                }
            }
            spr.accessRequestEnabled = serializedProject.settings.accessRequestsEnabled;
            spr.limitedVisibilityEnabled = serializedProject.settings.limitedVisibilityEnabled;
            serializedProject.exposedObjects.objects.forEach(exposedObject -> {
                boolean isDataset;
                boolean bl = isDataset = exposedObject.type == ITaggingService.TaggableType.DATASET;
                if (exposedObject.quickSharingEnabled) {
                    ++spr.exposedObjects.quickSharedObjects;
                    spr.exposedObjects.quickSharedDatasets = spr.exposedObjects.quickSharedDatasets + (isDataset ? 1 : 0);
                } else {
                    ++spr.exposedObjects.managedSharedObjects;
                    spr.exposedObjects.managedSharedDatasets = spr.exposedObjects.managedSharedDatasets + (isDataset ? 1 : 0);
                }
            });
        } else {
            logger.errorV("Could not load serialized project for project %s.", new Object[]{projectKey});
        }
        try {
            spr.filters = filterReportBuilder.toFilterSummaryReport();
        }
        catch (Throwable t15) {
            logger.warn((Object)("Failed to add filter usage - could not build report:" + ExceptionUtils.getMessageWithCauses((Throwable)t15)));
        }
        return spr;
    }

    private int getInstancesByAppId(String applicationTemplateId) throws IOException {
        return Math.toIntExact(this.projectsService.listAllUnsafe().stream().filter(project -> StringUtils.equals((String)project.generatingAppId, (String)applicationTemplateId)).count());
    }

    private Set<String> getCodeStudioTemplateBlockTypes(String templateId) throws IOException {
        try {
            CodeStudioTemplate template = this.codeStudioTemplatesDAO.getMandatoryUnsafe(templateId);
            if ("block_based".equals(template.type)) {
                BlockBasedCodeStudioTemplateParams params = template.getParamsAs(BlockBasedCodeStudioTemplateParams.class);
                return params.blocks.stream().map(b -> b.type).collect(Collectors.toSet());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Can't list blocks of " + templateId), (Throwable)e);
        }
        return Sets.newHashSet();
    }

    private UsageSummaryModel.ShakerRecipesProjectReport makeShakerRecipes(String projectKey) throws Exception {
        UsageSummaryModel.ShakerRecipesProjectReport section = new UsageSummaryModel.ShakerRecipesProjectReport();
        UsageSummaryBuilderUtils.VisualIfRuleAggregator visualIfRuleAggregator = new UsageSummaryBuilderUtils.VisualIfRuleAggregator();
        for (SerializedRecipe sr : this.recipesDAO.listUnsafe(projectKey)) {
            if (!"shaker".equals(sr.type)) continue;
            try {
                ++section.nbRecipes;
                String payloadStr = this.recipesDAO.getPayloadOrNull(projectKey, sr.name);
                SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)payloadStr, SerializedShakerScript.class);
                JsonObject obj = this.usbu.shakerDetails(section, sss);
                obj.addProperty("shakerType", "recipe");
                obj.addProperty("datasetId", DigestUtils.md5Hex((String)sr.getSingleInput((String)"main").ref));
                section.details.add(obj);
                this.usbu.gatherVisualIfRules(visualIfRuleAggregator, sss);
            }
            catch (Throwable t) {
                logger.warn((Object)("Failed to summarize shaker usage:" + ExceptionUtils.getMessageWithCauses((Throwable)t)));
            }
        }
        section.visualIfProcessor = visualIfRuleAggregator.toSummary();
        return section;
    }

    private UsageSummaryModel.AnalysisProjectReport makeAnalysis(String projectKey, FilterReportBuilder filterReportBuilder) throws Exception {
        UsageSummaryModel.AnalysisProjectReport section = new UsageSummaryModel.AnalysisProjectReport();
        UsageSummaryBuilderUtils.VisualIfRuleAggregator visIfAggregator = new UsageSummaryBuilderUtils.VisualIfRuleAggregator();
        for (AnalysisCoreParams.AnalysisListItem ah : this.analysisCRUDService.listHeadsUnsafe(projectKey, null)) {
            try {
                AnalysisCoreParams acp = this.analysisCRUDService.getCoreOrNullUnsafe(projectKey, ah.id);
                if (acp == null) continue;
                this.filterTraverser.traverseFilters(filterReportBuilder, acp);
                this.usbu.gatherVisualIfRules(visIfAggregator, acp.script);
                ++section.nbAnalyses;
                int nbClusteringTasks = 0;
                int nbPredictionTasks = 0;
                int nbBinaryPred = 0;
                int nbMulticlass = 0;
                int nbRegression = 0;
                for (AnalysisCRUDService.MLTaskHead head : this.analysisCRUDService.listMLTasks(projectKey, acp.id, false)) {
                    if (head.taskType == MLTask.MLTaskType.PREDICTION) {
                        ++nbPredictionTasks;
                        switch (head.predictionType) {
                            case BINARY_CLASSIFICATION: {
                                ++nbBinaryPred;
                                break;
                            }
                            case MULTICLASS: {
                                ++nbMulticlass;
                                break;
                            }
                            case REGRESSION: {
                                ++nbRegression;
                                break;
                            }
                        }
                        PredictionMLTask mlTask = this.analysisCRUDService.getPMLTaskUnsafe(new MLTaskLoc(projectKey, acp.id, head.mlTaskId));
                        this.filterTraverser.traverseFilters(filterReportBuilder, mlTask);
                        continue;
                    }
                    if (head.taskType != MLTask.MLTaskType.CLUSTERING) continue;
                    ++nbClusteringTasks;
                }
                section.nbClustMLTasks += nbClusteringTasks;
                section.nbPredMLTasks += nbPredictionTasks;
                SerializedShakerScript sss = acp.script;
                JsonObject detailObj = this.usbu.shakerDetails(section, sss);
                detailObj.addProperty("shakerType", "script");
                detailObj.addProperty("ncharts", (Number)acp.charts.size());
                detailObj.addProperty("datasetId", DigestUtils.md5Hex((String)acp.inputDatasetSmartName));
                JsonObject mlTaskObj = new JsonObject();
                mlTaskObj.addProperty("nbTotal", (Number)(nbClusteringTasks + nbPredictionTasks));
                mlTaskObj.addProperty("nbClustMLTasks", (Number)nbClusteringTasks);
                JsonObject predObj = new JsonObject();
                predObj.addProperty("nbTotal", (Number)nbPredictionTasks);
                predObj.addProperty("nbBinary", (Number)nbBinaryPred);
                predObj.addProperty("nbMulticlass", (Number)nbMulticlass);
                predObj.addProperty("nbRegression", (Number)nbRegression);
                mlTaskObj.add("nbPredMLTasks", (JsonElement)predObj);
                detailObj.add("nbMlTasks", (JsonElement)mlTaskObj);
                section.details.add(detailObj);
            }
            catch (Throwable t) {
                logger.warn((Object)("Failed to summarize analyses usage (including related filters):" + ExceptionUtils.getMessageWithCauses((Throwable)t)));
            }
        }
        section.visualIfProcessor = visIfAggregator.toSummary();
        return section;
    }

    private UsageSummaryModel.ChartsProjectReport makeCharts(String projectKey) throws Exception {
        return this.usbu.buildSummarizedProjectChartsSection(projectKey);
    }

    private UsageSummaryModel.DatasetsProjectReport makeDatasets(String projectKey, Set<String> inputObjects, Set<String> outputObjects, Map<String, Set<String>> sharedInputObjects, FilterReportBuilder filterReportBuilder) throws Exception {
        UsageSummaryBuilderUtils usbu = new UsageSummaryBuilderUtils();
        UsageSummaryModel.DatasetsProjectReport section = new UsageSummaryModel.DatasetsProjectReport();
        for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
            try {
                DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, sd.name);
                usbu.summarizeDataset(section, projectKey, sd, inputObjects, outputObjects);
                Dataset dataset = Dataset.fromSerializedUnsafe(loc.getFullName(), sd);
                JsonObject datasetDetails = DatasetHandlerFactory.getMeta(sd.type).selfReport(dataset);
                section.details.add(datasetDetails);
            }
            catch (Throwable t) {
                logger.warn((Object)("Failed to summarize datasets usage (including filters):" + ExceptionUtils.getMessageWithCauses((Throwable)t)));
            }
        }
        this.updateSharedDataset(sharedInputObjects, section);
        return section;
    }

    private void updateSharedDataset(Map<String, Set<String>> sharedInputObjects, UsageSummaryModel.DatasetsProjectReport section) {
        for (Map.Entry<String, Set<String>> e : sharedInputObjects.entrySet()) {
            try {
                SerializedProject serializedProject = this.projectsService.getOrNullUnsafe(e.getKey());
                for (String objectName : e.getValue()) {
                    if (serializedProject != null) {
                        SerializedProject.ProjectExposedObjects exposedObjects = serializedProject.exposedObjects;
                        Optional<ExposedObject> first = exposedObjects.objects.stream().filter(exposedObject -> exposedObject.localName.equals(objectName)).findFirst();
                        if (first.isPresent() && first.get().type == ITaggingService.TaggableType.DATASET) {
                            if (first.get().quickSharingEnabled) {
                                this.inc(section.flowInput, "QuickShared");
                                continue;
                            }
                            this.inc(section.flowInput, "ManagedShared");
                            continue;
                        }
                        if (first.isPresent()) continue;
                        this.inc(section.flowInput, "BrokenShared");
                        continue;
                    }
                    this.inc(section.flowInput, "BrokenShared");
                }
            }
            catch (Throwable t) {
                logger.warn((Object)("Failed to summarize shared datasets usage:" + ExceptionUtils.getMessageWithCauses((Throwable)t)));
            }
        }
    }

    private UsageSummaryModel.RecipesProjectReport makeRecipes(String projectKey, FilterReportBuilder filterReportBuilder) throws IOException {
        UsageSummaryModel.RecipesProjectReport ret = new UsageSummaryModel.RecipesProjectReport();
        for (SerializedRecipe sr : this.recipesDAO.listUnsafe(projectKey)) {
            boolean veLoopEnabled;
            Object recipePayload;
            StatsTestRecipePayloadParams payloadParams;
            ++ret.all;
            Object recipeType = sr.type;
            if (StatsTestRecipeMeta.META.getType().equals(sr.type) && (payloadParams = (StatsTestRecipePayloadParams)JSON.parse((String)(recipePayload = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name)), StatsTestRecipePayloadParams.class)) != null) {
                recipeType = sr.type + "-" + payloadParams.getType();
            }
            this.inc(ret.byType, (String)recipeType);
            recipePayload = sr.getInputsUnsafe().values().iterator();
            while (recipePayload.hasNext()) {
                SerializedRecipe.InputRole irole = (SerializedRecipe.InputRole)recipePayload.next();
                for (SerializedRecipe.RecipeInput rinput : irole.items) {
                    for (SerializedRecipe.SDep dep : rinput.deps) {
                        this.inc(ret.pdepByType, dep.func);
                    }
                }
            }
            if (sr.params instanceof ParamsWithVariablesExpansionLoopConfig && (veLoopEnabled = ((ParamsWithVariablesExpansionLoopConfig)((Object)sr.params)).getVariablesExpansionLoopConfig().isEnabled())) {
                this.inc(ret.repeatingByType, (String)recipeType);
            }
            try {
                this.filterTraverser.traverseFilters(filterReportBuilder, sr);
            }
            catch (Throwable t) {
                logger.warn((Object)("Error while summarizing recipe filters:" + ExceptionUtils.getMessageWithCauses((Throwable)t)));
            }
        }
        return ret;
    }

    private void inc(Map<String, Integer> countMap, String key) {
        Integer prev = countMap.get(key);
        if (prev == null) {
            prev = 0;
        }
        countMap.put(key, prev + 1);
    }
}

