/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolParams;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.utils.JsonSchema;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AgentToolMeta {
    public boolean supportsLoadSampleQuery;

    public AgentToolMeta(boolean supportsLoadSampleQuery) {
        this.supportsLoadSampleQuery = supportsLoadSampleQuery;
    }

    public abstract String getType();

    public abstract Class<? extends AgentToolParams> paramsClass();

    public abstract List<SavedModel.AgentDependency> getDependencies(AgentTool var1);

    public Set<String> listConnectionNames(AgentTool tool) {
        return new HashSet<String>();
    }

    public boolean remapConnections(AgentTool tool, Map<String, String> replacements) {
        return false;
    }

    public abstract ToolDescriptor getResultingDescriptor(AuthCtx var1, String var2, AgentTool var3) throws Exception;

    public JsonObject loadSampleQuery(AuthCtx authCtx, String projectKey, AgentTool tool) throws Exception {
        throw new NotImplementedException(String.format("The %s tool does not have a custom sample query to load.", this.getType()));
    }

    public abstract AgentToolRunner buildRunner(AuthCtx var1, String var2, AgentTool var3, boolean var4) throws Exception;

    public final AgentToolRunner buildRunner(AuthCtx authCtx, String projectKey, AgentTool tool) throws Exception {
        return this.buildRunner(authCtx, projectKey, tool, false);
    }

    public AgentToolParams newParams() {
        try {
            return this.paramsClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Required default constructor for param class: " + String.valueOf(this.paramsClass()), e);
        }
    }

    public static class ToolDescriptor {
        public String name;
        public String description;
        public JsonSchema inputSchema;

        public ToolDescriptor(String name) {
            this.name = name.replaceAll("[^A-Za-z0-9_]", "_") + "_" + SecretKeyGenerator.generate((int)6);
        }
    }
}

