/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public interface AgentToolRunner
extends AutoCloseable {
    public void init() throws Exception;

    public AgentToolOutput run(AgentToolInput var1) throws Exception;

    default public SmartLogTail getKernelLog() throws Exception {
        return null;
    }

    default public String getArgumentNameAtPath(Object ... path) {
        if (path.length == 1) {
            return path[0].toString();
        }
        return Arrays.toString(path);
    }

    default public JsonElement safeGetArgument(AgentToolInput input, Object ... path) {
        if (!1.$assertionsDisabled && input == null) {
            throw new AssertionError();
        }
        if (input.input == null) {
            throw new IllegalArgumentException("No input arguments in tool call");
        }
        if (!input.input.isJsonObject()) {
            throw new IllegalArgumentException("Tool call input is not an object");
        }
        JsonElement elt = JsonUtils.getOrNull(input.input, path);
        if (elt == null) {
            throw new IllegalArgumentException("Argument '" + this.getArgumentNameAtPath(path) + "' not found in tool call");
        }
        return elt;
    }

    default public <T> T safeParseArgument(AgentToolInput input, Class<T> ofType, Object ... path) {
        JsonElement elt = this.safeGetArgument(input, path);
        Object t = JSON.parse((JsonElement)elt, ofType);
        if (t == null) {
            throw new IllegalArgumentException("Could not parse argument '" + this.getArgumentNameAtPath(path) + "' from tool call");
        }
        return (T)t;
    }

    default public JsonObject safeReadObjectArgument(AgentToolInput input, Object ... path) {
        JsonElement elt = this.safeGetArgument(input, path);
        if (!elt.isJsonObject()) {
            throw new IllegalArgumentException("Tool call argument '" + this.getArgumentNameAtPath(path) + "' is not an object");
        }
        return elt.getAsJsonObject();
    }

    default public String safeReadStringArgument(AgentToolInput input, Object ... path) {
        JsonElement elt = this.safeGetArgument(input, path);
        if (!elt.isJsonPrimitive() || !elt.getAsJsonPrimitive().isString()) {
            throw new IllegalArgumentException("Tool call argument '" + this.getArgumentNameAtPath(path) + "' is not a string");
        }
        return elt.getAsString();
    }

    default public boolean safeHasArgument(AgentToolInput input, Object ... path) {
        if (input.input == null) {
            return false;
        }
        if (!input.input.isJsonObject()) {
            return false;
        }
        JsonElement elt = JsonUtils.getOrNull(input.input, path);
        return elt != null;
    }

    default public Optional<JsonElement> getContextVariable(AgentToolInput input, Object ... contextPath) {
        if (!1.$assertionsDisabled && input == null) {
            throw new AssertionError();
        }
        if (input.context == null || !input.context.isJsonObject() || contextPath == null) {
            return Optional.empty();
        }
        JsonElement elt = JsonUtils.getOrNull((JsonElement)input.context, contextPath);
        return Optional.ofNullable(elt);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class AgentToolInput {
        public JsonObject context = new JsonObject();
        public JsonElement input;
    }

    public static class Source {
        public String originToolId;
        public String originToolName;
        public String toolCallDescription;
        public List<LLMClient.SourceItem> items = new ArrayList<LLMClient.SourceItem>();
    }

    public static class AgentToolOutput {
        public JsonElement output;
        public LLMClient.LLMMeshTraceSpan trace;
        public List<Source> sources = new ArrayList<Source>();
        public String error;

        public AgentToolOutput() {
        }

        public AgentToolOutput(JsonObject output) {
            this.output = output;
        }
    }
}

