/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.agents.tools.AgentToolsRegistry;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.llm.AgentToolsController;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgentToolsCRUDService {
    @Autowired
    private AgentToolsDAO dao;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private TaggableObjectDiffService taggableObjectDiffService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private FlowGraphService flowGraphService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.agents.tools.service");

    public AgentTool getOrNull(String projectKey, String id) throws IOException {
        return (AgentTool)this.dao.getOrNull(projectKey, id);
    }

    public AgentTool getOrNullUnsafe(String projectKey, String id) throws IOException {
        return (AgentTool)this.dao.getOrNullUnsafe(projectKey, id);
    }

    public AgentTool getMandatory(String projectKey, String id) throws IOException {
        return (AgentTool)this.dao.getMandatory(projectKey, id);
    }

    public AgentTool getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return (AgentTool)this.dao.getMandatoryUnsafe(projectKey, id);
    }

    protected String getAgentToolId(String projectKey, AgentToolsController.ProtoAgentTool proto) throws IllegalArgumentException, IOException {
        if (StringUtils.isNotBlank((String)proto.id)) {
            if (this.dao.getOrNull(projectKey, proto.id) != null) {
                throw new IllegalArgumentException("Tool with id " + proto.id + " already exists");
            }
            return proto.id;
        }
        return SecretKeyGenerator.generateSmall();
    }

    public String create(AuthCtx u, String projectKey, AgentToolsController.ProtoAgentTool proto) throws Exception {
        String id = this.getAgentToolId(projectKey, proto);
        StringTransmogrifier transmogrifier = new StringTransmogrifier(" ");
        for (AgentTool head : this.dao.list(projectKey)) {
            transmogrifier.addAlreadyTransmogrifiedAcceptDupes(head.name);
        }
        AgentTool at = new AgentTool();
        at.projectKey = projectKey;
        at.id = id;
        at.creationTag = new VersionTag(u.getIdentifier());
        at.versionTag = new VersionTag(u.getIdentifier());
        at.name = transmogrifier.transmogrify(proto.name);
        at.type = proto.type;
        at.quickTestQuery = proto.quickTestQuery;
        AgentToolMeta meta = AgentToolsRegistry.getMeta(at.type);
        at.params = JSON.toJsonObject((Object)meta.newParams());
        if (proto.creationParams != null) {
            for (Map.Entry entry : proto.creationParams.entrySet()) {
                at.params.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(at);
        this.customPolicyHooksRegistry.onPreObjectSave(u, null, at);
        this.dao.save(at);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", at.name);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.AGENT_TOOL, projectKey, id, u, TaggableObjectChangedEvent.ActionType.AGENT_TOOL_CREATE).withDetails(details));
        return id;
    }

    public String createFromKB(AuthCtx u, String projectKey, AgentToolsController.ProtoAgentTool proto, String knowledgeBankRef) throws Exception {
        proto.creationParams = JF.obj().with("knowledgeBankRef", knowledgeBankRef).get();
        return this.create(u, projectKey, proto);
    }

    public AgentTool save(AgentTool at, boolean summaryOnly) throws IOException, CodedException {
        TaggableObjectChangedEvent.ActionType action;
        Preconditions.checkNotNull((Object)at.projectKey);
        Preconditions.checkNotNull((Object)at.id);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AgentTool preExisting = (AgentTool)this.dao.getOrNullUnsafe(at.projectKey, at.id);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(at, preExisting);
        TaggableObjectDiffService.TaggableObjectsDiff diff = new TaggableObjectDiffService.TaggableObjectsDiff();
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", at.name);
        if (at.name != null && preExisting != null && !at.name.equals(preExisting.name)) {
            action = TaggableObjectChangedEvent.ActionType.AGENT_TOOL_RENAME;
            details.addProperty("newName", at.name);
            details.addProperty("oldName", preExisting.name);
        } else {
            action = TaggableObjectChangedEvent.ActionType.AGENT_TOOL_EDIT;
            diff = this.taggableObjectDiffService.diff(preExisting, at, t.getUser().getIdentifier());
        }
        if (at.params == null) {
            AgentToolMeta meta = AgentToolsRegistry.getMeta(at.type);
            at.params = JSON.toJsonObject((Object)meta.newParams());
        }
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), (TaggableObjectsService.TaggableObject)this.dao.getOrNull(at.projectKey, at.id), at);
        this.dao.save(at);
        if (diff.metadataChanged()) {
            this.taggableObjectDiffService.publishAfterTransaction(diff);
        }
        if (!summaryOnly) {
            this.pubSubService.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.AGENT_TOOL, at.projectKey, at.id, t.getUser(), action).withDetails(details));
        }
        this.taggingService.onObjectSaved(at.projectKey, at.tags);
        this.flowGraphService.invalidateCache(at.projectKey);
        return at;
    }

    public String copy(AuthCtx user, AgentTool at, String projectKey) throws IOException, CodedException {
        String id = SecretKeyGenerator.generateSmall();
        AgentTool copy = (AgentTool)JSON.deepCopy((Object)at);
        copy.projectKey = projectKey;
        copy.id = id;
        copy.versionTag = copy.creationTag = new VersionTag(user.getIdentifier());
        StringTransmogrifier transmogrifier = new StringTransmogrifier(" ");
        for (AgentTool head : this.dao.list(projectKey)) {
            transmogrifier.addAlreadyTransmogrifiedAcceptDupes(head.name);
        }
        copy.name = transmogrifier.transmogrify("Copy of " + at.name);
        this.customPolicyHooksRegistry.onPreObjectSave(user, null, copy);
        this.dao.save(at);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", copy.name);
        details.addProperty("copy", Boolean.valueOf(true));
        details.addProperty("originalObjectDisplayName", at.name);
        details.addProperty("originalObjectId", at.id);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.AGENT_TOOL, projectKey, id, user, TaggableObjectChangedEvent.ActionType.AGENT_TOOL_CREATE).withDetails(details));
        return id;
    }

    public void delete(AuthCtx liu, String projectKey, String id) throws Exception {
        AgentTool at = (AgentTool)this.dao.getOrNull(projectKey, id);
        this.customPolicyHooksRegistry.onPreObjectDelete(liu, at);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", at.name);
        this.dao.delete(projectKey, id);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.AGENT_TOOL, projectKey, id, liu, TaggableObjectChangedEvent.ActionType.AGENT_TOOL_DELETE).withDetails(details));
    }
}

