/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.PythonAgentToolServer;
import com.dataiku.dip.agents.tools.PythonAgentToolServerAPI;
import com.dataiku.dip.agents.tools.PythonAgentToolServerKernelDesc;
import com.dataiku.dip.llm.LLMRelatedPoolablePythonServerKernelPool;
import com.dataiku.dip.llm.kernel.KernelPool;
import com.dataiku.dip.llm.kernel.KernelPoolThreadFactory;
import com.dataiku.dip.llm.kernel.KernelScalingStrategyBuilder;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKUCompletableFuture;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PythonAgentToolServerPool
extends LLMRelatedPoolablePythonServerKernelPool<PythonAgentToolServer, PythonAgentToolServerKernelDesc, PythonAgentToolServerKernelDesc> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.agents.tools.python.pool");

    public void invalidateKernels(AgentTool tool) {
        this.manager.clearKernels(kd -> tool.projectKey.equals(kd.projectKey) && tool.id.equals(kd.toolId), KernelPool.DeathReason.OUTDATED);
    }

    public PythonAgentToolServerAPI getServerAPI(DSSAuthCtx authCtx, AgentTool tool, String code, String pluginId, String libFolder, boolean loadPythonLibs, JsonObject config, JsonObject pluginConfig, String envName, String containerConfName, String clusterId) {
        final PythonAgentToolServerKernelDesc kernelDesc = new PythonAgentToolServerKernelDesc();
        kernelDesc.authCtx = authCtx;
        kernelDesc.projectKey = tool.projectKey;
        kernelDesc.toolId = tool.id;
        kernelDesc.cruContext = ComputeResourceUsageContext.forPythonAgentTool((String)tool.projectKey);
        kernelDesc.code = code;
        kernelDesc.pluginId = pluginId;
        kernelDesc.libFolder = libFolder;
        kernelDesc.loadPythonLibs = loadPythonLibs;
        kernelDesc.config = config;
        kernelDesc.pluginConfig = pluginConfig;
        kernelDesc.envName = envName;
        kernelDesc.containerConfName = containerConfName;
        kernelDesc.clusterId = clusterId;
        kernelDesc.poolKey = authCtx.getIdentifier() + "-" + tool.projectKey + "-" + tool.id + "-" + DigestUtils.sha1Hex((String)StringUtils.join((Object[])new String[]{JSON.json((Object)tool), code, pluginId, libFolder, "" + loadPythonLibs, JSON.json((Object)config), JSON.json((Object)pluginConfig), envName, containerConfName, clusterId}, (String)"__DKU__"));
        return new PythonAgentToolServerAPI(){

            @Override
            public CompletableFuture<AgentToolRunner.AgentToolOutput> runAsync(AgentToolRunner.AgentToolInput input) {
                return PythonAgentToolServerPool.this.manager.handle(kernel -> kernel.runAsync(input), kernelDesc, kernelDesc.poolKey, input);
            }

            @Override
            public CompletableFuture<AgentToolMeta.ToolDescriptor> getResultingDescriptorAsync(AgentTool tool) throws Exception {
                return PythonAgentToolServerPool.this.manager.handle(kernel -> kernel.getResultingDescriptorAsync(tool), kernelDesc, kernelDesc.poolKey, tool);
            }

            @Override
            public CompletableFuture<JsonObject> loadSampleQuery(AgentTool tool) {
                return PythonAgentToolServerPool.this.manager.handle(kernel -> kernel.loadSampleQuery(tool), kernelDesc, kernelDesc.poolKey, tool);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public PythonAgentToolServerPool() {
        super("python-agent-tool");
        this.setManager(new KernelPool(new LLMRelatedPoolablePythonServerKernelPool.LLMRelatedPoolablePythonServerKernelController("dku.agents.tools.python"){

            @Override
            public PythonAgentToolServer createKernel(PythonAgentToolServerKernelDesc kernelDesc) {
                return new PythonAgentToolServer(kernelDesc.authCtx, kernelDesc.projectKey, kernelDesc.toolId, kernelDesc.code, kernelDesc.envName, kernelDesc.containerConfName, kernelDesc.pluginId, kernelDesc.libFolder, kernelDesc.config, kernelDesc.pluginConfig, kernelDesc.loadPythonLibs);
            }

            @Override
            public CompletableFuture<Void> startKernel(PythonAgentToolServer kernel, PythonAgentToolServerKernelDesc kernelDesc) {
                File logBaseDir = DKUApp.getFile((String[])new String[]{"agent-tools", kernelDesc.projectKey, kernelDesc.toolId, "logs"});
                return DKUCompletableFuture.runAsync(() -> {
                    this.setKernelContext(kernelDesc.cruContext, kernelDesc.jobContext, logger);
                    kernel.start(false, logBaseDir);
                }, (Executor)PythonAgentToolServerPool.this.executorService);
            }

            @Override
            public int getGlobalMaxKernelCount() {
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".maxKernels", Integer.valueOf(50));
            }

            @Override
            public int getHardMaxParallelRequests(PythonAgentToolServerKernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".hardMaxRequestsPerKernel", Integer.valueOf(16));
            }

            @Override
            public int getSoftMaxParallelRequests(PythonAgentToolServerKernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".softMaxRequestsPerKernel", Integer.valueOf(16));
            }
        }, new KernelScalingStrategyBuilder(), new KernelPoolThreadFactory("python-agent-tool"), logger));
    }
}

