/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.filtering;

import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SimpleFilterClause {
    public Operator operator;
    public List<SimpleFilterClause> clauses;
    public SimpleFilterClause clause;
    public String column;
    public JsonElement value;

    public void validate() throws IllegalArgumentException {
        this.validateOperator();
        switch (this.operator) {
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case LESS_THAN: 
            case GREATER_OR_EQUAL: 
            case LESS_OR_EQUAL: 
            case CONTAINS: 
            case MATCHES: {
                this.validateColumn();
                this.validateValue();
                break;
            }
            case IN_ANY_OF: 
            case IN_NONE_OF: {
                this.validateColumn();
                this.validateValue();
                if (this.value.isJsonArray()) break;
                throw new IllegalArgumentException(this.getEnrichedValidationMessage("Value should be an array"));
            }
            case DEFINED: 
            case NOT_DEFINED: {
                this.validateColumn();
                break;
            }
            case AND: 
            case OR: {
                this.validateClauses();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + String.valueOf((Object)this.operator));
            }
        }
    }

    private void validateOperator() throws IllegalArgumentException {
        if (this.operator == null) {
            throw new IllegalArgumentException(this.getEnrichedValidationMessage("A valid operator is required"));
        }
    }

    private void validateColumn() throws IllegalArgumentException {
        if (StringUtils.isBlank((String)this.column)) {
            throw new IllegalArgumentException(this.getEnrichedValidationMessage("A column name is required"));
        }
    }

    private void validateValue() throws IllegalArgumentException {
        if (this.value == null) {
            throw new IllegalArgumentException(this.getEnrichedValidationMessage("A value is required"));
        }
    }

    private void validateClauses() throws IllegalArgumentException {
        if (this.clauses == null) {
            throw new IllegalArgumentException(this.getEnrichedValidationMessage("A list of clauses is required"));
        }
        for (SimpleFilterClause clause : this.clauses) {
            clause.validate();
        }
    }

    private void validateClause() throws IllegalArgumentException {
        if (this.clause == null) {
            throw new IllegalArgumentException(this.getEnrichedValidationMessage("A clause is required"));
        }
        this.clause.validate();
    }

    private String getEnrichedValidationMessage(String message) {
        if (this.operator != null) {
            message = (String)message + " for operator '" + String.valueOf((Object)this.operator) + "'";
        }
        if (!StringUtils.isBlank((String)this.column)) {
            message = (String)message + " on column '" + this.column + "'";
        }
        message = (String)message + ".";
        return message;
    }

    public Set<String> listColumnsNamesRecursively() {
        HashSet<String> columns = new HashSet<String>();
        if (this.operator == null) {
            return columns;
        }
        switch (this.operator) {
            case AND: 
            case OR: {
                if (this.clauses == null) break;
                for (SimpleFilterClause clause : this.clauses) {
                    columns.addAll(clause.listColumnsNamesRecursively());
                }
                break;
            }
            default: {
                columns.add(this.column);
            }
        }
        return columns;
    }

    static {
        JSON.registerAdapter(Operator.class, (Object)new JSON.UppercaseEnumAdapter());
    }

    public static enum Operator {
        EQUALS,
        NOT_EQUALS,
        DEFINED,
        NOT_DEFINED,
        IN_ANY_OF,
        IN_NONE_OF,
        GREATER_THAN,
        LESS_THAN,
        GREATER_OR_EQUAL,
        LESS_OR_EQUAL,
        CONTAINS,
        MATCHES,
        AND,
        OR;

    }
}

