/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.vectorstore;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryTool;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryToolServer;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryToolServerAPI;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryToolServerPool;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUCompletableFuture;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class VectorStoreQueryToolRunner
implements AgentToolRunner {
    private final RetrievableKnowledge rk;
    private final String projectKey;
    private final AgentTool tool;
    private final DSSAuthCtx authCtx;
    private boolean devMode;
    private VectorStoreQueryTool.VectorStoreQueryToolParams params;
    private VectorStoreQueryToolServerAPI serverAPI;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.agents.tools.vectorstore");

    public VectorStoreQueryToolRunner(DSSAuthCtx authCtx, String projectKey, RetrievableKnowledge rk, AgentTool tool, boolean devMode) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.tool = tool;
        this.rk = rk;
        this.params = tool.getParamsCopyAs(VectorStoreQueryTool.VectorStoreQueryToolParams.class);
        this.devMode = devMode;
    }

    @Override
    public void init() throws IOException {
        block6: {
            try {
                ContainerExecSelection containerExecSelection = this.rk.containerExecSelection.containerMode == ContainerExecSelection.ContainerExecMode.INHERIT ? ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.defaultRetrievableKnowledgeContainerExecSelection : this.rk.containerExecSelection;
                String containerConfName = new ContainerExecConfigSelector().selectName_autoTXN(this.projectKey, containerExecSelection, WorkloadType.USER_CODE);
                String clusterId = new ClusterSelector().selectForProject(this.authCtx, this.projectKey).getClusterId();
                String envName = new CodeEnvSelector().selectForPythonRecipe(this.rk.projectKey, this.rk.envSelection);
                if (this.devMode) {
                    File logBaseDir = DKUApp.getFile((String[])new String[]{"agent-tools", this.tool.projectKey, this.tool.id, "logs"});
                    VectorStoreQueryToolServer server = new VectorStoreQueryToolServer(this.authCtx, this.rk.projectKey, this.rk, this.params, this.rk.envSelection, containerConfName, clusterId);
                    try {
                        server.init(this.devMode, logBaseDir);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Kernel failed to start, closing it", (Throwable)e);
                        IOUtils.closeQuietly((Closeable)server, null);
                        throw e;
                    }
                    this.serverAPI = server;
                    break block6;
                }
                VectorStoreQueryToolServerPool kernelPool = (VectorStoreQueryToolServerPool)SpringUtils.getBean(VectorStoreQueryToolServerPool.class);
                this.serverAPI = kernelPool.getServerAPI(this.authCtx, this.tool, this.rk, this.params, envName, containerConfName, clusterId);
            }
            catch (CustomPythonKernelException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Failed to initialize agent", e);
            }
        }
    }

    @Override
    public SmartLogTail getKernelLog() {
        if (this.devMode) {
            assert (this.serverAPI instanceof VectorStoreQueryToolServer);
            return ((VectorStoreQueryToolServer)this.serverAPI).getKernelLogTail();
        }
        SmartLogTail fakeSLT = new SmartLogTail();
        fakeSLT.appendLine("You need to switch to development mode in the settings to get logs");
        return fakeSLT;
    }

    @Override
    public void close() throws IOException {
        this.serverAPI.close();
    }

    @Override
    public AgentToolRunner.AgentToolOutput run(AgentToolRunner.AgentToolInput input) throws Exception {
        logger.trace(() -> "Running with input " + JSON.json((Object)input));
        return (AgentToolRunner.AgentToolOutput)DKUCompletableFuture.collectResponse(this.serverAPI.runAsync(input));
    }
}

