/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.vectorstore;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryTool;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryToolServer;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryToolServerAPI;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryToolServerKernelDesc;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.llm.LLMRelatedPoolablePythonServerKernelPool;
import com.dataiku.dip.llm.kernel.KernelPool;
import com.dataiku.dip.llm.kernel.KernelPoolThreadFactory;
import com.dataiku.dip.llm.kernel.KernelScalingStrategyBuilder;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeUtils;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKUCompletableFuture;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class VectorStoreQueryToolServerPool
extends LLMRelatedPoolablePythonServerKernelPool<VectorStoreQueryToolServer, VectorStoreQueryToolServerKernelDesc, VectorStoreQueryToolServerKernelDesc> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.agents.tools.vectorstore.pool");

    public void invalidateKernels(AgentTool tool) {
        this.manager.clearKernels(kd -> tool.projectKey.equals(kd.projectKey) && tool.id.equals(kd.toolId), KernelPool.DeathReason.OUTDATED);
    }

    public VectorStoreQueryToolServerAPI getServerAPI(DSSAuthCtx authCtx, AgentTool tool, RetrievableKnowledge rk, VectorStoreQueryTool.VectorStoreQueryToolParams params, String envName, String containerConfName, String clusterId) throws IOException {
        final VectorStoreQueryToolServerKernelDesc kernelDesc = new VectorStoreQueryToolServerKernelDesc();
        kernelDesc.authCtx = authCtx;
        kernelDesc.projectKey = tool.projectKey;
        kernelDesc.toolId = tool.id;
        kernelDesc.rk = rk;
        kernelDesc.params = params;
        kernelDesc.envName = envName;
        kernelDesc.containerConfName = containerConfName;
        kernelDesc.clusterId = clusterId;
        kernelDesc.poolKey = authCtx.getIdentifier() + "-" + tool.projectKey + "-" + tool.id + "-" + DigestUtils.sha1Hex((String)StringUtils.join((Object[])new String[]{JSON.json((Object)tool), JSON.json((Object)rk), JSON.json((Object)params), envName, containerConfName, clusterId}, (String)"__DKU__"));
        kernelDesc.rkVersion = RetrievableKnowledgeUtils.getCurrentVersionUnsafe(rk);
        return new VectorStoreQueryToolServerAPI(){

            @Override
            public CompletableFuture<AgentToolRunner.AgentToolOutput> runAsync(AgentToolRunner.AgentToolInput input) {
                return VectorStoreQueryToolServerPool.this.manager.handle(kernel -> kernel.runAsync(input), kernelDesc, kernelDesc.poolKey, input);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public VectorStoreQueryToolServerPool() {
        super("vector-store-tool");
        this.setManager(new KernelPool(new LLMRelatedPoolablePythonServerKernelPool.LLMRelatedPoolablePythonServerKernelController("dku.agents.tools.vectorstore"){

            @Override
            public VectorStoreQueryToolServer createKernel(VectorStoreQueryToolServerKernelDesc kernelDesc) {
                return new VectorStoreQueryToolServer(kernelDesc.authCtx, kernelDesc.projectKey, kernelDesc.rk, kernelDesc.params, CodeEnvSelection.explicitEnv(kernelDesc.envName), kernelDesc.containerConfName, kernelDesc.clusterId);
            }

            @Override
            public CompletableFuture<Void> startKernel(VectorStoreQueryToolServer kernel, VectorStoreQueryToolServerKernelDesc kernelDesc) {
                File logBaseDir = DKUApp.getFile((String[])new String[]{"agent-tools", kernelDesc.projectKey, kernelDesc.toolId, "logs"});
                return DKUCompletableFuture.runAsync(() -> {
                    this.setKernelContext(kernelDesc.cruContext, kernelDesc.jobContext, logger);
                    kernel.init(false, logBaseDir);
                }, (Executor)VectorStoreQueryToolServerPool.this.executorService);
            }

            @Override
            public int getGlobalMaxKernelCount() {
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".maxKernels", Integer.valueOf(50));
            }

            @Override
            public int getHardMaxParallelRequests(VectorStoreQueryToolServerKernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".hardMaxRequestsPerKernel", Integer.valueOf(16));
            }

            @Override
            public int getSoftMaxParallelRequests(VectorStoreQueryToolServerKernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".softMaxRequestsPerKernel", Integer.valueOf(16));
            }

            @Override
            public boolean isOutdated(VectorStoreQueryToolServerKernelDesc kernelDesc) {
                try {
                    String version = RetrievableKnowledgeUtils.getCurrentVersionUnsafe(kernelDesc.rk);
                    return !Objects.equals(version, kernelDesc.rkVersion);
                }
                catch (IOException e) {
                    logger.error((Object)String.format("Cannot retrieve the current version for KB %s", kernelDesc.rk.getFullId()), (Throwable)e);
                    return false;
                }
            }
        }, new KernelScalingStrategyBuilder(), new KernelPoolThreadFactory("vector-store-tool"), logger));
    }
}

