/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aiexplanations.code;

import com.dataiku.dip.aiexplanations.ExplainStuffFrontendResponse;
import com.dataiku.dip.aiexplanations.ExplainStuffFutureThread;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AICodeExplanationService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseStatusService licenseStatusService;

    public FutureResponse<ExplainStuffFrontendResponse> startExplainingCode(DSSAuthCtx authCtx, String language, String code, String explanationOptions) throws Exception {
        ExplainThatCodeFutureThread futureThread = new ExplainThatCodeFutureThread(authCtx, language, code, explanationOptions);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<ExplainStuffFrontendResponse>>(){});
    }

    private class ExplainThatCodeFutureThread
    extends ExplainStuffFutureThread {
        private final String language;
        private final String code;

        public ExplainThatCodeFutureThread(DSSAuthCtx owner, String language, String code, String explanationOptions) {
            super(owner, AICodeExplanationService.this.licenseStatusService, explanationOptions);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)language));
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)code));
            this.language = language;
            this.code = code;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_explain_code", (String)"AI Explain Code");
        }

        @Override
        protected ExplainStuffFutureThread.ExplainStuffBackendQuery createQuery() {
            ExplainThatCodeBackendQuery explainQuery = new ExplainThatCodeBackendQuery();
            explainQuery.language = this.language;
            explainQuery.code = this.code;
            return explainQuery;
        }

        @Override
        protected String createBackendApiEndpointPath() {
            return "/explain-stuff/explain-code";
        }

        @Override
        protected String createFailureReason() {
            return "AI was not able to explain that code";
        }

        @Override
        protected String createNdcMessage() {
            return "ai-explain-code";
        }

        private class ExplainThatCodeBackendQuery
        extends ExplainStuffFutureThread.ExplainStuffBackendQuery {
            String language;
            String code;

            private ExplainThatCodeBackendQuery() {
            }
        }
    }
}

