/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aiexplanations.dataset;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.types.DataTypeMatch;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AIDatasetExplanationService {
    @Autowired
    private DataService dataService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    private static final DKULogger logger = DKULogger.getLogger(AIDatasetExplanationService.class);

    public FutureResponse<ExplainDatasetFrontendResponse> startExplainingDataset(AuthCtx authCtx, Dataset dataset, String explanationOptions) throws Exception {
        AIFeaturesUtil.parseAndValidateExplanationOptions(explanationOptions);
        ExplainThatDatasetFutureThread futureThread = new ExplainThatDatasetFutureThread(authCtx, dataset, explanationOptions);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<ExplainDatasetFrontendResponse>>(){});
    }

    private class ExplainThatDatasetFutureThread
    extends SimpleFutureThread<ExplainDatasetFrontendResponse> {
        private final Dataset dataset;
        private final JsonObject explanationOptions;
        private final GeneralSettingsDAO.GeneralSettings generalSettings;

        public ExplainThatDatasetFutureThread(AuthCtx owner, Dataset dataset, String explanationOptions) {
            super(owner);
            this.dataset = dataset;
            this.generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            this.explanationOptions = (JsonObject)JSON.parse((String)explanationOptions, JsonObject.class);
        }

        protected ExplainDatasetBackendQuery createQuery() throws Exception {
            ExplainDatasetBackendQuery explainQuery = new ExplainDatasetBackendQuery();
            explainQuery.datasetName = this.dataset.getName();
            explainQuery.datasetSchema = this.dataset.getSchema();
            SerializedShakerScript serializedShakerScript = new SerializedShakerScript();
            serializedShakerScript.contextProjectKey = this.dataset.getProjectKey();
            MemScriptRunner.TableWithReport tableWithReport = AIDatasetExplanationService.this.dataService.get_NOTRANSACTION(this.dataset, serializedShakerScript, null, null, true, (AuthCtx)this.owner);
            for (Column column : tableWithReport.table.columns()) {
                MemColumn memColumn = (MemColumn)column;
                AIDatasetColumn col = new AIDatasetColumn();
                col.name = memColumn.getName();
                DataTypeMatch dataTypeMatch = memColumn.selectedType;
                col.meaning = dataTypeMatch.type.getMeaningId();
                col.nbInvalid = dataTypeMatch.nbFails;
                col.nbEmpty = dataTypeMatch.nbEmpty;
                if (this.generalSettings.aiDrivenAnalyticsSettings.prepareAICompletionSendSampleValues) {
                    col.sampleValues.addAll(AIFeaturesUtil.collectSampleRowValues(tableWithReport, memColumn, AIFeaturesUtil.Feature.AIEXPLAINDATASET, ""));
                }
                explainQuery.datasetColumns.add(col);
            }
            return explainQuery;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public ExplainDatasetFrontendResponse compute() throws Exception {
            NDC.push((String)"ai-explain-dataset");
            try {
                ExplainDatasetFrontendResponse explainDatasetFrontendResponse;
                block21: {
                    ExplainDatasetBackendResponse resp2222;
                    InternalAPIClient apiClient;
                    block19: {
                        ExplainDatasetFrontendResponse explainDatasetFrontendResponse2;
                        block20: {
                            if (!this.generalSettings.aiDrivenAnalyticsSettings.prepareAICompletionEnabled) {
                                throw new IllegalStateException("Generate Dataset Metadata is not enabled");
                            }
                            LicenseStatusService.LicensingStatus licensingStatus = AIDatasetExplanationService.this.licenseStatusService.getLicensingStatus();
                            if (licensingStatus.community) {
                                String message = "AI services are not available with Dataiku Free Edition";
                                throw new IllegalArgumentException(message);
                            }
                            ExplainDatasetBackendQuery explainQuery = this.createQuery();
                            explainQuery.licenseId = licensingStatus.licenseContent != null ? licensingStatus.licenseContent.licenseId : null;
                            explainQuery.telemetryEnabled = this.generalSettings.aiDrivenAnalyticsSettings.prepareAICompletionTelemetryEnabled;
                            explainQuery.explanationOptions = this.explanationOptions;
                            int aiExplainTimeout = DKUApp.getParams().getIntParam("dku.dada.AIExplain.network.timeout", Integer.valueOf(200000));
                            apiClient = AIFeaturesUtil.getAiServerAPIClient(this.owner, this.generalSettings, GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.prepareAICompletion, aiExplainTimeout, aiExplainTimeout);
                            resp2222 = (ExplainDatasetBackendResponse)apiClient.postObject("/explain-stuff/explain-dataset", ExplainDatasetBackendResponse.class, (Object)explainQuery);
                            logger.info((Object)("AI Response: " + JSON.json((Object)resp2222)));
                            if (resp2222.ok) break block19;
                            ExplainDatasetFrontendResponse finalResp = new ExplainDatasetFrontendResponse();
                            finalResp.reason = "AI was not able to generate metadata for that dataset";
                            if (resp2222.error != null) {
                                finalResp.reason = finalResp.reason + ": " + resp2222.error;
                            }
                            finalResp.ok = false;
                            logger.warn((Object)finalResp.reason);
                            explainDatasetFrontendResponse2 = finalResp;
                            if (apiClient == null) break block20;
                            apiClient.close();
                        }
                        return explainDatasetFrontendResponse2;
                    }
                    ExplainDatasetFrontendResponse finalResp = new ExplainDatasetFrontendResponse();
                    finalResp.ok = true;
                    finalResp.requestId = resp2222.request_id;
                    finalResp.shortDesc = resp2222.shortDesc;
                    finalResp.longDesc = resp2222.longDesc;
                    finalResp.colDesc = resp2222.colDesc;
                    explainDatasetFrontendResponse = finalResp;
                    if (apiClient == null) break block21;
                    {
                        catch (Throwable resp2222) {
                            ExplainDatasetFrontendResponse finalResp2;
                            try {
                                if (apiClient != null) {
                                    try {
                                        apiClient.close();
                                    }
                                    catch (Throwable throwable) {
                                        resp2222.addSuppressed(throwable);
                                    }
                                }
                                throw resp2222;
                            }
                            catch (IOException e) {
                                logger.error((Object)"IO exception while generating dataset metadata", (Throwable)e);
                                finalResp2 = new ExplainDatasetFrontendResponse();
                                finalResp2.ok = false;
                                finalResp2.reason = "Could not get response from AI service: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                                ExplainDatasetFrontendResponse explainDatasetFrontendResponse3 = finalResp2;
                                return explainDatasetFrontendResponse3;
                            }
                            catch (DKUSecurityException e) {
                                logger.error((Object)"Unauthorized exception while generating dataset metadata", (Throwable)e);
                                finalResp2 = new ExplainDatasetFrontendResponse();
                                finalResp2.ok = false;
                                finalResp2.reason = ExceptionUtils.getMessageWithCauses((Throwable)e);
                                ExplainDatasetFrontendResponse explainDatasetFrontendResponse4 = finalResp2;
                                return explainDatasetFrontendResponse4;
                            }
                        }
                    }
                    apiClient.close();
                }
                return explainDatasetFrontendResponse;
            }
            finally {
                NDC.pop();
            }
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_explain_dataset", (String)"AI Explain Dataset");
        }
    }

    private static class AIDatasetColumn {
        String name;
        String meaning;
        int nbEmpty = 0;
        int nbInvalid = 0;
        List<String> sampleValues = new ArrayList<String>();

        private AIDatasetColumn() {
        }
    }

    public static class ExplainDatasetFrontendResponse {
        public boolean ok;
        public String reason;
        public String requestId;
        public String shortDesc;
        public String longDesc;
        public JsonElement colDesc;
    }

    public static class ExplainDatasetBackendResponse {
        boolean ok;
        String error;
        String request_id;
        String shortDesc;
        String longDesc;
        JsonElement colDesc;
    }

    private static class ExplainDatasetBackendQuery {
        String licenseId;
        boolean telemetryEnabled;
        JsonObject explanationOptions;
        String datasetName;
        Schema datasetSchema;
        List<AIDatasetColumn> datasetColumns = new ArrayList<AIDatasetColumn>();

        private ExplainDatasetBackendQuery() {
        }
    }
}

