/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.analysis.ml.prediction.CustomPythonPredictionAlgoDesc;
import com.dataiku.dip.analysis.ml.prediction.LoadedCustomPythonPredictionAlgoDesc;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class CustomPythonPredictionAlgoService
extends CustomPythonElementService<CustomPythonPredictionAlgoDesc, LoadedCustomPythonPredictionAlgoDesc> {
    @Override
    public String getFolderName() {
        return "python-prediction-algos";
    }

    @Override
    public String getPrefix() {
        return "algo";
    }

    @Override
    protected void removeElement(LoadedCustomPythonPredictionAlgoDesc desc) {
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "CustomPyPredAlgo_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedCustomPythonPredictionAlgoDesc load(String elementType, String pluginId, String elementId, File file) throws IOException {
        CustomPythonPredictionAlgoDesc modelDesc = (CustomPythonPredictionAlgoDesc)JSON.parseFile((File)file, CustomPythonPredictionAlgoDesc.class);
        return new LoadedCustomPythonPredictionAlgoDesc(elementType, elementId, pluginId, modelDesc);
    }

    @Override
    public Class<CustomPythonPredictionAlgoDesc> getDescClass() {
        return CustomPythonPredictionAlgoDesc.class;
    }

    @Override
    public Class<LoadedCustomPythonPredictionAlgoDesc> getLoadedDescClass() {
        return LoadedCustomPythonPredictionAlgoDesc.class;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomPythonPredictionAlgoDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomPythonPredictionAlgoService.this.getPrefix());
                    if (CustomPythonPredictionAlgoDesc.GridSearchMode.MANAGED.equals((Object)desc.gridSearchMode)) {
                        ArrayList arrayLikeTypes = Lists.newArrayList((Object[])new ParamDesc.Type[]{ParamDesc.Type.STRINGS, ParamDesc.Type.DOUBLES, ParamDesc.Type.MULTISELECT, ParamDesc.Type.ARRAY});
                        for (CustomPythonPredictionAlgoDesc.MLParamDesc param : desc.params) {
                            if (!param.gridParam || arrayLikeTypes.contains((Object)param.type)) continue;
                            this.withWarning("Grid param '" + param.name + "' must have an array-like type. It is currently: '" + String.valueOf((Object)param.type) + "'");
                        }
                    }
                }
                this.genericValidateMeta(desc.meta);
                if (desc.predictionTypes == null || desc.predictionTypes.isEmpty()) {
                    this.withFatal("Custom Prediction Algo needs at least one \"predictionTypes\" among (BINARY_CLASSIFICATION, MULTICLASS, REGRESSION)");
                }
                return this.messages;
            }
        }.validate();
    }

    public List<LoadedCustomPythonPredictionAlgoDesc> listAlgosFromLoadedPlugins() {
        ArrayList<LoadedCustomPythonPredictionAlgoDesc> ret = new ArrayList<LoadedCustomPythonPredictionAlgoDesc>();
        for (LoadedCustomPythonPredictionAlgoDesc modelDesc : this.list()) {
            if (!this.pluginsService.isPluginInstalled(modelDesc.ownerPluginId)) continue;
            ret.add(modelDesc);
        }
        return ret;
    }

    public LoadedCustomPythonPredictionAlgoDesc get(String pluginId, String elementId) {
        String type = this.makeType(pluginId, elementId);
        return this.get(type);
    }

    public boolean exists(String pluginId, String elementId) {
        return this.pluginsService.isPluginInstalled(pluginId) && this.loadedDescs.containsKey(this.makeType(pluginId, elementId));
    }

    public LoadedCustomPythonPredictionAlgoDesc get(String elementType) {
        if (!this.loadedDescs.containsKey(elementType)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Element " + elementType + " not found.");
        }
        return (LoadedCustomPythonPredictionAlgoDesc)this.loadedDescs.get(elementType);
    }
}

