/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.shared;

import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.preprocessing.CatFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.NumFeaturePreprocessingParams;
import com.dataiku.dip.utils.JSON;
import java.util.Map;

public abstract class ParameterAutoCompleter {
    public abstract CatFeaturePreprocessingParams.DummyDroppingMethod getDummyDroppingMethod();

    public WorkSet.PreprocessingSet autocomplete(WorkSet.PreprocessingSet pps) {
        WorkSet.PreprocessingSet copy = (WorkSet.PreprocessingSet)JSON.deepCopy((Object)pps);
        Map<String, FeaturePreprocessingParams> perFeature = copy.preprocessing_params.per_feature;
        for (FeaturePreprocessingParams par : perFeature.values()) {
            if (!(par instanceof CatFeaturePreprocessingParams)) continue;
            CatFeaturePreprocessingParams cat = (CatFeaturePreprocessingParams)par;
            if (cat.dummy_drop == CatFeaturePreprocessingParams.DummyDroppingMethod.AUTO) {
                cat.dummy_drop = this.getDummyDroppingMethod();
            }
            if (!cat.frequency_normalized || cat.category_handling != CatFeaturePreprocessingParams.CategoryHandlingMethod.FREQUENCY) continue;
            cat.categorical_rescaling = NumFeaturePreprocessingParams.RescalingMethod.NONE;
        }
        return copy;
    }

    public static class DummyDropAutoCompleter
    extends ParameterAutoCompleter {
        @Override
        public CatFeaturePreprocessingParams.DummyDroppingMethod getDummyDroppingMethod() {
            return CatFeaturePreprocessingParams.DummyDroppingMethod.DROP;
        }
    }

    public static class DefaultParameterAutoCompleter
    extends ParameterAutoCompleter {
        @Override
        public CatFeaturePreprocessingParams.DummyDroppingMethod getDummyDroppingMethod() {
            return CatFeaturePreprocessingParams.DummyDroppingMethod.NONE;
        }
    }
}

