/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.core;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.clustering.PostTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.core.PreTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.DeepHubPostTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;

public interface PostTrainModelingParams {
    public ModelTrainInfo.PostSearchDescription generatePostSearchDescription(ModelTrainInfo.PreSearchDescription var1, PreTrainModelingParams var2);

    public String getAlgorithmName();

    public static class JsonAdapterInit {
        static {
            JSON.registerAdapter(PostTrainModelingParams.class, (Object)new JSON.Adapter<PostTrainModelingParams>(){

                public PostTrainModelingParams deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    if (jsonObj.has("k")) {
                        return (PostTrainModelingParams)jsonDeserializationContext.deserialize(jsonElement, PostTrainClusteringModelingParams.class);
                    }
                    if (jsonObj.has("type")) {
                        String type = jsonObj.get("type").getAsString();
                        if (PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_OBJECT_DETECTION.name().equals(type)) {
                            return (PostTrainModelingParams)jsonDeserializationContext.deserialize(jsonElement, DeepHubPostTrainModelingParams.ObjectDetectionPostTrainModelingParams.class);
                        }
                        if (PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_CLASSIFICATION.name().equals(type)) {
                            return (PostTrainModelingParams)jsonDeserializationContext.deserialize(jsonElement, DeepHubPostTrainModelingParams.ImageClassificationPostTrainModelingParams.class);
                        }
                        throw new IllegalArgumentException("Unknown type: " + type);
                    }
                    return (PostTrainModelingParams)jsonDeserializationContext.deserialize(jsonElement, PostTrainPredictionModelingParams.class);
                }

                public JsonElement serialize(PostTrainModelingParams modelingParams, Type type, JsonSerializationContext ctx) {
                    return ctx.serialize((Object)modelingParams);
                }
            });
        }
    }
}

