/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public class TimestepParams {
    public long numberOfTimeunits = 7L;
    public Timeunit timeunit = Timeunit.DAY;
    public int endOfWeekDay = 1;
    public int unitAlignment = 0;
    public int monthlyAlignment = 31;

    public int getEndOfWeekDay() {
        if (this.endOfWeekDay == 1) {
            return 7;
        }
        return this.endOfWeekDay - 1;
    }

    public static enum Timeunit {
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        BUSINESS_DAY,
        WEEK,
        MONTH,
        QUARTER,
        HALF_YEAR,
        YEAR;


        public TimeUnitQuantity toTimeUnitQuantity() {
            switch (this) {
                case MILLISECOND: {
                    return new TimeUnitQuantity(ChronoUnit.MILLIS, 1);
                }
                case SECOND: {
                    return new TimeUnitQuantity(ChronoUnit.SECONDS, 1);
                }
                case MINUTE: {
                    return new TimeUnitQuantity(ChronoUnit.MINUTES, 1);
                }
                case HOUR: {
                    return new TimeUnitQuantity(ChronoUnit.HOURS, 1);
                }
                case BUSINESS_DAY: 
                case DAY: {
                    return new TimeUnitQuantity(ChronoUnit.DAYS, 1);
                }
                case WEEK: {
                    return new TimeUnitQuantity(ChronoUnit.WEEKS, 1);
                }
                case MONTH: {
                    return new TimeUnitQuantity(ChronoUnit.MONTHS, 1);
                }
                case QUARTER: {
                    return new TimeUnitQuantity(ChronoUnit.MONTHS, 3);
                }
                case HALF_YEAR: {
                    return new TimeUnitQuantity(ChronoUnit.MONTHS, 6);
                }
                case YEAR: {
                    return new TimeUnitQuantity(ChronoUnit.YEARS, 1);
                }
            }
            throw new IllegalArgumentException("Unhandled chrono unit conversion");
        }
    }

    public static class TimeUnitQuantity {
        public ChronoUnit unit;
        public int quantity;

        public TimeUnitQuantity(ChronoUnit unit, int quantity) {
            this.unit = unit;
            this.quantity = quantity;
        }

        public int getCurrentDateUnitAlignment(LocalDateTime currentDate) {
            switch (this.unit) {
                case DAYS: {
                    return currentDate.getDayOfWeek().getValue();
                }
                case MONTHS: {
                    return currentDate.getMonthValue();
                }
            }
            throw new IllegalArgumentException("Unsupported alignment for " + String.valueOf(this.unit));
        }
    }
}

