/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms;

import com.dataiku.dip.analysis.ml.shared.ParameterAutoCompleter;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.List;
import java.util.Optional;

public abstract class PredictionAlgorithmMeta {
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.ml.prediction.algorithm.prediction-algorithm-meta");

    public abstract MLTask.BackendType backendType();

    public abstract String generateName(PreTrainPredictionModelingParams var1);

    public abstract ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams var1);

    public abstract ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription var1, PreTrainPredictionModelingParams var2, PostTrainPredictionModelingParams var3);

    public abstract void validateParameters(PredictionModelingParams var1, PredictionMLTask.TabularPredictionMLTask var2, PredictionParameterChecks var3);

    public abstract List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams var1, PredictionMLTask.TabularPredictionMLTask var2, int var3);

    public abstract PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams var1, PreTrainPredictionModelingParams var2);

    protected PreTrainPredictionModelingParams getCopyWithGridStrategy(PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams ptpmp = (PreTrainPredictionModelingParams)JSON.deepCopy((Object)usedToTrain);
        ptpmp.grid_search_params.strategy = PredictionModelingParams.GridSearchParams.Strategy.GRID;
        return ptpmp;
    }

    public abstract void regridifyToMLTask(PredictionModelingParams var1, PostTrainPredictionModelingParams var2, PreTrainPredictionModelingParams var3);

    public abstract void refreshMLTask(PredictionModelingParams var1, PreTrainPredictionModelingParams var2);

    public ParameterAutoCompleter autoCompleter() {
        return new ParameterAutoCompleter.DefaultParameterAutoCompleter();
    }

    public abstract boolean hasProbabilities(PreTrainPredictionModelingParams var1);

    public boolean isJavaCompatible(ResolvedClassicalPredictionCoreParams coreParams) {
        return false;
    }

    public boolean isPythonCompatible(ResolvedClassicalPredictionCoreParams coreParams) {
        return false;
    }

    public boolean isSQLCompatible(ResolvedClassicalPredictionCoreParams coreParams) {
        return false;
    }

    public boolean isPMMLCompatible() {
        return false;
    }

    public boolean oneModelPerPreprocessingSet() {
        return false;
    }

    protected int getGridLength(PredictionModelingParams.HyperparametersSpace space) {
        return 1;
    }

    public int getSearchSize(PredictionModelingParams.GridSearchParams searchParams, PredictionModelingParams.HyperparametersSpace space) {
        if (searchParams.strategy == PredictionModelingParams.GridSearchParams.Strategy.GRID) {
            if (searchParams.nIter > 0) {
                return Math.min(this.getGridLength(space), searchParams.nIter);
            }
            return this.getGridLength(space);
        }
        return searchParams.nIterRandom;
    }

    protected void checkAndUpdateSearchStrategy(PredictionModelingParams pmp, PreTrainPredictionModelingParams usedToTrain) {
        Optional<PredictionModelingParams.GridSearchParams.Strategy> maxSupportedStrategy = usedToTrain.checkMaximumSearchStrategy(pmp.gridSearchParams.strategy);
        maxSupportedStrategy.ifPresent(strategy -> {
            logger.warnV("Model %s does not support %s search, switching to %s search", new Object[]{usedToTrain.generateName(), pmp.gridSearchParams.strategy.name(), strategy.name()});
            usedToTrain.grid_search_params.strategy = strategy;
        });
    }

    public PredictionModelingParams.GridSearchParams.Strategy getMaximumSupportedSearchStrategy() {
        return PredictionModelingParams.GridSearchParams.Strategy.BAYESIAN;
    }
}

