/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.python;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.CategoricalHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.algorithms.python.PyMemoryAlgorithmMeta;
import java.util.Collections;
import java.util.List;

public class GluonTSTorchSimpleFeedForwardMeta
extends PyMemoryAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        return "Simple Feed Forward - Torch";
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        PredictionModelingParams.GluonTSTorchSimpleFeedForwardSpace space = rpmp.gluonts_torch_simple_feed_forward_timeseries_grid;
        ModelTrainInfo.PreSearchDescription description = new ModelTrainInfo.PreSearchDescription(rpmp).withGridLength(this.getSearchSize(rpmp.grid_search_params, space)).withMVParam("Learning rate", space.learning_rate).withMVParam("Batch normalization", space.batch_normalization).withMVParam("Weight decay", space.weight_decay).withSVParam("Hidden layer sizes", space.num_hidden_dimensions);
        if (!space.full_context) {
            description = description.withMVParam("Context length", space.context_length);
        }
        return description;
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        PredictionModelingParams.GluonTSTorchSimpleFeedForwardSpace space = before.gluonts_torch_simple_feed_forward_timeseries_grid;
        PostTrainPredictionModelingParams.GluonTSTorchSimpleFeedForwardParams params = after.gluonts_torch_simple_feedforward_timeseries_params;
        ModelTrainInfo.PostSearchDescription description = new ModelTrainInfo.PostSearchDescription().withSVParam("Learning rate", params.learning_rate).withSVParam("Batch normalization", params.batch_normalization).withSVParam("Weight decay", params.weight_decay).withSVParam("Hidden layer sizes", params.num_hidden_dimensions).withSVParam("Epochs", params.epochs);
        if (!space.full_context) {
            description = description.withSVParam("Context length", params.context_length);
        }
        return description;
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        PredictionModelingParams.GluonTSTorchSimpleFeedForwardSpace space = pmp.gluonts_torch_simple_feed_forward_timeseries;
        if (space == null || !space.enabled) {
            return;
        }
        checks.checkPositive(space.batch_normalization.getLength(), "At least one batch normalization option must be selected (Simple Feed Forward)");
        checks.checkNumericalDimension(space.learning_rate, "Learning rate (Simple Feed Forward)");
        checks.checkNumericalDimension(space.weight_decay, "Weight Decay (Simple Feed Forward)");
        if (!space.full_context) {
            checks.checkNumericalDimension(space.context_length, "Context length (Simple Feed Forward)");
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        PredictionModelingParams.GluonTSTorchSimpleFeedForwardSpace space = pmp.gluonts_torch_simple_feed_forward_timeseries;
        if (space == null || !space.enabled) {
            return Collections.emptyList();
        }
        PreTrainPredictionModelingParams preTrainParams = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.GLUONTS_TORCH_SIMPLE_FEEDFORWARD, pmp);
        preTrainParams.gluonts_torch_simple_feed_forward_timeseries_grid = space;
        preTrainParams.gridLength = this.getSearchSize(preTrainParams.grid_search_params, space);
        WorkSet.ModelingSet modelingSet = new WorkSet.ModelingSet(preTrainParams);
        if (preTrainParams.gridLength > 1) {
            modelingSet.estimatedTrains = preTrainParams.gridLength * gsFolds + 1;
        }
        return Collections.singletonList(modelingSet);
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PostTrainPredictionModelingParams.GluonTSTorchSimpleFeedForwardParams optimizedParameters = optimized.gluonts_torch_simple_feedforward_timeseries_params;
        PreTrainPredictionModelingParams preTrainParams = this.getCopyWithGridStrategy(usedToTrain);
        PredictionModelingParams.GluonTSTorchSimpleFeedForwardSpace space = preTrainParams.gluonts_torch_simple_feed_forward_timeseries_grid;
        if (!preTrainParams.gluonts_torch_simple_feed_forward_timeseries_grid.full_context) {
            space.context_length.setToSingleValueGrid(optimizedParameters.context_length);
        }
        space.learning_rate.setToSingleValueGrid(optimizedParameters.learning_rate);
        space.weight_decay.setToSingleValueGrid(optimizedParameters.weight_decay);
        space.distr_output = CategoricalHyperparameterDimension.create(optimizedParameters.distr_output, "StudentTOutput");
        space.batch_normalization = CategoricalHyperparameterDimension.create(optimizedParameters.batch_normalization, "true", "false");
        return preTrainParams;
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrainParams = this.regridifyToPreTrain(optimized, usedToTrain);
        target.gluonts_torch_simple_feed_forward_timeseries = preTrainParams.gluonts_torch_simple_feed_forward_timeseries_grid;
        target.gluonts_torch_simple_feed_forward_timeseries.enabled = true;
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.gluonts_torch_simple_feed_forward_timeseries = usedToTrain.gluonts_torch_simple_feed_forward_timeseries_grid;
        target.gluonts_torch_simple_feed_forward_timeseries.enabled = true;
    }

    @Override
    public boolean hasProbabilities(PreTrainPredictionModelingParams usedToTrain) {
        return true;
    }

    @Override
    protected int getGridLength(PredictionModelingParams.HyperparametersSpace space) {
        PredictionModelingParams.GluonTSTorchSimpleFeedForwardSpace gluonTSTorchSimpleFeedForwardSpace = (PredictionModelingParams.GluonTSTorchSimpleFeedForwardSpace)space;
        int gridLength = gluonTSTorchSimpleFeedForwardSpace.batch_normalization.getLength() * gluonTSTorchSimpleFeedForwardSpace.distr_output.getLength() * gluonTSTorchSimpleFeedForwardSpace.learning_rate.getLength() * gluonTSTorchSimpleFeedForwardSpace.weight_decay.getLength();
        if (!gluonTSTorchSimpleFeedForwardSpace.full_context) {
            gridLength *= gluonTSTorchSimpleFeedForwardSpace.context_length.getLength();
        }
        return gridLength;
    }
}

