/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.preprocessing;

import com.dataiku.dip.analysis.model.ParameterChecks;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.PreprocessingParams;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class FeatureGenerationParams {
    public PairwiseLinearCombinations pairwise_linear = new PairwiseLinearCombinations();
    public PolynomialCombinations polynomial_combinations = new PolynomialCombinations();
    public ManualPairwiseInteractions manual_interactions = new ManualPairwiseInteractions();
    public NumericalsClusteringGenerator numericals_clustering = new NumericalsClusteringGenerator();
    public CategoricalsCountTransformerGenerator categoricals_count_transformer = new CategoricalsCountTransformerGenerator();

    public void validate(ParameterChecks checks, PreprocessingParams params) {
        this.validateInteractions(checks, params);
        this.validateNumericalCombinations(checks, params);
    }

    private void validateNumericalCombinations(ParameterChecks checks, PreprocessingParams params) {
        long genNumComb = 0L;
        if (this.pairwise_linear.behavior == GeneratorBehavior.ENABLED_MANUAL || this.polynomial_combinations.behavior == GeneratorBehavior.ENABLED_MANUAL) {
            long n = 0L;
            for (FeaturePreprocessingParams fpp : params.per_feature.values()) {
                if (!fpp.type.equals((Object)FeaturePreprocessingParams.FeatureType.NUMERIC)) continue;
                ++n;
            }
            if (n >= 2L) {
                n = n * (n - 1L) / 2L;
                if (this.pairwise_linear.behavior == GeneratorBehavior.ENABLED_MANUAL) {
                    genNumComb += n * 2L;
                }
                if (this.polynomial_combinations.behavior == GeneratorBehavior.ENABLED_MANUAL) {
                    genNumComb += n;
                }
                if (genNumComb > 1000L) {
                    checks.addWarning("Generated many features", "You have enabled feature generation that adds " + genNumComb + " features.");
                }
            }
        }
    }

    private void validateInteractions(ParameterChecks checks, PreprocessingParams params) {
        HashSet<CallSite> dupset = new HashSet<CallSite>();
        for (FeatureInteraction fi : this.manual_interactions.interactions) {
            Logger.getLogger(this.getClass()).info((Object)("Analyzing interaction : " + fi.column_1 + " " + fi.column_2));
            if (fi.column_1 == null || fi.column_2 == null) {
                checks.addError("Missing column name in feature interaction", "Missing column name in feature interaction");
                continue;
            }
            if (params.per_feature.get((Object)fi.column_1).role == FeaturePreprocessingParams.Role.REJECT || params.per_feature.get((Object)fi.column_2).role == FeaturePreprocessingParams.Role.REJECT) {
                checks.addError("Invalid interaction", "Cannot use a rejected feature in an interaction");
            }
            if (fi.column_1.equals(fi.column_2)) {
                checks.addError("Invalid interaction", "Cannot use the same feature twice in an interaction.");
            }
            String a = fi.column_1 + "__join__" + fi.column_2;
            String b = fi.column_2 + "__join__" + fi.column_1;
            if (dupset.contains(a) || dupset.contains(b)) {
                checks.addError("Redundant interaction", "Interaction between " + fi.column_1 + " and " + fi.column_2 + " is defined twice.");
            }
            dupset.add((CallSite)((Object)a));
            dupset.add((CallSite)((Object)b));
        }
    }

    public static class PairwiseLinearCombinations
    extends AutomatizableFeatureGenerator {
    }

    public static class PolynomialCombinations
    extends AutomatizableFeatureGenerator {
    }

    public static class ManualPairwiseInteractions {
        public List<FeatureInteraction> interactions = new ArrayList<FeatureInteraction>();
    }

    public static class NumericalsClusteringGenerator
    extends AutomatizableFeatureGenerator {
        public int k;
        public TransformationMode transformation_mode;
        public boolean all_features;
        public List<String> input_features = new ArrayList<String>();

        public static enum TransformationMode {
            REPLACE_BY_DISTANCE,
            IMPACT_CODE_CLUSTERID,
            DUMMIFY_CLUSTERID;

        }
    }

    public static class CategoricalsCountTransformerGenerator
    extends AutomatizableFeatureGenerator {
        public boolean all_features;
        public List<String> input_features = new ArrayList<String>();
    }

    public static enum GeneratorBehavior {
        DISABLED,
        ENABLED_AUTOMATIC,
        ENABLED_MANUAL;

    }

    public static class FeatureInteraction {
        public String column_1;
        public String column_2;
        public int max_features;
        public boolean rescale;
    }

    public static class AutomatizableFeatureGenerator {
        public GeneratorBehavior behavior = GeneratorBehavior.DISABLED;
    }
}

