/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual;

import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class APIServiceDeploymentHeavyStatus
extends AbstractDeploymentHeavyStatus {
    public List<PublishedPackageInfo> packages = new ArrayList<PublishedPackageInfo>();
    public List<EndpointSummary> endpoints = new ArrayList<EndpointSummary>();

    protected APIServiceDeploymentHeavyStatus() {
    }

    protected APIServiceDeploymentHeavyStatus(String deploymentId, String infraId) {
        super(deploymentId, infraId);
    }

    public List<EndpointSummary> summarizeEndpoints_NT(AbstractAPIServiceDeployment deployment, boolean withPackageExtraInfo) throws NotFoundException {
        if (deployment.generationsMapping == null) {
            throw ErrorContext.iae((String)"The deployment does not contain any version.");
        }
        this.packages.sort((o1, o2) -> -o1.id.compareTo(o2.id));
        for (PublishedPackageInfo pp : this.packages) {
            if (!deployment.generationsMapping.isUsed(pp.id)) continue;
            PublishedApiServicePackageInfo packageInfo = (PublishedApiServicePackageInfo)pp;
            ArrayList<EndpointSummary> packageEndpoints = new ArrayList<EndpointSummary>();
            for (LambdaEndpointConfig lec : packageInfo.endpoints) {
                EndpointSummary es = new EndpointSummary();
                es.id = lec.id;
                es.type = lec.type;
                if (withPackageExtraInfo) {
                    List<ApiEndpointQuery> originalTestQueries = ((PublishedAPIServicesService)SpringUtils.getBean(PublishedAPIServicesService.class)).readTestQueries_NT(deployment.publishedServiceId, pp.id, lec.id);
                    if (originalTestQueries != null) {
                        es.testQueries = originalTestQueries.stream().map(testQuery -> this.adaptQueryForInfraType((ApiEndpointQuery)testQuery, es.type)).collect(Collectors.toList());
                    }
                    if (lec.hasCustomCode()) {
                        es.code = ((PublishedAPIServicesService)SpringUtils.getBean(PublishedAPIServicesService.class)).readCode_NT(deployment.publishedServiceId, pp.id, lec);
                    }
                }
                packageEndpoints.add(es);
            }
            return packageEndpoints;
        }
        return new ArrayList<EndpointSummary>();
    }

    public ApiEndpointQuery adaptQueryForInfraType(ApiEndpointQuery query, LambdaEndpointConfig.EndpointType endpointType) {
        return query;
    }

    public static class EndpointSummary {
        public LambdaEndpointConfig.EndpointType type;
        public String id;
        public List<ApiEndpointQuery> testQueries = new ArrayList<ApiEndpointQuery>();
        @Nullable
        public String code;
        public PredictionMLTask.PredictionType predictionType;
    }
}

