/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIServiceDeployment;
import com.dataiku.dip.apideployer.datamodel.config.MultiNodeProjectDeployment;
import com.dataiku.dip.apideployer.datamodel.config.SageMakerAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.SingleNodeProjectDeployment;
import com.dataiku.dip.apideployer.datamodel.config.SnowparkAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.StaticDeployment;
import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeployment;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@PolyJSON(value={@Mapping(type="K8S", value=K8SAPIServiceDeployment.class), @Mapping(type="STATIC", value=StaticDeployment.class), @Mapping(type="AZURE_ML", value=AzureMLAPIDeployment.class), @Mapping(type="DATABRICKS", value=DatabricksAPIDeployment.class), @Mapping(type="SAGEMAKER", value=SageMakerAPIDeployment.class), @Mapping(type="SNOWPARK", value=SnowparkAPIDeployment.class), @Mapping(type="VERTEX_AI", value=VertexAIAPIDeployment.class), @Mapping(type="PROJECT", value=SingleNodeProjectDeployment.class), @Mapping(type="PROJECT_MULTI", value=MultiNodeProjectDeployment.class)})
public abstract class AbstractDeployment {
    @JSON.FileTransient
    public String id;
    public String infraId;
    public Set<String> tags = new HashSet<String>();
    public VersionTag creationTag;
    public VersionTag versionTag;
    public VersionTag deploymentTag;

    protected AbstractDeployment() {
    }

    protected AbstractDeployment(String id, String infraId, VersionTag creationTag) {
        this.id = id;
        this.infraId = infraId;
        this.creationTag = creationTag;
        this.versionTag = creationTag;
        this.deploymentTag = new VersionTag();
    }

    public abstract String getKey();

    public abstract String getPublishedItemId();

    public abstract String getTargetId();

    public abstract boolean hasPublishedItemAndPackageVersion(String var1, String var2);

    public abstract void switchVersion(String var1);

    public abstract AbstractDeploymentBasicInfo basicInfoUnsafe();

    public void verifyFields(AbstractDeploymentInfra infra, AbstractDeployment oldDeployment, boolean isDeployed) {
        AbstractDeployment.verifyImmutableField(oldDeployment.infraId, this.infraId, "target infrastructure");
    }

    protected static void verifyImmutableField(Object oldField, Object newField, String fieldName) {
        if (!Objects.equals(oldField, newField)) {
            throw ErrorContext.iaef((String)"The %s of a deployment cannot be modified (old value: %s, new value: %s)", (Object)fieldName, (Object[])new Object[]{oldField.toString(), newField.toString()});
        }
    }
}

