/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;

public class DeploymentHookResult {
    public ExecutionStatus status;
    public String message;
    public String sensitiveData;

    public static void registerJsonAdapters() {
        JSON.registerAdapter(DeploymentHookResult.class, (Object)new Deserializer());
    }

    private static class Deserializer
    implements JsonDeserializer<DeploymentHookResult> {
        private Deserializer() {
        }

        public DeploymentHookResult deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            DeploymentHookResult result = new DeploymentHookResult();
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("message")) {
                result.message = (String)jsonDeserializationContext.deserialize(jsonObject.get("message"), String.class);
            }
            if (jsonObject.has("sensitiveData")) {
                result.sensitiveData = (String)jsonDeserializationContext.deserialize(jsonObject.get("sensitiveData"), String.class);
            }
            if (jsonObject.has("status")) {
                String responseStatus = (String)jsonDeserializationContext.deserialize(jsonObject.get("status"), String.class);
                for (ExecutionStatus status : ExecutionStatus.values()) {
                    if (!status.name().equals(responseStatus)) continue;
                    result.status = status;
                    return result;
                }
                throw new JsonParseException(String.format("Unknown status returned by hook: %s. The possible statuses are: %s (message in response is: %s)", responseStatus, Arrays.stream(ExecutionStatus.values()).map(Enum::name).collect(Collectors.joining(", ")), result.message));
            }
            throw new JsonParseException(String.format("Missing status field in hook response (message in response is: %s)", result.message));
        }
    }

    public static enum ExecutionStatus {
        SUCCESS,
        WARNING,
        ERROR;

    }
}

