/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.apideployer.infra.ApiNodeK8SInfraManager;
import com.dataiku.dip.cluster.ClusterPropertyList;
import com.dataiku.dip.cluster.ClusterSelection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.LoadBalancerExposition;
import com.dataiku.dip.resourceusage.k8s.IK8SContainerLimits;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class K8SAPIDeploymentInfra
extends AbstractAPIDockerDeploymentInfra {
    public ClusterSelection cluster = new ClusterSelection();
    public String k8sContext;
    private String k8sNamespace;
    public String k8sConfigPath;
    public List<SimpleKeyValue> k8sProperties = new ArrayList<SimpleKeyValue>();
    public List<SimpleKeyValue> additionalEnvVars = new ArrayList<SimpleKeyValue>();
    public boolean useSecretToDefineEnvVars;
    public boolean allowAdditionalEnvVarsInDeployments;
    public List<SimpleKeyValue> additionalLabels = new ArrayList<SimpleKeyValue>();
    public boolean allowAdditionalLabelsInDeployments;
    public List<SimpleKeyValue> additionalAnnotations = new ArrayList<SimpleKeyValue>();
    public boolean allowAdditionalAnnotationsInDeployments;
    public String serviceAccountName;
    public Exposition defaultServiceExposition = K8SAPIDeploymentInfra.makeDefaultExposition();
    public K8SContainerLimits defaultContainerLimits = new K8SContainerLimits();
    public K8SAPINodeServerSizing defaultApiNodeServerSizing = new K8SAPINodeServerSizing();
    public K8SDeploymentScaling defaultDeploymentScaling = new K8SDeploymentScaling();
    public K8SDeploymentPodDisruptionBudget defaultDeploymentPodDisruptionBudget = new K8SDeploymentPodDisruptionBudget();
    public String defaultDeploymentTopologySpreadConstraints;
    public K8SYamlModifier defaultDeploymentModifier = new K8SYamlModifier();
    public boolean enableOpenshiftCompatibility = true;

    private K8SAPIDeploymentInfra() {
    }

    public K8SAPIDeploymentInfra(String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        super(id, stage, userIdentifier, governCheckPolicy);
        NodesDirectory nd = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectoryUnsafe_AutoTXN();
        this.activityMonitoringSettings = nd.enabled ? new ActivityMonitoringSettings.PushAuto() : new ActivityMonitoringSettings.Disabled();
    }

    @Override
    public AbstractDeploymentInfra.InfraType getInfraType() {
        return AbstractDeploymentInfra.InfraType.K8S;
    }

    @Override
    public ApiNodeInfraManager getInfraManager(DKULogger logger) {
        return new ApiNodeK8SInfraManager(this);
    }

    public String getK8sNamespace() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.k8sNamespace, (CharSequence)"default");
    }

    public static Exposition makeDefaultExposition() {
        Exposition ret = new Exposition().withType(LoadBalancerExposition.META.getType());
        try {
            ret.params = LoadBalancerExposition.META.getParamsClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static class K8SContainerLimits
    implements IK8SContainerLimits {
        public int memRequestMB = -1;
        public int memLimitMB = -1;
        public double cpuRequest = -1.0;
        public double cpuLimit = -1.0;
        public String nodeSelector;
        public String tolerations;
        public String affinity;
        public ClusterPropertyList customLimits = new ClusterPropertyList();
        public ClusterPropertyList customRequests = new ClusterPropertyList();

        public K8SContainerLimits() {
        }

        public K8SContainerLimits(K8SContainerLimits k8SContainerLimits) {
            this.memRequestMB = k8SContainerLimits.memRequestMB;
            this.memLimitMB = k8SContainerLimits.memLimitMB;
            this.cpuRequest = k8SContainerLimits.cpuRequest;
            this.cpuLimit = k8SContainerLimits.cpuLimit;
            this.nodeSelector = k8SContainerLimits.nodeSelector;
            this.tolerations = k8SContainerLimits.tolerations;
            this.affinity = k8SContainerLimits.affinity;
            this.customLimits = k8SContainerLimits.customLimits.deepCopy();
            this.customRequests = k8SContainerLimits.customRequests.deepCopy();
        }

        public K8SContainerLimits deepCopy() {
            return new K8SContainerLimits(this);
        }

        public boolean hasRequests() {
            return this.cpuRequest > 0.0 || this.memRequestMB > 0 || !this.customRequests.isEmpty();
        }

        public boolean hasLimits() {
            return this.cpuLimit > 0.0 || this.memLimitMB > 0 || !this.customLimits.isEmpty();
        }

        public int getMemRequestMB() {
            return this.memRequestMB;
        }

        public int getMemLimitMB() {
            return this.memLimitMB;
        }

        public double getCpuRequest() {
            return this.cpuRequest;
        }

        public double getCpuLimit() {
            return this.cpuLimit;
        }
    }

    public static class K8SAPINodeServerSizing {
        public String apimainXmx = "1g";
        public String apimainGC = "g1";
        public String apimainAdditionalOpts;
    }

    public static class K8SDeploymentScaling {
        public int initialReplicas = 3;
        public int progressDeadlineSeconds = 600;
        public boolean hpa;
        public int hpaTargetCPUPercent;
        public int hpaTargetMemoryPercent;
        public List<K8SAutoscalerMetric> hpaMetrics = new ArrayList<K8SAutoscalerMetric>();
        public String hpaExtraMetrics;
        public int hpaMinPods;
        public int hpaMaxPods;
        public List<SimpleKeyValue> hpaAnnotations = new ArrayList<SimpleKeyValue>();
    }

    public static class K8SDeploymentPodDisruptionBudget {
        public boolean enable;
        public boolean isMaxUnavailable;
        public String minAvailable;
        public String maxUnavailable;
    }

    public static class K8SYamlModifier {
        public String runnableType;
        public JsonObject config = new JsonObject();

        public JsonObject getSensitiveSettings() {
            JsonObject ret = new JsonObject();
            ret.addProperty("runnableType", this.runnableType);
            ret.add("config", (JsonElement)this.config);
            return ret;
        }
    }

    public static class K8SAutoscalerMetric {
        public String type;
        public String name;
        public boolean utilization;
        public String value;
    }
}

