/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.apideployer.infra.AbstractAutomationNodeInfraManager;
import com.dataiku.dip.apideployer.infra.SingleAutomationNodeInfraManager;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SingleAutomationNodeInfra
extends AbstractProjectDeploymentInfra {
    public String nodeId;
    private String automationNodeUrl;
    @Nullable
    private String automationNodeExternalUrl;
    @Nullable
    private String adminApiKey;

    @Nonnull
    public NodeConnection getConnectionInfo() {
        PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        if (this.autoconfigureFromNodesDirectory) {
            NodesDirectory nd = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectoryUnsafe_AutoTXN();
            NodesDirectory.NodeRef nr = (NodesDirectory.NodeRef)nd.getById(this.nodeId).orElseThrow(() -> new IllegalArgumentException("Invalid automation node " + this.nodeId));
            return NodeConnection.forSingleNodeInfra((String)nr.url, (String)nr.externalUrl, (String)passwordEncryptionService.decryptIfEncrypted(nr.adminAPIKey), (boolean)true, (NodesDirectory.NodeStatus)nr.status);
        }
        return NodeConnection.forSingleNodeInfra((String)this.automationNodeUrl, (String)this.automationNodeExternalUrl, (String)passwordEncryptionService.decryptIfEncrypted(this.adminApiKey), (boolean)this.trustAllSSLCertificates, null);
    }

    private SingleAutomationNodeInfra() {
    }

    public SingleAutomationNodeInfra(String id, String stage, String userIdentifier, String automationNodeUrl, String adminApiKey, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        super(id, stage, userIdentifier, governCheckPolicy);
        this.automationNodeUrl = automationNodeUrl;
        this.adminApiKey = adminApiKey;
    }

    @Override
    public AbstractDeploymentInfra.InfraType getInfraType() {
        return AbstractDeploymentInfra.InfraType.AUTOMATION_NODE;
    }

    public String getAdminApiKeyForUnitTests() {
        return this.adminApiKey;
    }

    @Override
    public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
        this.adminApiKey = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(this.adminApiKey);
    }

    @Override
    public AbstractAutomationNodeInfraManager getInfraManager(AuthCtx authCtx, int connectTimeout, int socketTimeout) {
        return new SingleAutomationNodeInfraManager(authCtx, this, connectTimeout, socketTimeout);
    }
}

