/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.common.server.APIKeyBase;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.AzureMLDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.AzureMLDeploymentSummary;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.DatabricksDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.databricks.DatabricksDeploymentLocalSummary;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.vertexai.VertexAIDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.vertexai.VertexAIDeploymentLocalSummary;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractFullyManagedAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIServiceDeployment;
import com.dataiku.dip.apideployer.datamodel.config.PublishedItem;
import com.dataiku.dip.apideployer.datamodel.config.SageMakerAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.StaticAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.StaticDeployment;
import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.AzureMLDeploymentInfo;
import com.dataiku.dip.apideployer.deploymentinfo.DatabricksDeploymentInfo;
import com.dataiku.dip.apideployer.deploymentinfo.DeploymentInfoCRUDService;
import com.dataiku.dip.apideployer.deploymentinfo.SageMakerDeploymentInfo;
import com.dataiku.dip.apideployer.deploymentinfo.VertexAIDeploymentInfo;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsDAO;
import com.dataiku.dip.apideployer.deployments.AbstractAPIServiceDeploymentManager;
import com.dataiku.dip.apideployer.deployments.AbstractAPIServiceDockerDeploymentManager;
import com.dataiku.dip.apideployer.deployments.AbstractDeploymentsService;
import com.dataiku.dip.apideployer.deployments.AbstractFullyManagedAPIServiceDeploymentManager;
import com.dataiku.dip.apideployer.deployments.AbstractPublishedPackageInfoForGovernIdentification;
import com.dataiku.dip.apideployer.deployments.AzureMLDeploymentManager;
import com.dataiku.dip.apideployer.deployments.DatabricksDeploymentManager;
import com.dataiku.dip.apideployer.deployments.PublishedApiServicePackageInfoForGovernIdentification;
import com.dataiku.dip.apideployer.deployments.QueryableEndpoint;
import com.dataiku.dip.apideployer.deployments.SingleStaticDeploymentManager;
import com.dataiku.dip.apideployer.deployments.VertexAIDeploymentManager;
import com.dataiku.dip.apideployer.engine.DeploymentReport;
import com.dataiku.dip.apideployer.infra.AbstractInfrasService;
import com.dataiku.dip.apideployer.infra.ApiNodeInfrasDAO;
import com.dataiku.dip.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.apideployer.infra.DeploymentInfrasDAO;
import com.dataiku.dip.apideployer.published.AbstractPublishedItemsService;
import com.dataiku.dip.apideployer.published.PublishedAPIServicesDAO;
import com.dataiku.dip.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.connections.VertexAIModelDeploymentConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineEndpoint;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLHttpClient;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointBase;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerUtils;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.gh.GovernIntegrationService;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerDeploymentConfigChangedEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerDeploymentCreatedEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerDeploymentDeletedEvent;
import com.dataiku.dip.server.openapi.OpenAPIHelper;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.com.google.auth.oauth2.GoogleCredentials;
import com.dataiku.dss.shadelib.com.google.cloud.aiplatform.v1.Endpoint;
import com.dataiku.dss.shadelib.io.swagger.models.Operation;
import com.dataiku.dss.shadelib.io.swagger.models.Swagger;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.client.config.RequestConfig;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClients;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.exception.SdkException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.EndpointSummary;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatusList;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifierList;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.LambdaAuthMethod;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class APIServiceDeploymentsService
extends AbstractDeploymentsService<AbstractAPIServiceDeployment, AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo, AbstractAPIDeploymentInfra> {
    @Autowired
    private APIServiceDeploymentsDAO deploymentsDAO;
    @Autowired
    private ApiNodeInfrasDAO apiNodeInfrasDAO;
    @Autowired
    private PublishedAPIServicesService publishedAPIServicesService;
    @Autowired
    private PublishedAPIServicesDAO publishedAPIServicesDAO;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private ApiNodeInfrasService infrasService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private DeploymentInfoCRUDService deploymentInfoCRUDService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;

    protected APIServiceDeploymentsDAO getDeploymentDAO() {
        return this.deploymentsDAO;
    }

    @Override
    protected DeploymentInfrasDAO<AbstractAPIDeploymentInfra> getInfrasDAO() {
        return this.apiNodeInfrasDAO;
    }

    protected PublishedAPIServicesService getPublishedItemsService() {
        return this.publishedAPIServicesService;
    }

    protected ApiNodeInfrasService getInfrasService() {
        return this.infrasService;
    }

    @Override
    public PublishedAPIServicesDAO getPublishedItemsDAO() {
        return this.publishedAPIServicesDAO;
    }

    @Override
    protected Set<String> getNeverEverDeployedSet() {
        return AbstractAPIServiceDeploymentManager.neverEverDeployed;
    }

    @Override
    protected void publishDeploymentConfigChangedEventAfterTransaction(String deploymentId, String infrastructureId) {
        this.pubSub.publishAfterTransaction((DSSEvent)new APIDeployerDeploymentConfigChangedEvent(deploymentId, infrastructureId));
    }

    @Override
    protected void publishDeploymentDeletedEventAfterTransaction(String deploymentId, String infrastructureId) {
        this.pubSub.publishAfterTransaction((DSSEvent)new APIDeployerDeploymentDeletedEvent(deploymentId, infrastructureId));
    }

    @Override
    protected void publishDeploymentCopiedEventAfterTransaction(String deploymentId) {
        this.pubSub.publishAfterTransaction((DSSEvent)new APIDeployerDeploymentCreatedEvent(deploymentId));
    }

    AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo getDeploymentBasicInfo(AbstractAPIServiceDeployment deployment) throws IOException {
        PublicUser pu;
        AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo deploymentBasicInfo = deployment.basicInfoUnsafe();
        this.addAuthorsNames(deploymentBasicInfo);
        if (deploymentBasicInfo instanceof AbstractDeploymentBasicInfo.FullyManagedDeploymentBasicInfo) {
            ((AbstractDeploymentBasicInfo.FullyManagedDeploymentBasicInfo)deploymentBasicInfo).deploymentInfo = this.deploymentInfoCRUDService.get(deploymentBasicInfo.infraId, deploymentBasicInfo.id);
        }
        if (deploymentBasicInfo.deploymentTag != null && StringUtils.isNotBlank((String)deploymentBasicInfo.deploymentTag.getLastAuthor()) && (pu = this.usersService.getPublicUser(deploymentBasicInfo.deploymentTag.getLastAuthor())) != null) {
            deploymentBasicInfo.deployedByDisplayName = pu.displayName;
        }
        return deploymentBasicInfo;
    }

    @Override
    List<AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo> getDeploymentBasicInfoList(List<AbstractAPIServiceDeployment> deployments) throws IOException {
        ArrayList<AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo> infos = new ArrayList<AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo>();
        for (AbstractAPIServiceDeployment deployment : deployments) {
            infos.add(this.getDeploymentBasicInfo(deployment));
        }
        return infos;
    }

    @Override
    public List<AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo> listBasicInfoUnsafe_Check(AuthCtx authCtx) throws IOException {
        List<AbstractAPIServiceDeployment> deployments = this.listDeploymentsUnsafe_Check(authCtx);
        return this.getDeploymentBasicInfoList(deployments);
    }

    @Override
    public List<AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo> listBasicInfoForInfraUnsafe_Check(String infraId, AuthCtx authCtx) throws IOException {
        List<AbstractAPIServiceDeployment> deployments = this.listDeploymentsForInfraUnsafe_Check(infraId, authCtx);
        return this.getDeploymentBasicInfoList(deployments);
    }

    @Override
    public List<AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo> listBasicInfoForItemUnsafe_Check(String publishedItemId, AuthCtx authCtx) throws IOException {
        List<AbstractAPIServiceDeployment> deployments = this.listDeploymentsForItemUnsafe_Check(publishedItemId, authCtx);
        return this.getDeploymentBasicInfoList(deployments);
    }

    private void checkGenerationsMappingCorrectlySet(GenerationsMapping gm) {
        if (gm == null) {
            throw ErrorContext.iae((String)"generations mapping is not set, edit the deployment settings");
        }
        if (gm.getEntries().isEmpty()) {
            throw ErrorContext.iae((String)"generations mapping is empty, edit the deployment settings");
        }
    }

    private void checkStaticDeploymentServiceIdConflict(AbstractAPIServiceDeployment deployment) throws IOException, CodedException {
        String thisOneDeployedService = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)deployment.deployedServiceId) ? deployment.publishedServiceId : deployment.deployedServiceId;
        HashSet<String> conflicting = new HashSet<String>();
        for (AbstractAPIServiceDeployment other : this.getDeploymentDAO().listUnsafe()) {
            String otherDeployedServiceId;
            if (other.id.equals(deployment.id) || !other.infraId.equals(deployment.infraId) || !thisOneDeployedService.equals(otherDeployedServiceId = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)other.deployedServiceId) ? other.publishedServiceId : other.deployedServiceId)) continue;
            conflicting.add(other.id);
        }
        if (!conflicting.isEmpty()) {
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_STATIC_CONFLICTING_SERVICE, "The following deployment(s) on the same infrastructure are deployed with the same service identifier (" + thisOneDeployedService + "): " + org.apache.commons.lang3.StringUtils.join(conflicting, (String)",") + ". Deployment cannot continue as this would lead to URL conflicts. Select a 'deployed service identifier' for this deployment or any of the above-mentioned deployments");
        }
    }

    public AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus getDeploymentLightStatus_NT(AbstractAPIServiceDeployment deployment, AbstractInfraBasicInfo infraBasicInfo, AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo serviceBasicInfo, List<PublishedPackageInfo> packageInfoList, boolean hasFullDeployPermissions, boolean isInfraAdmin) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            boolean neverEverDeployed = !this.isDeployed(deployment);
            AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus lightStatus = new AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus(this.getDeploymentBasicInfo(deployment), infraBasicInfo, packageInfoList, neverEverDeployed, serviceBasicInfo, hasFullDeployPermissions, isInfraAdmin);
            PublishedApiServicePackageInfo packageInfo = !lightStatus.packages.isEmpty() ? (PublishedApiServicePackageInfo)lightStatus.packages.get(lightStatus.packages.size() - 1) : null;
            switch (deployment.auth.authMode) {
                case PUBLIC: {
                    lightStatus.authMethod = LambdaAuthMethod.PUBLIC;
                    break;
                }
                case API_KEYS: {
                    for (APIKeyBase aPIKeyBase : deployment.auth.apiKeys) {
                        AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus.APIKeyBasicInfo akbi = new AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus.APIKeyBasicInfo();
                        akbi.key = this.passwordEncryptionService.decryptIfEncrypted(aPIKeyBase.key);
                        akbi.label = aPIKeyBase.label;
                        lightStatus.apiKeys.add(akbi);
                    }
                    lightStatus.authMethod = LambdaAuthMethod.API_KEYS;
                    break;
                }
                case OAUTH2: {
                    lightStatus.oauth2Config = deployment.auth.oauth2Config;
                    lightStatus.authMethod = LambdaAuthMethod.OAUTH2;
                    break;
                }
                case INHERIT_DEV: {
                    if (packageInfo != null) {
                        lightStatus.authMethod = packageInfo.authMethod;
                        lightStatus.apiKeys = packageInfo.apiKeys;
                        lightStatus.oauth2Config = packageInfo.oauth2Config;
                        break;
                    }
                    lightStatus.authMethod = LambdaAuthMethod.PUBLIC;
                }
            }
            lightStatus.authorizationInherited = new AbstractDeploymentLightStatus.APIServiceDeploymentLightStatusInherited();
            if (packageInfo != null) {
                lightStatus.authorizationInherited.authMethod = packageInfo.authMethod;
                lightStatus.authorizationInherited.apiKeys = packageInfo.apiKeys;
                lightStatus.authorizationInherited.oauth2Config = packageInfo.oauth2Config;
            }
            AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus aPIServiceDeploymentLightStatus = lightStatus;
            return aPIServiceDeploymentLightStatus;
        }
    }

    @Nullable
    public String getDeploymentOpenAPIDocContentOrNull_Check_NT(AuthCtx authCtx, String deploymentId) throws UnauthorizedException, IOException {
        AbstractAPIServiceDeployment deployment;
        try (Transaction t = this.transactionService.beginRead();){
            deployment = (AbstractAPIServiceDeployment)this.getSettingsMandatoryUnsafe_Check(deploymentId, authCtx);
        }
        String version = deployment.getOpenAPISettingsGenerationIfIsUsedOrNull();
        if (version == null) {
            return null;
        }
        PublishedApiServicePackageInfo publishedPackageInfo = this.getPublishedItemsService().getPublishedPackageOrNull_Check_NT(deployment.getPublishedItemId(), version, authCtx);
        if (publishedPackageInfo != null && publishedPackageInfo.openAPIDocContent != null) {
            return publishedPackageInfo.openAPIDocContent;
        }
        return null;
    }

    @Override
    public APIServiceDeploymentHeavyStatus getHeavyStatus_Unsafe_NT_Check(AuthCtx dssAuthCtx, String deploymentId) throws Exception {
        return this.getHeavyStatus_Unsafe_NT_Check(dssAuthCtx, deploymentId, true);
    }

    public APIServiceDeploymentHeavyStatus getHeavyStatus_Unsafe_NT_Check(AuthCtx authCtx, String deploymentId, boolean withPackageExtraInfo) throws Exception {
        return this.getHeavyStatus_Unsafe_NT_Check(authCtx, authCtx, deploymentId, withPackageExtraInfo, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout(), null, true);
    }

    public APIServiceDeploymentHeavyStatus getHeavyStatusUnsafe_NT(AuthCtx dssAuthCtx, AuthCtx cnxAuthCtx, String deploymentId, boolean withPackageExtraInfo) throws Exception {
        return this.getHeavyStatus_Unsafe_NT_Check(dssAuthCtx, cnxAuthCtx, deploymentId, withPackageExtraInfo, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout(), null, false);
    }

    public APIServiceDeploymentHeavyStatus getHeavyStatus_Unsafe_NT_Check(AuthCtx dssAuthCtx, AuthCtx cnxAuthCtx, String deploymentId, boolean withPackageExtraInfo, int connectTimeout, int socketTimeout, @Nullable String overridingConnectionName, boolean checkReadPermissions) throws Exception {
        AbstractAPIDeploymentInfra infra;
        AbstractAPIServiceDeployment deployment;
        try (Transaction t = this.transactionService.beginRead();){
            deployment = (AbstractAPIServiceDeployment)this.deploymentsDAO.getMandatoryUnsafe(deploymentId);
            infra = (AbstractAPIDeploymentInfra)this.getInfrasDAO().getMandatory(deployment.infraId);
            PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(deployment.getPublishedItemId());
            if (checkReadPermissions) {
                this.checkReadPermissions(infra, item, dssAuthCtx);
            }
        }
        AbstractAPIServiceDeploymentManager manager = AbstractAPIServiceDeploymentManager.getManagerForInfraAndDeployment(cnxAuthCtx, infra, deployment, connectTimeout, socketTimeout);
        return manager.getStatus_Unsafe_NT(withPackageExtraInfo, overridingConnectionName);
    }

    private List<APIServiceDeploymentHeavyStatus> listAzureMLInfraHeavyStatus_NT(AuthCtx authCtx, AzureMLAPIDeploymentInfra infra, List<AzureMLAPIDeployment> deployments, boolean withPackageExtraInfo) throws IOException, AzureMLUtils.AzureAuthenticationException, DKUSecurityException {
        ArrayList<APIServiceDeploymentHeavyStatus> ret = new ArrayList<APIServiceDeploymentHeavyStatus>();
        Map<Object, Object> onlineEndpoints = new HashMap();
        try (AzureMLHttpClient azureMLClient = AzureMLUtils.getAzureMLClient_NT(authCtx, infra.authConnection, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());){
            onlineEndpoints = azureMLClient.listOnlineEndpoints_NT(infra.azWorkspace, infra.azResourceGroup, infra.azSubscription).stream().collect(Collectors.toMap(e -> e.name, Function.identity()));
        }
        catch (AzureMLUtils.AzureAuthenticationException e2) {
            this.getLogger().error((Object)e2);
            throw e2;
        }
        catch (Exception e3) {
            this.getLogger().error((Object)"Unable to retrieve deployment status.", (Throwable)e3);
            throw e3;
        }
        for (AzureMLAPIDeployment deployment : deployments) {
            AzureMLDeploymentHeavyStatus deploymentHeavyStatus = new AzureMLDeploymentHeavyStatus(deployment.id, deployment.infraId);
            deploymentHeavyStatus.packages = this.publishedAPIServicesService.listPublishedPackages_Check_Unsafe_NT(deployment.publishedServiceId, authCtx);
            deploymentHeavyStatus.endpoints = deploymentHeavyStatus.summarizeEndpoints_NT(deployment, withPackageExtraInfo);
            AzureMLDeploymentInfo lastDeploymentInfo = (AzureMLDeploymentInfo)ObjectUtils.defaultIfNull((Object)this.deploymentInfoCRUDService.get(infra.id, deployment.id, AzureMLDeploymentInfo.class), (Object)new AzureMLDeploymentInfo(infra, deployment.id));
            String endpointName = lastDeploymentInfo.azOnlineEndpointName;
            AzureMLDeploymentManager deploymentManager = new AzureMLDeploymentManager(authCtx, deployment, infra, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
            AzureMLDeploymentSummary storedSummary = AzureMLDeploymentSummary.AzureMLDeploymentSummaryBuilder.buildFromLocalConfig(deployment, infra, deploymentManager.getVariablesContext(), lastDeploymentInfo);
            deploymentHeavyStatus.checkEndpointHealth(storedSummary, (AzureMLOnlineEndpoint)onlineEndpoints.get(endpointName), deployment.enabled);
            ret.add(deploymentHeavyStatus);
        }
        return ret;
    }

    private List<APIServiceDeploymentHeavyStatus> listSageMakerInfraHeavyStatus_NT(AuthCtx authCtx, SageMakerAPIDeploymentInfra infra, List<SageMakerAPIDeployment> deployments, boolean withPackageExtraInfo) throws CodedException, IOException, DKUSecurityException {
        Map endpointSummaries;
        SageMakerClient sageMakerClient;
        ArrayList<APIServiceDeploymentHeavyStatus> ret = new ArrayList<APIServiceDeploymentHeavyStatus>();
        try {
            sageMakerClient = SageMakerUtils.checkAndLoginSageMaker_NT(authCtx, infra.authConnection, infra.awsRegion, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        }
        catch (SdkException e) {
            this.getLogger().error((Object)"Error while trying to login into AWS.", (Throwable)e);
            throw e;
        }
        try {
            endpointSummaries = SageMakerUtils.retrieveEndpointList_NT(sageMakerClient, null, true).stream().collect(Collectors.toMap(EndpointSummary::endpointName, Function.identity()));
        }
        catch (SdkException e) {
            this.getLogger().error((Object)("Unable to retrieve deployment status for infra" + infra.id), (Throwable)e);
            throw e;
        }
        for (SageMakerAPIDeployment deployment : deployments) {
            SageMakerDeploymentHeavyStatus deploymentHeavyStatus = new SageMakerDeploymentHeavyStatus(deployment.id, deployment.infraId);
            deploymentHeavyStatus.packages = this.publishedAPIServicesService.listPublishedPackages_Check_Unsafe_NT(deployment.publishedServiceId, authCtx);
            deploymentHeavyStatus.endpoints = deploymentHeavyStatus.summarizeEndpoints_NT(deployment, withPackageExtraInfo);
            SageMakerDeploymentInfo lastDeploymentInfo = this.deploymentInfoCRUDService.get(infra.id, deployment.id, SageMakerDeploymentInfo.class);
            String endpointName = !Objects.isNull(lastDeploymentInfo) ? lastDeploymentInfo.sageMakerEndpointName : "";
            deploymentHeavyStatus.checkEndpointHealth((EndpointSummary)endpointSummaries.get(endpointName), lastDeploymentInfo, deployment.enabled);
            ret.add(deploymentHeavyStatus);
        }
        return ret;
    }

    private List<APIServiceDeploymentHeavyStatus> listVertexAIInfraHeavyStatus_NT(AuthCtx authCtx, VertexAIAPIDeploymentInfra infra, List<VertexAIAPIDeployment> deployments, boolean withPackageExtraInfo) throws IOException, DKUSecurityException, URISyntaxException {
        GoogleCredentials credentials;
        ArrayList<APIServiceDeploymentHeavyStatus> ret = new ArrayList<APIServiceDeploymentHeavyStatus>();
        VertexAIModelDeploymentConnection connection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, infra.authConnection);
        HashMap endpoints = new HashMap();
        try {
            credentials = VertexAIUtils.getGoogleCredentials_NT(authCtx, connection);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error while trying to get Google credentials.", (Throwable)e);
            throw e;
        }
        try {
            VertexAIUtils.from(infra.gcpRegion, infra.gcpProjectId, credentials, connection).listEndpoints_NT(null).forEach(endpoint -> endpoints.put(VertexAIUtils.extractEndpointId(endpoint.getName()), endpoint));
        }
        catch (Exception e) {
            this.getLogger().error((Object)("Unable to retrieve deployment status for infra" + infra.id), (Throwable)e);
            throw e;
        }
        for (VertexAIAPIDeployment deployment : deployments) {
            VertexAIDeploymentHeavyStatus deploymentHeavyStatus = new VertexAIDeploymentHeavyStatus(deployment.id, deployment.infraId);
            deploymentHeavyStatus.packages = this.publishedAPIServicesService.listPublishedPackages_Check_Unsafe_NT(deployment.publishedServiceId, authCtx);
            deploymentHeavyStatus.endpoints = deploymentHeavyStatus.summarizeEndpoints_NT(deployment, withPackageExtraInfo);
            VertexAIDeploymentInfo lastDeploymentInfo = (VertexAIDeploymentInfo)ObjectUtils.defaultIfNull((Object)this.deploymentInfoCRUDService.get(infra.id, deployment.id, VertexAIDeploymentInfo.class), (Object)new VertexAIDeploymentInfo(infra, deployment));
            String endpointId = lastDeploymentInfo.vertexAIEndpointId;
            VertexAIDeploymentManager deploymentManager = new VertexAIDeploymentManager(authCtx, deployment, infra, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
            VertexAIDeploymentLocalSummary localSummary = VertexAIDeploymentLocalSummary.buildFromLocalConfig(deployment, infra, deploymentManager.getVariablesContext(), lastDeploymentInfo);
            deploymentHeavyStatus.checkEndpointHealth(localSummary, (Endpoint)endpoints.get(endpointId), deployment.enabled);
            ret.add(deploymentHeavyStatus);
        }
        return ret;
    }

    private List<APIServiceDeploymentHeavyStatus> listDatabricksInfraHeavyStatus_NT(AuthCtx authCtx, DatabricksAPIDeploymentInfra infra, List<DatabricksAPIDeployment> deployments, boolean withPackageExtraInfo) throws InvalidConfigurationException, IOException, URISyntaxException, DKUSecurityException {
        TransactionContext.assertNoAttachedTransaction();
        ArrayList<APIServiceDeploymentHeavyStatus> ret = new ArrayList<APIServiceDeploymentHeavyStatus>();
        DatabricksModelDeploymentConnection connection = (DatabricksModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, infra.authConnection);
        HashMap endpoints = new HashMap();
        try {
            if (connection == null) {
                throw new InvalidConfigurationException("no connection defined in infra " + infra.id);
            }
            DatabricksUtils.listEndpoints(authCtx, connection.name, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout()).forEach(endpoint -> endpoints.put(endpoint.name, endpoint));
        }
        catch (Exception e) {
            this.getLogger().error((Object)("Unable to retrieve deployment status for infra" + infra.id), (Throwable)e);
            throw e;
        }
        for (DatabricksAPIDeployment deployment : deployments) {
            DatabricksDeploymentHeavyStatus deploymentHeavyStatus = new DatabricksDeploymentHeavyStatus(deployment.id, deployment.infraId);
            deploymentHeavyStatus.packages = this.publishedAPIServicesService.listPublishedPackages_Check_Unsafe_NT(deployment.publishedServiceId, authCtx);
            deploymentHeavyStatus.endpoints = deploymentHeavyStatus.summarizeEndpoints_NT(deployment, withPackageExtraInfo);
            DatabricksDeploymentInfo lastDeploymentInfo = this.deploymentInfoCRUDService.get(infra.id, deployment.id, DatabricksDeploymentInfo.class);
            String endpointName = !Objects.isNull(lastDeploymentInfo = (DatabricksDeploymentInfo)ObjectUtils.defaultIfNull((Object)lastDeploymentInfo, (Object)new DatabricksDeploymentInfo(infra, deployment))) ? lastDeploymentInfo.dbxEndpointName : "";
            DatabricksDeploymentManager deploymentManager = new DatabricksDeploymentManager(authCtx, deployment, infra, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
            DatabricksDeploymentLocalSummary localSummary = DatabricksDeploymentLocalSummary.buildFromLocalConfig(deployment, infra, deploymentManager.getVariablesContext(), lastDeploymentInfo);
            deploymentHeavyStatus.checkEndpointHealth(localSummary, (DatabricksServingEndpointBase)endpoints.get(endpointName), deployment.enabled);
            ret.add(deploymentHeavyStatus);
        }
        return ret;
    }

    private List<APIServiceDeploymentHeavyStatus> listHeavyStatus_NT(AuthCtx authCtx, AbstractDeploymentInfra infra, List<AbstractAPIServiceDeployment> deployments, boolean withPackageExtraInfo) throws CodedException, IOException, DKUSecurityException, URISyntaxException, AzureMLUtils.AzureAuthenticationException, InvalidConfigurationException {
        if (infra instanceof AzureMLAPIDeploymentInfra) {
            List<AzureMLAPIDeployment> azureMLAPIDeployments = this.filterDeployments(deployments, AzureMLAPIDeployment.class);
            return this.listAzureMLInfraHeavyStatus_NT(authCtx, (AzureMLAPIDeploymentInfra)infra, azureMLAPIDeployments, withPackageExtraInfo);
        }
        if (infra instanceof SageMakerAPIDeploymentInfra) {
            List<SageMakerAPIDeployment> sageMakerAPIDeployments = this.filterDeployments(deployments, SageMakerAPIDeployment.class);
            return this.listSageMakerInfraHeavyStatus_NT(authCtx, (SageMakerAPIDeploymentInfra)infra, sageMakerAPIDeployments, withPackageExtraInfo);
        }
        if (infra instanceof VertexAIAPIDeploymentInfra) {
            List<VertexAIAPIDeployment> vertexAIAPIDeployments = this.filterDeployments(deployments, VertexAIAPIDeployment.class);
            return this.listVertexAIInfraHeavyStatus_NT(authCtx, (VertexAIAPIDeploymentInfra)infra, vertexAIAPIDeployments, withPackageExtraInfo);
        }
        if (infra instanceof DatabricksAPIDeploymentInfra) {
            List<DatabricksAPIDeployment> databricksAPIDeployments = this.filterDeployments(deployments, DatabricksAPIDeployment.class);
            return this.listDatabricksInfraHeavyStatus_NT(authCtx, (DatabricksAPIDeploymentInfra)infra, databricksAPIDeployments, withPackageExtraInfo);
        }
        throw new IllegalArgumentException("Invalid infra type: " + JSON.getType((Object)infra));
    }

    public List<APIServiceDeploymentHeavyStatus> listHeavyStatusUnsafe_NT_Check(AuthCtx authCtx, String infraId, boolean withPackageExtraInfo) throws Exception {
        List<AbstractAPIServiceDeployment> infraDeployments;
        AbstractDeploymentInfra infra;
        try (Transaction t = this.transactionService.beginRead();){
            infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatory(infraId);
            infraDeployments = this.listDeploymentsForInfraUnsafe_Check(infraId, authCtx);
        }
        return this.listHeavyStatus_NT(authCtx, infra, infraDeployments, withPackageExtraInfo);
    }

    public DeploymentStatusReport getFullCheckReport_NT_Check(AuthCtx authCtx, String deploymentId) throws Exception {
        AbstractAPIDeploymentInfra infra;
        AbstractAPIServiceDeployment deployment;
        try (Transaction t = this.transactionService.beginRead();){
            deployment = (AbstractAPIServiceDeployment)this.deploymentsDAO.getMandatoryUnsafe(deploymentId);
            infra = (AbstractAPIDeploymentInfra)this.getInfrasDAO().getMandatory(deployment.infraId);
            PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(deployment.getPublishedItemId());
            this.checkReadPermissions(infra, item, authCtx);
        }
        if (deployment instanceof AbstractFullyManagedAPIDeployment) {
            AbstractFullyManagedAPIServiceDeploymentManager manager = (AbstractFullyManagedAPIServiceDeploymentManager)AbstractAPIServiceDeploymentManager.getManagerForInfraAndDeployment(authCtx, infra, deployment, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
            return manager.getFullCheckReport_NT();
        }
        throw new IllegalArgumentException("Out of sync report cannot be performed for the infra type: " + JSON.getType((Object)infra));
    }

    @Nullable
    public String getStorageUrl_NT_Check(@Nonnull AuthCtx authCtx, @Nonnull String infraId) throws Exception {
        AbstractAPIDeploymentInfra infra;
        try (Transaction t = this.transactionService.beginRead();){
            infra = (AbstractAPIDeploymentInfra)this.getInfrasDAO().getMandatory(infraId);
            if (!AbstractInfrasService.hasReadPermission(infra, authCtx)) {
                throw new UnauthorizedException("Permission denied: unable to view infrastructure", "infra-read-denied");
            }
        }
        AbstractAPIDeploymentInfra.APINodeLogging.FsLikeSettings fsLikeSettings = infra.getNodeLogging().fsLikeSettings;
        return this.getStorageUrl_NT_Check(infra, fsLikeSettings.connectionName, fsLikeSettings.pathWithinConnection, fsLikeSettings.bucket);
    }

    @Nullable
    public String getStorageUrl_NT_Check(@Nonnull AuthCtx authCtx, @Nonnull String infraId, @Nullable String connectionName, @Nullable String pathWithinConnection, @Nullable String bucket) throws Exception {
        AbstractAPIDeploymentInfra infra;
        try (Transaction t = this.transactionService.beginRead();){
            infra = (AbstractAPIDeploymentInfra)this.getInfrasDAO().getMandatory(infraId);
            if (!AbstractInfrasService.hasReadPermission(infra, authCtx)) {
                throw new UnauthorizedException("Permission denied: unable to view infrastructure", "infra-read-denied");
            }
        }
        return this.getStorageUrl_NT_Check(infra, connectionName, pathWithinConnection, bucket);
    }

    @Nullable
    private String getStorageUrl_NT_Check(@Nonnull AbstractAPIDeploymentInfra infra, @Nullable String connectionName, @Nullable String pathWithinConnection, @Nullable String bucket) {
        if (infra instanceof AbstractAPIDockerDeploymentInfra) {
            Map<String, DSSConnection> remappedConnections = ((AbstractAPIDockerDeploymentInfra)infra).remappedConnections;
            return AbstractAPIServiceDeploymentManager.computeUrlForStorageInfo(remappedConnections, connectionName, pathWithinConnection, bucket);
        }
        if (infra instanceof StaticAPIDeploymentInfra) {
            return null;
        }
        throw new IllegalArgumentException("Audit log to fs-like info cannot be performed for the infra type: " + JSON.getType((Object)infra));
    }

    public FutureResponse<SingleStaticDeploymentManager.PrepareAndSyncReport> executeSyncStatic_NT_Check(@Nonnull AuthCtx authCtx, String deploymentId, boolean forceRefresh, boolean withPrepare) throws Exception {
        AbstractInfraBasicInfo infraBasicInfo;
        StaticAPIDeploymentInfra infra;
        StaticDeployment deployment;
        try (Transaction t = this.transactionService.beginRead();){
            deployment = (StaticDeployment)this.deploymentsDAO.getMandatoryUnsafe(deploymentId);
            PublishedItem svc = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(deployment.publishedServiceId);
            infra = (StaticAPIDeploymentInfra)this.getInfrasDAO().getMandatory(deployment.infraId);
            infraBasicInfo = this.infrasService.getLightStatusUnsafe_Check((String)deployment.infraId, (AuthCtx)authCtx).infraBasicInfo;
            this.checkDeployPermissions(infra, svc, authCtx);
            this.checkStaticDeploymentServiceIdConflict(deployment);
        }
        GenerationsMapping gm = deployment.generationsMapping;
        this.checkGenerationsMappingCorrectlySet(gm);
        this.doGovernanceCheck_NT(infraBasicInfo, deployment);
        SingleStaticDeploymentManager ssdm = new SingleStaticDeploymentManager(authCtx, deployment, infra, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        ssdm.forceRefresh = forceRefresh;
        ssdm.withPrepare = withPrepare;
        return ssdm.startUpdateDeployment_NT();
    }

    public FutureResponse<AbstractAPIServiceDockerDeploymentManager.DockerBasedDeploymentReport> executeSyncDockerBased_NT_Check(@Nonnull AuthCtx authCtx, String deploymentId, boolean rebuildCodeEnv) throws Exception {
        AbstractInfraBasicInfo infraBasicInfo;
        AbstractAPIDeploymentInfra infra;
        AbstractAPIServiceDeployment deployment;
        try (Transaction t = this.transactionService.beginRead();){
            deployment = (AbstractAPIServiceDeployment)this.deploymentsDAO.getMandatoryUnsafe(deploymentId);
            PublishedItem svc = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(deployment.getPublishedItemId());
            infra = (AbstractAPIDeploymentInfra)this.getInfrasDAO().getMandatory(deployment.infraId);
            infraBasicInfo = this.infrasService.getLightStatusUnsafe_Check((String)deployment.infraId, (AuthCtx)authCtx).infraBasicInfo;
            this.checkDeployPermissions(infra, svc, authCtx);
        }
        this.doGovernanceCheck_NT(infraBasicInfo, deployment);
        AbstractAPIServiceDockerDeploymentManager manager = (AbstractAPIServiceDockerDeploymentManager)AbstractAPIServiceDeploymentManager.getManagerForInfraAndDeployment(authCtx, infra, deployment, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        manager.setRebuildCodeEnv(rebuildCodeEnv);
        return manager.startUpdateDeployment_NT();
    }

    public FutureResponse<? extends DeploymentReport> executeOneStepSync_NT_Check(@Nonnull AuthCtx authCtx, String deploymentId, boolean isFullUpdate) throws Exception {
        return this.executeOneStepSync_NT_Check(authCtx, deploymentId, isFullUpdate ? SingleStaticDeploymentManager.StaticDeploymentUpdateMode.FULL : SingleStaticDeploymentManager.StaticDeploymentUpdateMode.LIGHT, false);
    }

    @Override
    protected DSSItemGovernanceStatusList getGovernanceStatus_NT(List<AbstractPublishedPackageInfoForGovernIdentification> publishedPackages) throws IOException, CodedException {
        DSSItemIdentifierList dssItemIdentifierList = new DSSItemIdentifierList();
        for (AbstractPublishedPackageInfoForGovernIdentification publishedPackage : publishedPackages) {
            if (!(publishedPackage instanceof PublishedApiServicePackageInfoForGovernIdentification)) {
                throw new AssertionError((Object)("Error: trying to publish something else than a " + PublishedApiServicePackageInfoForGovernIdentification.class.getName() + " with " + this.getClass().getName()));
            }
            PublishedApiServicePackageInfoForGovernIdentification publishedApiPackage = (PublishedApiServicePackageInfoForGovernIdentification)publishedPackage;
            dssItemIdentifierList.dssItemItentifiers.addAll(GovernIntegrationService.buildDSSSavedModelVersionIdentifierList(publishedApiPackage));
        }
        if (dssItemIdentifierList.dssItemItentifiers.isEmpty()) {
            return new DSSItemGovernanceStatusList();
        }
        return this.governIntegrationService.getDSSItemsGovernanceStatus(dssItemIdentifierList);
    }

    public void doGovernanceCheck_NT(AbstractInfraBasicInfo infraBasicInfo, AbstractAPIServiceDeployment deployment) throws IOException, CodedException {
        ArrayList<String> versionIds = new ArrayList<String>();
        if (deployment.generationsMapping == null) {
            throw ErrorContext.iae((String)"The deployment does not contain any version.");
        }
        for (GenerationsMapping.MappingEntry mappingEntry : deployment.generationsMapping.getEntries()) {
            versionIds.add(mappingEntry.generation);
        }
        this.doGovernanceCheck_NT(infraBasicInfo, deployment.getPublishedItemId(), versionIds);
    }

    public FutureResponse<? extends AbstractAPIServiceDeploymentManager.APIDeploymentReport> executeOneStepSync_NT_Check(@Nonnull AuthCtx authCtx, String deploymentId, SingleStaticDeploymentManager.StaticDeploymentUpdateMode updateMode, boolean rebuildCodeEnv) throws Exception {
        AbstractInfraBasicInfo infraBasicInfo;
        AbstractAPIDeploymentInfra infra;
        AbstractAPIServiceDeployment deployment;
        try (Transaction t = this.transactionService.beginRead();){
            deployment = (AbstractAPIServiceDeployment)this.deploymentsDAO.getMandatoryUnsafe(deploymentId);
            PublishedItem svc = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(deployment.publishedServiceId);
            if (!AbstractPublishedItemsService.hasDeployPermission(svc, authCtx)) {
                throw new UnauthorizedException("Permission denied: unable to deploy this published API service", "deployment-action-denied");
            }
            infra = (AbstractAPIDeploymentInfra)this.getInfrasDAO().getMandatory(deployment.infraId);
            if (!AbstractInfrasService.hasDeployPermission(infra, authCtx)) {
                throw new UnauthorizedException("Permission denied: unable to deploy on this infrastructure", "deployment-action-denied");
            }
            infraBasicInfo = this.infrasService.getLightStatusUnsafe_Check((String)deployment.infraId, (AuthCtx)authCtx).infraBasicInfo;
        }
        this.doGovernanceCheck_NT(infraBasicInfo, deployment);
        AbstractAPIServiceDeploymentManager deploymentManager = AbstractAPIServiceDeploymentManager.getManagerForInfraAndDeployment(authCtx, infra, deployment, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        if (deploymentManager instanceof SingleStaticDeploymentManager) {
            try (Transaction t = this.transactionService.beginRead();){
                this.checkStaticDeploymentServiceIdConflict(deployment);
            }
            SingleStaticDeploymentManager ssdm = (SingleStaticDeploymentManager)deploymentManager;
            ssdm.forceRefresh = updateMode == SingleStaticDeploymentManager.StaticDeploymentUpdateMode.FULL;
            return ssdm.startUpdateDeployment_NT();
        }
        AbstractAPIServiceDockerDeploymentManager manager = (AbstractAPIServiceDockerDeploymentManager)deploymentManager;
        manager.setRebuildCodeEnv(rebuildCodeEnv);
        return manager.startUpdateDeployment_NT();
    }

    public BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT_Check(String deploymentId, String endpointId, AuthCtx authCtx, List<ApiEndpointQuery> queries, Map<String, ApiEndpointQuery> additionalQueries, boolean forTest, boolean adaptQueryForInfraType) throws Exception {
        AbstractAPIDeploymentInfra infra;
        PublishedItem service;
        AbstractAPIServiceDeployment deployment;
        try (Transaction t = this.transactionService.beginRead();){
            deployment = (AbstractAPIServiceDeployment)this.deploymentsDAO.getMandatoryUnsafe(deploymentId);
            service = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(deployment.publishedServiceId);
            infra = (AbstractAPIDeploymentInfra)this.getInfrasDAO().getMandatory(deployment.infraId);
            if (forTest) {
                if (!AbstractPublishedItemsService.hasReadPermission(service, authCtx)) {
                    throw new UnauthorizedException("Permission denied: unable to access the published API service '%s'".formatted(service.id), "mad-deployment-action-denied");
                }
                if (!AbstractInfrasService.hasReadPermission(infra, authCtx)) {
                    throw new UnauthorizedException("Permission denied: unable to access the infrastructure '%s'".formatted(infra.id), "mad-deployment-action-denied");
                }
            } else if (!deployment.canQueryThroughDeployer(authCtx)) {
                throw new UnauthorizedException("Authorization denied: user can not query deployment '%s' through the deployer".formatted(deploymentId), "mad-deployment-action-denied");
            }
        }
        AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo infraBasicInfo = this.infrasService.basicInfoUnsafe(infra);
        AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo publishedAPIServiceBasicInfo = this.getPublishedItemsService().basicInfoUnsafe(service);
        List<PublishedPackageInfo> publishedPackageInfoList = this.getPublishedItemsService().listPublishedPackages_Check_Unsafe_NT(deployment.getPublishedItemId(), authCtx);
        AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus lightStatus = this.getDeploymentLightStatus_NT(deployment, (AbstractInfraBasicInfo)infraBasicInfo, publishedAPIServiceBasicInfo, publishedPackageInfoList, AbstractDeploymentsService.hasFullDeployPermissions(infra, service, authCtx), AbstractInfrasService.hasAdminPermission(infra, authCtx));
        String deployedServiceId = lightStatus.deploymentBasicInfo.getDeployedItemId();
        APIServiceDeploymentHeavyStatus heavyStatus = this.getHeavyStatusUnsafe_NT(authCtx, authCtx, deploymentId, true);
        APIServiceDeploymentHeavyStatus.EndpointSummary endpoint = heavyStatus.endpoints.stream().filter(e -> e.id.equals(endpointId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Endpoint " + endpointId + " not found in deployment " + deploymentId));
        if (adaptQueryForInfraType) {
            queries = queries.stream().map(q -> heavyStatus.adaptQueryForInfraType((ApiEndpointQuery)q, endpoint.type)).collect(Collectors.toList());
        }
        AbstractAPIServiceDeploymentManager manager = AbstractAPIServiceDeploymentManager.getManagerForInfraAndDeployment(authCtx, infra, deployment, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        return manager.runQueries_NT(deployedServiceId, endpointId, lightStatus, heavyStatus, queries, additionalQueries, forTest);
    }

    @Override
    boolean isDeployed(AbstractAPIServiceDeployment deployment) throws IOException {
        if (deployment instanceof AbstractFullyManagedAPIDeployment) {
            return Objects.nonNull(this.deploymentInfoCRUDService.get(deployment.infraId, deployment.id));
        }
        return !this.getNeverEverDeployedSet().contains(deployment.id);
    }

    @Override
    void additionalSaveSteps(AbstractAPIServiceDeployment oldDeployment, AbstractAPIServiceDeployment newDeployment) {
        newDeployment.createOrUpdateOpenAPISettingsGenerationIfNeeded();
        if (newDeployment.auth.apiKeys != null) {
            newDeployment.auth.encryptKeysIfNotEncrypted(this.passwordEncryptionService);
        }
    }

    @Override
    protected String getPublishedItemType() {
        return "model version";
    }

    private AbstractAPIDeploymentInfra prepareCreation_Check(AuthCtx authCtx, String deploymentId, String publishedServiceId, String infraId) throws IOException, UnauthorizedException, LicenseRestrictionException {
        Integer maxApiDeploymentsAllowed = this.licenseEnforcementService.getFeaturesStatus().deployerMaxAPIDeployments;
        if (maxApiDeploymentsAllowed != null && maxApiDeploymentsAllowed >= 0 && this.deploymentsDAO.listUnsafe().size() >= maxApiDeploymentsAllowed) {
            throw new LicenseRestrictionException(String.format("Your license is limited to %d API deployment(s)", maxApiDeploymentsAllowed));
        }
        this.checkIdValidity(deploymentId, publishedServiceId, infraId);
        PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(publishedServiceId);
        AbstractAPIDeploymentInfra infra = (AbstractAPIDeploymentInfra)this.getInfrasDAO().getMandatoryUnsafe(infraId);
        this.checkDeployPermissions(infra, item, authCtx);
        return infra;
    }

    @Override
    public void preDeleteActions_NT(AuthCtx authCtx, AbstractAPIDeploymentInfra infra, AbstractAPIServiceDeployment deployment) throws CodedException, IOException, SQLException, InterruptedException {
        if (deployment instanceof AbstractFullyManagedAPIDeployment) {
            AbstractFullyManagedAPIServiceDeploymentManager manager = (AbstractFullyManagedAPIServiceDeploymentManager)AbstractAPIServiceDeploymentManager.getManagerForInfraAndDeployment(authCtx, infra, deployment, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
            manager.deleteResources_NT();
        }
    }

    public String copy_Check(AuthCtx authCtx, String oldDeploymentId, String newDeploymentId, String newInfraId, @Nullable String endpointId, @Nullable PublishedApiServicePackageInfo publishedPackageInfo) throws UnauthorizedException, IOException, LicenseRestrictionException {
        AbstractAPIServiceDeployment deployment;
        AbstractAPIServiceDeployment oldDeployment = (AbstractAPIServiceDeployment)this.getDeploymentDAO().getMandatoryUnsafe(oldDeploymentId);
        AbstractAPIDeploymentInfra infra = this.prepareCreation_Check(authCtx, newDeploymentId, oldDeployment.getPublishedItemId(), newInfraId);
        VersionTag creationTag = new VersionTag(authCtx.getIdentifier());
        if (infra instanceof StaticAPIDeploymentInfra) {
            deployment = new StaticDeployment(oldDeployment, newDeploymentId, newInfraId, true, creationTag);
        } else if (infra instanceof K8SAPIDeploymentInfra) {
            deployment = new K8SAPIServiceDeployment(oldDeployment, newDeploymentId, newInfraId, true, creationTag);
        } else if (infra instanceof AbstractFullyManagedAPIDeploymentInfra) {
            if (publishedPackageInfo == null) {
                throw ErrorContext.ice((String)"On this Deploy Anywhere infrastructure, you can only copy services with a single generation.");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)endpointId) && publishedPackageInfo.endpoints.size() == 1) {
                endpointId = publishedPackageInfo.endpoints.get((int)0).id;
            }
            AbstractFullyManagedAPIDeployment fullyManagedAPIDeployment = this.copyAbstractFullyManagedAPIDeployment(authCtx, oldDeployment, newDeploymentId, (AbstractFullyManagedAPIDeploymentInfra)infra, endpointId, creationTag);
            fullyManagedAPIDeployment.verifyPackageCompatibility(publishedPackageInfo);
            deployment = fullyManagedAPIDeployment;
        } else {
            throw new IllegalArgumentException("Invalid infra type: " + JSON.getType((Object)infra));
        }
        this.cleanPreexistingDeployment(deployment);
        this.finalizeCreation(deployment);
        this.publishDeploymentCopiedEventAfterTransaction(deployment.id);
        return deployment.id;
    }

    @Nonnull
    private AbstractFullyManagedAPIDeployment copyAbstractFullyManagedAPIDeployment(AuthCtx authCtx, AbstractAPIServiceDeployment oldDeployment, String newDeploymentId, AbstractFullyManagedAPIDeploymentInfra infra, @Nullable String endpointId, VersionTag creationTag) throws IOException {
        List<AbstractAPIServiceDeployment> deploymentsOfTheSameInfra = this.listDeploymentsForInfraUnsafe_Check(infra.id, authCtx);
        return AbstractFullyManagedAPIDeployment.copyDeployment(oldDeployment, infra, newDeploymentId, deploymentsOfTheSameInfra, endpointId, true, creationTag);
    }

    private <T extends AbstractAPIServiceDeployment> List<T> filterDeployments(List<AbstractAPIServiceDeployment> deployments, Class<T> clazz) {
        return deployments.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public String create_Check(AuthCtx authCtx, String deploymentId, String publishedServiceId, String infraId, String version, @Nullable String endpointId, @Nullable PublishedApiServicePackageInfo publishedPackageInfo, boolean shouldVerify, List<AbstractAPIServiceDeployment.AuthorizationItem> authorizationsToQueryThroughDeployer) throws UnauthorizedException, IOException, LicenseRestrictionException {
        AbstractAPIServiceDeployment deployment;
        AbstractAPIDeploymentInfra infra = this.prepareCreation_Check(authCtx, deploymentId, publishedServiceId, infraId);
        VersionTag creationTag = new VersionTag(authCtx.getIdentifier());
        if (infra instanceof StaticAPIDeploymentInfra) {
            deployment = new StaticDeployment(deploymentId, infra.id, publishedServiceId, version, true, creationTag, authorizationsToQueryThroughDeployer);
        } else if (infra instanceof K8SAPIDeploymentInfra) {
            deployment = new K8SAPIServiceDeployment(deploymentId, infra.id, publishedServiceId, version, true, creationTag, authorizationsToQueryThroughDeployer);
        } else if (infra instanceof AbstractFullyManagedAPIDeploymentInfra) {
            if (publishedPackageInfo == null) {
                throw new NotFoundException(String.format("No version named '%s' found in the service.", version));
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)endpointId) && publishedPackageInfo.endpoints.size() == 1) {
                endpointId = publishedPackageInfo.endpoints.get((int)0).id;
            }
            AbstractFullyManagedAPIDeployment fullyManagedAPIDeployment = APIServiceDeploymentsService.createAbstractFullyManagedAPIDeployment(deploymentId, (AbstractFullyManagedAPIDeploymentInfra)infra, publishedServiceId, version, endpointId, creationTag);
            if (shouldVerify) {
                fullyManagedAPIDeployment.verifyPackageCompatibility(publishedPackageInfo);
            }
            deployment = fullyManagedAPIDeployment;
        } else {
            throw new IllegalArgumentException("Invalid infra type: " + JSON.getType((Object)infra));
        }
        deployment.createOrUpdateOpenAPISettingsGenerationIfNeeded();
        this.cleanPreexistingDeployment(deployment);
        this.finalizeCreation(deployment);
        this.pubSub.publishAfterTransaction((DSSEvent)new APIDeployerDeploymentCreatedEvent(deployment.id));
        return deployment.id;
    }

    @Nonnull
    private static AbstractFullyManagedAPIDeployment createAbstractFullyManagedAPIDeployment(String deploymentId, AbstractFullyManagedAPIDeploymentInfra infra, String publishedServiceId, String version, String endpointId, VersionTag creationTag) {
        return AbstractFullyManagedAPIDeployment.createDeployment(deploymentId, infra, publishedServiceId, version, endpointId, true, creationTag);
    }

    private void cleanPreexistingDeployment(AbstractAPIServiceDeployment deployment) {
        try {
            if (this.getDeploymentDAO().exists(deployment.id)) {
                this.getLogger().debug((Object)("Deleting pre-existing configuration for API deployment " + deployment.id));
                this.getDeploymentDAO().delete(deployment.id);
            } else {
                this.getLogger().debug((Object)("No pre-existing configuration for API deployment " + deployment.id));
            }
        }
        catch (Exception e) {
            this.getLogger().debug((Object)("Error deleting pre-existing API deployment " + deployment.id), (Throwable)e);
        }
        if (deployment instanceof AbstractFullyManagedAPIDeployment) {
            try {
                if (this.deploymentInfoCRUDService.exists(deployment.infraId, deployment.id)) {
                    this.getLogger().debug((Object)("Deleting pre-existing info on API deployment " + deployment.id));
                    this.deploymentInfoCRUDService.delete(deployment.infraId, deployment.id);
                }
            }
            catch (Exception e) {
                this.getLogger().debug((Object)("Error deleting info on API deployment " + deployment.id), (Throwable)e);
            }
        }
    }

    public void streamChartData_NT_Check(HttpServletResponse resp, AuthCtx authCtx, String deploymentId, @Nullable String endpointId, CarbonAPITimeRange timeRange, CarbonAPIChartType chartType, String format) throws UnsupportedOperationException, IOException, UnauthorizedException, URISyntaxException {
        String actualDeployedItem;
        AbstractDeploymentInfra infra;
        AbstractAPIServiceDeployment deployment;
        try (Transaction t = this.transactionService.beginRead();){
            deployment = (AbstractAPIServiceDeployment)this.getDeploymentDAO().getMandatoryUnsafe(deploymentId);
            PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(deployment.getPublishedItemId());
            infra = (AbstractDeploymentInfra)this.getInfrasDAO().getMandatory(deployment.infraId);
            this.checkReadPermissions(infra, item, authCtx);
        }
        String carbonAPIURL = null;
        String metricToQuery = null;
        String string = actualDeployedItem = deployment.deployedServiceId == null ? deployment.publishedServiceId : deployment.deployedServiceId;
        if (deployment instanceof StaticDeployment) {
            StaticAPIDeploymentInfra si = (StaticAPIDeploymentInfra)infra;
            carbonAPIURL = si.carbonAPISettings.carbonAPIURL;
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)carbonAPIURL)) {
                throw ErrorContext.iae((String)"Charts engine not enabled for this deployment infrastructure. Please enter a CarbonAPI server address");
            }
            ArrayList<CallSite> metrics = new ArrayList<CallSite>();
            switch (chartType) {
                case ENDPOINT_QPS_COMBINED: {
                    for (StaticAPIDeploymentInfra.APINodeRef apiNode : si.apiNodes) {
                        metrics.add((CallSite)((Object)(apiNode.graphitePrefix + ".apinodeserver.dku.lambda.service." + actualDeployedItem + "." + endpointId + ".requests.m1_rate")));
                    }
                    metricToQuery = "sum(" + org.apache.commons.lang3.StringUtils.join(metrics, (String)",") + ")";
                    break;
                }
                case ENDPOINT_TIMING_SPLIT: {
                    for (StaticAPIDeploymentInfra.APINodeRef apiNode : si.apiNodes) {
                        metrics.add((CallSite)((Object)(apiNode.graphitePrefix + ".apinodeserver.dku.lambda.service." + actualDeployedItem + "." + endpointId + ".totalProcessing.p95")));
                    }
                    metricToQuery = "{" + org.apache.commons.lang3.StringUtils.join(metrics, (String)",") + "}";
                    break;
                }
                case OVERALL_QPS_COMBINED: {
                    for (StaticAPIDeploymentInfra.APINodeRef apiNode : si.apiNodes) {
                        metrics.add((CallSite)((Object)(apiNode.graphitePrefix + ".apinodeserver.dku.lambda.service." + actualDeployedItem + ".*.requests.m1_rate")));
                    }
                    metricToQuery = "sum(" + org.apache.commons.lang3.StringUtils.join(metrics, (String)",") + ")";
                }
            }
        }
        if (deployment instanceof K8SAPIServiceDeployment) {
            K8SAPIDeploymentInfra k8si = (K8SAPIDeploymentInfra)infra;
            carbonAPIURL = k8si.carbonAPISettings.carbonAPIURL;
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)carbonAPIURL)) {
                throw ErrorContext.iae((String)"Charts engine not enabled for this deployment infrastructure. Please enter a CarbonAPI server address");
            }
            String graphiteBase = k8si.graphiteConfig.graphiteCarbonCommonPrefix + ".deployments." + deployment.id;
            switch (chartType) {
                case ENDPOINT_QPS_COMBINED: {
                    metricToQuery = "sum(" + graphiteBase + ".*.apinodeserver.dku.lambda.service." + actualDeployedItem + "." + endpointId + ".requests.m1_rate)";
                    break;
                }
                case ENDPOINT_TIMING_SPLIT: {
                    metricToQuery = graphiteBase + ".*.apinodeserver.dku.lambda.service." + actualDeployedItem + "." + endpointId + ".totalProcessing.p95";
                    break;
                }
                case OVERALL_QPS_COMBINED: {
                    metricToQuery = "sum(" + graphiteBase + ".*.apinodeserver.dku.lambda.service." + actualDeployedItem + ".*.requests.m1_rate)";
                }
            }
        }
        URIBuilder builder = new URIBuilder(carbonAPIURL + "/render");
        builder.addParameter("target", metricToQuery);
        switch (timeRange) {
            case ONE_DAY: {
                builder.addParameter("from", "-1d");
                break;
            }
            case ONE_HOUR: {
                builder.addParameter("from", "-1h");
                break;
            }
            case SIX_HOURS: {
                builder.addParameter("from", "-6h");
            }
        }
        if ("png".equals(format)) {
            builder.addParameter("format", "png");
            builder.addParameter("width", "800");
            builder.addParameter("hideLegend", "true");
            builder.addParameter("areaMode", "all");
            builder.addParameter("areaAlpha", "0.3");
            builder.addParameter("colorList", "2AB1AC");
        } else if ("json".equals(format)) {
            builder.addParameter("format", "json");
        } else {
            throw ErrorContext.iaef((String)"Unknown chart format: %s", (Object)format, (Object[])new Object[0]);
        }
        this.getLogger().info((Object)("Query URL " + String.valueOf(builder.build())));
        HttpGet get = new HttpGet(builder.build());
        int carbonApiConnectTimeout = DKUApp.getParams().getIntParam("dku.deployer.carbonApiConnectTimeout", Integer.valueOf(0));
        int carbonApiSocketTimeout = DKUApp.getParams().getIntParam("dku.deployer.carbonApiSocketTimeout", Integer.valueOf(0));
        RequestConfig config = RequestConfig.custom().setConnectTimeout(carbonApiConnectTimeout).setSocketTimeout(carbonApiSocketTimeout).build();
        try (CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(config).addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR).build();){
            CloseableHttpResponse httpResp = client.execute((HttpUriRequest)get);
            if (httpResp.getStatusLine().getStatusCode() != 200) {
                throw ErrorContext.iaef((String)"HTTP RET %s", (Object)httpResp.getStatusLine().getStatusCode(), (Object[])new Object[0]);
            }
            if ("png".equals(format)) {
                resp.addHeader("Content-Type", "image/png");
            }
            IOUtils.copyLarge((InputStream)httpResp.getEntity().getContent(), (OutputStream)resp.getOutputStream());
        }
    }

    private AbstractAPIServiceDeploymentManager getDeploymentManagerAndCheck_NT(AuthCtx authCtx, String deploymentId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AbstractAPIServiceDeployment deployment = (AbstractAPIServiceDeployment)this.deploymentsDAO.getMandatoryUnsafe(deploymentId);
            AbstractAPIDeploymentInfra infra = (AbstractAPIDeploymentInfra)this.getInfrasDAO().getMandatory(deployment.infraId);
            PublishedItem svc = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(deployment.getPublishedItemId());
            this.checkDeployPermissions(infra, svc, authCtx);
            AbstractAPIServiceDeploymentManager abstractAPIServiceDeploymentManager = AbstractAPIServiceDeploymentManager.getManagerForInfraAndDeployment(authCtx, infra, deployment, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
            return abstractAPIServiceDeploymentManager;
        }
    }

    public FutureResponse<String> startDiagnosis_NT_Check(AuthCtx authCtx, String deploymentId) throws Exception {
        return this.getDeploymentManagerAndCheck_NT(authCtx, deploymentId).startDiagnosis();
    }

    public void getDiagnosis_NT_Check(AuthCtx authCtx, HttpServletResponse resp, String deploymentId, String diagnosticName) throws Exception {
        this.getDeploymentManagerAndCheck_NT(authCtx, deploymentId).getDiagnosis(resp, diagnosticName);
    }

    public Set<String> getConfiguredEndpointIds_NT(String deploymentId, AuthCtx user) throws UnauthorizedException, IOException {
        AbstractAPIServiceDeployment deployment;
        try (Transaction t = this.transactionService.beginRead();){
            deployment = (AbstractAPIServiceDeployment)this.getSettingsMandatoryUnsafe_Check(deploymentId, user);
        }
        List<PublishedPackageInfo> packages = this.publishedAPIServicesService.listPublishedPackages_Check_Unsafe_NT(deployment.getPublishedItemId(), user);
        return packages.stream().filter(p -> deployment.generationsMapping.isUsed(p.id)).flatMap(p -> ((PublishedApiServicePackageInfo)p).endpoints.stream()).map(e -> e.id).collect(Collectors.toSet());
    }

    public QueryableEndpoint getEndpointQueryableThroughDeployer_Check(AuthCtx user, String deploymentId, String endpointId) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            AbstractAPIServiceDeployment deployment = (AbstractAPIServiceDeployment)this.getDeploymentDAO().getMandatory(deploymentId);
            if (!deployment.canQueryThroughDeployer(user)) {
                throw new UnauthorizedException("Authorization denied: user can not query deployment '%s' through the deployer".formatted(deploymentId), "mad-deployment-action-denied");
            }
            QueryableEndpoint queryableEndpoint = this.getDeploymentQueryableEndpoints(deployment).stream().filter(endpoint -> Objects.equals(endpoint.endpointId, endpointId)).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find endpoint %s of deployment %s".formatted(endpointId, deploymentId)));
            return queryableEndpoint;
        }
    }

    public List<QueryableEndpoint> listEndpointsQueryableThroughDeployer_Check(AuthCtx user) throws IOException, DKUSecurityException {
        List allDeployments;
        ArrayList<QueryableEndpoint> ret = new ArrayList<QueryableEndpoint>();
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            allDeployments = this.getDeploymentDAO().listUnsafe();
        }
        for (AbstractAPIServiceDeployment deployment : allDeployments) {
            if (!deployment.canQueryThroughDeployer(user) || deployment.generationsMapping == null) continue;
            ret.addAll(this.getDeploymentQueryableEndpoints(deployment));
        }
        return ret;
    }

    private List<QueryableEndpoint> getDeploymentQueryableEndpoints(AbstractAPIServiceDeployment deployment) throws IOException {
        ArrayList<QueryableEndpoint> ret = new ArrayList<QueryableEndpoint>();
        String deployedGeneration = deployment.generationsMapping.getEntries().get((int)0).generation;
        PublishedApiServicePackageInfo publishedPackageInfo = this.getPublishedItemsService().getPublishedPackageOrNull(deployment.getPublishedItemId(), deployedGeneration);
        if (publishedPackageInfo == null) {
            return new ArrayList<QueryableEndpoint>();
        }
        for (LambdaEndpointConfig endpoint : publishedPackageInfo.endpoints) {
            if (deployment instanceof AbstractFullyManagedAPIDeployment && !Objects.equals(endpoint.id, ((AbstractFullyManagedAPIDeployment)deployment).endpointId)) continue;
            QueryableEndpoint endpointConfig = new QueryableEndpoint();
            endpointConfig.type = endpoint.type;
            endpointConfig.deploymentId = deployment.id;
            endpointConfig.endpointId = endpoint.id;
            endpointConfig.infrastructureId = deployment.infraId;
            try {
                Swagger swagger;
                Operation endpointOperation;
                if (publishedPackageInfo.hasOpenAPIDoc && (endpointOperation = OpenAPIHelper.getEndpointOperation(swagger = OpenAPIHelper.getSwagger(publishedPackageInfo.openAPIDocContent), endpoint.id, endpoint.type)) != null) {
                    endpointConfig.hasOpenAPIDocumentation = true;
                    endpointConfig.description = endpointOperation.getDescription();
                    endpointConfig.deploymentOpenApiDocContent = publishedPackageInfo.openAPIDocContent;
                }
            }
            catch (Exception e) {
                this.getLogger().info((Object)"Could not parse the openAPI documentation for endpoint %s of deployment %s, skipping".formatted(endpointConfig.endpointId, endpointConfig.deploymentId));
            }
            ret.add(endpointConfig);
        }
        return ret;
    }

    @Override
    protected DKULogger getLogger() {
        return DKULogger.getLogger((String)"dku.api-deployments.service");
    }

    public static enum CarbonAPIChartType {
        OVERALL_QPS_COMBINED,
        ENDPOINT_QPS_COMBINED,
        ENDPOINT_TIMING_SPLIT;

    }

    public static enum CarbonAPITimeRange {
        ONE_HOUR,
        SIX_HOURS,
        ONE_DAY;

    }
}

