/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentHook;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.AbstractDeploymentsService;
import com.dataiku.dip.apideployer.deployments.actions.DeploymentActionHandle;
import com.dataiku.dip.apideployer.deployments.actions.DeploymentActionsService;
import com.dataiku.dip.apideployer.deployments.actions.updates.DeploymentUpdateService;
import com.dataiku.dip.apideployer.engine.DeploymentException;
import com.dataiku.dip.apideployer.engine.DeploymentFutureThread;
import com.dataiku.dip.apideployer.engine.DeploymentHooksRunner;
import com.dataiku.dip.apideployer.engine.DeploymentHooksService;
import com.dataiku.dip.apideployer.engine.DeploymentReport;
import com.dataiku.dip.apideployer.engine.DeploymentReportForPostHooksCode;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.logging.AutoClosableAppenderWrapper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDeploymentManager<D extends AbstractDeployment, I extends AbstractPublishedItemBasicInfo, N extends AbstractDeploymentInfra, R extends DeploymentReport> {
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected FutureService futureService;
    @Autowired
    protected DeploymentHooksService deploymentHooksService;
    @Autowired
    protected DeploymentActionsService deploymentActionsService;
    @Autowired
    protected DeploymentUpdateService deploymentUpdateService;
    protected final AuthCtx authCtx;

    protected AbstractDeploymentManager(AuthCtx authCtx) {
        this.authCtx = authCtx;
    }

    protected abstract DKULogger getLogger();

    protected abstract D getDeployment();

    protected abstract N getInfra();

    protected abstract AbstractDeploymentsService<D, I, N> getDeploymentsService();

    protected abstract int numberOfDeploymentSteps();

    @Nonnull
    protected abstract String getDeploymentPrettyName();

    @Nonnull
    protected abstract String getInfraPrettyName();

    @Nonnull
    protected abstract R initializeDeploymentReport();

    protected abstract void preDeploymentActions(@Nonnull R var1, @Nonnull DKUtils.SmartLogTailBuilder var2) throws InterruptedException, CodedException;

    @Nonnull
    protected abstract DeploymentHooksRunner.DeploymentHookMetadata getDeploymentHookMetadata();

    protected abstract InfoMessage.InfoMessages doDeployment(DKUtils.SmartLogTailBuilder var1) throws Exception;

    protected abstract void postDeploymentActions(@Nonnull R var1) throws InterruptedException;

    @Nonnull
    protected abstract FuturePayload getDeploymentPayload();

    public FutureResponse<R> startUpdateDeployment_NT() throws Exception {
        D deployment = this.getDeployment();
        N infra = this.getInfra();
        DKULogger logger = this.getLogger();
        logger.info((Object)("Execute single-step sync of  " + JSON.json(deployment)));
        return this.futureService.runFuture(new DeploymentFutureThread<R>(this.authCtx, (AbstractDeployment)deployment, (AbstractDeploymentInfra)infra){
            final /* synthetic */ AbstractDeployment val$deployment;
            final /* synthetic */ AbstractDeploymentInfra val$infra;
            {
                this.val$deployment = abstractDeployment;
                this.val$infra = abstractDeploymentInfra;
                super(authCtx);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute() throws Exception {
                int steps = AbstractDeploymentManager.this.numberOfDeploymentHooksSteps() + AbstractDeploymentManager.this.numberOfDeploymentSteps();
                this.report = AbstractDeploymentManager.this.initializeDeploymentReport();
                long startTimestamp = Instant.now().toEpochMilli();
                AutoClosableAppenderWrapper ignored1 = AbstractDeploymentManager.this.getDeploymentsService().appendThreadLogsToDeploymentLogFile(this.val$deployment);
                try {
                    DeploymentActionHandle deploymentActionHandle = AbstractDeploymentManager.this.deploymentActionsService.updateDeployment(this.val$deployment, this.val$infra, this, startTimestamp);
                    try {
                        AutoClosableAppenderWrapper ignored2 = AbstractDeploymentManager.this.getDeploymentsService().appendThreadLogsToUpdateLogFile(this.val$infra, this.val$deployment, startTimestamp);
                        try {
                            FutureProgress.AutocloseableFutureProgressState ignored3 = FutureProgress.pushAutoCloseableState((String)("Updating deployment on " + AbstractDeploymentManager.this.getInfraPrettyName()), (double)steps, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                            try {
                                try {
                                    AbstractDeploymentManager.this.preDeploymentActions(this.report, this.logTailBuilder);
                                }
                                catch (InterruptedException e) {
                                    AbstractDeploymentManager.this.getLogger().infoV("Deployment has been interrupted during pre deployment actions. %s", new Object[]{this.abortMessage});
                                    this.report.withError(DeployerCodes.ERR_DEPLOYER_INTERRUPTED, this.abortMessage);
                                    this.report.interrupted = true;
                                    AbstractDeploymentManager.this.addHeavyStatusToHandle(deploymentActionHandle, AbstractDeploymentManager.this.authCtx);
                                    if (ignored3 != null) {
                                        ignored3.close();
                                    }
                                    if (ignored2 != null) {
                                        ignored2.close();
                                    }
                                    if (deploymentActionHandle != null) {
                                        deploymentActionHandle.close();
                                    }
                                    if (ignored1 == null) return;
                                    ignored1.close();
                                    return;
                                }
                                if (this.report.preDeploymentActionsSucceeded()) {
                                    boolean hasDeploymentHooksEnabled = this.val$infra.hasDeploymentHooksEnabled();
                                    boolean skipDeployment = false;
                                    if (hasDeploymentHooksEnabled) {
                                        block72: {
                                            try {
                                                AbstractDeploymentManager.this.executePreHooksIfNeeded(this.report);
                                            }
                                            catch (Exception e) {
                                                AbstractDeploymentManager.this.getLogger().error((Object)"Pre deployment hooks failed with an unexpected error", (Throwable)e);
                                                if (this.aborted) break block72;
                                                this.report.withError(DeployerCodes.ERR_DEPLOYMENT_HOOK, ExceptionUtils.getMessageWithCauses((Throwable)e));
                                                this.report.preHookFailure();
                                                AbstractDeploymentManager.this.addHeavyStatusToHandle(deploymentActionHandle, AbstractDeploymentManager.this.authCtx);
                                                if (ignored3 != null) {
                                                    ignored3.close();
                                                }
                                                if (ignored2 != null) {
                                                    ignored2.close();
                                                }
                                                if (deploymentActionHandle != null) {
                                                    deploymentActionHandle.close();
                                                }
                                                if (ignored1 == null) return;
                                                ignored1.close();
                                                return;
                                            }
                                        }
                                        if (this.aborted) {
                                            AbstractDeploymentManager.this.getLogger().errorV("Pre deployment hooks have been interrupted. %s", new Object[]{this.abortMessage});
                                            this.report.withError(DeployerCodes.ERR_DEPLOYMENT_HOOK_INTERRUPTED, this.abortMessage);
                                            this.report.preHookFailure();
                                            this.report.interrupted = true;
                                            AbstractDeploymentManager.this.addHeavyStatusToHandle(deploymentActionHandle, AbstractDeploymentManager.this.authCtx);
                                            return;
                                        }
                                        if (this.report.deploymentHookExecutionStatus.preHookFailed) {
                                            skipDeployment = true;
                                        }
                                    }
                                    if (!skipDeployment) {
                                        block73: {
                                            try {
                                                if (!hasDeploymentHooksEnabled) {
                                                    AbstractDeploymentManager.this.getLogger().info((Object)("No deployment hooks defined or enabled for this infrastructure, will only execute " + AbstractDeploymentManager.this.getDeploymentPrettyName()));
                                                    this.report.deploymentHookExecutionStatus.noHookDefined();
                                                }
                                                this.report.deploymentHookExecutionStatus.startDeployment("Starting " + AbstractDeploymentManager.this.getDeploymentPrettyName() + " " + ((AbstractDeployment)AbstractDeploymentManager.this.getDeployment()).id + " (requested by user " + AbstractDeploymentManager.this.authCtx.getIdentifier() + ")");
                                                this.report.setActualDeploymentStepReport(AbstractDeploymentManager.this.doDeployment(this.logTailBuilder));
                                            }
                                            catch (DeploymentException e) {
                                                if (!this.aborted) {
                                                    AbstractDeploymentManager.this.getLogger().error((Object)"Deployment failed with an unexpected error", (Throwable)e);
                                                    this.report.withError(DeployerCodes.ERR_DEPLOYER_UNEXPECTED_ERROR, e.getMessage(), e.getAdminMessage());
                                                }
                                            }
                                            catch (Exception e) {
                                                if (this.aborted) break block73;
                                                AbstractDeploymentManager.this.getLogger().error((Object)"Deployment failed with an unexpected error", (Throwable)e);
                                                this.report.withError(DeployerCodes.ERR_DEPLOYER_UNEXPECTED_ERROR, ExceptionUtils.getMessageWithCauses((Throwable)e));
                                            }
                                        }
                                        if (this.aborted) {
                                            AbstractDeploymentManager.this.getLogger().errorV("Deployment has been interrupted. %s", new Object[]{this.abortMessage});
                                            this.report.withError(DeployerCodes.ERR_DEPLOYER_INTERRUPTED, this.abortMessage);
                                            this.report.interrupted = true;
                                            this.report.deploymentHookExecutionStatus.updateStatusAfterDeployment(this.report, StringUtils.capitalize((String)AbstractDeploymentManager.this.getDeploymentPrettyName()) + " " + ((AbstractDeployment)AbstractDeploymentManager.this.getDeployment()).id);
                                            AbstractDeploymentManager.this.addHeavyStatusToHandle(deploymentActionHandle, AbstractDeploymentManager.this.authCtx);
                                            return;
                                        }
                                        this.report.deploymentHookExecutionStatus.updateStatusAfterDeployment(this.report, StringUtils.capitalize((String)AbstractDeploymentManager.this.getDeploymentPrettyName()) + " " + ((AbstractDeployment)AbstractDeploymentManager.this.getDeployment()).id);
                                    } else {
                                        this.report.deploymentHookExecutionStatus.skipDeployment("Skipping " + AbstractDeploymentManager.this.getDeploymentPrettyName());
                                    }
                                    if (hasDeploymentHooksEnabled) {
                                        block74: {
                                            try {
                                                AbstractDeploymentManager.this.executePostHooksIfNeeded(this.report);
                                            }
                                            catch (Exception e) {
                                                AbstractDeploymentManager.this.getLogger().error((Object)"Post deployment hooks failed with an unexpected error", (Throwable)e);
                                                if (this.aborted) break block74;
                                                this.report.withWarning(DeployerCodes.ERR_DEPLOYMENT_HOOK, ExceptionUtils.getMessageWithCauses((Throwable)e));
                                            }
                                        }
                                        if (this.aborted) {
                                            AbstractDeploymentManager.this.getLogger().errorV("Post deployment hooks have been interrupted. %s", new Object[]{this.abortMessage});
                                            this.report.withWarning(DeployerCodes.ERR_DEPLOYMENT_HOOK_INTERRUPTED, this.abortMessage);
                                            AbstractDeploymentManager.this.addHeavyStatusToHandle(deploymentActionHandle, AbstractDeploymentManager.this.authCtx);
                                            return;
                                        }
                                    }
                                }
                                try {
                                    AbstractDeploymentManager.this.postDeploymentActions(this.report);
                                }
                                catch (InterruptedException e) {
                                    AbstractDeploymentManager.this.getLogger().infoV("Post deployment actions have been interrupted. %s", new Object[]{this.abortMessage});
                                    this.report.withWarning(DeployerCodes.ERR_DEPLOYER_INTERRUPTED, this.abortMessage);
                                }
                                AbstractDeploymentManager.this.addHeavyStatusToHandle(deploymentActionHandle, AbstractDeploymentManager.this.authCtx);
                                return;
                            }
                            finally {
                                if (ignored3 != null) {
                                    try {
                                        ignored3.close();
                                    }
                                    catch (Throwable throwable) {
                                        Throwable throwable2;
                                        throwable2.addSuppressed(throwable);
                                    }
                                }
                            }
                        }
                        finally {
                            if (ignored2 != null) {
                                try {
                                    ignored2.close();
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable3;
                                    throwable3.addSuppressed(throwable);
                                }
                            }
                        }
                    }
                    finally {
                        if (deploymentActionHandle != null) {
                            try {
                                deploymentActionHandle.close();
                            }
                            catch (Throwable throwable) {
                                Throwable throwable4;
                                throwable4.addSuppressed(throwable);
                            }
                        }
                    }
                }
                finally {
                    if (ignored1 != null) {
                        try {
                            ignored1.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable5;
                            throwable5.addSuppressed(throwable);
                        }
                    }
                }
            }

            public FuturePayload getPayload() {
                return AbstractDeploymentManager.this.getDeploymentPayload();
            }
        }, 0L, new TypeToken<FutureResponse<R>>(){});
    }

    private void addHeavyStatusToHandle(DeploymentActionHandle handle, AuthCtx authCtx) throws Exception {
        AbstractDeploymentHeavyStatus heavyStatus = this.getDeploymentsService().getHeavyStatus_Unsafe_NT_Check(authCtx, ((AbstractDeployment)this.getDeployment()).id);
        handle.setHeavyStatus((AbstractDeploymentHeavyStatus)JSON.deepCopy((Object)heavyStatus));
    }

    private int numberOfDeploymentHooksSteps() {
        int steps = 0;
        if (((AbstractDeploymentInfra)this.getInfra()).deploymentHookSettings.preDeploymentHooks.stream().anyMatch(h -> h.enabled)) {
            ++steps;
        }
        if (((AbstractDeploymentInfra)this.getInfra()).deploymentHookSettings.postDeploymentHooks.stream().anyMatch(h -> h.enabled)) {
            ++steps;
        }
        return steps;
    }

    @Nullable
    private DSSAuthCtx getDeploymentHooksRunningUser_NT() throws UnauthorizedException, IOException {
        DSSAuthCtx dssAuthCtx;
        if (StringUtils.isEmpty((String)((AbstractDeploymentInfra)this.getInfra()).deploymentHookSettings.runHooksAsUser)) {
            this.getLogger().infoV("Running hooks with current user %s", new Object[]{this.authCtx.getIdentifier()});
        } else {
            this.getLogger().infoV("Running hooks with run-as user %s", new Object[]{((AbstractDeploymentInfra)this.getInfra()).deploymentHookSettings.runHooksAsUser});
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            dssAuthCtx = this.deploymentHooksService.getHooksRunningUser_Check(this.authCtx, (AbstractDeploymentInfra)this.getInfra());
        }
        return dssAuthCtx;
    }

    private void executePreHooksIfNeeded(DeploymentReport report) throws Exception {
        long numberOfHooks = ((AbstractDeploymentInfra)this.getInfra()).numberOfPreDeploymentHooksEnabled();
        if (numberOfHooks > 0L) {
            this.executeHooks(report, true, numberOfHooks);
        } else {
            this.getLogger().info((Object)"No pre deployment hook defined or enabled for this infrastructure");
        }
    }

    private void executePostHooksIfNeeded(DeploymentReport report) throws Exception {
        long numberOfHooks = ((AbstractDeploymentInfra)this.getInfra()).numberOfPostDeploymentHooksEnabled();
        if (numberOfHooks > 0L) {
            this.executeHooks(report, false, numberOfHooks);
        } else {
            this.getLogger().info((Object)"No pre deployment hook defined or enabled for this infrastructure");
        }
    }

    private void executeHooks(DeploymentReport report, boolean preHooks, long numberOfHooks) throws Exception {
        DSSAuthCtx dssAuthCtx = this.getDeploymentHooksRunningUser_NT();
        File deploymentLogFile = this.getDeploymentsService().getDeploymentLogFile(this.getDeployment());
        File updateLogFile = this.deploymentUpdateService.getLastUpdateLogsFile((AbstractDeploymentInfra)this.getInfra(), (AbstractDeployment)this.getDeployment());
        DeploymentHooksRunner.DeploymentHookMetadata metadata = this.getDeploymentHookMetadata();
        try (DeploymentHooksRunner runner = this.deploymentHooksService.acquireRunner(dssAuthCtx, (AbstractDeploymentInfra)this.getInfra(), preHooks);){
            this.getLogger().infoV("Executing the %d enabled %s deployment hooks", new Object[]{numberOfHooks, preHooks ? "pre" : "post"});
            if (preHooks) {
                report.deploymentHookExecutionStatus.preHooks = numberOfHooks;
            } else {
                report.deploymentHookExecutionStatus.postHooks = numberOfHooks;
            }
            List<AbstractDeploymentHook> deploymentHooks = ((AbstractDeploymentInfra)this.getInfra()).getDeploymentHooks(preHooks);
            InfoMessage.InfoMessages deploymentHooksReport = runner.execute(this.authCtx, deploymentHooks, deploymentLogFile, updateLogFile, report.getHookResults(preHooks), metadata, preHooks ? null : DeploymentReportForPostHooksCode.from(report), !preHooks);
            report.mergeFrom(deploymentHooksReport);
            if (deploymentHooksReport.error && preHooks) {
                report.preHookFailure();
            }
            FutureProgress.incrementState((double)1.0);
        }
    }
}

