/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.AzureMLDataModelBuilder;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.AzureMLDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.AzureMLDeploymentStatusReporter;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.AzureMLDeploymentSummary;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.comparator.AzureMLOnlineDeploymentComparator;
import com.dataiku.dip.apideployer.datamodel.actual.azureml.comparator.AzureMLOnlineEndpointComparator;
import com.dataiku.dip.apideployer.datamodel.config.AbstractFullyManagedAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.AzureMLDeploymentInfo;
import com.dataiku.dip.apideployer.deployments.APIDeployerImageBuilderService;
import com.dataiku.dip.apideployer.deployments.AbstractFullyManagedAPIServiceDeploymentManager;
import com.dataiku.dip.apideployer.deployments.AzureMLDeploymentConfigManager;
import com.dataiku.dip.apideployer.deployments.FullyManagedAPIServiceDeploymentConfigManager;
import com.dataiku.dip.apideployer.infra.AbstractInfrasService;
import com.dataiku.dip.connections.AzureMLConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLEnvironment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLModel;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineDeployment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineEndpoint;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResourceIdentifier;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLVersionedResourceIdentifier;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLHttpClient;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.lambda.client.AzureMLLambdaAPIClient;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AzureMLDeploymentManager
extends AbstractFullyManagedAPIServiceDeploymentManager {
    private final AzureMLAPIDeployment deployment;
    private final AzureMLAPIDeploymentInfra infra;
    private final AzureMLDeploymentConfigManager deploymentConfigManager;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.azureml.manager");

    public AzureMLDeploymentManager(AuthCtx authCtx, AzureMLAPIDeployment deployment, AzureMLAPIDeploymentInfra infra, int connectTimeout, int socketTimeout) {
        super(authCtx, connectTimeout, socketTimeout);
        this.deployment = (AzureMLAPIDeployment)JSON.deepCopy((Object)deployment);
        this.deployment.overrideSettings.applyToDeployment(this.deployment, infra);
        this.infra = infra;
        this.deploymentConfigManager = new AzureMLDeploymentConfigManager(this.deployment, this.infra, this.getVariablesContext());
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected AzureMLDeploymentStatusReporter getDeploymentStatusReporter() {
        return new AzureMLDeploymentStatusReporter(this.deployment.id, this.deployment.infraId);
    }

    @Override
    public DeploymentStatusReport getFullCheckReport_NT() throws AzureMLUtils.AzureAuthenticationException, IOException, DKUSecurityException {
        try (AzureMLHttpClient azureMLClient = AzureMLUtils.getAzureMLClient_NT(this.authCtx, this.infra.authConnection, this.connectTimeout, this.socketTimeout);){
            AzureMLDeploymentInfo lastDeploymentInfo = this.getOrBuildDeploymentInfo(azureMLClient);
            AzureMLDeploymentSummary deployedSummary = AzureMLDeploymentSummary.AzureMLDeploymentSummaryBuilder.buildFromRemoteConfig_NT(azureMLClient, lastDeploymentInfo);
            AzureMLDeploymentSummary storedSummary = AzureMLDeploymentSummary.AzureMLDeploymentSummaryBuilder.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), lastDeploymentInfo);
            DeploymentStatusReport deploymentStatusReport = this.getDeploymentStatusReporter().computeFullCheck(storedSummary, deployedSummary, this.deployment.enabled);
            return deploymentStatusReport;
        }
    }

    @Override
    public AzureMLDeploymentHeavyStatus getStatus_Unsafe_NT(boolean withPackageExtraInfo, @Nullable String overridingConnectionName) throws IOException, InterruptedException, DKUSecurityException, AzureMLUtils.AzureAuthenticationException {
        AzureMLDeploymentHeavyStatus status = new AzureMLDeploymentHeavyStatus(this.deployment.id, this.deployment.infraId);
        status.packages = this.publishedAPIServicesService.listPublishedPackages_Check_Unsafe_NT(this.deployment.publishedServiceId, this.authCtx);
        status.endpoints = status.summarizeEndpoints_NT(this.deployment, withPackageExtraInfo);
        String usedConnection = overridingConnectionName != null ? overridingConnectionName : this.infra.authConnection;
        AzureMLHttpClient azureMLClient = AzureMLUtils.getAzureMLClient_NT(this.authCtx, usedConnection, this.connectTimeout, this.socketTimeout);
        try {
            AzureMLDeploymentInfo lastDeploymentInfo = this.getOrBuildDeploymentInfo(azureMLClient);
            AzureMLDeploymentSummary storedSummary = AzureMLDeploymentSummary.AzureMLDeploymentSummaryBuilder.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), lastDeploymentInfo);
            AzureMLOnlineEndpoint deployedOnlineEndpoint = AzureMLDataModelBuilder.buildOnlineEndpointFromRemoteConfig_NT(azureMLClient, lastDeploymentInfo.getOnlineEndpointIdentifier());
            status.checkEndpointHealth(storedSummary, deployedOnlineEndpoint, this.deployment.enabled);
            AzureMLDeploymentHeavyStatus azureMLDeploymentHeavyStatus = status;
            if (azureMLClient != null) {
                azureMLClient.close();
            }
            return azureMLDeploymentHeavyStatus;
        }
        catch (Throwable lastDeploymentInfo) {
            try {
                if (azureMLClient != null) {
                    try {
                        azureMLClient.close();
                    }
                    catch (Throwable throwable) {
                        lastDeploymentInfo.addSuppressed(throwable);
                    }
                }
                throw lastDeploymentInfo;
            }
            catch (AzureMLUtils.AzureAuthenticationException e) {
                logger.error((Object)e);
                status.setMessageAndHealthWithSeverity(InfoMessage.error((InfoMessage.MessageCode)e.getCode(), (String)e.getMessage()), DeploymentHealth.ERROR);
                return status;
            }
            catch (Exception e) {
                String message = "Unable to retrieve deployment status.";
                logger.warn((Object)message, (Throwable)e);
                status.setMessageAndHealthWithSeverity(InfoMessage.error((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_DEPLOYMENT_RETRIEVAL, (String)message), DeploymentHealth.ERROR);
                return status;
            }
        }
    }

    @Override
    protected String diagnosisInternal(File tmpDir, String fileFriendlyLocalNow, FutureThreadBase<?> future) throws Exception {
        logger.infoV("Generating diagnostic of  %s...", new Object[]{this.deployment.id});
        AzureMLDeploymentInfo deploymentInfo = this.getOrBuildDeploymentInfo(null);
        JSON.prettyToFile((Object)this.deployment, (File)new File(tmpDir, "deployment.json"));
        JSON.prettyToFile((Object)deploymentInfo, (File)new File(tmpDir, "deployment-info.json"));
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.infoV("Diagnosis requested by a user with admin permissions on infra. Including %s configuration file.", new Object[]{"infra.json"});
            JSON.prettyToFile((Object)this.infra, (File)new File(tmpDir, "infra.json"));
        } else {
            logger.infoV("Diagnosis requested by a user without admin permissions on infra. Not including configuration file %s.", new Object[]{"infra.json"});
        }
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        try (AzureMLHttpClient azureMLClient = AzureMLUtils.getAzureMLClient_NT(this.authCtx, this.infra.authConnection, this.connectTimeout, this.socketTimeout);){
            JsonObject azVersion;
            logger.info((Object)"Fetch summaries of Azure ML resources");
            AzureMLDeploymentSummary localSummary = AzureMLDeploymentSummary.AzureMLDeploymentSummaryBuilder.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
            AzureMLDeploymentSummary remoteSummary = AzureMLDeploymentSummary.AzureMLDeploymentSummaryBuilder.buildFromRemoteConfig_NT(azureMLClient, deploymentInfo);
            if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
                logger.info((Object)"Diagnosis requested by a user with admin permissions on infra. Including local and remote summary files.");
                JSON.prettyToFile((Object)localSummary, (File)new File(tmpDir, "local-summary.json"));
                JSON.prettyToFile((Object)remoteSummary, (File)new File(tmpDir, "remote-summary.json"));
            } else {
                logger.info((Object)"Diagnosis requested by a user without admin permissions on infra. Not including local and remote summary files.");
            }
            DeploymentStatusReport statusReport = this.getDeploymentStatusReporter().computeFullCheck(localSummary, remoteSummary, this.deployment.enabled);
            JSON.prettyToFile((Object)statusReport, (File)new File(tmpDir, "status-report.json"));
            if (future.isAborted()) {
                throw new InterruptedException("Diagnosis aborted");
            }
            FutureProgress.incrementState((double)1.0);
            logger.info((Object)"Fetch versions");
            JsonObject versions = new JsonObject();
            versions.addProperty("dss-version", DKUApp.getDSSVersion().product_version);
            DKUtils.ExecutionResults cmdResult = DKUtils.execAndGetOutputAndErrors((String[])new String[]{"az", "version", "--output=json"}, System.getenv());
            if (cmdResult.rv != 0) {
                azVersion = new JsonObject();
                azVersion.addProperty("error", cmdResult.err);
                logger.warn((Object)("Failed to get az CLI version: " + JSON.json((Object)cmdResult)));
            } else {
                azVersion = (JsonObject)JSON.parse((String)cmdResult.out, JsonObject.class);
            }
            versions.add("az-cli-versions", (JsonElement)azVersion);
            JSON.prettyToFile((Object)versions, (File)new File(tmpDir, "versions.json"));
            if (future.isAborted()) {
                throw new InterruptedException("Diagnosis aborted");
            }
            FutureProgress.incrementState((double)1.0);
            if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
                logger.info((Object)"User has infra admin permissions ; adding deployment logs");
                File logsDir = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{"deployment-logs"});
                DKUFileUtils.mkdirs((File)logsDir);
                for (Path path : this.apiServiceDeploymentsService.listLogFiles(this.deployment)) {
                    FileUtils.copyFileToDirectory((File)path.toFile(), (File)logsDir);
                }
            } else {
                logger.info((Object)"User does not have infra admin permissions ; not adding deployment logs");
            }
            String string = tmpDir.getName();
            return string;
        }
    }

    @Override
    public BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(String deployedServiceId, APIServiceDeploymentHeavyStatus.EndpointSummary endpoint, AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus lightStatus, APIServiceDeploymentHeavyStatus heavyStatus, List<ApiEndpointQuery> allQueries, boolean forTest) throws IOException, AzureMLUtils.AzureAuthenticationException, DKUSecurityException {
        try (AzureMLHttpClient azureMLClient = AzureMLUtils.getAzureMLClient_NT(this.authCtx, this.infra.authConnection, this.connectTimeout, this.socketTimeout);){
            AzureMLDeploymentInfo deploymentInfo = this.getOrBuildDeploymentInfo(azureMLClient);
            AzureMLResourceIdentifier endpointIdentifier = deploymentInfo.getOnlineEndpointIdentifier();
            BaseLambdaAPIClient.ApiEndpointResponses apiEndpointResponses = AzureMLLambdaAPIClient.runQueries_NT(this.authCtx, this.infra, this.deployment.id, endpointIdentifier, endpoint, allQueries, forTest);
            return apiEndpointResponses;
        }
    }

    private AzureMLModel createModel(@Nonnull AzureMLUtils.AzureSession session, @Nonnull File contextDir) throws IOException, InterruptedException {
        logger.debugV("Recreating a new model.", new Object[0]);
        AzureMLVersionedResourceIdentifier modelIdentifier = new AzureMLVersionedResourceIdentifier(this.deploymentConfigManager.generateModelName(), this.infra.azWorkspace, this.infra.azResourceGroup, this.infra.azSubscription, "1");
        AzureMLModel model = AzureMLDataModelBuilder.buildModelFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), modelIdentifier);
        return AzureMLUtils.createModel_NT(session, model, contextDir);
    }

    private AzureMLEnvironment createEnvironment(@Nonnull AzureMLUtils.AzureSession session, @Nonnull File contextDir, @Nonnull APIDeployerImageBuilderService.ImageNameTags imageNameTags) throws IOException, InterruptedException {
        logger.debugV("Recreating a new environment.", new Object[0]);
        AzureMLVersionedResourceIdentifier environmentIdentifier = new AzureMLVersionedResourceIdentifier(this.deploymentConfigManager.generateEnvironmentName(), this.infra.azWorkspace, this.infra.azResourceGroup, this.infra.azSubscription, "1");
        String containerImageUri = this.infra.getImageAliasInRegistryHost(imageNameTags.imageName, imageNameTags.imageVersion);
        AzureMLEnvironment environment = AzureMLDataModelBuilder.buildEnvironmentFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), environmentIdentifier, containerImageUri);
        return AzureMLUtils.createEnvironment_NT(session, environment, contextDir);
    }

    private AzureMLOnlineEndpoint createOrUpdateOnlineEndpoint(@Nonnull AzureMLUtils.AzureSession session, @Nonnull File contextDir, @Nullable AzureMLOnlineEndpoint deployedOnlineEndpoint, @Nonnull AzureMLOnlineEndpoint storedOnlineEndpoint) throws IOException, InterruptedException {
        AzureMLOnlineEndpoint updatedOnlineEndpoint;
        AzureMLOnlineEndpointComparator onlineEndpointComparator = new AzureMLOnlineEndpointComparator(storedOnlineEndpoint);
        boolean isOnlineEndpointOutOfSync = onlineEndpointComparator.isOutOfSync(deployedOnlineEndpoint);
        if (deployedOnlineEndpoint != null) {
            if (isOnlineEndpointOutOfSync) {
                try {
                    logger.debugV("Stored settings differ from the ones retrieved for Online Endpoint %s. Online Endpoint needs to be updated.", new Object[]{storedOnlineEndpoint.name});
                    updatedOnlineEndpoint = AzureMLUtils.updateOnlineEndpoint_NT(session, storedOnlineEndpoint, contextDir);
                }
                catch (Exception e) {
                    logger.errorV("Error while updating AzureML Online Endpoint %s.", new Object[]{storedOnlineEndpoint.name});
                    throw e;
                }
            } else {
                try {
                    logger.debugV("Settings have not changed for Online Endpoint %s.", new Object[]{storedOnlineEndpoint.name});
                    if (onlineEndpointComparator.areTagsOutOfSync(deployedOnlineEndpoint.tags)) {
                        logger.debugV("Tags for Online Endpoint %s are out of sync. Updating tags...", new Object[]{storedOnlineEndpoint.name});
                        updatedOnlineEndpoint = (AzureMLOnlineEndpoint)AzureMLUtils.updateResourceTags_NT(session, storedOnlineEndpoint, deployedOnlineEndpoint.tags);
                    }
                    logger.debugV("Nothing to update for Online Endpoint %s.", new Object[]{storedOnlineEndpoint.name});
                    updatedOnlineEndpoint = deployedOnlineEndpoint;
                }
                catch (Exception e) {
                    logger.errorV("Error while updating tags for the AzureML Online Endpoint %s.", new Object[]{storedOnlineEndpoint.name});
                    throw e;
                }
            }
        } else {
            String onlineEndpointName = StringUtils.isNotBlank((CharSequence)storedOnlineEndpoint.name) ? storedOnlineEndpoint.name : (StringUtils.isNotBlank((CharSequence)this.deployment.getCustomEndpointName(this.infra)) ? this.deployment.getCustomEndpointName(this.infra) : this.deploymentConfigManager.generateOnlineEndpointName());
            AzureMLResourceIdentifier onlineEndpointId = new AzureMLResourceIdentifier(onlineEndpointName, this.infra.azWorkspace, this.infra.azResourceGroup, this.infra.azSubscription);
            AzureMLOnlineEndpoint onlineEndpoint = AzureMLDataModelBuilder.buildOnlineEndpointFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), onlineEndpointId, null);
            updatedOnlineEndpoint = AzureMLUtils.createOnlineEndpoint_NT(session, onlineEndpoint, contextDir);
        }
        return updatedOnlineEndpoint;
    }

    private AzureMLOnlineDeployment rollingDeployment(@Nonnull AzureMLUtils.AzureSession session, @Nonnull File contextDir, @Nonnull AzureMLOnlineDeployment onlineEndpointToRollout, @Nonnull AzureMLDeploymentSummary updatedSummary) throws IOException, InterruptedException {
        AzureMLOnlineDeployment updatedOnlineDeployment = AzureMLUtils.createOnlineDeployment_NT(session, onlineEndpointToRollout, contextDir);
        updatedSummary.onlineEndpoint.traffic = Collections.singletonMap(onlineEndpointToRollout.name, 100);
        return updatedOnlineDeployment;
    }

    private AzureMLOnlineDeployment buildOnlineDeployment(String name, String endpointName, String modelRef, String environmentRef) {
        AzureMLResourceIdentifier onlineDeploymentId = new AzureMLResourceIdentifier(name, this.infra.azWorkspace, this.infra.azResourceGroup, this.infra.azSubscription);
        return AzureMLDataModelBuilder.buildOnlineDeploymentFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), onlineDeploymentId, endpointName, modelRef, environmentRef);
    }

    private AzureMLOnlineDeployment createOrUpdateOnlineDeployment(@Nonnull AzureMLUtils.AzureSession session, @Nonnull File contextDir, @Nullable AzureMLOnlineDeployment deployedOnlineDeployment, @Nonnull AzureMLOnlineDeployment storedOnlineDeployment, @Nonnull AzureMLDeploymentSummary updatedSummary) throws IOException, InterruptedException {
        AzureMLOnlineDeployment updatedOnlineDeployment;
        AzureMLOnlineDeploymentComparator onlineEndpointComparator = new AzureMLOnlineDeploymentComparator(storedOnlineDeployment);
        boolean isOnlineEndpointOutOfSync = onlineEndpointComparator.isOutOfSync(deployedOnlineDeployment);
        if (deployedOnlineDeployment != null) {
            if (isOnlineEndpointOutOfSync) {
                try {
                    if (onlineEndpointComparator.requiresRecreation(deployedOnlineDeployment)) {
                        logger.debugV("Stored settings differ from the ones retrieved for Online Deployment %s in Online Endpoint '%s' in a way that requires a recreation. Online Deployment needs to be created again.", new Object[]{storedOnlineDeployment.name, storedOnlineDeployment.endpointName});
                        AzureMLOnlineDeployment onlineDeploymentToUpdate = this.buildOnlineDeployment(this.deploymentConfigManager.generateOnlineDeploymentName(), updatedSummary.onlineEndpoint.name, updatedSummary.model.getReference(), updatedSummary.environment.getReference());
                        updatedOnlineDeployment = this.rollingDeployment(session, contextDir, onlineDeploymentToUpdate, updatedSummary);
                    }
                    logger.debugV("Stored settings differ from the ones retrieved for Online Deployment %s in Online Endpoint '%s'. Online Deployment needs to be updated.", new Object[]{storedOnlineDeployment.name, storedOnlineDeployment.endpointName});
                    AzureMLOnlineDeployment onlineDeploymentToUpdate = this.buildOnlineDeployment(storedOnlineDeployment.name, updatedSummary.onlineEndpoint.name, updatedSummary.model.getReference(), updatedSummary.environment.getReference());
                    updatedOnlineDeployment = AzureMLUtils.updateOnlineDeployment_NT(session, onlineDeploymentToUpdate, contextDir);
                }
                catch (Exception e) {
                    logger.errorV("Error while updating AzureML Online Deployment %s in Online Endpoint '%s'.", new Object[]{storedOnlineDeployment.name, storedOnlineDeployment.endpointName});
                    throw e;
                }
            } else {
                try {
                    logger.debugV("Settings have not changed for Online Deployment %s in Online Endpoint '%s'.", new Object[]{storedOnlineDeployment.name, storedOnlineDeployment.endpointName});
                    if (onlineEndpointComparator.areTagsOutOfSync(deployedOnlineDeployment.tags)) {
                        logger.debugV("Tags for Online Deployment %s in Online Endpoint '%s' are out of sync. Updating tags...", new Object[]{storedOnlineDeployment.name, storedOnlineDeployment.endpointName});
                        updatedOnlineDeployment = (AzureMLOnlineDeployment)AzureMLUtils.updateResourceTags_NT(session, storedOnlineDeployment, deployedOnlineDeployment.tags);
                    }
                    logger.debugV("Nothing to update for Online Deployment '%s' in Online Endpoint '%s'", new Object[]{storedOnlineDeployment.name, storedOnlineDeployment.endpointName});
                    updatedOnlineDeployment = deployedOnlineDeployment;
                }
                catch (Exception e) {
                    logger.errorV("Error while updating tags for the AzureML Online Deployment '%s' in Online Endpoint '%s'", new Object[]{storedOnlineDeployment.name, storedOnlineDeployment.endpointName});
                    throw e;
                }
            }
        } else {
            AzureMLOnlineDeployment onlineDeployment = this.buildOnlineDeployment(this.deploymentConfigManager.generateOnlineDeploymentName(), updatedSummary.onlineEndpoint.name, updatedSummary.model.getReference(), updatedSummary.environment.getReference());
            updatedOnlineDeployment = AzureMLUtils.createOnlineDeployment_NT(session, onlineDeployment, contextDir);
        }
        return updatedOnlineDeployment;
    }

    private void deleteOnlineDeploymentResource(@Nonnull AzureMLHttpClient azureMLClient, @Nonnull AzureMLResourceIdentifier onlineDeploymentId) throws CodedException {
        if (StringUtils.isBlank((CharSequence)onlineDeploymentId.name)) {
            String noDeleteMessage = "No AzureML Online Deployment resource to delete.";
            logger.info((Object)noDeleteMessage);
            return;
        }
        try {
            logger.debugV("Deleting Online Deployment '%s' in Online Endpoint '%s'.", new Object[]{onlineDeploymentId.name, onlineDeploymentId.parentResourceName});
            azureMLClient.deleteOnlineDeployment_NT(onlineDeploymentId);
        }
        catch (Exception e) {
            String message = String.format("Error deleting AzureML Online Deployment '%s' in Online Endpoint '%s' associated to the deployment '%s'.", onlineDeploymentId.name, onlineDeploymentId.parentResourceName, this.deployment.id);
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_DELETE_RESOURCE, message + " " + e.getMessage());
        }
    }

    private void deleteOnlineEndpointResource(@Nonnull AzureMLHttpClient azureMLClient, @Nonnull AzureMLResourceIdentifier onlineEndpointId) throws CodedException {
        if (StringUtils.isBlank((CharSequence)onlineEndpointId.name)) {
            String noDeleteMessage = "No AzureML Online Endpoint resource to delete.";
            logger.info((Object)noDeleteMessage);
            return;
        }
        try {
            azureMLClient.deleteOnlineEndpoint_NT(onlineEndpointId);
        }
        catch (Exception e) {
            String message = String.format("Error deleting AzureML Online Endpoint '%s' associated to the deployment '%s'.", onlineEndpointId.name, this.deployment.id);
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_DELETE_RESOURCE, message + " " + e.getMessage());
        }
    }

    private void archiveEnvironmentResource(@Nonnull AzureMLHttpClient azureMLClient, @Nonnull AzureMLVersionedResourceIdentifier environmentId) throws CodedException {
        if (StringUtils.isBlank((CharSequence)environmentId.name)) {
            String noDeleteMessage = "No AzureML Environment resource to archive.";
            logger.info((Object)noDeleteMessage);
            return;
        }
        try {
            azureMLClient.archiveEnvironment_NT(environmentId);
        }
        catch (Exception e) {
            String message = String.format("Error archiving AzureML Environment '%s' associated to the deployment '%s'.", environmentId.name, this.deployment.id);
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_DELETE_RESOURCE, message + " " + e.getMessage());
        }
    }

    private void archiveModelResource(@Nonnull AzureMLHttpClient azureMLClient, @Nonnull AzureMLVersionedResourceIdentifier modelId) throws CodedException {
        if (StringUtils.isBlank((CharSequence)modelId.name)) {
            String noDeleteMessage = "No AzureML Model resource to archive.";
            logger.info((Object)noDeleteMessage);
            return;
        }
        try {
            azureMLClient.archiveModel_NT(modelId);
        }
        catch (Exception e) {
            String message = String.format("Error archiving AzureML Model '%s' associated to the deployment '%s'.", modelId.name, this.deployment.id);
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_DELETE_RESOURCE, message + " " + e.getMessage());
        }
    }

    private void rollbackModelIfNecessary(@Nonnull AzureMLHttpClient azureMLClient, @Nullable AzureMLModel previouslyDeployedModel, @Nonnull AzureMLModel justDeployedModel) {
        try {
            if (previouslyDeployedModel == null || !StringUtils.equals((CharSequence)previouslyDeployedModel.name, (CharSequence)justDeployedModel.name)) {
                logger.debugV("Rolling back previously created AzureML Model '%s'.", new Object[]{justDeployedModel.name});
                this.archiveModelResource(azureMLClient, justDeployedModel.getResourceIdentifier());
                logger.debugV("Rollback for AzureML Model '%s' successful.", new Object[]{justDeployedModel.name});
            }
        }
        catch (Exception rollbackException) {
            logger.errorV((Throwable)rollbackException, "Error rolling back previously created model %s", new Object[]{justDeployedModel.name});
        }
    }

    private void rollbackEnvironmentIfNecessary(@Nonnull AzureMLHttpClient azureMLClient, @Nullable AzureMLEnvironment previouslyDeployedEnvironment, @Nonnull AzureMLEnvironment justDeployedEnvironment) {
        try {
            if (previouslyDeployedEnvironment == null || !StringUtils.equals((CharSequence)previouslyDeployedEnvironment.name, (CharSequence)justDeployedEnvironment.name)) {
                logger.debugV("Rolling back previously created AzureML Environment '%s'.", new Object[]{justDeployedEnvironment.name});
                this.archiveEnvironmentResource(azureMLClient, justDeployedEnvironment.getResourceIdentifier());
                logger.debugV("Rollback for AzureML Environment '%s' successful.", new Object[]{justDeployedEnvironment.name});
            }
        }
        catch (Exception rollbackException) {
            logger.errorV((Throwable)rollbackException, "Error rolling back previously created environment %s", new Object[]{justDeployedEnvironment.name});
        }
    }

    private void rollbackEndpointIfNecessary(@Nonnull AzureMLHttpClient azureMLClient, @Nullable AzureMLOnlineEndpoint previouslyDeployedOnlineEndpoint, @Nonnull AzureMLOnlineEndpoint justDeployedOnlineEndpoint) {
        try {
            if (previouslyDeployedOnlineEndpoint == null || !StringUtils.equals((CharSequence)previouslyDeployedOnlineEndpoint.name, (CharSequence)justDeployedOnlineEndpoint.name)) {
                logger.debugV("Rolling back previously created AzureML Online Endpoint '%s'.", new Object[]{justDeployedOnlineEndpoint.name});
                this.deleteOnlineEndpointResource(azureMLClient, justDeployedOnlineEndpoint.getResourceIdentifier());
                logger.debugV("Rollback for AzureML Online Endpoint '%s' successful.", new Object[]{justDeployedOnlineEndpoint.name});
            }
        }
        catch (Exception rollbackException) {
            logger.errorV((Throwable)rollbackException, "Error rolling back previously created Online Endpoint %s", new Object[]{justDeployedOnlineEndpoint.name});
        }
    }

    private void cleanupOnlineDeploymentIfNecessary(@Nonnull AzureMLHttpClient azureMLClient, @Nullable AzureMLOnlineDeployment previouslyDeployedOnlineDeployment, @Nonnull AzureMLOnlineDeployment justDeployedOnlineDeployment) throws CodedException {
        if (previouslyDeployedOnlineDeployment != null && !StringUtils.equals((CharSequence)previouslyDeployedOnlineDeployment.name, (CharSequence)justDeployedOnlineDeployment.name)) {
            logger.debugV("Cleaning up AzureML Online Deployment '%s' used in previous deployment.", new Object[]{previouslyDeployedOnlineDeployment.name});
            this.deleteOnlineDeploymentResource(azureMLClient, previouslyDeployedOnlineDeployment.getResourceIdentifier());
            logger.debugV("Successfully cleaned up AzureML Online Deployment '%s'.", new Object[]{previouslyDeployedOnlineDeployment.name});
        }
    }

    private void cleanupPreviousResources(@Nonnull AzureMLHttpClient azureMLClient, @Nonnull AzureMLDeploymentSummary deployedSummary, @Nonnull AzureMLDeploymentSummary updatedSummary) throws CodedException {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        try {
            this.cleanupOnlineDeploymentIfNecessary(azureMLClient, deployedSummary.onlineDeployment, updatedSummary.onlineDeployment);
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error cleaning up previously existing Online Deployment '%s' in Online Endpoint.", new Object[]{updatedSummary.onlineDeployment.name, updatedSummary.onlineDeployment.endpointName});
            errors.add(e);
        }
        try {
            if (deployedSummary.environment != null && updatedSummary.environment != null && !StringUtils.equals((CharSequence)deployedSummary.environment.name, (CharSequence)updatedSummary.environment.name)) {
                logger.debugV("Cleaning up AzureML Environment '%s' used in previous deployment.", new Object[]{deployedSummary.environment.name});
                this.archiveEnvironmentResource(azureMLClient, deployedSummary.environment.getResourceIdentifier());
                logger.debugV("Successfully cleaned up AzureML Environment '%s'.", new Object[]{deployedSummary.environment.name});
            }
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error cleaning up previously existing Environment '%s'.", new Object[]{updatedSummary.environment.name});
            errors.add(e);
        }
        try {
            if (deployedSummary.model != null && updatedSummary.model != null && !StringUtils.equals((CharSequence)deployedSummary.model.name, (CharSequence)updatedSummary.model.name)) {
                logger.debugV("Cleaning up AzureML Model '%s' used in previous deployment.", new Object[]{deployedSummary.model.name});
                this.archiveModelResource(azureMLClient, deployedSummary.model.getResourceIdentifier());
                logger.debugV("Successfully cleaned up AzureML Model '%s'.", new Object[]{deployedSummary.model.name});
            }
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error cleaning up previously existing Model '%s'.", new Object[]{updatedSummary.onlineDeployment.name});
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            String consolidatedMessage = errors.stream().map(Throwable::getMessage).collect(Collectors.joining("\n"));
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_DELETE_RESOURCE, consolidatedMessage);
        }
    }

    private void checkPreconditions(@Nonnull AzureMLDeploymentSummary deployedSummary) throws CodedException {
        if (deployedSummary.onlineDeployment != null) {
            logger.debugV("Deployment exists in AzureML.", new Object[0]);
            AzureMLOnlineDeployment.DeploymentProvisioningState deploymentState = deployedSummary.onlineDeployment.provisioningState;
            List<AzureMLOnlineDeployment.DeploymentProvisioningState> allowedStates = Arrays.asList(AzureMLOnlineDeployment.DeploymentProvisioningState.SUCCEEDED, AzureMLOnlineDeployment.DeploymentProvisioningState.FAILED, AzureMLOnlineDeployment.DeploymentProvisioningState.CANCELED);
            if (!allowedStates.contains((Object)deploymentState)) {
                String allowedStatesToString = allowedStates.stream().map(Object::toString).collect(Collectors.joining(", "));
                throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_INCOMPATIBLE_STATE_FOR_ACTION_ENDPOINT, String.format("The AzureML deployment is not ready to be updated since it is in the state '%s'. Wait until the deployment is in one of the following states %s", new Object[]{deploymentState, allowedStatesToString}));
            }
        }
    }

    private AzureMLDeploymentInfo getOrBuildDeploymentInfo(@Nullable AzureMLHttpClient azureMLClient) throws IOException {
        AzureMLDeploymentInfo storedDeploymentInfo = this.deploymentInfoCRUDService.get(this.infra.id, this.deployment.id, AzureMLDeploymentInfo.class);
        if (!Objects.isNull(storedDeploymentInfo)) {
            return storedDeploymentInfo;
        }
        AzureMLDeploymentInfo deploymentInfo = new AzureMLDeploymentInfo(this.infra.id, this.deployment.id);
        deploymentInfo.azSubscription = this.infra.azSubscription;
        deploymentInfo.azResourceGroup = this.infra.azResourceGroup;
        deploymentInfo.azWorkspace = this.infra.azWorkspace;
        if (azureMLClient != null) {
            azureMLClient.retrieveSubscriptions_NT().stream().filter(subscription -> subscription.getSubscriptionId().equals(deploymentInfo.azSubscription)).map(subscription -> subscription.tenantId).findFirst().ifPresent(tenantId -> {
                deploymentInfo.azTenantId = tenantId;
            });
        }
        return deploymentInfo;
    }

    private void disableDeployment(@Nonnull AzureMLHttpClient azureMLClient, @Nonnull AzureMLDeploymentInfo lastDeploymentInfo) throws CodedException, IOException {
        this.deleteOnlineEndpointResource(azureMLClient, lastDeploymentInfo.getOnlineEndpointIdentifier());
        lastDeploymentInfo.azOnlineDeploymentName = null;
        logger.info((Object)"Updating deployment changes...");
        this.deploymentInfoCRUDService.save(lastDeploymentInfo);
        logger.info((Object)String.format("Changes saved for deployment with id %s.", this.deployment.id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected InfoMessage.InfoMessages doDeployment(@Nonnull DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        logger.infoV("Prepare sync of deployment %s", new Object[]{this.deployment.id});
        logger.info((Object)"Summary of the DSS resources used to update the deployment:");
        logger.infoV("Azure ML infra: %s", new Object[]{JSON.json((Object)this.infra)});
        logger.infoV("Azure ML deployment: %s", new Object[]{JSON.json((Object)this.deployment)});
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try (AzureMLHttpClient azureMLClient = AzureMLUtils.getAzureMLClient_NT(this.authCtx, this.infra.authConnection, this.connectTimeout, this.socketTimeout);
             AzureMLUtils.AzureSession session = AzureMLUtils.loginOrCheckAzure_NT(this.authCtx, this.infra.authConnection);
             AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"api_deployer", (String)this.deployment.id, (boolean)true);){
            AzureMLDeploymentSummary deployedSummary;
            AzureMLDeploymentSummary storedSummary;
            AzureMLDeploymentInfo lastDeploymentInfo = this.getOrBuildDeploymentInfo(azureMLClient);
            try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)"Retrieving resource information from AzureML");){
                storedSummary = AzureMLDeploymentSummary.AzureMLDeploymentSummaryBuilder.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), lastDeploymentInfo);
                deployedSummary = AzureMLDeploymentSummary.AzureMLDeploymentSummaryBuilder.buildFromRemoteConfig_NT(azureMLClient, lastDeploymentInfo);
            }
            FutureProgress.incrementState((double)1.0);
            if (!this.deployment.enabled) {
                String disabledMessage;
                if (StringUtils.isNotBlank((CharSequence)lastDeploymentInfo.azOnlineEndpointName)) {
                    String disablingMessage = String.format("Disabling deployment %s and removing AzureML Online Endpoint resource %s. The reference will be kept for the moment the deployment is re-enabled.", this.deployment.id, lastDeploymentInfo.azOnlineEndpointName);
                    logger.info((Object)disablingMessage);
                    logTailBuilder.appendLine(disablingMessage);
                    this.disableDeployment(azureMLClient, lastDeploymentInfo);
                } else {
                    disabledMessage = String.format("Disabling deployment %s. No AzureML Online Endpoint resource to remove.", this.deployment.id);
                    logger.info((Object)disabledMessage);
                    logTailBuilder.appendLine(disabledMessage);
                }
                FutureProgress.incrementState((double)1.0);
                disabledMessage = ret;
                return disabledMessage;
            }
            this.deployment.verifyPackageCompatibility(this.getPackageInfo_NT());
            AzureMLDeploymentSummary updatedSummary = new AzureMLDeploymentSummary(storedSummary.infraId, storedSummary.deploymentId, storedSummary.azSubscription, storedSummary.azResourceGroup, storedSummary.azWorkspace, storedSummary.azTenantId);
            this.checkPreconditions(deployedSummary);
            this.createDeployerKeyIfAuthorizationToQueryThroughDeployer(this.deployment, ret);
            File contextDir = this.apiDeployerImageBuilderService.prepareDockerImageContext(this.authCtx, this.infra, this.deployment, this.deployment.getTargetId(), (File)tmpDir);
            FutureProgress.incrementState((double)1.0);
            AzureMLConnection connection = (AzureMLConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.infra.authConnection);
            ProxySettings proxySettings = ExternalInfrasUtils.getProxy(connection);
            Map<String, String> additionalEnv = session.getSessionEnv();
            APIDeployerImageBuilderService.ImageNameTags imageNameTags = new APIDeployerImageBuilderService.ImageNameTags(this.infra, this.deployment, this.getVariablesContext());
            String buildMessage = "Building Docker image" + (DKUApp.isDataikuCloud() ? " and pushing it to registry" : "");
            try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)buildMessage);){
                if (DKUApp.isDataikuCloud()) {
                    this.apiDeployerImageBuilderService.executePrePushScript(this.authCtx, this.infra, imageNameTags, proxySettings, additionalEnv, logTailBuilder);
                    additionalEnv.putAll(this.apiDeployerImageBuilderService.getCraneAuthToken(this.infra.getRegistryHost(), additionalEnv));
                }
                this.apiDeployerImageBuilderService.buildDockerImage(this.infra, imageNameTags, logTailBuilder, this.rebuildCodeEnv, contextDir, additionalEnv);
            }
            FutureProgress.incrementState((double)1.0);
            if (!DKUApp.isDataikuCloud()) {
                ignored = FutureProgress.pushAutoCloseableState((String)"Pushing image to repository");
                try {
                    if (StringUtils.isBlank((CharSequence)this.getInfra().getRegistryHost())) {
                        throw ErrorContext.ice((String)"The 'Registry host' is not defined in the infrastructure settings.");
                    }
                    this.apiDeployerImageBuilderService.tagAndPushImage(this.authCtx, this.infra, logTailBuilder, imageNameTags, proxySettings, additionalEnv);
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            FutureProgress.incrementState((double)1.0);
            neverEverDeployed.remove(this.getDeployment().id);
            ignored = FutureProgress.pushAutoCloseableState((String)"Creating AzureML Model");
            try {
                AzureMLModel model;
                logTailBuilder.appendLine("Creating AzureML Model...");
                updatedSummary.model = model = this.createModel(session, (File)tmpDir);
                logTailBuilder.appendLine(String.format("AzureML Model created with name %s", model.name));
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            FutureProgress.incrementState((double)1.0);
            try {
                ignored = FutureProgress.pushAutoCloseableState((String)"Creating AzureML Environment");
                try {
                    AzureMLEnvironment environment;
                    logTailBuilder.appendLine("Creating AzureML Environment...");
                    updatedSummary.environment = environment = this.createEnvironment(session, (File)tmpDir, imageNameTags);
                    logTailBuilder.appendLine(String.format("AzureML Environment created with name %s", environment.name));
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            catch (Exception e) {
                this.rollbackModelIfNecessary(azureMLClient, deployedSummary.model, updatedSummary.model);
                throw e;
            }
            FutureProgress.incrementState((double)1.0);
            try {
                ignored = FutureProgress.pushAutoCloseableState((String)"Creating/Updating AzureML Online Endpoint");
                try {
                    AzureMLOnlineEndpoint onlineEndpoint;
                    logTailBuilder.appendLine("Creating/Updating AzureML Online Endpoint...");
                    updatedSummary.onlineEndpoint = onlineEndpoint = this.createOrUpdateOnlineEndpoint(session, (File)tmpDir, deployedSummary.onlineEndpoint, storedSummary.onlineEndpoint);
                    logTailBuilder.appendLine(String.format("AzureML Online Endpoint created/updated with name %s", onlineEndpoint.name));
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            catch (Exception e) {
                this.rollbackEnvironmentIfNecessary(azureMLClient, deployedSummary.environment, updatedSummary.environment);
                this.rollbackModelIfNecessary(azureMLClient, deployedSummary.model, updatedSummary.model);
                throw e;
            }
            FutureProgress.incrementState((double)1.0);
            try {
                ignored = FutureProgress.pushAutoCloseableState((String)"Creating/Updating AzureML Online Deployment");
                try {
                    AzureMLOnlineDeployment onlineDeployment;
                    logTailBuilder.appendLine("Creating/Updating AzureML Online Deployment...");
                    updatedSummary.onlineDeployment = onlineDeployment = this.createOrUpdateOnlineDeployment(session, (File)tmpDir, deployedSummary.onlineDeployment, storedSummary.onlineDeployment, updatedSummary);
                    logTailBuilder.appendLine(String.format("AzureML Online Deployment created/updated with name '%s' in Online Endpoint '%s'", onlineDeployment.name, onlineDeployment.endpointName));
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            catch (Exception e) {
                this.rollbackEndpointIfNecessary(azureMLClient, deployedSummary.onlineEndpoint, updatedSummary.onlineEndpoint);
                this.rollbackEnvironmentIfNecessary(azureMLClient, deployedSummary.environment, updatedSummary.environment);
                this.rollbackModelIfNecessary(azureMLClient, deployedSummary.model, updatedSummary.model);
                throw e;
            }
            FutureProgress.incrementState((double)1.0);
            ignored = FutureProgress.pushAutoCloseableState((String)"Saving changes");
            try {
                logTailBuilder.appendLine("Updating deployment changes...");
                try {
                    updatedSummary = AzureMLDeploymentSummary.AzureMLDeploymentSummaryBuilder.buildFromRemoteConfig_NT(azureMLClient, updatedSummary.asDeploymentInfo());
                }
                catch (Exception e) {
                    logger.error((Object)"Unable to retrieve the deployed resources. The SystemData neither latest provisioning State will be stored.", (Throwable)e);
                }
                this.deploymentInfoCRUDService.save(updatedSummary.asDeploymentInfo());
                logTailBuilder.appendLine(String.format("Changes saved for deployment with id %s.", this.deployment.id));
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            FutureProgress.incrementState((double)1.0);
            logger.debugV("AzureML deployment successfully created/updated with the following summary:%n%s", new Object[]{JSON.pretty((Object)updatedSummary)});
            ignored = FutureProgress.pushAutoCloseableState((String)"Cleaning previous deployment resources");
            try {
                logTailBuilder.appendLine("Cleaning resources from previous deployment...");
                this.cleanupPreviousResources(azureMLClient, deployedSummary, updatedSummary);
                logTailBuilder.appendLine(String.format("Successfully cleaned up previous deployment resources for deployment with id '%s'", this.deployment.id));
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            FutureProgress.incrementState((double)1.0);
        }
        return ret;
    }

    @Override
    public void deleteResources_NT() throws CodedException, IOException {
        AzureMLDeploymentInfo deploymentInfo = this.deploymentInfoCRUDService.get(this.deployment.infraId, this.deployment.id, AzureMLDeploymentInfo.class);
        try (AzureMLHttpClient azureMLClient = AzureMLUtils.getAzureMLClient_NT(this.authCtx, this.infra.authConnection, this.connectTimeout, this.socketTimeout);){
            if (!Objects.isNull(deploymentInfo)) {
                AzureMLResourceIdentifier onlineEndpointId = deploymentInfo.getOnlineEndpointIdentifier();
                this.deleteOnlineEndpointResource(azureMLClient, onlineEndpointId);
                AzureMLVersionedResourceIdentifier environmentId = deploymentInfo.getEnvironmentIdentifier();
                this.archiveEnvironmentResource(azureMLClient, environmentId);
                AzureMLVersionedResourceIdentifier modelId = deploymentInfo.getModelIdentifier();
                this.archiveModelResource(azureMLClient, modelId);
                this.deploymentInfoCRUDService.delete(this.deployment.infraId, this.deployment.id);
            }
        }
        catch (AzureMLUtils.AzureAuthenticationException e) {
            throw new CodedException(e.getCode(), "Error while trying to login into Azure.", (Throwable)e);
        }
        catch (DKUSecurityException e) {
            throw new CodedException((InfoMessage.MessageCode)(e.getCode() != null ? e.getCode() : DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_INVALID_CONNECTION), "Error while accessing connection details", (Throwable)e);
        }
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected AbstractFullyManagedAPIDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected AbstractFullyManagedAPIDeploymentInfra getInfra() {
        return this.infra;
    }

    @Override
    protected FullyManagedAPIServiceDeploymentConfigManager getConfigManager() {
        return this.deploymentConfigManager;
    }

    @Override
    protected int numberOfDeploymentSteps() {
        return this.deployment.enabled ? 10 : 2;
    }

    @Override
    @Nonnull
    protected String getInfraPrettyName() {
        return "AzureML";
    }

    @Override
    @Nonnull
    protected FuturePayload getDeploymentPayload() {
        return FuturePayload.newSimple((String)"sync_azureml_api_deployment", (String)("Sync AzureML deployment: " + this.deployment.id));
    }
}

