/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerDeploymentStatusReporter;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerDeploymentSummary;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerEndpoint;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerEndpointConfig;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerModel;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.comparator.SageMakerEndpointComparator;
import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.comparator.SageMakerEndpointConfigComparator;
import com.dataiku.dip.apideployer.datamodel.config.SageMakerAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.SageMakerDeploymentInfo;
import com.dataiku.dip.apideployer.deployments.APIDeployerImageBuilderService;
import com.dataiku.dip.apideployer.deployments.AbstractAPIServiceDockerDeploymentManager;
import com.dataiku.dip.apideployer.deployments.AbstractFullyManagedAPIServiceDeploymentManager;
import com.dataiku.dip.apideployer.deployments.SageMakerDeploymentConfigManager;
import com.dataiku.dip.apideployer.infra.AbstractInfrasService;
import com.dataiku.dip.connections.AWSCredentialsHelper;
import com.dataiku.dip.connections.SageMakerConnection;
import com.dataiku.dip.connections.aws.ShadedS3ConnectionAWSSessionCredentialsProviderV2;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.exception.SdkException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CreateModelRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.EndpointStatus;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.client.SageMakerLambdaAPIClient;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SageMakerDeploymentManager
extends AbstractFullyManagedAPIServiceDeploymentManager {
    private static final int DEFAULT_WAIT_TIME_BEFORE_HEAVY_STATUS_AFTER_SYNC_IN_SECONDS = 5;
    private static final String WAIT_TIME_BEFORE_HEAVY_STATUS_AFTER_SYNC_IN_SECONDS_CONFIG_KEY = "dku.deployer.deployment.sagemaker.manager.waitTimeBeforeHeavyStatusAfterSyncInSeconds";
    private final SageMakerAPIDeployment deployment;
    private final SageMakerAPIDeploymentInfra infra;
    private final SageMakerDeploymentConfigManager deploymentConfigManager;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.sagemaker.manager");

    public SageMakerDeploymentManager(AuthCtx authCtx, SageMakerAPIDeployment deployment, SageMakerAPIDeploymentInfra infra, int connectTimeout, int socketTimeout) {
        super(authCtx, connectTimeout, socketTimeout);
        this.deployment = (SageMakerAPIDeployment)JSON.deepCopy((Object)deployment);
        this.deployment.overrideSettings.applyToDeployment(this.deployment, infra);
        this.infra = infra;
        SpringUtils.getInstance().autowire((Object)this);
        this.deploymentConfigManager = new SageMakerDeploymentConfigManager(this.deployment, this.infra, this.getVariablesContext());
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected SageMakerAPIDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected SageMakerAPIDeploymentInfra getInfra() {
        return this.infra;
    }

    @Override
    protected int numberOfDeploymentSteps() {
        return this.deployment.enabled ? 8 : 1;
    }

    @Override
    @Nonnull
    protected FuturePayload getDeploymentPayload() {
        return FuturePayload.newSimple((String)"sync_sagemaker_api_deployment", (String)("Sync SageMaker deployment: " + this.deployment.id));
    }

    @Override
    @Nonnull
    protected String getInfraPrettyName() {
        return "SageMaker";
    }

    @Override
    protected void postDeploymentActions(@Nonnull AbstractAPIServiceDockerDeploymentManager.DockerBasedDeploymentReport report) throws InterruptedException {
        super.postDeploymentActions(report);
        if (report.syncReport == null) {
            logger.debug((Object)"Deployment failed before sync phase, not waiting before ending the deployment.");
        } else {
            try (FutureProgress.AutocloseableFutureProgressState fps2 = FutureProgress.pushAutoCloseableState((String)"Fetching status");){
                Params p = DKUApp.getParams();
                long waitTimeBeforeHeavyStatusInSec = p.getLongParam(WAIT_TIME_BEFORE_HEAVY_STATUS_AFTER_SYNC_IN_SECONDS_CONFIG_KEY, 5L);
                Thread.sleep(waitTimeBeforeHeavyStatusInSec * 1000L);
            }
        }
    }

    @Override
    protected SageMakerDeploymentConfigManager getConfigManager() {
        return this.deploymentConfigManager;
    }

    @Override
    protected SageMakerDeploymentStatusReporter getDeploymentStatusReporter() {
        return new SageMakerDeploymentStatusReporter(this.deployment.id, this.deployment.infraId);
    }

    @Override
    public BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(String deployedServiceId, APIServiceDeploymentHeavyStatus.EndpointSummary endpoint, AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus lightStatus, APIServiceDeploymentHeavyStatus heavyStatus, List<ApiEndpointQuery> allQueries, boolean forTest) throws IOException, DKUSecurityException {
        SageMakerDeploymentInfo sageMakerDeploymentInfo = this.getOrBuildDeploymentInfo(this.infra, this.deployment);
        return SageMakerLambdaAPIClient.runQueries_NT(this.authCtx, this.infra, sageMakerDeploymentInfo.awsRegion, sageMakerDeploymentInfo.sageMakerEndpointName, endpoint, allQueries, forTest);
    }

    private SageMakerModel createModel(SageMakerClient sageMakerClient, SageMakerDeploymentSummary deployedSummary, APIDeployerImageBuilderService.ImageNameTags imageNameTags) {
        logger.debugV("Recreating a new model.", new Object[0]);
        String modelName = this.deploymentConfigManager.generateResourceName();
        String containerImageUri = this.infra.getImageAliasInRegistryHost(imageNameTags.imageName, imageNameTags.imageVersion);
        SageMakerModel newSageMakerModel = SageMakerModel.SageMakerModelBuilder.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), modelName, containerImageUri);
        CreateModelRequest createModelRequest = newSageMakerModel.createCreateModelRequest();
        SageMakerUtils.createModel_NT(sageMakerClient, createModelRequest);
        deployedSummary.refreshModel_NT(sageMakerClient, modelName);
        return deployedSummary.model;
    }

    private SageMakerEndpointConfig createOrUpdateEndpointConfig(SageMakerClient sageMakerClient, SageMakerDeploymentSummary deployedSummary, SageMakerDeploymentSummary storedSummary) throws IOException, DKUSecurityException {
        boolean shallCreateMissing;
        String endpointConfigName = storedSummary.endpointConfig.name;
        SageMakerEndpointConfig deployedEndpointConfig = deployedSummary.endpointConfig;
        SageMakerEndpoint deployedEndpoint = deployedSummary.endpoint;
        SageMakerEndpointConfig storedEndpointConfig = storedSummary.endpointConfig;
        SageMakerEndpoint storedEndpoint = storedSummary.endpoint;
        SageMakerEndpointConfigComparator endpointConfigComparator = new SageMakerEndpointConfigComparator(storedEndpointConfig);
        boolean isEndpointConfigOutOfSync = endpointConfigComparator.isOutOfSync(deployedEndpointConfig, deployedSummary.model);
        SageMakerEndpointComparator endpointComparator = new SageMakerEndpointComparator(storedEndpoint);
        boolean isEndpointOutOfSync = endpointComparator.isOutOfSync(deployedEndpoint, deployedEndpointConfig);
        boolean isUpdate = deployedEndpointConfig.resourceShouldExist && deployedEndpointConfig.resourceDescription.isPresent() && !isEndpointConfigOutOfSync && !isEndpointOutOfSync;
        boolean bl = shallCreateMissing = !deployedEndpointConfig.resourceDescription.isPresent() && deployedEndpointConfig.resourceShouldExist && deployedEndpoint.resourceDescription.isPresent() && ((DescribeEndpointResponse)deployedEndpoint.resourceDescription.get()).endpointConfigName().equals(endpointConfigName);
        if (isUpdate) {
            try {
                DescribeEndpointConfigResponse describeEndpointConfig = (DescribeEndpointConfigResponse)deployedEndpointConfig.resourceDescription.get();
                logger.debugV("Settings have not changed for endpoint configuration %s.", new Object[]{endpointConfigName});
                if (endpointConfigComparator.areTagsOutOfSync(deployedEndpointConfig.tags)) {
                    logger.debugV("Tags for endpoint configuration %s are out of sync. Updating tags...", new Object[]{endpointConfigName});
                    SageMakerUtils.updateTags_NT(sageMakerClient, describeEndpointConfig.endpointConfigArn(), storedEndpointConfig.getSageMakerTags());
                    logger.debugV("SageMaker endpoint configuration %s successfully updated.", new Object[]{endpointConfigName});
                }
                logger.debugV("Nothing to update in endpoint configuration %s.", new Object[]{endpointConfigName});
            }
            catch (SdkException e) {
                logger.errorV("Error while updating tags for SageMaker Endpoint config %s.", new Object[]{endpointConfigName});
                throw e;
            }
        } else {
            if (shallCreateMissing) {
                logger.debugV("Endpoint config %s used in the endpoint is supposed to exist but is missing. Creating it again to ensure the correct update of the endpoint.", new Object[]{endpointConfigName});
                SageMakerEndpointConfig missingEndpointConfig = SageMakerEndpointConfig.SageMakerEndpointConfigBuilder.buildFromLocalConfig(this.authCtx, this.deployment, this.infra, this.getVariablesContext(), endpointConfigName, deployedSummary.model.name);
                CreateEndpointConfigRequest createEndpointConfigRequestMissing = missingEndpointConfig.createCreateEndpointConfigRequest();
                SageMakerUtils.createEndpointConfig_NT(sageMakerClient, createEndpointConfigRequestMissing);
            }
            endpointConfigName = this.deploymentConfigManager.generateResourceName();
            SageMakerEndpointConfig newEndpointConfig = SageMakerEndpointConfig.SageMakerEndpointConfigBuilder.buildFromLocalConfig(this.authCtx, this.deployment, this.infra, this.getVariablesContext(), endpointConfigName, deployedSummary.model.name);
            CreateEndpointConfigRequest createEndpointConfigRequestNew = newEndpointConfig.createCreateEndpointConfigRequest();
            SageMakerUtils.createEndpointConfig_NT(sageMakerClient, createEndpointConfigRequestNew);
        }
        deployedSummary.refreshEndpointConfig_NT(sageMakerClient, endpointConfigName);
        return deployedSummary.endpointConfig;
    }

    private void rollbackSageMakerModelIfNecessary(SageMakerClient sageMakerClient, String sageMakerModelName, String previousSageMakerModelName) {
        try {
            if (StringUtils.isNotBlank((String)sageMakerModelName) && !sageMakerModelName.equals(previousSageMakerModelName)) {
                logger.debugV("Rolling back previously created model %s", new Object[]{sageMakerModelName});
                SageMakerUtils.deleteCheckSageMakerModel_NT(sageMakerClient, sageMakerModelName);
                logger.debug((Object)"SageMaker model rollback successful.");
            }
        }
        catch (SdkException rollbackException) {
            logger.errorV((Throwable)rollbackException, "Error rolling back previously created model %s", new Object[]{sageMakerModelName});
        }
    }

    private SageMakerEndpoint createOrUpdateEndpoint(SageMakerClient sageMakerClient, SageMakerDeploymentSummary deployedSummary, SageMakerDeploymentSummary storedSummary) {
        boolean isUpdate;
        String modelName = deployedSummary.model.name;
        String endpointConfigName = deployedSummary.endpointConfig.name;
        String endpointName = deployedSummary.endpoint.name;
        SageMakerEndpoint deployedEndpoint = deployedSummary.endpoint;
        SageMakerEndpoint storedEndpoint = storedSummary.endpoint;
        SageMakerEndpointComparator endpointComparator = new SageMakerEndpointComparator(storedEndpoint);
        boolean bl = isUpdate = deployedEndpoint.resourceShouldExist && deployedEndpoint.resourceDescription.isPresent();
        if (isUpdate) {
            try {
                DescribeEndpointResponse deployedEndpointDescription = (DescribeEndpointResponse)deployedEndpoint.resourceDescription.get();
                if (endpointComparator.isOutOfSync(deployedEndpoint, deployedSummary.endpointConfig)) {
                    SageMakerEndpoint endpointToUpdate = SageMakerEndpoint.SageMakerEndpointBuilder.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), endpointName, endpointConfigName, modelName);
                    UpdateEndpointRequest updateEndpointRequest = endpointToUpdate.createUpdateEndpointRequest();
                    SageMakerUtils.updateEndpoint_NT(sageMakerClient, updateEndpointRequest);
                }
                SageMakerUtils.updateTags_NT(sageMakerClient, deployedEndpointDescription.endpointArn(), storedEndpoint.getSageMakerTags());
            }
            catch (SdkException e) {
                logger.errorV("Error while updating SageMaker endpoint %s.", new Object[]{endpointName});
                throw e;
            }
        } else {
            endpointName = deployedEndpoint.resourceShouldExist ? deployedEndpoint.name : (StringUtils.isNotBlank((String)this.deployment.getCustomEndpointName(this.infra)) ? this.deployment.getCustomEndpointName(this.infra) : this.deploymentConfigManager.generateResourceName());
            SageMakerEndpoint newEndpoint = SageMakerEndpoint.SageMakerEndpointBuilder.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), endpointName, endpointConfigName, modelName);
            CreateEndpointRequest createEndpointRequest = newEndpoint.createCreateEndpointRequest();
            SageMakerUtils.createEndpoint_NT(sageMakerClient, createEndpointRequest);
        }
        deployedSummary.refreshEndpoint_NT(sageMakerClient, endpointName);
        return deployedSummary.endpoint;
    }

    private void rollbackSageMakerEndpointConfigIfNecessary(SageMakerClient sageMakerClient, String endpointConfigName, String previousEndpointConfigName) {
        try {
            if (StringUtils.isNotBlank((String)endpointConfigName) && !endpointConfigName.equals(previousEndpointConfigName)) {
                logger.debugV("Rolling back previously created Endpoint Config %s", new Object[]{endpointConfigName});
                SageMakerUtils.deleteCheckEndpointConfig_NT(sageMakerClient, endpointConfigName);
                logger.debug((Object)"Endpoint Config rollback successful.");
            }
        }
        catch (SdkException rollbackException) {
            logger.errorV((Throwable)rollbackException, "Error rolling back previously created Endpoint Config %s", new Object[]{endpointConfigName});
        }
    }

    private void checkPreconditions(SageMakerDeploymentSummary deployedSummary) throws CodedException {
        SageMakerEndpoint endpoint = deployedSummary.endpoint;
        if (endpoint.resourceShouldExist) {
            if (endpoint.resourceDescription.isPresent()) {
                logger.debugV("Endpoint %s exists in SageMaker.", new Object[]{endpoint.name});
                EndpointStatus endpointStatus = ((DescribeEndpointResponse)endpoint.resourceDescription.get()).endpointStatus();
                if (EndpointStatus.FAILED.equals((Object)endpointStatus)) {
                    throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SAGEMAKER_ENDPOINT_FATAL_ERROR, String.format("The SageMaker endpoint is in the state '%s' and cannot be recovered.", endpointStatus));
                }
                if (!EndpointStatus.IN_SERVICE.equals((Object)endpointStatus)) {
                    throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SAGEMAKER_INCOMPATIBLE_STATE_FOR_ACTION_ENDPOINT, String.format("The SageMaker endpoint is not ready to be updated since it is in the state '%s'. Wait until the deployment is '%s' or '%s'", endpointStatus, EndpointStatus.IN_SERVICE.toString(), EndpointStatus.FAILED.toString()));
                }
            } else {
                logger.warnV("Endpoint '%s' is not present in SageMaker. Updating the deployment should create it.", new Object[]{endpoint.name});
            }
        }
    }

    private void deleteEndpointResource(SageMakerClient sageMakerClient, String endpointName, @Nullable DKUtils.SmartLogTailBuilder logTailBuilder) throws CodedException {
        if (StringUtils.isBlank((String)endpointName)) {
            String noDeleteMessage = "No endpoint resource to delete.";
            logger.info((Object)noDeleteMessage);
            if (logTailBuilder != null) {
                logTailBuilder.appendLine(noDeleteMessage);
            }
            return;
        }
        try {
            if (logTailBuilder != null) {
                logTailBuilder.appendLine("Deleting SageMaker endpoint with name " + endpointName);
            }
            SageMakerUtils.deleteCheckEndpoint_NT(sageMakerClient, endpointName);
            if (logTailBuilder != null) {
                logTailBuilder.appendLine("Endpoint " + endpointName + " deleted.");
            }
        }
        catch (Exception e) {
            String message = String.format("Error deleting SageMaker Endpoint '%s' associated to the deployment '%s'.", endpointName, this.deployment.id);
            if (logTailBuilder != null) {
                logTailBuilder.appendLine(message);
            }
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DELETE_RESOURCE, message + " " + e.getMessage());
        }
    }

    private void deleteEndpointConfigResource(SageMakerClient sageMakerClient, String endpointConfigName) throws CodedException {
        if (StringUtils.isBlank((String)endpointConfigName)) {
            logger.info((Object)"No endpoint config resource to delete.");
            return;
        }
        try {
            SageMakerUtils.deleteCheckEndpointConfig_NT(sageMakerClient, endpointConfigName);
        }
        catch (Exception e) {
            String message = String.format("Error deleting SageMaker Endpoint config '%s' associated to the deployment '%s'.", endpointConfigName, this.deployment.id);
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DELETE_RESOURCE, message + " " + e.getMessage());
        }
    }

    private void deleteModelResource(SageMakerClient sageMakerClient, String modelName) throws CodedException {
        if (StringUtils.isBlank((String)modelName)) {
            logger.info((Object)"No model resource to delete.");
            return;
        }
        try {
            SageMakerUtils.deleteCheckSageMakerModel_NT(sageMakerClient, modelName);
        }
        catch (Exception e) {
            String message = String.format("Error deleting SageMaker Model '%s' associated to the deployment '%s'.", modelName, this.deployment.id);
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DELETE_RESOURCE, message + " " + e.getMessage());
        }
    }

    private void disableDeployment(SageMakerClient sageMakerClient, SageMakerDeploymentInfo deploymentInfo, DKUtils.SmartLogTailBuilder logTailBuilder) throws CodedException {
        String disablingMessage = String.format("Deployment %s disabled, removing SageMaker Endpoint resource.", this.deployment.id);
        logger.info((Object)disablingMessage);
        logTailBuilder.appendLine(disablingMessage);
        this.deleteEndpointResource(sageMakerClient, deploymentInfo.sageMakerEndpointName, logTailBuilder);
        if (StringUtils.isNotBlank((String)deploymentInfo.sageMakerEndpointName)) {
            String disabledMessage = String.format("SageMaker Endpoint resource %s deleted but keeping the reference for the moment the deployment is re-enabled.", deploymentInfo.sageMakerEndpointName);
            logger.info((Object)disabledMessage);
            logTailBuilder.appendLine(disabledMessage);
        }
    }

    private SageMakerDeploymentInfo getOrBuildDeploymentInfo(SageMakerAPIDeploymentInfra infra, SageMakerAPIDeployment deployment) throws IOException {
        SageMakerDeploymentInfo storedDeploymentInfo = this.deploymentInfoCRUDService.get(infra.id, deployment.id, SageMakerDeploymentInfo.class);
        if (!Objects.isNull(storedDeploymentInfo)) {
            return storedDeploymentInfo;
        }
        logger.debugV("Stored deployment info for infra=%s and deployment=%s not found. Building it from infra and deployment config.", new Object[]{infra.id, deployment.id});
        return new SageMakerDeploymentInfo(infra.id, deployment.id, infra.awsRegion, "", "", "", "", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected InfoMessage.InfoMessages doDeployment(@Nonnull DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        logger.infoV("Prepare sync of deployment %s", new Object[]{this.deployment.id});
        logger.info((Object)"Summary of the DSS resources used to update the deployment:");
        logger.infoV("SageMaker infra: %s", new Object[]{JSON.json((Object)this.infra)});
        logger.infoV("SageMaker deployment: %s", new Object[]{JSON.json((Object)this.deployment)});
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"api_deployer", (String)this.deployment.id, (boolean)true);){
            SageMakerDeploymentInfo lastDeploymentInfo = this.getOrBuildDeploymentInfo(this.infra, this.deployment);
            SageMakerClient sageMakerClient = SageMakerUtils.checkAndLoginSageMaker_NT(this.authCtx, this.infra.authConnection, lastDeploymentInfo.awsRegion, this.connectTimeout, this.socketTimeout);
            if (!this.deployment.enabled) {
                this.disableDeployment(sageMakerClient, lastDeploymentInfo, logTailBuilder);
                FutureProgress.incrementState((double)1.0);
                InfoMessage.InfoMessages infoMessages = ret;
                return infoMessages;
            }
            this.deployment.verifyPackageCompatibility(this.getPackageInfo_NT());
            SageMakerDeploymentSummary storedSummary = SageMakerDeploymentSummary.SageMakerDeploymentSummaryBuilder.buildFromLocalConfig(this.authCtx, this.deployment, this.infra, this.getVariablesContext(), lastDeploymentInfo);
            SageMakerDeploymentSummary deployedSummary = SageMakerDeploymentSummary.SageMakerDeploymentSummaryBuilder.buildFromRemoteConfig_NT(sageMakerClient, lastDeploymentInfo);
            this.checkPreconditions(deployedSummary);
            this.createDeployerKeyIfAuthorizationToQueryThroughDeployer(this.deployment, ret);
            File contextDir = this.apiDeployerImageBuilderService.prepareDockerImageContext(this.authCtx, this.infra, this.deployment, this.deployment.getTargetId(), (File)tmpDir);
            SageMakerConnection authConnection = (SageMakerConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.infra.authConnection);
            AwsCredentials credentials = Objects.nonNull(authConnection) ? new ShadedS3ConnectionAWSSessionCredentialsProviderV2(this.authCtx, authConnection).resolveCredentials() : AWSCredentialsHelper.getCredentialsFromEnvironment().toAWSCredentials();
            ProxySettings proxySettings = ExternalInfrasUtils.getProxy(authConnection);
            HashMap<String, String> proxyVariables = new HashMap<String, String>();
            if (proxySettings.hasProxy()) {
                logger.infoV("Setting HTTP_PROXY and HTTPS_PROXY according to global proxy settings", new Object[0]);
                String proxy = proxySettings.getAsString();
                proxyVariables.put("HTTP_PROXY", proxy);
                proxyVariables.put("HTTPS_PROXY", proxy);
            }
            HashMap<String, String> prePushVariables = new HashMap<String, String>(proxyVariables);
            HashMap<String, String> buildVariables = new HashMap<String, String>(proxyVariables);
            AWSCredentialsHelper.toEnv(credentials, prePushVariables, lastDeploymentInfo.awsRegion);
            FutureProgress.incrementState((double)1.0);
            APIDeployerImageBuilderService.ImageNameTags imageNameTags = new APIDeployerImageBuilderService.ImageNameTags(this.infra, this.deployment, this.getVariablesContext());
            String buildMessage = "Building Docker image" + (DKUApp.isDataikuCloud() ? " and pushing it to registry" : "");
            try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)buildMessage);){
                if (DKUApp.isDataikuCloud()) {
                    this.apiDeployerImageBuilderService.executePrePushScript(this.authCtx, this.infra, imageNameTags, proxySettings, prePushVariables, logTailBuilder);
                    buildVariables.putAll(this.apiDeployerImageBuilderService.getCraneAuthToken(this.infra.getRegistryHost(), proxyVariables));
                }
                this.apiDeployerImageBuilderService.buildDockerImage(this.infra, imageNameTags, logTailBuilder, this.rebuildCodeEnv, contextDir, buildVariables);
            }
            FutureProgress.incrementState((double)1.0);
            if (!DKUApp.isDataikuCloud()) {
                ignored = FutureProgress.pushAutoCloseableState((String)"Pushing image to repository");
                try {
                    if (StringUtils.isBlank((String)this.getInfra().getRegistryHost())) {
                        throw ErrorContext.ice((String)"The 'Registry host' is not defined in the infrastructure settings.");
                    }
                    this.apiDeployerImageBuilderService.tagAndPushImage(this.authCtx, this.infra, logTailBuilder, imageNameTags, proxySettings, prePushVariables);
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            FutureProgress.incrementState((double)1.0);
            neverEverDeployed.remove(this.getDeployment().id);
            try {
                SageMakerEndpoint endpointDetails;
                FutureProgress.AutocloseableFutureProgressState ignored;
                ignored = FutureProgress.pushAutoCloseableState((String)"Creating SageMaker model");
                try {
                    logTailBuilder.appendLine("Creating SageMaker model...");
                    SageMakerModel model = this.createModel(sageMakerClient, deployedSummary, imageNameTags);
                    logTailBuilder.appendLine(String.format("SageMaker model created with name %s", model.name));
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
                FutureProgress.incrementState((double)1.0);
                try {
                    ignored = FutureProgress.pushAutoCloseableState((String)"Creating SageMaker Endpoint Configuration");
                    try {
                        logTailBuilder.appendLine("Creating/Updating SageMaker Endpoint Configuration...");
                        SageMakerEndpointConfig endpointConfig = this.createOrUpdateEndpointConfig(sageMakerClient, deployedSummary, storedSummary);
                        logTailBuilder.appendLine(String.format("SageMaker Endpoint Configuration created/updated with name %s", endpointConfig.name));
                    }
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                catch (SdkException e) {
                    this.rollbackSageMakerModelIfNecessary(sageMakerClient, deployedSummary.model.name, lastDeploymentInfo.sageMakerModelName);
                    throw e;
                }
                FutureProgress.incrementState((double)1.0);
                try {
                    ignored = FutureProgress.pushAutoCloseableState((String)"Creating SageMaker Endpoint");
                    try {
                        logTailBuilder.appendLine("Creating/Updating SageMaker Endpoint...");
                        endpointDetails = this.createOrUpdateEndpoint(sageMakerClient, deployedSummary, storedSummary);
                        logTailBuilder.appendLine(String.format("SageMaker Endpoint created/updated with name %s", endpointDetails.name));
                    }
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                catch (SdkException e) {
                    this.rollbackSageMakerEndpointConfigIfNecessary(sageMakerClient, deployedSummary.endpointConfig.name, lastDeploymentInfo.sageMakerEndpointConfigName);
                    this.rollbackSageMakerModelIfNecessary(sageMakerClient, deployedSummary.model.name, lastDeploymentInfo.sageMakerModelName);
                    throw e;
                }
                FutureProgress.incrementState((double)1.0);
                ignored = FutureProgress.pushAutoCloseableState((String)"Waiting for SageMaker Endpoint to be ready");
                try {
                    logTailBuilder.appendLine("Waiting for SageMaker Endpoint to be ready...");
                    String finalEndpointStatus = SageMakerUtils.awaitEndpointCreationResult_NT(sageMakerClient, endpointDetails.name);
                    deployedSummary.refreshEndpoint_NT(sageMakerClient, deployedSummary.endpoint.name);
                    ret.mergeFrom((InfoMessage.InfoMessages)SageMakerUtils.getEndpointHealth((String)finalEndpointStatus, null).second);
                    logTailBuilder.appendLine(String.format("SageMaker endpoint creation/update finished: '%s'", endpointDetails.name));
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
                FutureProgress.incrementState((double)1.0);
                ignored = FutureProgress.pushAutoCloseableState((String)"Saving changes");
                try {
                    logTailBuilder.appendLine("Updating deployment changes...");
                    this.deploymentInfoCRUDService.save(deployedSummary.asDeploymentInfo());
                    logTailBuilder.appendLine(String.format("Changes saved for deployment with id %s.", this.deployment.id));
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
                FutureProgress.incrementState((double)1.0);
                logger.debugV("SageMaker deployment successfully created/updated with the following summary:%n%s", new Object[]{JSON.pretty((Object)deployedSummary)});
            }
            finally {
                if (sageMakerClient != null) {
                    logger.debug((Object)"Closing SageMaker client.");
                    sageMakerClient.close();
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentStatusReport getFullCheckReport_NT() throws IOException, DKUSecurityException {
        SageMakerClient sageMakerClient;
        SageMakerDeploymentInfo lastDeploymentInfo = this.getOrBuildDeploymentInfo(this.infra, this.deployment);
        try {
            sageMakerClient = SageMakerUtils.loginSageMaker_NT(this.authCtx, this.infra.authConnection, lastDeploymentInfo.awsRegion, this.connectTimeout, this.socketTimeout);
        }
        catch (SdkException e) {
            logger.error((Object)"Error while trying to login into AWS.", (Throwable)e);
            throw e;
        }
        try {
            SageMakerDeploymentSummary deployedSummary = SageMakerDeploymentSummary.SageMakerDeploymentSummaryBuilder.buildFromRemoteConfig_NT(sageMakerClient, lastDeploymentInfo);
            SageMakerDeploymentSummary storedSummary = SageMakerDeploymentSummary.SageMakerDeploymentSummaryBuilder.buildFromLocalConfig(this.authCtx, this.deployment, this.infra, this.getVariablesContext(), lastDeploymentInfo);
            DeploymentStatusReport deploymentStatusReport = this.getDeploymentStatusReporter().computeFullCheck(storedSummary, deployedSummary, this.deployment.enabled);
            return deploymentStatusReport;
        }
        finally {
            if (sageMakerClient != null) {
                logger.debug((Object)"Closing SageMaker client.");
                sageMakerClient.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SageMakerDeploymentHeavyStatus getStatus_Unsafe_NT(boolean withPackageExtraInfo, @Nullable String overridingConnectionName) throws DKUSecurityException, IOException {
        SageMakerEndpoint deployedEndpoint;
        SageMakerClient sageMakerClient;
        SageMakerDeploymentHeavyStatus status = new SageMakerDeploymentHeavyStatus(this.deployment.id, this.deployment.infraId);
        status.packages = this.publishedAPIServicesService.listPublishedPackages_Check_Unsafe_NT(this.deployment.publishedServiceId, this.authCtx);
        SageMakerDeploymentInfo lastDeploymentInfo = this.getOrBuildDeploymentInfo(this.infra, this.deployment);
        String usedConnection = overridingConnectionName != null ? overridingConnectionName : this.infra.authConnection;
        try {
            sageMakerClient = SageMakerUtils.loginSageMaker_NT(this.authCtx, usedConnection, lastDeploymentInfo.awsRegion, this.connectTimeout, this.socketTimeout);
        }
        catch (SdkException e) {
            logger.error((Object)"Error while trying to login into AWS.", (Throwable)e);
            status.setMessageAndHealthWithSeverity(InfoMessage.error((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SAGEMAKER_LOGIN_FAILED, (String)"Cannot login into AWS."), DeploymentHealth.ERROR);
            return status;
        }
        try {
            deployedEndpoint = SageMakerEndpoint.SageMakerEndpointBuilder.buildFromRemoteConfig_NT(sageMakerClient, lastDeploymentInfo.sageMakerEndpointName);
        }
        catch (SdkException e) {
            String message = "Unable to retrieve deployment status. Error is: " + e.getLocalizedMessage();
            logger.error((Object)message, (Throwable)e);
            status.setMessageAndHealthWithSeverity(InfoMessage.error((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SAGEMAKER_DEPLOYMENT_RETRIEVAL, (String)message), DeploymentHealth.ERROR);
            SageMakerDeploymentHeavyStatus sageMakerDeploymentHeavyStatus = status;
            return sageMakerDeploymentHeavyStatus;
        }
        finally {
            if (sageMakerClient != null) {
                logger.debug((Object)"Closing SageMaker client.");
                sageMakerClient.close();
            }
        }
        status.endpoints = status.summarizeEndpoints_NT(this.deployment, withPackageExtraInfo);
        status.checkEndpointHealth(deployedEndpoint, this.deployment.enabled);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteResources_NT() throws CodedException, IOException {
        SageMakerDeploymentInfo lastDeploymentInfo = this.deploymentInfoCRUDService.get(this.infra.id, this.deployment.id, SageMakerDeploymentInfo.class);
        if (!Objects.isNull(lastDeploymentInfo)) {
            SageMakerClient sageMakerClient;
            try {
                sageMakerClient = SageMakerUtils.loginSageMaker_NT(this.authCtx, this.infra.authConnection, lastDeploymentInfo.awsRegion, this.connectTimeout, this.socketTimeout);
            }
            catch (DKUSecurityException | SdkException | IOException e) {
                String message = "Error while trying to login into AWS.";
                logger.error((Object)message, e);
                throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SAGEMAKER_LOGIN_FAILED, message, e);
            }
            try {
                this.deleteEndpointResource(sageMakerClient, lastDeploymentInfo.sageMakerEndpointName, null);
                this.deleteEndpointConfigResource(sageMakerClient, lastDeploymentInfo.sageMakerEndpointConfigName);
                this.deleteModelResource(sageMakerClient, lastDeploymentInfo.sageMakerModelName);
                this.deploymentInfoCRUDService.delete(this.deployment.infraId, this.deployment.id);
            }
            finally {
                if (sageMakerClient != null) {
                    logger.debug((Object)"Closing SageMaker client.");
                    sageMakerClient.close();
                }
            }
        }
    }

    @Override
    protected String diagnosisInternal(File tmpDir, String fileFriendlyLocalNow, FutureThreadBase<?> future) throws Exception {
        JsonObject awsVersion;
        SageMakerClient sageMakerClient;
        logger.infoV("Generating diagnostic of  %s...", new Object[]{this.deployment.id});
        SageMakerDeploymentInfo deploymentInfo = this.getOrBuildDeploymentInfo(this.infra, this.deployment);
        try {
            sageMakerClient = SageMakerUtils.loginSageMaker_NT(this.authCtx, this.infra.authConnection, deploymentInfo.awsRegion, this.connectTimeout, this.socketTimeout);
        }
        catch (SdkException e) {
            logger.error((Object)"Error while trying to login into AWS.", (Throwable)e);
            throw e;
        }
        JSON.prettyToFile((Object)this.deployment, (File)new File(tmpDir, "deployment.json"));
        JSON.prettyToFile((Object)deploymentInfo, (File)new File(tmpDir, "deployment-info.json"));
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.infoV("Diagnosis requested by a user with admin permissions on infra. Including %s configuration file.", new Object[]{"infra.json"});
            JSON.prettyToFile((Object)this.infra, (File)new File(tmpDir, "infra.json"));
        } else {
            logger.infoV("Diagnosis requested by a user without admin permissions on infra. Not including configuration file %s.", new Object[]{"infra.json"});
        }
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        logger.info((Object)"Fetch summaries of SageMaker resources");
        SageMakerDeploymentSummary localSummary = SageMakerDeploymentSummary.SageMakerDeploymentSummaryBuilder.buildFromLocalConfig(this.authCtx, this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
        SageMakerDeploymentSummary remoteSummary = SageMakerDeploymentSummary.SageMakerDeploymentSummaryBuilder.buildFromRemoteConfig_NT(sageMakerClient, deploymentInfo);
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.info((Object)"Diagnosis requested by a user with admin permissions on infra. Including local and remote summary files.");
            JSON.prettyToFile((Object)localSummary, (File)new File(tmpDir, "local-summary.json"));
            JSON.prettyToFile((Object)remoteSummary, (File)new File(tmpDir, "remote-summary.json"));
        } else {
            logger.info((Object)"Diagnosis requested by a user without admin permissions on infra. Not including local and remote summary files.");
        }
        DeploymentStatusReport statusReport = this.getDeploymentStatusReporter().computeFullCheck(localSummary, remoteSummary, this.deployment.enabled);
        JSON.prettyToFile((Object)statusReport, (File)new File(tmpDir, "status-report.json"));
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        logger.info((Object)"Fetch versions");
        JsonObject versions = new JsonObject();
        versions.addProperty("dss-version", DKUApp.getDSSVersion().product_version);
        DKUtils.ExecutionResults cmdResult = DKUtils.execAndGetOutputAndErrors((String[])new String[]{"aws", "--version"}, System.getenv());
        if (cmdResult.rv != 0) {
            awsVersion = new JsonObject();
            awsVersion.addProperty("error", cmdResult.err);
            logger.warn((Object)("Failed to get aws CLI version: " + JSON.json((Object)cmdResult)));
        } else {
            awsVersion = new JsonObject();
            awsVersion.addProperty("version", cmdResult.out);
        }
        versions.add("aws-cli-versions", (JsonElement)awsVersion);
        JSON.prettyToFile((Object)versions, (File)new File(tmpDir, "versions.json"));
        FutureProgress.incrementState((double)1.0);
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.info((Object)"User has infra admin permissions ; adding deployment logs");
            File logsDir = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{"deployment-logs"});
            DKUFileUtils.mkdirs((File)logsDir);
            for (Path path : this.apiServiceDeploymentsService.listLogFiles(this.deployment)) {
                FileUtils.copyFileToDirectory((File)path.toFile(), (File)logsDir);
            }
        } else {
            logger.info((Object)"User does not have infra admin permissions ; not adding deployment logs");
        }
        return tmpDir.getName();
    }
}

