/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.apideployer.datamodel.actual.StaticDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.datamodel.config.StaticAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.StaticDeployment;
import com.dataiku.dip.apideployer.deployments.APINodeDeploymentQuerier;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentHelper;
import com.dataiku.dip.apideployer.deployments.AbstractAPIServiceDeploymentManager;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.filters.RoutingKeyFiltering;
import com.dataiku.dip.filters.TopicsFiltering;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.audit.model.AuditTrailTargetSettings;
import com.dataiku.dip.security.audit.model.EventServerTargetSettings;
import com.dataiku.dip.security.audit.model.FsLikeTargetSettings;
import com.dataiku.dip.security.audit.model.KafkaTargetSettings;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.HashUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.client.LambdaAdminAPIClient;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceGenTag;
import com.dataiku.lambda.model.serverconfig.ServiceSummaryState;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SingleStaticDeploymentManager
extends AbstractAPIServiceDeploymentManager<PrepareAndSyncReport> {
    public boolean forceRefresh;
    public boolean withPrepare = true;
    private final StaticDeployment deployment;
    private final StaticAPIDeploymentInfra infra;
    private final String apiNodeQueryTopic = "apinode-query";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.static.manager");

    public SingleStaticDeploymentManager(AuthCtx authCtx, StaticDeployment deployment, StaticAPIDeploymentInfra infra, int connectTimeout, int socketTimeout) {
        super(authCtx, connectTimeout, socketTimeout);
        this.deployment = (StaticDeployment)JSON.deepCopy((Object)deployment);
        this.deployment.overrideSettings.applyToDeployment(this.deployment, infra);
        this.infra = infra;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected StaticDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected StaticAPIDeploymentInfra getInfra() {
        return this.infra;
    }

    @Override
    protected int numberOfDeploymentSteps() {
        return this.withPrepare ? 2 : 1;
    }

    @Override
    @Nonnull
    protected FuturePayload getDeploymentPayload() {
        return FuturePayload.newSimple((String)"sync_static_api_deployment", (String)("Sync static node deployment: " + this.deployment.id));
    }

    @Override
    @Nonnull
    protected String getInfraPrettyName() {
        return "API nodes";
    }

    @Override
    @Nonnull
    protected PrepareAndSyncReport initializeDeploymentReport() {
        return new PrepareAndSyncReport();
    }

    @Override
    protected void preDeploymentActions(@Nonnull PrepareAndSyncReport report, @Nonnull DKUtils.SmartLogTailBuilder logTailBuilder) throws InterruptedException {
        if (this.withPrepare) {
            logger.info((Object)("Prepare sync of  " + JSON.json((Object)this.deployment)));
            report.prepareReport = this.prepareSync();
            report.mergeFrom(report.prepareReport);
            FutureProgress.incrementState((double)1.0);
            if (report.maxSeverity == InfoMessage.Severity.ERROR) {
                logger.error((Object)("Prepare sync of deployment " + this.deployment.id + " failed"));
            }
        } else {
            report.withPrepare = false;
        }
    }

    @Override
    public BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(String deployedServiceId, APIServiceDeploymentHeavyStatus.EndpointSummary endpoint, AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus lightStatus, APIServiceDeploymentHeavyStatus heavyStatus, List<ApiEndpointQuery> allQueries, boolean forTest) throws IOException {
        return new APINodeDeploymentQuerier().runQueries_NT(deployedServiceId, endpoint, lightStatus, heavyStatus, allQueries, this.infra.shouldTrustAllCertificates(), forTest);
    }

    private void uploadAllWithoutCheckForSingleAPINode(LambdaAdminAPIClient client, String targetServiceId) throws IOException {
        if (this.deployment.generationsMapping == null) {
            return;
        }
        for (GenerationsMapping.MappingEntry mappingEntry : this.deployment.generationsMapping.getEntries()) {
            logger.info((Object)("Prepare sync of package version " + mappingEntry.generation));
            this.importGeneration(targetServiceId, client, mappingEntry);
        }
    }

    private PrepareReport prepareSync() {
        PrepareReport ret = new PrepareReport();
        if (!this.deployment.enabled) {
            logger.info((Object)"Deployment is disabled, nothing to prepare");
            return ret;
        }
        if (this.deployment.generationsMapping == null) {
            throw ErrorContext.iae((String)"The deployment does not contain any version.");
        }
        String targetServiceId = StringUtils.isBlank((String)this.deployment.deployedServiceId) ? this.deployment.publishedServiceId : this.deployment.deployedServiceId;
        this.createDeployerKeyIfAuthorizationToQueryThroughDeployer(this.deployment, ret);
        for (StaticAPIDeploymentInfra.APINodeRef apiNode : this.infra.apiNodes) {
            logger.info((Object)("Uploading to " + apiNode.url));
            String currentPackageId = null;
            try (LambdaAdminAPIClient client = new LambdaAdminAPIClient(apiNode.url, this.passwordEncryptionService.decryptIfEncrypted(apiNode.adminAPIKey), this.infra.shouldTrustAllCertificates(), null, this.connectTimeout, this.socketTimeout);){
                client.createService(targetServiceId, true);
                List<LambdaServiceGenTag.WithStatus> existingGenerations = client.listGenerations(targetServiceId);
                logger.info((Object)("Existing generations: " + JSON.json(existingGenerations)));
                for (GenerationsMapping.MappingEntry mappingEntry : this.deployment.generationsMapping.getEntries()) {
                    currentPackageId = mappingEntry.generation;
                    logger.info((Object)("Prepare sync of package version " + mappingEntry.generation));
                    boolean exists = false;
                    for (LambdaServiceGenTag.WithStatus existingGeneration : existingGenerations) {
                        if (!existingGeneration.generationId.equals(mappingEntry.generation)) continue;
                        exists = true;
                        break;
                    }
                    if (exists) {
                        logger.info((Object)("Generation " + currentPackageId + " already exists on the API node, ignoring"));
                        continue;
                    }
                    this.importGeneration(targetServiceId, client, mappingEntry);
                }
                ++ret.nbOKNodes;
            }
            catch (Exception e) {
                logger.warn((Object)("Upload to API Node " + apiNode.url + " failed"), (Throwable)e);
                PrepareReport.Failure failure = new PrepareReport.Failure();
                failure.error = new SerializedError((Throwable)e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                failure.packageId = currentPackageId;
                ret.failures.add(failure);
                ret.withFatal(DeployerCodes.ERR_API_DEPLOYER_STATIC_UPLOAD_FAILED, failure.error.detailedMessage);
                ++ret.nbNOKNodes;
            }
        }
        return ret;
    }

    private void importGeneration(String targetServiceId, LambdaAdminAPIClient client, GenerationsMapping.MappingEntry mappingEntry) throws IOException {
        File authReadyPackageFile;
        boolean hasAPermissionToQueryThroughDeployer = this.deployment.auth.permissions.stream().anyMatch(permission -> permission.queryThroughDeployer);
        File sourcePackageFile = this.publishedAPIServicesService.getPublishedPackageFileMandatory(this.deployment.publishedServiceId, mappingEntry.generation);
        if (this.deployment.auth.authMode == AbstractAPIServiceDeployment.APIAuthSettings.DeployedAuthenticationMode.INHERIT_DEV && !hasAPermissionToQueryThroughDeployer) {
            authReadyPackageFile = sourcePackageFile;
        } else {
            AutoDelete tempDir = DSSTempUtils.getTempFolder((String)"mad-authready", (String)this.deployment.id);
            authReadyPackageFile = APIServiceDeploymentHelper.getOrMakeAuthReadyPackage(sourcePackageFile, (File)tempDir, this.deployment, mappingEntry.generation);
        }
        logger.info((Object)("  Will sync package " + String.valueOf(authReadyPackageFile)));
        client.importGenerationFromFile(targetServiceId, authReadyPackageFile);
    }

    @Override
    @Nonnull
    protected StaticSyncReport doDeployment(@Nonnull DKUtils.SmartLogTailBuilder logTailBuilder) {
        logger.warn((Object)("Execute sync of deployment " + this.deployment.id));
        logger.info((Object)"Summary of the DSS resources used to update the deployment:");
        logger.infoV("Static infra: %s", new Object[]{JSON.json((Object)this.infra)});
        logger.infoV("Static deployment: %s", new Object[]{JSON.json((Object)this.deployment)});
        StaticSyncReport ret = new StaticSyncReport();
        String targetServiceId = this.deployment.getTargetId();
        neverEverDeployed.remove(this.getDeployment().id);
        if (this.infra.apiNodes.isEmpty()) {
            ret.withWarning(DeployerCodes.ERR_API_DEPLOYER_STATIC_NO_APINODES, "There are no configured API nodes");
            return ret;
        }
        for (StaticAPIDeploymentInfra.APINodeRef apiNode : this.infra.apiNodes) {
            logger.info((Object)("Syncing on api node " + apiNode.url));
            try (LambdaAdminAPIClient client = new LambdaAdminAPIClient(apiNode.url, this.passwordEncryptionService.decryptIfEncrypted(apiNode.adminAPIKey), this.infra.shouldTrustAllCertificates(), null, this.connectTimeout, this.socketTimeout);){
                if (!this.deployment.enabled) {
                    logger.info((Object)"Deployment is disabled, trying to remove the service");
                    client.deleteService(targetServiceId);
                } else {
                    client.resetEndpointsSettings(targetServiceId);
                    if (this.deployment.apiNodeLogging.automaticallyConfigureEventServerReporting) {
                        try {
                            this.configureEventServerReporting(client);
                        }
                        catch (IOException e) {
                            logger.warn((Object)("Failed to update audit logs settings on API node " + apiNode.url), (Throwable)e);
                            ret.withWarning(DeployerCodes.WARN_API_DEPLOYER_STATIC_AUXILIARY_SERVICES_INCOMPLETE, "Sending of audit logs not configured. " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                        }
                    }
                    if (this.deployment.apiNodeLogging.automaticallyConfigureKafkaReporting) {
                        try {
                            this.configureKafkaReporting(client);
                        }
                        catch (IOException e) {
                            logger.warn((Object)("Failed to update logging to Kafka settings on API node " + apiNode.url), (Throwable)e);
                            ret.withWarning(DeployerCodes.WARN_API_DEPLOYER_STATIC_AUXILIARY_SERVICES_INCOMPLETE, "Sending of logging to Kafka not configured. " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                        }
                    }
                    if (this.deployment.apiNodeLogging.automaticallyConfigureFsLikeReporting && FeatureFlags.isEnabled((String)"fsLikeApiNodeLogging")) {
                        try {
                            this.configureFsLikeReporting(client);
                        }
                        catch (IOException e) {
                            logger.warn((Object)("Failed to update logging to storage settings on API node " + apiNode.url), (Throwable)e);
                            ret.withWarning(DeployerCodes.WARN_API_DEPLOYER_STATIC_AUXILIARY_SERVICES_INCOMPLETE, "Sending of logging to storage not configured. " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                        }
                    }
                    try {
                        this.configureActivityServer(client);
                    }
                    catch (IllegalConfigurationException | IOException e) {
                        logger.warn((Object)("Failed to update activity metrics settings on API node " + apiNode.url), e);
                        ret.withWarning(DeployerCodes.WARN_API_DEPLOYER_STATIC_AUXILIARY_SERVICES_INCOMPLETE, "Sending of activity metrics not configured. " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                    for (AbstractAPIServiceDeployment.OverrideEndpointServerSideConfig oessc : this.deployment.endpointsServerSideConfigs) {
                        logger.info((Object)("Deploying endpoint config for " + oessc.endpointId));
                        client.setEndpointSettings(targetServiceId, oessc.endpointId, oessc.config);
                    }
                    if (this.forceRefresh && this.infra.apiNodes.size() > 1) {
                        logger.info((Object)("Forcing refresh with staged deployment mode on " + JSON.json((Object)apiNode)));
                        if (this.deployment.rollingUpdateSettings.waitLoadBalancerTimeout) {
                            logger.info((Object)"Setting service as not alive");
                            client.setServiceNotAlive(targetServiceId);
                            logger.info((Object)"Waiting for load-balancer timeout");
                            Thread.sleep(this.deployment.rollingUpdateSettings.loadBalancerTimeoutMS);
                        }
                        logger.info((Object)"Disabling service");
                        try {
                            client.deleteService(targetServiceId);
                        }
                        catch (APIError.APIErrorException e) {
                            logger.warn((Object)("Failed to disable, possibly not a problem: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                        }
                        client.createService(targetServiceId, false);
                        this.uploadAllWithoutCheckForSingleAPINode(client, targetServiceId);
                        logger.info((Object)"Setting mapping");
                        client.setGenerationsMapping(targetServiceId, SingleStaticDeploymentManager.enrichedGenerationsMapping(this.deployment));
                        if (this.deployment.rollingUpdateSettings.waitLoadBalancerTimeout) {
                            logger.info((Object)"Setting service as alive");
                            client.setServiceAlive(targetServiceId);
                            logger.info((Object)"Waiting for load-balancer timeout");
                            Thread.sleep(this.deployment.rollingUpdateSettings.loadBalancerTimeoutMS);
                        }
                    } else if (this.forceRefresh) {
                        logger.info((Object)"Forcing refresh (single API node) - no LB wait");
                        logger.info((Object)"Disabling service");
                        try {
                            client.deleteService(targetServiceId);
                        }
                        catch (APIError.APIErrorException e) {
                            logger.warn((Object)("Failed to disable, possibly not a problem: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                        }
                        logger.info((Object)"Uploading packages");
                        client.createService(targetServiceId, false);
                        this.uploadAllWithoutCheckForSingleAPINode(client, targetServiceId);
                        logger.info((Object)"Setting mapping");
                        client.setGenerationsMapping(targetServiceId, SingleStaticDeploymentManager.enrichedGenerationsMapping(this.deployment));
                    } else {
                        logger.info((Object)("Switching on " + JSON.json((Object)apiNode)));
                        client.setGenerationsMapping(targetServiceId, SingleStaticDeploymentManager.enrichedGenerationsMapping(this.deployment));
                    }
                }
                ++ret.nbOKNodes;
                FutureProgress.incrementState((double)1.0);
            }
            catch (Exception e) {
                logger.warn((Object)("Switch on API node " + apiNode.url + " failed"), (Throwable)e);
                StaticSyncReport.Failure failure = new StaticSyncReport.Failure();
                failure.apiNodeURL = apiNode.url;
                failure.error = new SerializedError((Throwable)e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                ret.failures.add(failure);
                ret.withFatal(DeployerCodes.ERR_API_DEPLOYER_STATIC_ACTIVATE_FAILED, failure.error.detailedMessage);
                ++ret.nbNOKNodes;
            }
        }
        return ret;
    }

    @Override
    FutureResponse<String> startDiagnosis() {
        throw new IllegalArgumentException("Static deployment can't generate diagnosis yet.");
    }

    @Override
    void getDiagnosis(HttpServletResponse resp, String diagnosticName) {
        throw new IllegalArgumentException("Static deployment can't generate diagnosis yet.");
    }

    private void configureEventServerReporting(LambdaAdminAPIClient client) throws IOException {
        logger.info((Object)"Setting up logging to DSS Event Server");
        LambdaServerConfig.AuditLog previousAuditLog = client.getAuditLogSettings();
        GenerationsMapping generationsMapping = this.deployment.generationsMapping;
        if (generationsMapping == null) {
            throw ErrorContext.iae((String)"The deployment does not contain any version.");
        }
        if (StringUtils.isBlank((String)generationsMapping.auditRoutingKey)) {
            logger.info((Object)"Found a blank audit routing key, doing nothing more");
            return;
        }
        AbstractAPIDeploymentInfra.EventServerRef ref = this.deployment.apiNodeLogging.getEventServer();
        List<EventServerTargetSettings> currentEventServerTargetSettings = previousAuditLog.settings.targets.stream().filter(it -> it instanceof EventServerTargetSettings).map(it -> (EventServerTargetSettings)it).filter(it -> this.matchesTopic((AuditTrailTargetSettings)it, "apinode-query")).filter(it -> this.matchesRoutingKey((AuditTrailTargetSettings)it, generationsMapping.auditRoutingKey)).collect(Collectors.toList());
        EventServerTargetSettings ests = new EventServerTargetSettings();
        ests.routingKeysFiltering = RoutingKeyFiltering.SELECTED;
        ests.routingKeys.add(generationsMapping.auditRoutingKey);
        ests.topicsFiltering = TopicsFiltering.SELECTED;
        ests.topics.add("apinode-query");
        ests.url = ref.getEventServerURL();
        ests.authKey = this.passwordEncryptionService.decryptIfEncrypted(ref.getEventServerAuthKey());
        ests.trustAllSSLCertificates = this.deployment.apiNodeLogging.trustAllSSLCertificates;
        if (currentEventServerTargetSettings.stream().anyMatch(e -> e.equals((Object)ests))) {
            logger.info((Object)"Already well configured, doing nothing more");
            return;
        }
        currentEventServerTargetSettings.forEach(e -> previousAuditLog.settings.targets.remove(e));
        logger.info((Object)"Adding an audit target");
        previousAuditLog.settings.targets.add(ests);
        client.setAuditLogSettings(previousAuditLog);
    }

    private void configureKafkaReporting(LambdaAdminAPIClient client) throws IOException {
        logger.info((Object)"Setting up logging to Kafka");
        LambdaServerConfig.AuditLog previousAuditLog = client.getAuditLogSettings();
        GenerationsMapping generationsMapping = this.deployment.generationsMapping;
        if (generationsMapping == null) {
            throw ErrorContext.iae((String)"The deployment does not contain any version.");
        }
        if (StringUtils.isBlank((String)generationsMapping.auditRoutingKey)) {
            logger.info((Object)"Found a blank audit routing key, doing nothing more");
            return;
        }
        boolean isAlreadyConfigured = previousAuditLog.settings.targets.stream().filter(it -> it instanceof KafkaTargetSettings).map(it -> (KafkaTargetSettings)it).filter(it -> StringUtils.equals((String)it.connection, (String)this.deployment.apiNodeLogging.kafkaConnectionName)).filter(it -> this.matchesTopic((AuditTrailTargetSettings)it, "apinode-query")).anyMatch(it -> this.matchesRoutingKey((AuditTrailTargetSettings)it, generationsMapping.auditRoutingKey));
        if (isAlreadyConfigured) {
            logger.info((Object)"Already well configured, doing nothing more");
            return;
        }
        logger.info((Object)"Adding an audit target");
        KafkaTargetSettings kts = new KafkaTargetSettings();
        kts.routingKeysFiltering = RoutingKeyFiltering.SELECTED;
        kts.routingKeys.add(generationsMapping.auditRoutingKey);
        kts.topicsFiltering = TopicsFiltering.SELECTED;
        kts.topics.add("apinode-query");
        kts.connection = this.deployment.apiNodeLogging.kafkaConnectionName;
        kts.topic = this.deployment.apiNodeLogging.kafkaTopic;
        previousAuditLog.settings.targets.add(kts);
        client.setAuditLogSettings(previousAuditLog);
    }

    private void configureFsLikeReporting(LambdaAdminAPIClient client) throws IOException {
        logger.info((Object)"Setting up logging to object storage (or filesystem)");
        LambdaServerConfig.AuditLog previousAuditLog = client.getAuditLogSettings();
        GenerationsMapping generationsMapping = this.deployment.generationsMapping;
        if (generationsMapping == null) {
            throw ErrorContext.iae((String)"The deployment does not contain any version.");
        }
        if (StringUtils.isBlank((String)generationsMapping.auditRoutingKey)) {
            logger.info((Object)"Found a blank audit routing key, doing nothing more");
            return;
        }
        List<FsLikeTargetSettings> currentFsTargetSettings = previousAuditLog.settings.targets.stream().filter(it -> it instanceof FsLikeTargetSettings).map(it -> (FsLikeTargetSettings)it).filter(it -> this.matchesTopic((AuditTrailTargetSettings)it, "apinode-query")).filter(it -> this.matchesRoutingKey((AuditTrailTargetSettings)it, generationsMapping.auditRoutingKey)).collect(Collectors.toList());
        FsLikeTargetSettings fsts = new FsLikeTargetSettings();
        fsts.routingKeysFiltering = RoutingKeyFiltering.SELECTED;
        fsts.routingKeys.add(generationsMapping.auditRoutingKey);
        fsts.topicsFiltering = TopicsFiltering.SELECTED;
        fsts.topics.add("apinode-query");
        AbstractAPIDeploymentInfra.APINodeLogging.FsLikeSettings fsLikeSettings = this.deployment.apiNodeLogging.fsLikeSettings;
        fsts.fileLikeConnectionName = fsLikeSettings.connectionName;
        fsts.fileLikePathWithinConnection = fsLikeSettings.pathWithinConnection;
        fsts.bucket = fsLikeSettings.bucket;
        fsts.partitioningPeriod = fsLikeSettings.partitioningPeriod;
        fsts.flushEveryBytes = fsLikeSettings.flushEveryBytes;
        fsts.flushEveryS = fsLikeSettings.flushEveryS;
        fsts.folderByTopic = fsLikeSettings.folderByTopic;
        fsts.folderByRoutingKey = fsLikeSettings.folderByRoutingKey;
        if (currentFsTargetSettings.stream().anyMatch(e -> e.equals((Object)fsts))) {
            logger.info((Object)"Already well configured, doing nothing more");
            return;
        }
        if (!currentFsTargetSettings.isEmpty()) {
            logger.info((Object)"Removing previous storage audit targets.");
            currentFsTargetSettings.forEach(e -> previousAuditLog.settings.targets.remove(e));
        }
        logger.info((Object)"Adding a new storage audit target");
        previousAuditLog.settings.targets.add(fsts);
        client.setAuditLogSettings(previousAuditLog);
    }

    private void configureActivityServer(LambdaAdminAPIClient client) throws IOException, IllegalConfigurationException {
        logger.info((Object)"Setting up sending activity metrics to DSS Activity Server");
        if (this.infra.activityMonitoringSettings instanceof ActivityMonitoringSettings.Push) {
            ActivityMonitoringSettings.PushExplicit pushSettings = ((ActivityMonitoringSettings.Push)this.infra.activityMonitoringSettings).toPushSettings();
            if (StringUtils.isBlank((String)pushSettings.activityServerAPIURL) || StringUtils.isBlank((String)pushSettings.apiKey)) {
                client.setActivityMonitoringSettings(new ActivityMonitoringSettings.Disabled());
                throw ErrorContext.ice((String)"Activity server Url or api key not set at the infra level. Disabling the sending of activity metrics for this deployment.");
            }
            ActivityMonitoringSettings.PushExplicit copiedPushSettings = (ActivityMonitoringSettings.PushExplicit)JSON.deepCopy((Object)pushSettings);
            PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
            copiedPushSettings.decryptFields(passwordEncryptionService);
            client.setActivityMonitoringSettings(copiedPushSettings);
            logger.infoV("DSS Activity Server url set to %s", new Object[]{pushSettings.activityServerAPIURL});
        } else {
            client.setActivityMonitoringSettings(this.infra.activityMonitoringSettings);
        }
    }

    private boolean matchesTopic(AuditTrailTargetSettings targetSettings, String topic) {
        return targetSettings.topicsFiltering == TopicsFiltering.ALL || targetSettings.topics.contains(topic);
    }

    private boolean matchesRoutingKey(AuditTrailTargetSettings targetSettings, String routingKey) {
        return targetSettings.routingKeysFiltering == RoutingKeyFiltering.ALL || targetSettings.routingKeys.contains(routingKey);
    }

    @Override
    public StaticDeploymentHeavyStatus getStatus_Unsafe_NT(boolean withPackageExtraInfo, @Nullable String overridingConnectionName) throws DKUSecurityException, IOException {
        StaticDeploymentHeavyStatus ret = new StaticDeploymentHeavyStatus(this.deployment.id, this.infra.id);
        ret.packages = this.publishedAPIServicesService.listPublishedPackages_Check_Unsafe_NT(this.deployment.publishedServiceId, this.authCtx);
        ret.endpoints = ret.summarizeEndpoints_NT(this.deployment, withPackageExtraInfo);
        if (!this.deployment.enabled) {
            ret.setHealthWithSeverity(DeploymentHealth.DISABLED);
            return ret;
        }
        HashSet<String> requiredGenerations = new HashSet<String>();
        if (this.deployment.generationsMapping == null) {
            throw ErrorContext.iae((String)"The deployment does not contain any version.");
        }
        for (GenerationsMapping.MappingEntry me : this.deployment.generationsMapping.getEntries()) {
            requiredGenerations.add(me.generation);
        }
        String targetServiceId = StringUtils.isBlank((String)this.deployment.deployedServiceId) ? this.deployment.publishedServiceId : this.deployment.deployedServiceId;
        int healthyNodes = 0;
        for (StaticAPIDeploymentInfra.APINodeRef apiNode : this.infra.apiNodes) {
            StaticDeploymentHeavyStatus.APINodeDeploymentState apiNodeState = new StaticDeploymentHeavyStatus.APINodeDeploymentState();
            apiNodeState.url = apiNode.url;
            ret.apiNodes.add(apiNodeState);
            try (LambdaAdminAPIClient client = new LambdaAdminAPIClient(apiNode.url, this.passwordEncryptionService.decryptIfEncrypted(apiNode.adminAPIKey), this.infra.shouldTrustAllCertificates(), null, this.connectTimeout, this.socketTimeout);){
                List<ServiceSummaryState> services = client.listServices();
                ServiceSummaryState serviceState = null;
                for (ServiceSummaryState _s : services) {
                    if (!_s.serviceId.equals(targetServiceId)) continue;
                    serviceState = _s;
                    break;
                }
                if (serviceState == null) {
                    apiNodeState.serviceExists = false;
                } else {
                    apiNodeState.serviceExists = true;
                    apiNodeState.serviceEnabled = serviceState.enabled;
                    List<LambdaServiceGenTag.WithStatus> knownGenerations = client.listGenerations(targetServiceId);
                    String firstGeneration = serviceState.activeMapping == null || serviceState.activeMapping.getEntries().isEmpty() ? null : serviceState.activeMapping.getEntries().get((int)0).generation;
                    for (LambdaServiceGenTag.WithStatus ws : knownGenerations) {
                        String deployerKey;
                        apiNodeState.knownGenerations.add(ws.generationId);
                        if (!Objects.equals(ws.generationId, firstGeneration) || ((deployerKey = this.apiServiceDeployerKeysCRUDService.get(this.deployment.id)) != null || ws.deployerKeyHash != null) && !HashUtils.verifySha256((String)deployerKey, (String)ws.deployerKeyHash)) continue;
                        apiNodeState.isDeployerKeySynced = true;
                    }
                    apiNodeState.hasAllRequiredGenerations = apiNodeState.knownGenerations.containsAll(requiredGenerations);
                    apiNodeState.mapping = serviceState.activeMapping;
                    apiNodeState.mappingIsUpToDate = this.deployment.generationsMapping.equals(apiNodeState.mapping);
                }
            }
            catch (IOException e) {
                logger.warn((Object)("Get Status on API node " + apiNode.url + " failed"), (Throwable)e);
                apiNodeState.error = new SerializedError((Throwable)e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
            }
            if (apiNodeState.mappingIsUpToDate && apiNodeState.hasAllRequiredGenerations && apiNodeState.serviceEnabled && apiNodeState.isDeployerKeySynced) {
                ++healthyNodes;
                continue;
            }
            if (apiNodeState.error != null) {
                ret.healthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_STATIC_APINODE_ERROR, "Failed to get deployment status from API Node '" + apiNode.url + "': " + apiNodeState.error.detailedMessage);
                continue;
            }
            ret.healthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_STATIC_APINODE_INCOMPLETE, "Deployment incomplete on Node " + apiNode.url);
        }
        Exception generationsException = null;
        try {
            this.deployment.generationsMapping.validate();
        }
        catch (Exception e) {
            generationsException = e;
        }
        if (generationsException != null) {
            ret.setMessageAndHealthWithSeverity(InfoMessage.error((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_STATIC_INVALID_GENERATIONS_MAPPING, (String)generationsException.getMessage()), DeploymentHealth.ERROR);
        } else if (this.infra.apiNodes.isEmpty()) {
            ret.setMessageAndHealthWithSeverity(InfoMessage.warning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_STATIC_NO_APINODES, (String)"There are no configured API nodes"), DeploymentHealth.WARNING);
        } else if (healthyNodes == this.infra.apiNodes.size()) {
            ret.setHealthWithSeverity(DeploymentHealth.HEALTHY);
        } else if (healthyNodes + this.deployment.healthSettings.maxFailing >= this.infra.apiNodes.size()) {
            ret.setHealthWithSeverity(DeploymentHealth.WARNING);
        } else {
            ret.setMessageAndHealthWithSeverity(InfoMessage.fatal((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_STATIC_UNHEALTHY_NODES, (String)("Deployment is unhealthy on " + (this.infra.apiNodes.size() - healthyNodes) + "  nodes")), DeploymentHealth.UNHEALTHY);
        }
        return ret;
    }

    public static class PrepareAndSyncReport
    extends AbstractAPIServiceDeploymentManager.APIDeploymentReport {
        public boolean withPrepare = true;
        @Nullable
        public PrepareReport prepareReport;
        @Nullable
        public StaticSyncReport syncReport;

        @Override
        public void setActualDeploymentStepReport(@Nonnull InfoMessage.InfoMessages report) {
            if (!(report instanceof StaticSyncReport)) {
                throw new AssertionError((Object)String.format("Unexpected type of report. Expected a %s, got a %s", StaticSyncReport.class, report.getClass()));
            }
            this.syncReport = (StaticSyncReport)report;
            this.mergeFrom(report);
        }

        @Override
        public PrepareAndSyncReport copyHookStatusWithSensitiveDataAdded() {
            PrepareAndSyncReport copy = this.copyWithNonAdminDeploymentFailureMessage();
            copy.deploymentHookExecutionStatus.updateMessageWithSensitiveData();
            return copy;
        }

        @Override
        public PrepareAndSyncReport copyWithNonAdminDeploymentFailureMessage() {
            PrepareAndSyncReport copy = new PrepareAndSyncReport();
            copy.mergeFrom(this);
            copy.copyInterruptedAndHookStatus(this);
            copy.withPrepare = this.withPrepare;
            copy.prepareReport = (PrepareReport)((Object)JSON.deepCopy((Object)((Object)this.prepareReport)));
            copy.syncReport = (StaticSyncReport)((Object)JSON.deepCopy((Object)((Object)this.syncReport)));
            return copy;
        }

        @Override
        public InfoMessage.Severity getMaxSeverity() {
            if (this.withPrepare && (this.prepareReport == null || InfoMessage.Severity.ERROR.equals((Object)this.prepareReport.maxSeverity))) {
                return InfoMessage.Severity.ERROR;
            }
            if (this.syncReport == null) {
                return InfoMessage.Severity.ERROR;
            }
            return this.maxSeverity;
        }

        @Override
        public boolean preDeploymentActionsSucceeded() {
            return !this.withPrepare || this.prepareReport != null && this.prepareReport.maxSeverity != InfoMessage.Severity.ERROR;
        }
    }

    public static class PrepareReport
    extends InfoMessage.InfoMessages {
        public int nbOKNodes;
        public int nbNOKNodes;
        public List<Failure> failures = new ArrayList<Failure>();

        public static class Failure {
            String packageId;
            SerializedError error;
        }
    }

    public static class StaticSyncReport
    extends InfoMessage.InfoMessages {
        public int nbOKNodes;
        public int nbNOKNodes;
        public List<Failure> failures = new ArrayList<Failure>();

        public void mergeFrom(InfoMessage.InfoMessages other) {
            super.mergeFrom(other);
            if (other instanceof StaticSyncReport) {
                StaticSyncReport report = (StaticSyncReport)other;
                this.nbOKNodes = report.nbOKNodes;
                this.nbNOKNodes = report.nbNOKNodes;
                this.failures.addAll(report.failures);
            }
        }

        public static class Failure {
            String apiNodeURL;
            SerializedError error;
        }
    }

    public static enum StaticDeploymentUpdateMode {
        LIGHT,
        FULL;

    }
}

