/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.infra;

import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.InfraLightStatus;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentHelper;
import com.dataiku.dip.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.apideployer.monitoring.SystemMetric;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.ContainerOverrideMask;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.KubernetesClusterService;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ApiNodeK8SInfraManager
implements ApiNodeInfraManager {
    @Autowired
    KubernetesClusterService kubernetesClusterService;
    @Autowired
    FutureService futureService;
    @Autowired
    ApiNodeInfrasService apiNodeInfrasService;
    @Autowired
    TransactionService transactionService;
    private final K8SAPIDeploymentInfra infra;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.infra.k8s.manager");

    public ApiNodeK8SInfraManager(K8SAPIDeploymentInfra infra) {
        this.infra = infra;
        SpringUtils.getInstance().autowire((Object)this);
    }

    private InfoMessage.InfoMessages getStatus_NT(AuthCtx authCtx) throws IOException, DKUSecurityException, InterruptedException {
        Object baseImageTag;
        Map<String, String> k8sBaseEnv;
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        ContainerExecRuntimeConfig k8sConfig = this.getContainerExecRuntimeConfig(authCtx);
        boolean namespaceExists = this.doesNamespaceExist(authCtx, k8sConfig, k8sBaseEnv = KubernetesExecUtils.getKubeCtlEnv(k8sConfig));
        if (!namespaceExists) {
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_K8S_NAMESPACE_NOT_FOUND, "Namespace '" + k8sConfig.kubernetesNamespace + "' not found on Kubernetes.");
        }
        if (StringUtils.isBlank((String)k8sConfig.repositoryURL)) {
            messages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_K8S_REGISTRY_UNDEFINED, "Check the registry host defined in the infrastructure settings > Kubernetes cluster section.");
        }
        try {
            int healthyNodes = this.numberOfHealthyNodes(authCtx, k8sConfig, k8sBaseEnv);
            if (healthyNodes == 0) {
                messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_K8S_NO_NODES, "All nodes are unhealthy");
            }
        }
        catch (Exception e) {
            messages.withFatal((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_K8S_COMMUNICATION_ERROR, "kubectl get nodes failed with " + String.valueOf(e));
        }
        String defaultBaseImageTag = "dku-apideployer-apinode-base:dss-" + APIServiceDeploymentHelper.getSanitizedDSSVersionForImages();
        Object object = baseImageTag = StringUtils.isBlank((String)k8sConfig.baseImage) ? defaultBaseImageTag : k8sConfig.baseImage;
        if (!this.hasABaseImage((String)baseImageTag, k8sConfig)) {
            messages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_K8S_BASE_IMAGE_NOT_FOUND, "Base image " + (String)baseImageTag + " not found.");
        }
        return messages;
    }

    private boolean hasABaseImage(String baseImageTag, ContainerExecUtils.ContainerBaseConfig config) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder("docker", "images", baseImageTag, "--format=\"{{json .}}\"");
        ContainerExecUtils.enrichDockerEnv(config, pb.environment());
        byte[] output = DKUtils.execAndGetOutput((ProcessBuilder)pb);
        if (output.length == 0) {
            return false;
        }
        String[] imagesJson = new String(output, StandardCharsets.UTF_8).split("\n");
        return imagesJson.length > 0;
    }

    @Override
    public InfoMessage.InfoMessages checkInfraStatus_NT(AuthCtx authCtx) {
        try {
            return this.getStatus_NT(authCtx);
        }
        catch (Exception e) {
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_K8S_COMMUNICATION_ERROR, e.getMessage());
            return messages;
        }
    }

    @Override
    public ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getActivityMetrics_NT(AuthCtx authCtx, int connectTimeout, int socketTimeout, String overridingConnectionName) {
        TransactionContext.assertNoAttachedTransaction();
        return new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint();
    }

    @Override
    public SystemMetric.TimeAndMetricsByDeployment getSystemMetrics_NT(AuthCtx authCtx, int connectTimeout, int socketTimeout, String overridingConnectionName) throws Exception {
        List podMetrics;
        InfraLightStatus infraLightStatus;
        TransactionContext.assertNoAttachedTransaction();
        logger.traceV("Fetching system metrics from Kubernetes infrastructure: %s", new Object[]{this.infra.id});
        try (Transaction t = this.transactionService.beginRead();){
            infraLightStatus = this.apiNodeInfrasService.getLightStatusUnsafe_Check(this.infra.id, authCtx);
        }
        String clusterId = this.getBuiltinAwareClusterId(authCtx);
        long nowSeconds = DateTime.now().getMillis() / 1000L;
        String k8sNamespace = this.infra.getK8sNamespace();
        try {
            FutureResponse<List<KubernetesClusterService.ClusterPodTopMetrics>> getPodTopMetricsFutureResponse = this.kubernetesClusterService.getPodMetrics(authCtx, clusterId, k8sNamespace);
            podMetrics = (List)this.futureService.waitForFinalResponse(getPodTopMetricsFutureResponse).result;
        }
        catch (Exception e) {
            logger.warnV("Failed to get pod metrics for cluster %s and namespace %s, will not collect system metrics for infra %s: %s", new Object[]{clusterId, k8sNamespace, this.infra.id, e.getMessage()});
            return new SystemMetric.TimeAndMetricsByDeployment.None();
        }
        FutureResponse<List<KubernetesClusterService.ClusterNode>> listNodesFuture = this.kubernetesClusterService.listNodes(authCtx, clusterId, false);
        List nodes = (List)this.futureService.waitForFinalResponse(listNodesFuture).result;
        if (nodes.isEmpty()) {
            logger.infoV("No nodes found on cluster %s, will not collect system metrics for infra %s", new Object[]{clusterId, this.infra.id});
            return new SystemMetric.TimeAndMetricsByDeployment.None();
        }
        List nodeNames = nodes.stream().map(rec$ -> ((KubernetesClusterService.ClusterNode)rec$).getName()).collect(Collectors.toList());
        logger.traceV("Found %d nodes on cluster %s: %s", new Object[]{nodes.size(), clusterId, nodeNames});
        FutureResponse<List<KubernetesClusterService.ClusterPod>> listPodsFuture = this.kubernetesClusterService.listPods(authCtx, clusterId, KubernetesClusterService.NamespaceFilterType.EXPLICIT, k8sNamespace, false);
        List pods = (List)this.futureService.waitForFinalResponse(listPodsFuture).result;
        if (pods.isEmpty()) {
            logger.infoV("No pods found in cluster %s for namespace %s, will not collect system metrics for infra %s", new Object[]{clusterId, k8sNamespace, this.infra.id});
            return new SystemMetric.TimeAndMetricsByDeployment.None();
        }
        List podNames = pods.stream().map(rec$ -> ((KubernetesClusterService.ClusterPod)rec$).getName()).collect(Collectors.toList());
        logger.traceV("Found %d pods on cluster %s for namespace %s: %s", new Object[]{pods.size(), clusterId, k8sNamespace, podNames});
        KubernetesClusterService.ClusterCapacities clusterCapacities = KubernetesClusterService.extractCpuAndMemoryCapacity(nodes);
        if (clusterCapacities == null) {
            logger.warnV("Failed to get CPU and memory capacity for cluster %s", new Object[]{clusterId});
            return new SystemMetric.TimeAndMetricsByDeployment.None();
        }
        Integer clusterCpuCapacityMillis = clusterCapacities.getCpuCapacityMillis();
        Long clusterMemoryCapacityMB = clusterCapacities.getMemoryCapacityMB();
        logger.traceV("Computing system metrics for cluster %s (node count: %d, pod count: %d, CPU capacity: %dm, memory capacity: %dMB)", new Object[]{clusterId, nodes.size(), pods.size(), clusterCpuCapacityMillis, clusterMemoryCapacityMB});
        SystemMetric.TimeAndMetricsByDeployment timeAndMetricsByDeployment = new SystemMetric.TimeAndMetricsByDeployment();
        for (AbstractDeploymentBasicInfo abstractDeploymentBasicInfo : infraLightStatus.deployments) {
            List<KubernetesClusterService.ClusterPodTopMetrics> podMetricsForDeployment = ApiNodeK8SInfraManager.getPodMetricsForDeployment(abstractDeploymentBasicInfo.getId(), pods, podMetrics);
            if (podMetricsForDeployment.isEmpty()) {
                logger.traceV("No pods found for deployment %s", new Object[]{abstractDeploymentBasicInfo.getId()});
                continue;
            }
            Map<SystemMetric.Type, SystemMetric> systemMetricsByType = ApiNodeK8SInfraManager.buildSystemMetricsMap(podMetricsForDeployment, clusterCpuCapacityMillis, clusterMemoryCapacityMB, nodes.size(), pods.size());
            SystemMetric.TimeAndMetricsForDeployment timeAndMetricsForDeployment = new SystemMetric.TimeAndMetricsForDeployment(abstractDeploymentBasicInfo.id, new SystemMetric.TimeAndMetrics(nowSeconds, systemMetricsByType));
            timeAndMetricsByDeployment.put(abstractDeploymentBasicInfo.id, timeAndMetricsForDeployment);
        }
        return timeAndMetricsByDeployment;
    }

    @VisibleForTesting
    static List<KubernetesClusterService.ClusterPodTopMetrics> getPodMetricsForDeployment(String deploymentId, List<KubernetesClusterService.ClusterPod> pods, List<KubernetesClusterService.ClusterPodTopMetrics> podMetrics) {
        Set podsForDeploymentNames = pods.stream().filter(pod -> deploymentId.equalsIgnoreCase(pod.getDeploymentId())).map(rec$ -> ((KubernetesClusterService.ClusterPod)rec$).getName()).collect(Collectors.toSet());
        return podMetrics.stream().filter(podMetric -> podsForDeploymentNames.contains(podMetric.getName())).collect(Collectors.toList());
    }

    @Nonnull
    @VisibleForTesting
    static Map<SystemMetric.Type, SystemMetric> buildSystemMetricsMap(List<KubernetesClusterService.ClusterPodTopMetrics> podMetricsForDeployment, Integer clusterCpuCapacityMillis, Long clusterMemoryCapacityMB, int nNodes, int nPods) {
        double deploymentCpuMillisTotal = podMetricsForDeployment.stream().mapToInt(KubernetesClusterService.ClusterPodTopMetrics::getCpuMillis).sum();
        double deploymentMemoryMB = podMetricsForDeployment.stream().mapToLong(KubernetesClusterService.ClusterPodTopMetrics::getMemoryMB).sum();
        double deploymentCpuMillisAveragePerPod = deploymentCpuMillisTotal / (double)podMetricsForDeployment.size();
        double deploymentMemoryMBAveragePerPod = deploymentMemoryMB / (double)podMetricsForDeployment.size();
        double deploymentRelativeCpu = deploymentCpuMillisTotal / (double)clusterCpuCapacityMillis.intValue();
        double deploymentRelativeMemory = deploymentMemoryMB / (double)clusterMemoryCapacityMB.longValue();
        return Map.of(SystemMetric.Type.CPU_USAGE_ABSOLUTE_IN_MILLICORES, new SystemMetric(SystemMetric.Type.CPU_USAGE_ABSOLUTE_IN_MILLICORES, deploymentCpuMillisAveragePerPod), SystemMetric.Type.MEMORY_USAGE_ABSOLUTE_IN_MEGABYTES, new SystemMetric(SystemMetric.Type.MEMORY_USAGE_ABSOLUTE_IN_MEGABYTES, deploymentMemoryMBAveragePerPod), SystemMetric.Type.CPU_USAGE_RELATIVE, new SystemMetric(SystemMetric.Type.CPU_USAGE_RELATIVE, deploymentRelativeCpu), SystemMetric.Type.MEMORY_USAGE_RELATIVE, new SystemMetric(SystemMetric.Type.MEMORY_USAGE_RELATIVE, deploymentRelativeMemory), SystemMetric.Type.CPU_CAPACITY_IN_MILLICORES, new SystemMetric(SystemMetric.Type.CPU_CAPACITY_IN_MILLICORES, clusterCpuCapacityMillis.intValue()), SystemMetric.Type.MEMORY_CAPACITY_IN_MEGABYTES, new SystemMetric(SystemMetric.Type.MEMORY_CAPACITY_IN_MEGABYTES, clusterMemoryCapacityMB.longValue()), SystemMetric.Type.NODE_COUNT, new SystemMetric(SystemMetric.Type.NODE_COUNT, nNodes), SystemMetric.Type.POD_COUNT, new SystemMetric(SystemMetric.Type.POD_COUNT, nPods));
    }

    @Nonnull
    private String getBuiltinAwareClusterId(AuthCtx authCtx) throws IOException, DKUSecurityException {
        ClusterSettings clusterSettings = new ClusterSelector().selectForAPIDeployer(authCtx, this.infra.id);
        return clusterSettings.getClusterId() != null ? clusterSettings.getClusterId() : "__builtin__";
    }

    private String getRequestTimeout() {
        int socketTimeout = DeployerUtils.getInfraSocketTimeout();
        if (socketTimeout > 0) {
            return socketTimeout + "ms";
        }
        return null;
    }

    private int numberOfHealthyNodes(AuthCtx authCtx, ContainerExecRuntimeConfig k8sConfig, Map<String, String> k8sBaseEnv) throws IOException, InterruptedException {
        ArrayList args = Lists.newArrayList((Object[])KubernetesExecUtils.getKubeCtlCommand(authCtx, null, this.getRequestTimeout(), k8sConfig, false, new String[0]));
        args.add("get");
        args.add("nodes");
        args.add("-o");
        args.add("json");
        byte[] bytes = DKUtils.execAndGetOutput((String[])args.toArray(new String[0]), k8sBaseEnv);
        GetNodesOutput nodesOutput = (GetNodesOutput)JSON.parse((byte[])bytes, GetNodesOutput.class);
        return nodesOutput.items.stream().map(node -> this.isNodeHealthy(node.status)).mapToInt(isHealthy -> isHealthy != false ? 1 : 0).sum();
    }

    private boolean isNodeHealthy(GetNodesOutput.Status status) {
        for (GetNodesOutput.Condition condition : status.conditions) {
            if (!"Ready".equals(condition.type)) continue;
            return condition.status;
        }
        return false;
    }

    private boolean doesNamespaceExist(AuthCtx authCtx, ContainerExecRuntimeConfig k8sConfig, Map<String, String> k8sBaseEnv) throws IOException, InterruptedException {
        ArrayList args = Lists.newArrayList((Object[])KubernetesExecUtils.getKubeCtlCommand(authCtx, null, this.getRequestTimeout(), k8sConfig, false, new String[0]));
        args.add("get");
        args.add("namespace");
        args.add(k8sConfig.kubernetesNamespace);
        DKUtils.ExecutionResults res = DKUtils.execAndGetOutputAndErrors((String[])args.toArray(new String[0]), k8sBaseEnv);
        return res.rv == 0;
    }

    private ContainerExecRuntimeConfig getContainerExecRuntimeConfig(AuthCtx authCtx) throws IOException, DKUSecurityException {
        ClusterSettings clusterSettings = new ClusterSelector().selectForAPIDeployer(authCtx, this.infra.id);
        ContainerExecRuntimeConfig inlineConfig = new ContainerExecRuntimeConfig();
        inlineConfig.type = ContainerExecRuntimeConfig.Container.KUBERNETES;
        inlineConfig.kubeCtlContext = this.infra.k8sContext;
        inlineConfig.kubeConfigPath = this.infra.k8sConfigPath;
        inlineConfig.kubernetesNamespace = this.infra.getK8sNamespace();
        inlineConfig.prePushMode = this.infra.prePushMode;
        inlineConfig.prePushScript = this.infra.prePushScript;
        inlineConfig.baseImage = this.infra.baseImageTag;
        inlineConfig.repositoryURL = this.infra.getRegistryHost();
        inlineConfig.imagePullSecretName = this.infra.imagePullSecretName;
        inlineConfig.properties = this.infra.k8sProperties;
        inlineConfig.noImplicitK8sClusterAndNoDefaultClusterId = clusterSettings.isNoImplicitK8sClusterAndNoDefaultClusterId();
        ContainerExecRuntimeConfig configOverrides = clusterSettings.getContainerSettings().executionConfigsGenericOverrides;
        return ContainerOverrideMask.getOverriden(inlineConfig, configOverrides);
    }

    static class GetNodesOutput {
        List<Item> items;

        GetNodesOutput() {
        }

        static class Condition {
            String type;
            boolean status;

            Condition() {
            }
        }

        static class Status {
            List<Condition> conditions;

            Status() {
            }
        }

        static class Item {
            Status status;

            Item() {
            }
        }
    }
}

