/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.published;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.BundleDetailsExtended;
import com.dataiku.dip.apideployer.datamodel.actual.FullImageInfo;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedProjectBundleInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractProjectDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.BasicImageInfo;
import com.dataiku.dip.apideployer.datamodel.config.BundleOriginInfo;
import com.dataiku.dip.apideployer.datamodel.config.DesignNodeInfo;
import com.dataiku.dip.apideployer.datamodel.config.PublishedItem;
import com.dataiku.dip.apideployer.datamodel.config.PublishedProject;
import com.dataiku.dip.apideployer.deployments.ProjectDeploymentsService;
import com.dataiku.dip.apideployer.deployments.PublishedProjectBundleInfoForGovernIdentification;
import com.dataiku.dip.apideployer.infra.AutomationNodeInfrasService;
import com.dataiku.dip.apideployer.published.AbstractPublishedItemsService;
import com.dataiku.dip.apideployer.published.FileBasedPublishedItemsDAO;
import com.dataiku.dip.apideployer.published.PublishedProjectsDAO;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.gh.GovernIntegrationService;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projectstandards.ProjectStandardsRunReportSummary;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ImageService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatus;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatusList;
import com.dataiku.dss_gh.api.models.identifiers.DSSBundleIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifierList;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PublishedProjectsService
extends AbstractPublishedItemsService<AbstractProjectDeployment, AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo, AbstractProjectDeploymentInfra> {
    @Autowired
    private PublishedProjectsDAO publishedProjectsDAO;
    @Autowired
    private AutomationNodeInfrasService automationNodeInfrasService;
    @Autowired
    private ProjectDeploymentsService projectDeploymentsService;
    @Autowired
    private ImageService imageService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GovernIntegrationService governIntegrationService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.publishedprojects");

    public ProjectDeploymentsService getDeploymentsService() {
        return this.projectDeploymentsService;
    }

    @Override
    public FileBasedPublishedItemsDAO getPublishedItemsDAO() {
        return this.publishedProjectsDAO;
    }

    protected AutomationNodeInfrasService getInfrasService() {
        return this.automationNodeInfrasService;
    }

    public AbstractPublishedItemBasicInfo.PublishedProjectBasicInfoList createItemBasicInfoList() {
        return new AbstractPublishedItemBasicInfo.PublishedProjectBasicInfoList();
    }

    @Override
    protected AbstractPublishedItemLightStatus.PublishedProjectLightStatus createItemLightStatus(List<PublishedPackageInfo> packages, List<? extends AbstractDeploymentBasicInfo> deployments, List<AbstractInfraBasicInfo> infras, PublishedItem item, boolean isProjectAdmin, boolean canDeploy, boolean canWrite) throws IOException {
        return new AbstractPublishedItemLightStatus.PublishedProjectLightStatus(packages, deployments, infras, this.basicInfoUnsafe(item), isProjectAdmin, canDeploy, canWrite);
    }

    @Override
    protected PublishedItem newPublishedItem() {
        return new PublishedProject();
    }

    private FullImageInfo getProjectImageInfo(PublishedProject publishedProject) throws IOException {
        String projectKey = publishedProject.id;
        FullImageInfo fullInfo = new FullImageInfo();
        BasicImageInfo basicImageInfo = publishedProject.basicImageInfo;
        fullInfo.objectImgHash = this.imageService.getOriginalImgHash(projectKey, "PUBLISHED_PROJECT", null);
        boolean bl = fullInfo.isUploadedImg = fullInfo.objectImgHash != 0L;
        if (!fullInfo.isUploadedImg) {
            fullInfo.objectImgHash = this.imageService.generateNewImgHash(projectKey, "PUBLISHED_PROJECT", null);
        }
        fullInfo.defaultImgColor = this.imageService.generateProjectColorAsHex(projectKey);
        if (basicImageInfo != null) {
            fullInfo.imgColor = basicImageInfo.imgColor;
            fullInfo.imgPattern = basicImageInfo.imgPattern != null ? basicImageInfo.imgPattern : this.imageService.generateProjectPattern(projectKey);
            fullInfo.showInitials = basicImageInfo.showInitials;
        }
        return fullInfo;
    }

    private BasicImageInfo getBundleImageInfo(SerializedProject sp) {
        BasicImageInfo imageInfo = new BasicImageInfo();
        imageInfo.imgColor = sp.imgColor;
        imageInfo.imgPattern = sp.imgPattern;
        imageInfo.showInitials = sp.showInitials;
        return imageInfo;
    }

    public PublishedPackageInfo publishBundleFromStream_NT_Check(AuthCtx authCtx, String publishedProjectKey, InputStream is) throws UnauthorizedException, IOException {
        boolean created;
        byte[] imageInBytes;
        SerializedProject sp;
        String bundleId;
        DesignNodeInfo designNodeInfo = new DesignNodeInfo();
        try (AutoDelete contextDir = DSSTempUtils.getTempFolder((String)String.format("deployer-tmp-get-%s-id", this.getPackageType()), (String)SecretKeyGenerator.generate((int)8));){
            File tempPackageArchive = new File((File)contextDir, "package.zip");
            FileUtils.copyInputStreamToFile((InputStream)is, (File)tempPackageArchive);
            try (ZipFile archive = new ZipFile(tempPackageArchive);){
                ZipEntry epEntry = archive.getEntry("export-manifest.json");
                if (epEntry == null) {
                    throw ErrorContext.iae((String)"Zip file is not a valid project bundle (missing export-manifest.json)");
                }
                ExportedProject ep = (ExportedProject)JSON.parse((InputStream)archive.getInputStream(epEntry), ExportedProject.class);
                if (StringUtils.isBlank((String)publishedProjectKey)) {
                    publishedProjectKey = ep.originalProjectKey;
                }
                designNodeInfo.projectKey = ep.originalProjectKey;
                designNodeInfo.installId = ep.designNodeInstallId;
                designNodeInfo.nodeId = ep.designNodeId;
                designNodeInfo.url = ep.designNodeUrl;
                bundleId = ep.bundleId;
                ZipEntry spEntry = archive.getEntry("project_config/params.json");
                sp = spEntry == null ? null : (SerializedProject)JSON.parse((InputStream)archive.getInputStream(spEntry), SerializedProject.class);
                ZipEntry imageEntry = archive.getEntry("project_config/pictures/project-original.png");
                imageInBytes = imageEntry == null ? null : IOUtils.toByteArray((InputStream)archive.getInputStream(imageEntry));
            }
            created = this.publishPackageFromTempArchive_NT_Check(publishedProjectKey, bundleId, tempPackageArchive, authCtx);
        }
        this.writeProjectImageInfo(authCtx, publishedProjectKey, bundleId, sp, imageInBytes, created);
        this.writeBundleOriginInfo(authCtx, publishedProjectKey, bundleId, designNodeInfo);
        return this.getPublishedPackageOrNull_Check_NT(publishedProjectKey, bundleId, authCtx);
    }

    private void writeProjectImageInfo(AuthCtx authCtx, String publishedProjectKey, String bundleId, @Nullable SerializedProject sp, @Nullable byte[] imageInBytes, boolean created) throws IOException {
        RWTransaction t;
        if (sp != null) {
            BasicImageInfo basicImageInfo = this.getBundleImageInfo(sp);
            try (RWTransaction t2 = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                PublishedProject publishedProject = (PublishedProject)this.getPublishedItemsDAO().getMandatoryUnsafe(publishedProjectKey);
                publishedProject.basicImageInfo = basicImageInfo;
                publishedProject.versionTag = VersionTag.increment(publishedProject.versionTag, t2.getUser().getIdentifier());
                publishedProject.name = sp.name;
                if (created) {
                    logger.infoV("Propagating all permissions from project in bundle %s to published project %s.", new Object[]{bundleId, publishedProjectKey});
                    publishedProject.permissions = this.computeInitialPermissionsFromCoreGroupPermissions(sp.permissions);
                }
                this.getPublishedItemsDAO().save(publishedProject);
                t2.commit("Saving published project (updating image info) " + publishedProjectKey);
            }
        }
        if (imageInBytes == null) {
            t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
            try {
                this.imageService.removeImage(publishedProjectKey, "PUBLISHED_PROJECT", publishedProjectKey);
                t.commit("Removing previous project image for published project " + publishedProjectKey);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            this.imageService.setImage(publishedProjectKey, "PUBLISHED_PROJECT", publishedProjectKey, imageInBytes);
            t.commit("Adding project image to published project " + publishedProjectKey);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    private void checkReadPermission(String publishedProjectKey, AuthCtx authCtx) throws IOException, UnauthorizedException {
        try (Transaction t = this.transactionService.beginRead();){
            PublishedItem item = (PublishedItem)this.getPublishedItemsDAO().getMandatoryUnsafe(publishedProjectKey);
            if (!PublishedProjectsService.hasReadPermission(item, authCtx)) {
                throw new UnauthorizedException("You cannot access this published " + this.getType(), this.getExceptionTypePrefix() + "access-denied");
            }
        }
    }

    public CommonBundleUtils.BundleDetails getBundleDetails_NT(String publishedProjectKey, String bundleId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        this.checkReadPermission(publishedProjectKey, authCtx);
        File file = this.getPublishedPackageFileMandatory(publishedProjectKey, bundleId);
        return this.getBundleSummary(file);
    }

    public BundleDetailsExtended getBundleDetailsExtended_NT(String publishedProjectKey, String bundleId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        this.checkReadPermission(publishedProjectKey, authCtx);
        File file = this.getPublishedPackageFileMandatory(publishedProjectKey, bundleId);
        ExportedProject exportedProject = this.getBundleSummary((File)file).exportManifest;
        BundleDetailsExtended bundleDetailsExtended = new BundleDetailsExtended();
        bundleDetailsExtended.usedConnections = ImmutableList.copyOf(exportedProject.requiredConnections.values());
        bundleDetailsExtended.usedCodeEnvs = ImmutableList.copyOf(exportedProject.usedCodeEnvRefs);
        bundleDetailsExtended.usedContainerExecConfs = ImmutableList.copyOf(exportedProject.usedContainerExecConfs);
        bundleDetailsExtended.projectVariables = CommonBundleUtils.getProjectVariablesFromArchive(file);
        bundleDetailsExtended.scenarios = CommonBundleUtils.getScenariosFromArchive(file);
        return bundleDetailsExtended;
    }

    public List<String> listConnectionsNames_NT(String infraId, @Nullable String deploymentId, AuthCtx authCtx) throws UnauthorizedException, IOException, URISyntaxException, CodedException {
        return this.getInfrasService().listConnectionsNames_Check_NT(authCtx, infraId, deploymentId);
    }

    public List<String> listContainerExecNames_NT(String infraId, @Nullable String deploymentId, AuthCtx authCtx) throws UnauthorizedException, IOException, URISyntaxException, CodedException {
        return this.getInfrasService().listContainerExecNames_Check_NT(authCtx, infraId, deploymentId);
    }

    private CommonBundleUtils.BundleDetails getBundleSummary(File file) throws IOException {
        return CommonBundleUtils.getDetailsFromArchive(file);
    }

    public Set<String> getTagsFromBundle_NT(String publishedProjectKey, String bundleId) throws IOException {
        File file = this.publishedPackageFile(publishedProjectKey, bundleId);
        if (!file.exists()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(CommonBundleUtils.getProjectTagsFromArchive(file));
    }

    private void writeBundleOriginInfo(AuthCtx authCtx, String publishedProjectKey, String bundleId, DesignNodeInfo designNodeInfo) throws IOException {
        File bundleOriginInfoFile = this.bundleOriginInfoFile(publishedProjectKey, bundleId);
        BundleOriginInfo bundleOriginInfo = new BundleOriginInfo();
        bundleOriginInfo.bundleId = bundleId;
        bundleOriginInfo.publishedBy = authCtx.getIdentifier();
        bundleOriginInfo.designNodeInfo = designNodeInfo;
        JSON.prettyToFile((Object)bundleOriginInfo, (File)bundleOriginInfoFile);
    }

    private File bundleOriginInfoFile(String publishedProjectKey, String bundleId) {
        String bundleOriginFilename = "bundle-" + bundleId + "-origin-info.json";
        return ApplicationConfigurator.getFile((File)this.publishedPackagesDir(publishedProjectKey), (String[])new String[]{bundleOriginFilename});
    }

    public BundleOriginInfo getBundleOriginInfo(String publishedProjectKey, String bundleId) throws IOException {
        File bundleOriginInfoFile = this.bundleOriginInfoFile(publishedProjectKey, bundleId);
        if (bundleOriginInfoFile.exists()) {
            return (BundleOriginInfo)JSON.parseFile((File)bundleOriginInfoFile, BundleOriginInfo.class);
        }
        logger.warnV("Unable to get the bundle origin info of bundle %s in project %s", new Object[]{bundleId, publishedProjectKey});
        return null;
    }

    @Override
    public void deletePackage_NT_Check(String publishedProjectKey, String bundleId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        super.deletePackage_NT_Check(publishedProjectKey, bundleId, authCtx);
        File bundleOriginInfoFile = this.bundleOriginInfoFile(publishedProjectKey, bundleId);
        if (bundleOriginInfoFile.exists()) {
            DKUFileUtils.forceDelete((File)bundleOriginInfoFile);
        }
    }

    public DSSItemGovernanceStatus getGovernanceStatusForSinglePublishedPackage_NT_Check(String publishedProjectKey, String bundleId, AuthCtx authCtx) throws UnauthorizedException, IOException, CodedException {
        this.checkReadPermission(publishedProjectKey, authCtx);
        PublishedProjectBundleInfoForGovernIdentification packageInfo = this.getPublishedPackageInfoForGovernIdentification_NT(publishedProjectKey, bundleId);
        DSSBundleIdentifier bundleIdentifier = GovernIntegrationService.buildDSSBundleIdentifier(packageInfo);
        DSSItemIdentifierList dssItemIdentifierList = new DSSItemIdentifierList();
        dssItemIdentifierList.dssItemItentifiers.add(bundleIdentifier);
        DSSItemGovernanceStatusList dssItemGovernanceStatusList = this.governIntegrationService.getDSSItemsGovernanceStatus(dssItemIdentifierList);
        if (dssItemGovernanceStatusList.dssItemGovernanceStatuses.size() != 1) {
            throw new IllegalStateException(String.format("Unexpected error: cannot retrieve governance status for bundle: %s", bundleId));
        }
        return (DSSItemGovernanceStatus)dssItemGovernanceStatusList.dssItemGovernanceStatuses.get(0);
    }

    @Override
    public PublishedProjectBundleInfo getPublishedPackageOrNull_Check_NT(String publishedProjectKey, String bundleId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        File bundleFile = this.getPublishedPackageFileOrNull_Check_NT(publishedProjectKey, bundleId, authCtx);
        if (bundleFile == null) {
            return null;
        }
        PublishedProjectBundleInfo ret = new PublishedProjectBundleInfo();
        ret.id = bundleId;
        ret.publishedOn = bundleFile.lastModified();
        CommonBundleUtils.BundleDetails details = this.getBundleSummary(bundleFile);
        BundleOriginInfo bundleOriginInfo = this.getBundleOriginInfo(publishedProjectKey, bundleId);
        if (bundleOriginInfo != null) {
            ret.publishedBy = bundleOriginInfo.publishedBy;
            ret.designNodeInfo = bundleOriginInfo.designNodeInfo;
            ret.exportUserInfo = details.exportManifest.exportUserInfo;
        }
        ret.projectStandardsRunReportSummary = details.projectStandardsRunReport != null ? new ProjectStandardsRunReportSummary(details.projectStandardsRunReport) : null;
        return ret;
    }

    @Override
    public PublishedProjectBundleInfoForGovernIdentification getPublishedPackageInfoForGovernIdentification_NT(String publishedItemId, String packageId) throws CodedException, IOException {
        File file = this.getPublishedPackageFileMandatory(publishedItemId, packageId);
        CommonBundleUtils.BundleDetails details = this.getBundleSummary(file);
        if (details.exportManifest == null) {
            throw ErrorContext.iae((String)("Zip file is not a valid project bundle (missing export-manifest.json): " + publishedItemId + ", " + packageId));
        }
        if (StringUtils.isBlank((String)details.exportManifest.designNodeId) || StringUtils.isBlank((String)details.exportManifest.originalProjectKey) || StringUtils.isBlank((String)details.exportManifest.bundleId)) {
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_GOVERN_BUNDLE_FILE_MISSING_INFO, "Bundle has missing info in order to be identified in Govern: the Design instance Node ID may not be set; Node ID, Project Key, or Bundle ID is missing, the bundle may be too old: " + publishedItemId + ", " + packageId);
        }
        PublishedProjectBundleInfoForGovernIdentification publishedProjectBundleInfoForGovernIdentification = new PublishedProjectBundleInfoForGovernIdentification();
        publishedProjectBundleInfoForGovernIdentification.originalNodeId = details.exportManifest.designNodeId;
        publishedProjectBundleInfoForGovernIdentification.originalProjectKey = details.exportManifest.originalProjectKey;
        publishedProjectBundleInfoForGovernIdentification.originalBundleId = details.exportManifest.bundleId;
        return publishedProjectBundleInfoForGovernIdentification;
    }

    @Override
    public boolean hasCreatePermission(AuthCtx authCtx) {
        return ((DSSAuthCtx)authCtx).getPermissions().mayCreatePublishedProjects();
    }

    @Override
    public AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo basicInfoUnsafe(PublishedItem item) throws IOException {
        FullImageInfo imageInfo;
        if (TransactionContext.hasAttachedTransaction()) {
            imageInfo = this.getProjectImageInfo((PublishedProject)item);
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                imageInfo = this.getProjectImageInfo((PublishedProject)item);
            }
        }
        return new AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo(item, imageInfo);
    }

    @Override
    protected String packageFilenamePrefix() {
        return "dss-published-bundle-";
    }

    @Override
    protected String getExceptionTypePrefix() {
        return "projectdeployer-publishedproject-";
    }

    @Override
    public String getType() {
        return this.publishedProjectsDAO.getType();
    }

    @Override
    public String getPackageType() {
        return "bundle";
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }
}

