/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.security.model.GlobalScopePublicAPIKey;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import org.apache.commons.cli.Options;

public class AddAdminPublicAPIKeyCommand
extends CLICommandWithInvalidateCommonFilesCache {
    @Override
    public String usageString() {
        return "add-admin-api-key";
    }

    @Override
    public String description() {
        return "Adds an administrator-level public API key to DSS";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        this.parseAndMiniSetup(args, "add-admin-api-key", true);
        CLISetup.doSpringUtilsAndCoreServicesSetup();
        try (RWTransaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginWriteAsDSS();){
            PublicAPIKeysService keysService = new PublicAPIKeysService();
            keysService.standalone = true;
            GlobalScopePublicAPIKey key = new GlobalScopePublicAPIKey();
            key.label = "Added by dku command-line";
            key.createdBy = "CLI";
            key.createdOn = System.currentTimeMillis();
            key.globalPermissions.withAdmin(true);
            System.out.println(keysService.createGlobalAPIKey((GlobalScopePublicAPIKey)key).key);
            t.commit("CLI: Added an admin API key");
            int n = 0;
            return n;
        }
    }
}

