/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreSynchronizerFactory;
import com.dataiku.dip.hive.MetastoreSynchronizationUtils;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ErrorContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class HiveMetastoreSynchronizeCommand
extends CLICommand {
    @Override
    public Options opts() {
        Options opts = new Options();
        DKU.addGlobalOptions(opts);
        opts.addOption("n", "dry-run", false, "Only output the synchronization commands");
        opts.addOption("f", "force-drop", false, "Overwrite already existing Hive tables");
        return opts;
    }

    @Override
    public String usageString() {
        return "dku hive-metastore-synchronize DATASET [DATASET ...]";
    }

    @Override
    public String description() {
        return "Synchronize the Hive metastore for all partitions of a dataset";
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdline = this.parseAndMiniSetup(args, "hive-metastore-synchronize");
        CLISetup.doSpringUtilsAndCoreServicesSetup();
        try (HiveMetastoreSynchronizer synchronizer = HiveMetastoreSynchronizerFactory.getSynchronizer(DSSAuthCtx.newNone());){
            boolean simulate = cmdline.hasOption('n');
            boolean forceDrop = cmdline.hasOption('f');
            if (cmdline.getArgs().length == 0) {
                throw new IllegalArgumentException("Missing dataset parameter");
            }
            try (DKUTransactionService transactionService = new DKUTransactionService();
                 Transaction t = transactionService.beginRead();){
                for (int i = 1; i < cmdline.getArgs().length; ++i) {
                    String ds = cmdline.getArgs()[i];
                    DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(ds);
                    SerializedDataset sd = (SerializedDataset)CLISetup.getDatasetsDAO().getMandatory(loc.getProjectKey(), loc.getName());
                    Dataset dataset = Dataset.fromSerialized(sd);
                    if (!dataset.getType().equals("HDFS")) {
                        throw ErrorContext.iaef((String)"Dataset %s is not a HDFS dataset", (Object)dataset.getFullName(), (Object[])new Object[0]);
                    }
                    MetastoreSynchronizationUtils.SynchronizationRequestedStatus requestedStatus = MetastoreSynchronizationUtils.synchronizationRequested(DSSAuthCtx.newNone(), dataset);
                    if (!requestedStatus.requested) {
                        throw ErrorContext.iaef((String)"Synchronization is not enabled on dataset %s. %s", (Object)dataset.getFullName(), (Object[])new Object[]{requestedStatus.reason});
                    }
                    synchronizer.synchronizeOneDataset(dataset, simulate, forceDrop, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.OTHER, null, true);
                }
            }
        }
        return 0;
    }
}

