/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DKUNoGitTransactionService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SetupDSSVersionInProjectsGitTagCommand
extends CLICommand {
    public static final int DATASETS_PARTITION_SIZE = 10000;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cli.migration.projects-version-tag");

    @Override
    public String usageString() {
        return "__setup_dss_version_in_projects_git [--dry-run]";
    }

    @Override
    public String description() {
        return "Rewrite uncommitted datasets and add a git tag wit the current DSS version if changes were found.";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        options.addOption("n", "dry-run", false, "Dry run. Only log projects that need a version Git tag and a dataset rewrite.");
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "__setup_dss_version_in_projects_git", true);
        boolean dryRun = cmdLine.hasOption("dry-run");
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.DKU);
        if (ApplicationConfigurator.getNodeType() != ApplicationConfigurator.DSSNodeType.DESIGN) {
            logger.info((Object)"not a design node, projects git tag migration skipped");
            return 0;
        }
        AnnotationConfigApplicationContext ctx = CLISetup.doMiniJGitManagerServicesSetup();
        logger.info((Object)("starting dss version in projects git tag migration" + (dryRun ? " (dry run)" : "")));
        ProjectsJGitService projectsJGitService = (ProjectsJGitService)SpringUtils.getBean(ProjectsJGitService.class);
        String productVersion = DKUApp.getDSSVersion().product_version;
        List<String> projectKeys = CLISetup.listProjectKeys();
        DSSAuthCtx authCtx = DSSAuthCtx.migrationProcess();
        DKUNoGitTransactionService transactionService = new DKUNoGitTransactionService();
        for (String projectKey : projectKeys) {
            logger.info((Object)("Migrating " + projectKey));
            try {
                String projectVersion = projectsJGitService.getProjectVersion(projectKey);
                if (projectVersion != null && projectVersion.equals(productVersion)) {
                    logger.info((Object)("tag version of project " + projectKey + " is up-to-date (" + projectVersion + ")"));
                    continue;
                }
                GitModel.GitWorkingTreeStatus workingTreeStatus = projectsJGitService.getWorkingCopyStatus_NT(projectKey);
                if (!workingTreeStatus.hasUncommittedChanges) {
                    logger.info((Object)("No uncommitted changes found for project " + projectKey));
                    continue;
                }
                logger.info((Object)("Project " + projectKey + " has uncommited changes."));
                if (dryRun) {
                    logger.info((Object)("Project " + projectKey + " version tag needs to be updated from " + projectVersion + " to " + productVersion));
                    continue;
                }
                List<String> affectedDatasets = projectsJGitService.getAffectedDatasets(workingTreeStatus);
                List datasetsPartitions = Lists.partition(affectedDatasets, (int)10000);
                for (int i = 0; i < datasetsPartitions.size(); ++i) {
                    List datasetNamesPartition = (List)datasetsPartitions.get(i);
                    try (RWTransaction transaction = transactionService.beginWriteAsDSS();){
                        projectsJGitService.removeDiffNoiseFromSerialization(projectKey, datasetNamesPartition);
                        transaction.commit("Reformatting datasets " + (i + 1) + " / " + datasetsPartitions.size());
                    }
                    transactionService.clearCache();
                }
                workingTreeStatus = projectsJGitService.getWorkingCopyStatus_NT(projectKey);
                if (!workingTreeStatus.hasUncommittedChanges) {
                    logger.info((Object)"No changes to commit after noise removal - files reverted to original state");
                    continue;
                }
                TaggableObjectsService.TaggableObjectRef projectTagRef = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey);
                projectsJGitService.commitObject(projectTagRef, authCtx, "Migration to DSS version " + productVersion);
                projectsJGitService.addProjectVersionTag_NT(authCtx, projectKey);
                logger.info((Object)("Successfully updated version tag for project " + projectKey + " from " + (projectVersion == null ? "unknown version" : projectVersion) + " to " + productVersion));
            }
            catch (Exception ex) {
                logger.errorV("Failed to get project %s tag version: %s", new Object[]{projectKey, ExceptionUtils.getMessageWithCauses((Throwable)ex)});
            }
            finally {
                logger.info((Object)("Project " + projectKey + " migration completed."));
            }
        }
        ctx.close();
        return 0;
    }
}

