/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AvailablePythonInterpretersService {
    private List<StandardPythonInterpreter> availablePythonInterpreters = null;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.code.envs");

    public AvailablePythonInterpretersService() {
        new Thread(this::getAvailablePythonInterpreters).start();
    }

    static StandardPythonInterpreter findPythonVersionAndParse(String pythonCmd) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(pythonCmd, "-c", "import platform;major, minor, _ = platform.python_version_tuple();print(major+'.'+minor)");
        byte[] ret = DKUtils.execAndGetOutput((ProcessBuilder)pb);
        String[] version = new String(ret, StandardCharsets.UTF_8).trim().split("\\.|\\n");
        if (version.length != 2) {
            throw new RuntimeException("Cannot parse python version : " + new String(ret));
        }
        int major = Integer.parseInt(version[0]);
        int minor = Integer.parseInt(version[1]);
        return StandardPythonInterpreter.getInterpreter(major, minor);
    }

    private static boolean isAvailableInPath(StandardPythonInterpreter interpreter) {
        try {
            StandardPythonInterpreter foundInterpreter = AvailablePythonInterpretersService.findPythonVersionAndParse(interpreter.getPythonCommandString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized List<StandardPythonInterpreter> getAvailablePythonInterpreters() {
        if (this.availablePythonInterpreters != null) {
            return this.availablePythonInterpreters;
        }
        ArrayList<StandardPythonInterpreter> foundInterpreters = new ArrayList<StandardPythonInterpreter>();
        StandardPythonInterpreter baseEnvInterpreter = null;
        String baseEnvPythonBin = System.getenv("DKUPYTHONBIN");
        if (baseEnvPythonBin == null) {
            logger.warn((Object)"Could not find base env: DKUPYTHONBIN not defined");
        } else {
            try {
                baseEnvInterpreter = AvailablePythonInterpretersService.findPythonVersionAndParse(baseEnvPythonBin);
            }
            catch (Exception e) {
                logger.warn((Object)"Could not determine base env python interpreter", (Throwable)e);
            }
        }
        for (StandardPythonInterpreter interpreter : StandardPythonInterpreter.values()) {
            if (interpreter == StandardPythonInterpreter.CUSTOM || !AvailablePythonInterpretersService.isAvailableInPath(interpreter) && interpreter != baseEnvInterpreter) continue;
            foundInterpreters.add(interpreter);
        }
        this.availablePythonInterpreters = foundInterpreters;
        logger.info((Object)("Available interpreters found: " + String.valueOf(this.availablePythonInterpreters)));
        return this.availablePythonInterpreters;
    }
}

