/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.analysis.coreservices.MLTaskCodeEnvCompatibilityComputer;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.code.AvailablePythonInterpretersService;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvImportUtils;
import com.dataiku.dip.code.CodeEnvLanguages;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvPackageSystems;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.code.CodeEnvUtilsBase;
import com.dataiku.dip.code.CondaEnvUtils;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.code.DesignNodeCodeEnvPackagePresets;
import com.dataiku.dip.code.DesignNodeCodeEnvsAccessService;
import com.dataiku.dip.code.JupyterCodeEnvUtils;
import com.dataiku.dip.code.ProjectCodeEnvsSelection;
import com.dataiku.dip.code.PythonCodeEnvPackagesUtils;
import com.dataiku.dip.code.PythonCodeEnvUtils;
import com.dataiku.dip.code.RCodeEnvUtils;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecDockerFilePreparer;
import com.dataiku.dip.containers.exec.ContainerExecImagesBuilder;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.cde.ICDEImageBuilderService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.reports.IReflectedEventsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.CodeEnvChangedEvent;
import com.dataiku.dip.server.notifications.backend.ReflectedEventEvent;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.IPubSubService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DesignNodeCodeEnvsService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private DesignNodeCodeEnvsAccessService accessService;
    @Autowired
    private AvailablePythonInterpretersService availablePythonInterpretersService;
    @Autowired
    private IPluginsRegistryService pluginsRegistryService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IPubSubService pubSubService;
    @Autowired
    private ICDEImageBuilderService cdeImageBuilderService;
    private final File logsRootDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "logs"});
    private static DKULogger logger = DKULogger.getLogger((String)"dku.code.envs");

    public List<CodeEnvModel.CodeEnvListItem> listCodeEnvs() throws IOException {
        return this.accessService.listCodeEnvs();
    }

    public List<CodeEnvModel.CodeEnvListItem> listCodeEnvsWithKernelSpecNames_NT() throws IOException {
        List<CodeEnvModel.CodeEnvListItem> ret = this.accessService.listCodeEnvs();
        this.addKernelSpecNames(ret);
        return ret;
    }

    private void addKernelSpecNames(List<CodeEnvModel.CodeEnvListItem> ret) {
        HashMap kernelSpecByEnvName = Maps.newHashMap();
        try {
            for (JupyterService.KernelSpec kernelSpec : this.jupyterService.listKernelSpecs()) {
                if (!StringUtils.isNotBlank((String)kernelSpec.envName)) continue;
                kernelSpecByEnvName.put(kernelSpec.envName, kernelSpec);
            }
            for (CodeEnvModel.CodeEnvListItem env : ret) {
                if (!kernelSpecByEnvName.containsKey(env.envName)) continue;
                env.kernelSpecName = ((JupyterService.KernelSpec)kernelSpecByEnvName.get((Object)env.envName)).name;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get kernelSpecs", (Throwable)e);
            for (CodeEnvModel.CodeEnvListItem env : ret) {
                env.unknownKernelSpecStatus = true;
            }
        }
    }

    private List<CodeEnvModel.CodeEnvListItem> listCodeEnvsWithBuiltImagesForContainerConfigs() throws IOException {
        List<ContainerExecRuntimeConfig> containerConfs = ApplicationConfigurator.getGeneralSettings().containerSettings.listConfigsForWorkloadType(WorkloadType.USER_CODE);
        return this.listCodeEnvs().stream().peek(env -> {
            env.builtForContainerConfs = this.builtForContainerConfs(env.envName, env.envLang, containerConfs);
        }).collect(Collectors.toList());
    }

    public Set<String> builtForContainerConfs(String envName, CodeEnvModel.EnvLang envLang, List<ContainerExecRuntimeConfig> containerConfs) {
        return containerConfs.stream().filter(config -> ContainerExecImagesHelper.builtForContainerConf(config, envName, envLang, null)).map(config -> config.name).collect(Collectors.toSet());
    }

    public void checkPluginEnvUptodateWithDefinition(String pluginId, CodeEnvModel.CodeEnvListItem env) throws IOException {
        env.isUptodate = true;
        File pluginEnvFolder = new File(new File(this.pluginsRegistryService.getActualPluginFolder(pluginId), "code-env"), env.envLang.getFolderName());
        if (env.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED && pluginEnvFolder.exists()) {
            CodeEnvModel.EnvSpecData specData;
            try (Transaction t = this.accessService.getTransactionProvider().retrieveOrBeginRead();){
                specData = this.getEnvSpecData(env.envLang, env.envName);
            }
            String condaSpec = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)pluginEnvFolder, (String[])new String[]{"spec", "environment.spec"}));
            String packageList = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)pluginEnvFolder, (String[])new String[]{"spec", env.envLang.getPackageFileName()}));
            env.isUptodate &= StringUtils.equals((String)condaSpec, (String)specData.condaEnvSpec);
            env.isUptodate &= StringUtils.equals((String)packageList, (String)specData.packageList);
            String resourcesInitScript = DKUFileUtils.readFileToStringUTF8OrEmpty((File)DKUFileUtils.getWithin((File)pluginEnvFolder, (String[])new String[]{"spec", "resources_init.py"}));
            env.isUptodate &= StringUtils.equals((String)resourcesInitScript, (String)specData.resourcesInitScript);
        }
    }

    private List<PythonEnvInformation> getPythonEnvs_NT(AuthCtx authCtx) throws IOException, DKUSecurityException {
        List<CodeEnvModel.CodeEnvListItem> envList = this.listCodeEnvsWithBuiltImagesForContainerConfigs();
        HashSet pluginModes = Sets.newHashSet((Object[])new CodeEnvModel.CodeEnvDeploymentMode[]{CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED});
        ArrayList<CodeEnvModel.CodeEnvListItem> authorizedEnvs = new ArrayList<CodeEnvModel.CodeEnvListItem>();
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            for (CodeEnvModel.CodeEnvListItem env : envList) {
                if (pluginModes.contains((Object)env.deploymentMode) || !env.envLang.equals((Object)CodeEnvModel.EnvLang.PYTHON) || !this.permissionsService.hasAnyCodeEnvAccess(authCtx, env.envLang, env.envName)) continue;
                authorizedEnvs.add(env);
            }
        }
        ArrayList<PythonEnvInformation> ret = new ArrayList<PythonEnvInformation>();
        for (CodeEnvModel.CodeEnvListItem env : authorizedEnvs) {
            ret.add(new PythonEnvInformation(PythonCodeEnvPackagesUtils.getEnvPackages(this.getPythonEnvForUI(CodeEnvModel.EnvLang.PYTHON, env.envName, false)), env.builtForContainerConfs));
        }
        return ret;
    }

    public PythonCodeEnvPackagesUtils.PythonEnvPackages getPythonEnvPackages(String envName) throws IOException {
        return PythonCodeEnvPackagesUtils.getEnvPackages(this.getPythonEnvForUI(CodeEnvModel.EnvLang.PYTHON, envName, false));
    }

    public Stream<PythonCodeEnvPackagesUtils.PythonEnvPackages> getCompatiblePythonEnvs_NT(AuthCtx authCtx, String projectKey, PredictionMLTask task, MLTaskCodeEnvCompatibilityComputer envCompatibilityComputer) throws IOException, DKUSecurityException {
        List<PythonEnvInformation> allPythonEnvsExceptBuiltin = this.getPythonEnvs_NT(authCtx);
        ContainerExecRuntimeConfig containerConfig = null;
        try {
            containerConfig = new ContainerExecConfigSelector().selectForML_autoTXN(authCtx, projectKey, task.containerSelection, task.backendType);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to retrieve the container config", (Throwable)e);
        }
        ContainerExecRuntimeConfig finalContainerConfig = containerConfig;
        return allPythonEnvsExceptBuiltin.stream().filter(env -> envCompatibilityComputer.getIncompatibilityReasons_NT(new PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat(env.packages)).isEmpty() && (finalContainerConfig == null || env.builtForContainerConfs.contains(finalContainerConfig.name))).map(env -> env.packages);
    }

    public String getBestCompatibleEnvNameForKerasDL_NT(Stream<PythonCodeEnvPackagesUtils.PythonEnvPackages> compatibleEnvs) {
        PythonCodeEnvPackagesUtils.PythonEnvPackages selectedEnv = null;
        Iterator compatiblePythonEnvsIterator = compatibleEnvs.iterator();
        while (compatiblePythonEnvsIterator.hasNext()) {
            PythonCodeEnvPackagesUtils.PythonEnvPackages env = (PythonCodeEnvPackagesUtils.PythonEnvPackages)compatiblePythonEnvsIterator.next();
            if (PythonCodeEnvPackagesUtils.PythonEnvPackages.TensorflowSupport.LATEST_GPU.equals((Object)env.getTensorflowSupport())) {
                return env.envName;
            }
            if (selectedEnv != null && !env.getTensorflowSupport().gt(selectedEnv.getTensorflowSupport()) && (!env.getTensorflowSupport().equals((Object)selectedEnv.getTensorflowSupport()) || !env.getTensorflowVersion().gt(selectedEnv.getTensorflowVersion()))) continue;
            selectedEnv = env;
        }
        if (selectedEnv != null) {
            return selectedEnv.envName;
        }
        return null;
    }

    public String getBestCompatibleEnvNameForTimeseries_NT(Stream<PythonCodeEnvPackagesUtils.PythonEnvPackages> compatibleEnvs) {
        PythonCodeEnvPackagesUtils.PythonEnvPackages selectedEnv = null;
        Iterator compatiblePythonEnvsIterator = compatibleEnvs.iterator();
        while (compatiblePythonEnvsIterator.hasNext()) {
            PythonCodeEnvPackagesUtils.PythonEnvPackages env = (PythonCodeEnvPackagesUtils.PythonEnvPackages)compatiblePythonEnvsIterator.next();
            if (selectedEnv != null && !env.getMxnetSupport().gt(selectedEnv.getMxnetSupport()) && (!env.getMxnetSupport().equals((Object)selectedEnv.getMxnetSupport()) || !env.getMxnetVersion().gt(selectedEnv.getMxnetVersion()))) continue;
            selectedEnv = env;
        }
        if (selectedEnv != null) {
            return selectedEnv.envName;
        }
        return null;
    }

    public List<PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat> getEnvListWithVisualMlCompat_NT(AuthCtx authCtx) throws IOException, DKUSecurityException {
        ArrayList<PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat> envsWithVisualMlCompat = new ArrayList<PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat>();
        for (PythonEnvInformation envInfo : this.getPythonEnvs_NT(authCtx)) {
            envsWithVisualMlCompat.add(new PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat(envInfo.packages));
        }
        return envsWithVisualMlCompat;
    }

    public EnvsCompatibilityWithMLTask getEnvsCompatibilityWithMLTask_NT(AuthCtx authCtx, MLTask task, ProjectCodeEnvsSelection projectEnvsSelection, String projectKey) throws IOException, DKUSecurityException {
        EnvsCompatibilityWithMLTask res = new EnvsCompatibilityWithMLTask();
        String resolvedInheritDefaultCodeEnv = new CodeEnvSelector().getProjectDefault(CodeEnvModel.EnvLang.PYTHON, projectEnvsSelection);
        String resolvedInheritDefaultContainer = new ContainerExecConfigSelector().getProjectEnvDefault_autoTXN(projectKey, WorkloadType.USER_CODE);
        MLTaskCodeEnvCompatibilityComputer incompatibilityComputer = new MLTaskCodeEnvCompatibilityComputer(task);
        res.resolvedInheritDefaultCodeEnv = resolvedInheritDefaultCodeEnv;
        res.resolvedInheritDefaultContainer = resolvedInheritDefaultContainer;
        PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat envCompat = PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat.builtinEnvCompatibility();
        res.builtinIncompatibilityReasons = incompatibilityComputer.getIncompatibilityReasons_NT(envCompat);
        res.builtinEnvDescription = incompatibilityComputer.getMLTaskDescriptionForCompatibility(envCompat);
        for (PythonEnvInformation envInfo : this.getPythonEnvs_NT(authCtx)) {
            envCompat = new PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat(envInfo.packages);
            res.envs.add(new EnvCompatibilityWithMLTask(envInfo.packages.envName, incompatibilityComputer.getMLTaskDescriptionForCompatibility(envCompat), incompatibilityComputer.getIncompatibilityReasons_NT(envCompat), envInfo.builtForContainerConfs));
        }
        return res;
    }

    public List<PythonCodeEnvPackagesUtils.CodeEnvMLflowCompat> getEnvListWithMLflowCompat_NT(AuthCtx authCtx) throws IOException, DKUSecurityException {
        ArrayList<PythonCodeEnvPackagesUtils.CodeEnvMLflowCompat> envsWithMLflowCompat = new ArrayList<PythonCodeEnvPackagesUtils.CodeEnvMLflowCompat>();
        for (PythonEnvInformation envInfo : this.getPythonEnvs_NT(authCtx)) {
            envsWithMLflowCompat.add(new PythonCodeEnvPackagesUtils.CodeEnvMLflowCompat(envInfo.packages));
        }
        return envsWithMLflowCompat;
    }

    public List<PythonCodeEnvPackagesUtils.CodeEnvTestCompat> getEnvListWithTestCompat_NT(AuthCtx authCtx) throws IOException, DKUSecurityException {
        ArrayList<PythonCodeEnvPackagesUtils.CodeEnvTestCompat> envsWithTestCompat = new ArrayList<PythonCodeEnvPackagesUtils.CodeEnvTestCompat>();
        for (PythonEnvInformation envInfo : this.getPythonEnvs_NT(authCtx)) {
            envsWithTestCompat.add(new PythonCodeEnvPackagesUtils.CodeEnvTestCompat(envInfo.packages));
        }
        return envsWithTestCompat;
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> startImportEnv(AuthCtx authCtx, String owner, CodeEnvModel.CodeEnvDeploymentMode mode, String envName, CodeEnvModel.EnvLang envLang, File envFolder, File envFolderCleanup, CodeEnvModel.CodeEnvUpdateSettings updateSettings) throws Exception, Error {
        return this.startImportEnv(authCtx, owner, mode, envName, envLang, envFolder, envFolderCleanup, updateSettings, null, false);
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> startImportEnv(AuthCtx authCtx, String owner, CodeEnvModel.CodeEnvDeploymentMode mode, String envName, CodeEnvModel.EnvLang envLang, File envFolder, File envFolderCleanup, CodeEnvModel.CodeEnvUpdateSettings updateSettings, String pluginId, boolean associateToPlugin) throws Exception, Error {
        this.accessService.checkEnvDoesntExists(envLang, envName);
        switch (envLang) {
            case PYTHON: {
                return this.importPythonEnv(authCtx, owner, mode, envName, envLang, envFolder, envFolderCleanup, updateSettings, pluginId, associateToPlugin);
            }
            case R: {
                return this.importREnv(authCtx, owner, mode, envName, envLang, envFolder, envFolderCleanup);
            }
        }
        throw new Error("Unsupported language for code env: " + String.valueOf((Object)envLang));
    }

    private FutureResponse<CodeEnvModel.EnvCreationResult> importREnv(final AuthCtx authCtx, String owner, final CodeEnvModel.CodeEnvDeploymentMode mode, final String envName, final CodeEnvModel.EnvLang envLang, final File envFolder, final File envFolderCleanup) throws Exception {
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        File descFile = new File(envFolder, "desc.json");
        CodeEnvModel.AbstractEnvDesc envDesc = (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.REnvDesc.class);
        final CodeEnvModel.DesignNewREnvSpec spec = (CodeEnvModel.DesignNewREnvSpec)JSON.parse((String)JSON.json((Object)envDesc), CodeEnvModel.DesignNewREnvSpec.class);
        spec.envName = envName;
        spec.deploymentMode = mode;
        spec.owner = owner;
        spec.usableByAll = true;
        spec.permissions.clear();
        logger.info((Object)("Importing env with spec " + JSON.json((Object)spec)));
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvCreationResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvCreationResult compute() throws Exception {
                CodeEnvModel.EnvCreationResult ret = new CodeEnvModel.EnvCreationResult(spec.envName);
                try {
                    File log = ApplicationConfigurator.getFile((File)DesignNodeCodeEnvsService.this.logsRootDir, (String[])new String[]{CodeEnvModel.EnvLang.R.getFolderName(), spec.envName, "createREnv.log"});
                    DesignNodeCodeEnvsService.this.createREnv(authCtx, spec, logTailBuilder, log, ret);
                    DesignNodeCodeEnvsService.this.importSpecToDirectory(authCtx, CodeEnvModel.EnvLang.R, spec.envName, envFolder);
                    DKUFileUtils.mkdirsParent((File)log);
                    if (mode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED) {
                        DesignNodeCodeEnvsService.this.updateEnvAccordingToSpec(authCtx, CodeEnvModel.EnvLang.R, spec.envName, new CodeEnvModel.CodeEnvUpdateSettings(), logTailBuilder, log);
                    }
                    DesignNodeCodeEnvsService.this.buildEnvDockerImage(spec, envLang, envName, logTailBuilder, log, ret.messages, false);
                    ret.messages.withInfo((InfoMessage.MessageCode)CodeEnvCodes.INFO_CODEENV_IMPORT_OK, "Imported " + envFolder.getName() + " as code env " + spec.envName);
                }
                catch (Exception e) {
                    logger.error((Object)"Env creation failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                if (envFolderCleanup != null) {
                    DKUFileUtils.forceDelete((File)envFolderCleanup);
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"import_env", (String)("Import env: " + spec.envName));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvCreationResult>>(){});
    }

    private FutureResponse<CodeEnvModel.EnvCreationResult> importPythonEnv(final AuthCtx authCtx, String owner, final CodeEnvModel.CodeEnvDeploymentMode mode, final String envName, final CodeEnvModel.EnvLang envLang, final File envFolder, final File envFolderCleanup, final CodeEnvModel.CodeEnvUpdateSettings updateSettings, final String pluginId, final boolean associateToPlugin) throws Exception {
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        File descFile = new File(envFolder, "desc.json");
        final CodeEnvModel.DesignNewPythonEnvSpec spec = (CodeEnvModel.DesignNewPythonEnvSpec)JSON.parseFile((File)descFile, CodeEnvModel.DesignNewPythonEnvSpec.class);
        spec.envName = envName;
        spec.deploymentMode = mode;
        spec.owner = owner;
        spec.usableByAll = true;
        spec.permissions.clear();
        logger.info((Object)("Importing env with spec " + JSON.json((Object)spec)));
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvCreationResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvCreationResult compute() throws Exception {
                CodeEnvModel.EnvCreationResult ret = new CodeEnvModel.EnvCreationResult(spec.envName);
                try {
                    File log = ApplicationConfigurator.getFile((File)DesignNodeCodeEnvsService.this.logsRootDir, (String[])new String[]{CodeEnvModel.EnvLang.PYTHON.getFolderName(), spec.envName, "createPythonEnv.log"});
                    DesignNodeCodeEnvsService.this.createPythonEnv(authCtx, spec, logTailBuilder, log, ret);
                    DesignNodeCodeEnvsService.this.importSpecToDirectory(authCtx, CodeEnvModel.EnvLang.PYTHON, spec.envName, envFolder);
                    DKUFileUtils.mkdirsParent((File)log);
                    if (mode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED || mode == CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL || mode == CodeEnvModel.CodeEnvDeploymentMode.DESIGN_MANAGED) {
                        DesignNodeCodeEnvsService.this.updateEnvAccordingToSpec(authCtx, CodeEnvModel.EnvLang.PYTHON, spec.envName, updateSettings, logTailBuilder, log);
                    }
                    CodeEnvModel.EnvSpecData specData = DesignNodeCodeEnvsService.this.getEnvSpecData(CodeEnvModel.EnvLang.PYTHON, spec.envName);
                    if ((mode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED || mode == CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL) && ((CodeEnvModel.PythonEnvDesc)specData.desc).installCorePackages && updateSettings.updateResources) {
                        File resourcesFolder;
                        File envFolder2;
                        File descFolder = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", envLang.getFolderName(), envName});
                        boolean successfulRun = PythonCodeEnvUtils.maybeRunResourcesInitScript(authCtx, specData.resourcesInitScript, envName, descFolder, envFolder2 = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", envLang.getFolderName(), envName}), resourcesFolder = new File(DesignNodeCodeEnvsService.getResourcesPath(envLang, envName)), logTailBuilder, log, ret.messages);
                        if (successfulRun) {
                            DesignNodeCodeEnvsService.this.updateEnvSnapshotFromActualData(authCtx, envLang, envName, "After resources init script", logTailBuilder, log);
                        }
                        DesignNodeCodeEnvsService.this.addResourcesEnvVariablesToJupyterKernel(envLang, envName, logTailBuilder, log, false);
                    }
                    if (StringUtils.isNotBlank((String)pluginId) && associateToPlugin) {
                        String oldEnvName = null;
                        try (RWTransaction t = DesignNodeCodeEnvsService.this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                            PluginSettings settings = DesignNodeCodeEnvsService.this.pluginsRegistryService.getSettings(pluginId);
                            oldEnvName = settings.codeEnvName;
                            settings.codeEnvName = envName;
                            DesignNodeCodeEnvsService.this.pluginsRegistryService.setSettings(pluginId, settings);
                            t.commit("Changed code env on plugin " + pluginId);
                        }
                        if (StringUtils.isNotBlank((String)pluginId) && !StringUtils.equals((String)oldEnvName, (String)envName)) {
                            DesignNodeCodeEnvsService.this.cdeImageBuilderService.buildIfNeededOnPluginCodeEnvChange(pluginId, logTailBuilder, ret.messages);
                        }
                    }
                    DesignNodeCodeEnvsService.this.buildEnvDockerImage((CodeEnvModel.AbstractEnvDesc)specData.desc, envLang, envName, logTailBuilder, log, ret.messages, false);
                    if (((CodeEnvModel.PythonEnvDesc)specData.desc).pythonInterpreter.isDeprecated()) {
                        ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.WARN_CODEENV_PYTHON_DEPRECATED, "Python interpreter: '" + String.valueOf((Object)((CodeEnvModel.PythonEnvDesc)specData.desc).pythonInterpreter) + "' is deprecated.");
                    }
                    ret.messages.withInfo((InfoMessage.MessageCode)CodeEnvCodes.INFO_CODEENV_IMPORT_OK, "Imported " + envFolder.getName() + " as code env " + envName);
                }
                catch (Exception e) {
                    logger.error((Object)"Env creation failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                if (envFolderCleanup != null) {
                    DKUFileUtils.forceDelete((File)envFolderCleanup);
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"import_env", (String)("Import env: " + spec.envName));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvCreationResult>>(){});
    }

    public CodeEnvFromPresetResult handlePythonCodeEnvFromPreset(AuthCtx authCtx, CodeEnvModel.DesignNewPythonEnvSpec envSpec, String presetName, boolean allowUpdate, StandardPythonInterpreter interpreter, String customName) throws Exception {
        if (customName != null && !customName.matches("[\\w-]{1,50}")) {
            throw new IllegalArgumentException("Prefix may only contain letters, digits, underscores, and dashes.");
        }
        CodeEnvFromPresetResult result = new CodeEnvFromPresetResult();
        result.action = CodeEnvFromPresetAction.NONE;
        StandardPythonInterpreter defaultInterpreter = interpreter;
        ArrayList<StandardPythonInterpreter> acceptedPythonInterpreters = new ArrayList<StandardPythonInterpreter>(StandardPythonInterpreter.getAcceptedPythonInterpreters());
        if (defaultInterpreter == null || !acceptedPythonInterpreters.contains((Object)defaultInterpreter)) {
            List<StandardPythonInterpreter> availablePythonInterpreters = this.availablePythonInterpretersService.getAvailablePythonInterpreters();
            defaultInterpreter = CodeEnvUtilsBase.getDefaultInterpreterForPlugin(availablePythonInterpreters, acceptedPythonInterpreters);
        }
        envSpec.pythonInterpreter = defaultInterpreter;
        envSpec.initializeCorePackageSetBasedOnInterpreter();
        DesignNodeCodeEnvPackagePresets.CodeEnvPackagePreset selectedPreset = this.getPresetFromPresetName(defaultInterpreter, presetName, envSpec.corePackagesSet.name());
        if (selectedPreset == null) {
            throw new IllegalArgumentException("Could not find preset " + presetName);
        }
        String prefix = (customName != null ? customName : presetName) + "_py" + defaultInterpreter.getMajor() + defaultInterpreter.getMinor() + "_v";
        envSpec.envName = this.getCodeEnvNameToUpdateFromPreset(selectedPreset, defaultInterpreter, prefix, allowUpdate);
        logger.info((Object)("Setting up code env " + envSpec.envName));
        if (envSpec.envName != null) {
            boolean createNewCodeEnv;
            boolean bl = createNewCodeEnv = !this.accessService.doesEnvExist(CodeEnvModel.EnvLang.PYTHON, envSpec.envName);
            if (createNewCodeEnv) {
                logger.info((Object)("Creating new code env " + envSpec.envName));
                envSpec.installCorePackages = true;
                envSpec.installJupyterSupport = true;
                envSpec.upstreamPreset = selectedPreset;
                FutureResponse frCreate = this.startCreatePythonEnv(authCtx, envSpec);
                frCreate = this.futureService.waitForFinalResponse(frCreate);
                if (!frCreate.hasResult) {
                    logger.error((Object)("Code env " + envSpec.envName + " failed during creation."));
                }
            }
            CodeEnvModel.DesignUIPythonEnv currentEnv = this.getPythonEnvForUI(CodeEnvModel.EnvLang.PYTHON, envSpec.envName, false);
            currentEnv.specPackageList = String.join((CharSequence)"\n", selectedPreset.packages);
            currentEnv.upstreamPreset = selectedPreset;
            logger.info((Object)("Saving code env " + envSpec.envName));
            this.saveEnvForUI(authCtx, currentEnv.envLang, currentEnv.envName, currentEnv, false);
            CodeEnvModel.CodeEnvUpdateSettings updateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
            updateSettings.forceRebuildEnv = !createNewCodeEnv;
            logger.info((Object)("Installing packages via update on code env " + envSpec.envName));
            FutureResponse frUpdate = this.startUpdateEnvAccordingToSpec(authCtx, CodeEnvModel.EnvLang.PYTHON, envSpec.envName, updateSettings);
            frUpdate = this.futureService.waitForFinalResponse(frUpdate);
            if (frUpdate.hasResult) {
                result.action = createNewCodeEnv ? CodeEnvFromPresetAction.CREATE : CodeEnvFromPresetAction.UPDATE;
                logger.info((Object)("Update complete on code env " + envSpec.envName));
            } else {
                logger.error((Object)("Code env " + envSpec.envName + " failed during update"));
            }
        }
        result.envName = envSpec.envName;
        return result;
    }

    private DesignNodeCodeEnvPackagePresets.CodeEnvPackagePreset getPresetFromPresetName(StandardPythonInterpreter interpreter, String presetName, String corePackageSet) throws Exception {
        Map presetMap = DesignNodeCodeEnvPackagePresets.forPython(interpreter, false, corePackageSet).stream().collect(Collectors.toMap(DesignNodeCodeEnvPackagePresets.CodeEnvPackagePreset::getId, Function.identity()));
        DesignNodeCodeEnvPackagePresets.CodeEnvPackagePreset preset = null;
        if (presetName.equals("automl")) {
            preset = (DesignNodeCodeEnvPackagePresets.CodeEnvPackagePreset)presetMap.get(DesignNodeCodeEnvPackagePresets.CodeEnvPreset.DOCTOR.name());
        } else if (presetName.equals("automl_gpu")) {
            preset = (DesignNodeCodeEnvPackagePresets.CodeEnvPackagePreset)presetMap.get(DesignNodeCodeEnvPackagePresets.CodeEnvPreset.DOCTOR_TIMESERIES_GPU_CUDA112.name());
        }
        return preset;
    }

    private List<CodeEnvModel.CodeEnvListItem> getExistingCodeEnvsFromPreset(StandardPythonInterpreter interpreter, String presetId, String prefix) throws Exception {
        return this.listCodeEnvs().stream().filter(codeEnv -> codeEnv.upstreamPreset != null && codeEnv.upstreamPreset.id.equals(presetId) && codeEnv.pythonInterpreter == interpreter && this.codeEnvHasMatchingPrefix(codeEnv.envName, prefix)).collect(Collectors.toList());
    }

    private boolean codeEnvHasMatchingPrefix(String codeEnvName, String prefix) {
        return codeEnvName.substring(0, codeEnvName.lastIndexOf("v") + 1).equals(prefix);
    }

    String getCodeEnvNameToUpdateFromPreset(DesignNodeCodeEnvPackagePresets.CodeEnvPackagePreset preset, StandardPythonInterpreter defaultInterpreter, String prefix, boolean defaultAllowUpdate) throws Exception {
        List<CodeEnvModel.CodeEnvListItem> codeEnvList = this.getExistingCodeEnvsFromPreset(defaultInterpreter, preset.id, prefix);
        boolean allowUpdate = defaultAllowUpdate;
        logger.info((Object)"Getting name of code env to create or update...");
        if (!codeEnvList.isEmpty()) {
            codeEnvList.sort(new Comparator<CodeEnvModel.CodeEnvListItem>(){

                @Override
                public int compare(CodeEnvModel.CodeEnvListItem a, CodeEnvModel.CodeEnvListItem b) {
                    return a.upstreamPreset.major == b.upstreamPreset.major ? b.upstreamPreset.minor - a.upstreamPreset.minor : b.upstreamPreset.major - a.upstreamPreset.major;
                }
            });
            CodeEnvModel.CodeEnvListItem latestCodeEnv = codeEnvList.get(0);
            int latestMajorVersion = latestCodeEnv.upstreamPreset.major;
            int latestMinorVersion = latestCodeEnv.upstreamPreset.minor;
            Optional<CodeEnvModel.CodeEnvListItem> latestMajorCodeEnv = codeEnvList.stream().filter(codeEnv -> codeEnv.envName.endsWith("_v" + codeEnv.upstreamPreset.major)).findFirst();
            if (latestMajorVersion == preset.major) {
                if (latestMinorVersion < preset.minor && latestMajorCodeEnv.isPresent()) {
                    if (allowUpdate && !this.codeEnvPackagesHaveChanged(latestMajorCodeEnv.get())) {
                        logger.info((Object)("Found non-user-modified major code env " + latestMajorCodeEnv.get().envName + ": using major name for update"));
                        return latestMajorCodeEnv.get().envName;
                    }
                    logger.info((Object)(allowUpdate ? "Major code env tampered with" : "allowUpdate is false: using minor name for creation"));
                    allowUpdate = false;
                } else {
                    if (latestMinorVersion == preset.minor) {
                        logger.info((Object)"Major and minor versions haven't changed: doing nothing");
                        return null;
                    }
                    if (latestMinorVersion > preset.minor) {
                        logger.info((Object)"Installed major and minor version greater than preset major and minor version: doing nothing");
                        return null;
                    }
                }
            } else if (latestMajorVersion > preset.major) {
                logger.info((Object)"Installed major version greater than preset major version: doing nothing");
                return null;
            }
        } else {
            logger.info((Object)("No code envs for specified preset + python env exist yet: using " + (allowUpdate ? "major" : "minor") + " name for creation"));
        }
        return prefix + preset.major + (String)(allowUpdate ? "" : "-" + preset.minor);
    }

    boolean codeEnvPackagesHaveChanged(CodeEnvModel.CodeEnvListItem codeEnv) throws IOException {
        CodeEnvModel.DesignUIPythonEnv pythonEnv = this.getPythonEnvForUI(codeEnv.envLang, codeEnv.envName, false);
        ArrayList<String> specPackageList = new ArrayList<String>(Arrays.asList(pythonEnv.specPackageList.split("\n")));
        return specPackageList.size() != codeEnv.upstreamPreset.packages.size() || !specPackageList.containsAll(codeEnv.upstreamPreset.packages);
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> startUpdatePluginEnv(final AuthCtx authCtx, final CodeEnvModel.EnvLang envLang, final String envName, final File envFolder, final CodeEnvModel.CodeEnvUpdateSettings updateSettings, final String pluginId) throws Exception, Error {
        this.accessService.checkEnvExists(envLang, envName);
        CodeEnvModel.AbstractEnvDesc envDesc = this.getEnvDesc(envLang, envName);
        final CodeEnvModel.CodeEnvDeploymentMode mode = envDesc.deploymentMode;
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        if (envLang == CodeEnvModel.EnvLang.PYTHON) {
            return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvCreationResult>(authCtx){

                @Override
                protected CodeEnvModel.EnvCreationResult compute() throws Exception {
                    CodeEnvModel.EnvCreationResult ret = new CodeEnvModel.EnvCreationResult(envName);
                    try {
                        DesignNodeCodeEnvsService.this.importSpecToDirectory(authCtx, CodeEnvModel.EnvLang.PYTHON, envName, envFolder);
                        File log = ApplicationConfigurator.getFile((File)DesignNodeCodeEnvsService.this.logsRootDir, (String[])new String[]{CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName, "updatePythonEnv.log"});
                        DKUFileUtils.mkdirsParent((File)log);
                        CodeEnvModel.EnvSpecData<Object> specData = new CodeEnvModel.EnvSpecData();
                        if (mode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED) {
                            specData = DesignNodeCodeEnvsService.this.updateEnvAccordingToSpec(authCtx, CodeEnvModel.EnvLang.PYTHON, envName, updateSettings, logTailBuilder, log);
                        }
                        CodeEnvModel.AbstractEnvDesc desc = DesignNodeCodeEnvsService.this.getEnvDesc(envLang, envName);
                        if (mode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED && ((CodeEnvModel.PythonEnvDesc)desc).installCorePackages && updateSettings.updateResources) {
                            File resourcesFolder;
                            File envFolder2;
                            File descFolder = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", envLang.getFolderName(), envName});
                            boolean successfulRun = PythonCodeEnvUtils.maybeRunResourcesInitScript(authCtx, specData.resourcesInitScript, envName, descFolder, envFolder2 = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", envLang.getFolderName(), envName}), resourcesFolder = new File(DesignNodeCodeEnvsService.getResourcesPath(envLang, envName)), logTailBuilder, log, ret.messages);
                            if (successfulRun) {
                                DesignNodeCodeEnvsService.this.updateEnvSnapshotFromActualData(authCtx, envLang, envName, "After resources init script", logTailBuilder, log);
                            }
                            DesignNodeCodeEnvsService.this.addResourcesEnvVariablesToJupyterKernel(envLang, envName, logTailBuilder, log, false);
                        }
                        if (StringUtils.isNotBlank((String)pluginId)) {
                            DesignNodeCodeEnvsService.this.cdeImageBuilderService.buildIfNeededOnPluginCodeEnvChange(pluginId, logTailBuilder, ret.messages);
                        }
                        ret.messages.withInfo((InfoMessage.MessageCode)CodeEnvCodes.INFO_CODEENV_IMPORT_OK, "Updated " + envFolder.getName() + " as code env " + envName);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Env creation failed", (Throwable)e);
                        ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                    return ret;
                }

                public FuturePayload getPayload() {
                    return FuturePayload.newSimple((String)"update_env", (String)("Update env: " + envName));
                }

                public SmartLogTail getLog() {
                    return logTailBuilder.get();
                }
            }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvCreationResult>>(){});
        }
        if (envLang == CodeEnvModel.EnvLang.R) {
            return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvCreationResult>(authCtx){

                @Override
                protected CodeEnvModel.EnvCreationResult compute() throws Exception {
                    CodeEnvModel.EnvCreationResult ret = new CodeEnvModel.EnvCreationResult(envName);
                    try {
                        DesignNodeCodeEnvsService.this.importSpecToDirectory(authCtx, CodeEnvModel.EnvLang.R, envName, envFolder);
                        File log = ApplicationConfigurator.getFile((File)DesignNodeCodeEnvsService.this.logsRootDir, (String[])new String[]{CodeEnvModel.EnvLang.R.getFolderName(), envName, "updateREnv.log"});
                        DKUFileUtils.mkdirsParent((File)log);
                        if (mode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED) {
                            DesignNodeCodeEnvsService.this.updateEnvAccordingToSpec(authCtx, CodeEnvModel.EnvLang.R, envName, new CodeEnvModel.CodeEnvUpdateSettings(), logTailBuilder, log);
                        }
                        ret.messages.withInfo((InfoMessage.MessageCode)CodeEnvCodes.INFO_CODEENV_IMPORT_OK, "Imported " + envFolder.getName() + " as code env " + envName);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Env creation failed", (Throwable)e);
                        ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                    return ret;
                }

                public FuturePayload getPayload() {
                    return FuturePayload.newSimple((String)"update_env", (String)("Update env: " + envName));
                }

                public SmartLogTail getLog() {
                    return logTailBuilder.get();
                }
            }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvCreationResult>>(){});
        }
        throw new Error("Unreachable");
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> startCreatePythonEnv(final AuthCtx authCtx, final CodeEnvModel.DesignNewPythonEnvSpec spec) throws Exception {
        this.accessService.checkEnvDoesntExists(CodeEnvModel.EnvLang.PYTHON, spec.envName);
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvCreationResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvCreationResult compute() throws Exception {
                CodeEnvModel.EnvCreationResult ret = new CodeEnvModel.EnvCreationResult(spec.envName);
                try {
                    File log = ApplicationConfigurator.getFile((File)DesignNodeCodeEnvsService.this.logsRootDir, (String[])new String[]{CodeEnvModel.EnvLang.PYTHON.getFolderName(), spec.envName, "createPythonEnv.log"});
                    DesignNodeCodeEnvsService.this.createPythonEnv(authCtx, spec, logTailBuilder, log, ret);
                    DesignNodeCodeEnvsService.this.buildEnvDockerImage(spec, CodeEnvModel.EnvLang.PYTHON, spec.envName, logTailBuilder, log, ret.messages, false);
                    DesignNodeCodeEnvsService.this.pubSubService.publish((DSSEvent)new CodeEnvChangedEvent(spec.envName, CodeEnvChangedEvent.ActionType.CREATED, authCtx.getIdentifier()));
                }
                catch (Exception e) {
                    logger.error((Object)"Env creation failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"create_python_env", (String)("Create Python env: " + spec.envName));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvCreationResult>>(){});
    }

    private FutureResponse<CodeEnvModel.EnvCreationResult> startCreatePythonEnvFromDraft(final AuthCtx authCtx, final File draftFolder, final CodeEnvModel.DesignNewPythonEnvSpec spec, final File condaEnv, final File packages) throws Exception {
        this.accessService.checkEnvDoesntExists(CodeEnvModel.EnvLang.PYTHON, spec.envName);
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvCreationResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvCreationResult compute() throws Exception {
                CodeEnvModel.EnvCreationResult ret = new CodeEnvModel.EnvCreationResult(spec.envName);
                try {
                    File log = ApplicationConfigurator.getFile((File)DesignNodeCodeEnvsService.this.logsRootDir, (String[])new String[]{CodeEnvModel.EnvLang.PYTHON.getFolderName(), spec.envName, "createPythonEnv.log"});
                    DesignNodeCodeEnvsService.this.createPythonEnv(authCtx, spec, logTailBuilder, log, ret);
                    DesignNodeCodeEnvsService.this.updateSpecData(authCtx, spec.envName, CodeEnvModel.EnvLang.PYTHON, spec.conda, condaEnv, packages);
                    DesignNodeCodeEnvsService.this.buildEnvDockerImage(spec, CodeEnvModel.EnvLang.PYTHON, spec.envName, logTailBuilder, log, ret.messages, false);
                    DesignNodeCodeEnvsService.this.pubSubService.publish((DSSEvent)new CodeEnvChangedEvent(spec.envName, CodeEnvChangedEvent.ActionType.CREATED, authCtx.getIdentifier()));
                    DKUFileUtils.forceDelete((File)draftFolder);
                }
                catch (Exception e) {
                    logger.error((Object)"Env creation failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"create_python_env", (String)("Create Python env: " + spec.envName));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvCreationResult>>(){});
    }

    private void createPythonEnv(AuthCtx authCtx, CodeEnvModel.DesignNewPythonEnvSpec spec, DKUtils.SmartLogTailBuilder tailBuilder, File log, CodeEnvModel.EnvCreationResult ret) throws Exception {
        File targetEnvDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", CodeEnvModel.EnvLang.PYTHON.getFolderName(), spec.envName});
        DKUFileUtils.mkdirsParent((File)targetEnvDir);
        DKUFileUtils.mkdirsParent((File)log);
        if (spec.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DESIGN_NON_MANAGED || spec.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED) {
            logger.info((Object)"Creating a non managed env");
            CodeEnvModel.PythonEnvDesc newDesc = new CodeEnvModel.PythonEnvDesc();
            newDesc.owner = spec.owner;
            newDesc.usableByAll = true;
            newDesc.deploymentMode = spec.deploymentMode;
            newDesc.externalCondaEnvName = spec.externalCondaEnvName;
            try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
                t.writeObject(new RelFile(new String[]{CodeEnvModel.EnvLang.PYTHON.getFolderName(), spec.envName, "desc.json"}), (Object)newDesc);
                t.commit("Created non-managed Python environment: " + spec.envName);
            }
            DKUFileUtils.mkdirs((File)this.actualEnvFolder(CodeEnvModel.EnvLang.PYTHON, spec.envName));
            return;
        }
        if (spec.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED) {
            logger.info((Object)"Creating a non managed env");
            CodeEnvModel.PythonEnvDesc newDesc = new CodeEnvModel.PythonEnvDesc();
            newDesc.owner = spec.owner;
            newDesc.usableByAll = true;
            newDesc.deploymentMode = spec.deploymentMode;
            newDesc.externalCondaEnvName = spec.externalCondaEnvName;
            try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
                t.writeObject(new RelFile(new String[]{CodeEnvModel.EnvLang.PYTHON.getFolderName(), spec.envName, "desc.json"}), (Object)newDesc);
                t.commit("Created non-managed Python environment: " + spec.envName);
            }
            try {
                CondaEnvUtils.linkToCondaEnv(spec.externalCondaEnvName, this.actualEnvFolder(CodeEnvModel.EnvLang.PYTHON, spec.envName));
            }
            catch (IOException e) {
                logger.warn((Object)"Cannot link to conda", (Throwable)e);
                ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.WARN_CODEENV_CONDA_ENV_NOT_FOUND, "Cannot find environment '" + spec.externalCondaEnvName + "'.");
            }
            return;
        }
        PythonCodeEnvUtils.createEmptyPyEnv(authCtx, spec, targetEnvDir, tailBuilder, log, CodeEnvPackageSystems.getCodeEnvSettings(spec));
        CodeEnvModel.PythonEnvDesc initialDesc = (CodeEnvModel.PythonEnvDesc)JSON.parse((String)JSON.json((Object)spec), CodeEnvModel.PythonEnvDesc.class);
        initialDesc.usableByAll = true;
        initialDesc.versionTag = initialDesc.creationTag = VersionTag.increment(null, authCtx.getIdentifier());
        this.writeInitialEnvSnapshot(authCtx, CodeEnvModel.EnvLang.PYTHON, spec.envName, initialDesc, "Initial creation of env " + spec.envName, tailBuilder, log);
        CodeEnvModel.CodeEnvUpdateSettings initialUpdateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
        initialUpdateSettings.upgradeAllPackages = true;
        try {
            this.updateEnvAccordingToSpec(authCtx, CodeEnvModel.EnvLang.PYTHON, spec.envName, initialUpdateSettings, tailBuilder, log);
            this.updateEnvSnapshotFromActualData(authCtx, CodeEnvModel.EnvLang.PYTHON, spec.envName, "Installed initial package set into env " + spec.envName, tailBuilder, log);
        }
        catch (Exception e) {
            logger.error((Object)"Initial code env packages installation failed", (Throwable)e);
            ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, "Initial code env packages installation failed");
        }
        try {
            this.installJupyterSupportForEnv(authCtx, CodeEnvModel.EnvLang.PYTHON, spec.envName, tailBuilder, log, true);
        }
        catch (Exception e) {
            logger.error((Object)"Jupyter support installation failed", (Throwable)e);
            ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_INSTALL_FAILED, "Cannot install jupyter support");
        }
        this.writeContainerConfigDefaultValue(CodeEnvModel.EnvLang.PYTHON, initialDesc, spec.envName, authCtx);
    }

    private void writeContainerConfigDefaultValue(CodeEnvModel.EnvLang envLang, CodeEnvModel.ContainerConfBearingDesc envDesc, String envName, AuthCtx authCtx) throws IOException {
        if (DKUApp.getParams().getBoolParam("dku.codeenvs.enableAllContainerConfForUpdate", false)) {
            logger.info((Object)"Enable building the env for all containerized execution configs on future updates");
            envDesc.allContainerConfs = true;
            try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
                t.writeObject(new RelFile(new String[]{envLang.getFolderName(), envName, "desc.json"}), (Object)envDesc);
                t.commit("Enable building the env for all containerized execution configs on future updates");
            }
        }
    }

    private void recreatePythonEnv(AuthCtx authCtx, String envName, CodeEnvModel.PythonEnvDesc spec, DKUtils.SmartLogTailBuilder tailBuilder, File log) throws Exception {
        if (spec.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DESIGN_MANAGED || spec.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED || spec.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL) {
            tailBuilder.appendLine("Clearing code environment ...");
            CodeEnvUtilsBase.addLogHeader(authCtx, log, "clear environment", "");
            logger.info((Object)("Clear env " + envName + " to rebuild from scratch"));
            File targetEnvDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
            if (targetEnvDir.exists()) {
                DKUFileUtils.forceDelete((File)targetEnvDir);
            }
            DKUFileUtils.mkdirsParent((File)targetEnvDir);
            logger.info((Object)("Clear env " + envName + " resources to rebuild from scratch"));
            File targetEnvResourcesDir = this.getEnvResourcesDir(CodeEnvModel.EnvLang.PYTHON, envName);
            if (targetEnvResourcesDir.exists()) {
                DKUFileUtils.forceDelete((File)targetEnvResourcesDir);
            }
            tailBuilder.appendLine("Creating new pyenv environment according to spec ...");
            PythonCodeEnvUtils.createEmptyPyEnv(authCtx, spec, targetEnvDir, tailBuilder, log, CodeEnvPackageSystems.getCodeEnvSettings(spec));
        } else {
            tailBuilder.appendLine("Skipping force rebuild for non-managed code environment");
            logger.info((Object)("Skipping force rebuild for non-managed code environment" + envName));
        }
    }

    public CodeEnvDraft prepareCodeEnv(AuthCtx authCtx, String name, CodeEnvModel.AbstractEnvDesc desc, CodeEnvModel.EnvLang envLang, String specCondaEnvironment, String specPackagesList) throws IOException {
        FileOutputStream fos;
        UUID id = UUID.randomUUID();
        File tmpCodeEnvDirectory = DSSTempUtils.getTempFolderWithSpecifiName((String)"codeenv", (String)id.toString());
        desc.owner = authCtx.getIdentifier();
        CodeEnvDraftConfig config = new CodeEnvDraftConfig(id, name, envLang);
        JSON.prettyToFile((Object)config, (File)DKUFileUtils.getWithin((File)tmpCodeEnvDirectory, (String[])new String[]{"draft_config.json"}));
        JSON.prettyToFile((Object)desc, (File)DKUFileUtils.getWithin((File)tmpCodeEnvDirectory, (String[])new String[]{"desc.json"}));
        File condaEnvFile = DKUFileUtils.getWithin((File)tmpCodeEnvDirectory, (String[])new String[]{"environment.spec"});
        File reqFile = DKUFileUtils.getWithin((File)tmpCodeEnvDirectory, (String[])new String[]{envLang.getPackageFileName()});
        if (specCondaEnvironment != null) {
            fos = new FileOutputStream(condaEnvFile, false);
            try {
                IOUtils.write((String)specCondaEnvironment, (OutputStream)fos);
            }
            finally {
                fos.close();
            }
        }
        if (specPackagesList != null) {
            fos = new FileOutputStream(reqFile, false);
            try {
                IOUtils.write((String)specPackagesList, (OutputStream)fos);
            }
            finally {
                fos.close();
            }
        }
        return new CodeEnvDraft(config, desc);
    }

    public CodeEnvDraft getCodeEnvDraft(String codeEnvDraftId) {
        try {
            CodeEnvModel.AbstractEnvDesc desc;
            File tmpCodeEnvDirectory = DSSTempUtils.getTempFolderWithSpecifiName((String)"codeenv", (String)codeEnvDraftId);
            if (!tmpCodeEnvDirectory.exists()) {
                throw new NotFoundException("Cannot retrieve the draft code env configuration");
            }
            File configFile = DKUFileUtils.getWithin((File)tmpCodeEnvDirectory, (String[])new String[]{"draft_config.json"});
            File descFile = DKUFileUtils.getWithin((File)tmpCodeEnvDirectory, (String[])new String[]{"desc.json"});
            if (!configFile.exists() || !descFile.exists()) {
                throw new NotFoundException("Cannot retrieve the draft code env configuration");
            }
            CodeEnvDraftConfig config = (CodeEnvDraftConfig)JSON.parseFile((File)configFile, CodeEnvDraftConfig.class);
            if (config.envLang == CodeEnvModel.EnvLang.PYTHON) {
                desc = (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.PythonEnvDesc.class);
            } else if (config.envLang == CodeEnvModel.EnvLang.R) {
                desc = (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.REnvDesc.class);
            } else {
                throw new NotImplementedException();
            }
            return new CodeEnvDraft(config, desc);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load the draft code env", e);
        }
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> startCreateEnvFromDraft(DSSAuthCtx authCtx, String codeEnvDraftId, String envLang, String envSpec) throws Exception {
        File draftFolder = DSSTempUtils.getTempFolderWithSpecifiName((String)"codeenv", (String)codeEnvDraftId);
        if (!draftFolder.exists()) {
            throw new RuntimeException("The code env configuration does not exist anymore for draft: " + codeEnvDraftId);
        }
        File desc = DKUFileUtils.getWithin((File)draftFolder, (String[])new String[]{"desc.json"});
        if (!desc.exists()) {
            throw new RuntimeException("Cannot retrieve the initial code env configuration for draft : " + codeEnvDraftId);
        }
        File condaEnv = DKUFileUtils.getWithin((File)draftFolder, (String[])new String[]{"environment.spec"});
        if (CodeEnvModel.EnvLang.PYTHON.toString().equals(envLang)) {
            File pythonRequirements = DKUFileUtils.getWithin((File)draftFolder, (String[])new String[]{CodeEnvModel.EnvLang.PYTHON.getPackageFileName()});
            CodeEnvModel.DesignNewPythonEnvSpec newEnvSpec = (CodeEnvModel.DesignNewPythonEnvSpec)JSON.parse((String)envSpec, CodeEnvModel.DesignNewPythonEnvSpec.class);
            newEnvSpec.initializeCorePackageSetBasedOnInterpreter();
            newEnvSpec.owner = authCtx.getIdentifier();
            return this.startCreatePythonEnvFromDraft(authCtx, draftFolder, newEnvSpec, condaEnv, pythonRequirements);
        }
        if (CodeEnvModel.EnvLang.R.toString().equals(envLang)) {
            File rRequirements = DKUFileUtils.getWithin((File)draftFolder, (String[])new String[]{CodeEnvModel.EnvLang.R.getPackageFileName()});
            CodeEnvModel.DesignNewREnvSpec newEnvSpec = (CodeEnvModel.DesignNewREnvSpec)JSON.parse((String)envSpec, CodeEnvModel.DesignNewREnvSpec.class);
            newEnvSpec.owner = authCtx.getIdentifier();
            return this.startCreateREnvFromDraft(authCtx, draftFolder, newEnvSpec, condaEnv, rRequirements);
        }
        throw new NotImplementedException();
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> startCreateREnv(final AuthCtx authCtx, final CodeEnvModel.DesignNewREnvSpec spec) throws Exception {
        this.accessService.checkEnvDoesntExists(CodeEnvModel.EnvLang.R, spec.envName);
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvCreationResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvCreationResult compute() throws Exception {
                CodeEnvModel.EnvCreationResult ret = new CodeEnvModel.EnvCreationResult(spec.envName);
                try {
                    File log = ApplicationConfigurator.getFile((File)DesignNodeCodeEnvsService.this.logsRootDir, (String[])new String[]{CodeEnvModel.EnvLang.R.getFolderName(), spec.envName, "createREnv.log"});
                    DesignNodeCodeEnvsService.this.createREnv(authCtx, spec, logTailBuilder, log, ret);
                    DesignNodeCodeEnvsService.this.buildEnvDockerImage(spec, CodeEnvModel.EnvLang.R, spec.envName, logTailBuilder, log, ret.messages, false);
                    DesignNodeCodeEnvsService.this.pubSubService.publish((DSSEvent)new CodeEnvChangedEvent(spec.envName, CodeEnvChangedEvent.ActionType.CREATED, authCtx.getIdentifier()));
                }
                catch (Exception e) {
                    logger.error((Object)"Env creation failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"create_r_env", (String)("Create R env: " + spec.envName));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvCreationResult>>(){});
    }

    private FutureResponse<CodeEnvModel.EnvCreationResult> startCreateREnvFromDraft(final AuthCtx authCtx, final File draftFolder, final CodeEnvModel.DesignNewREnvSpec spec, final File condaData, final File specData) throws Exception {
        this.accessService.checkEnvDoesntExists(CodeEnvModel.EnvLang.R, spec.envName);
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvCreationResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvCreationResult compute() throws Exception {
                CodeEnvModel.EnvCreationResult ret = new CodeEnvModel.EnvCreationResult(spec.envName);
                try {
                    File log = ApplicationConfigurator.getFile((File)DesignNodeCodeEnvsService.this.logsRootDir, (String[])new String[]{CodeEnvModel.EnvLang.R.getFolderName(), spec.envName, "createREnv.log"});
                    DesignNodeCodeEnvsService.this.createREnv(authCtx, spec, logTailBuilder, log, ret);
                    DesignNodeCodeEnvsService.this.updateSpecData(authCtx, spec.envName, CodeEnvModel.EnvLang.R, spec.conda, condaData, specData);
                    DesignNodeCodeEnvsService.this.buildEnvDockerImage(spec, CodeEnvModel.EnvLang.R, spec.envName, logTailBuilder, log, ret.messages, false);
                    DesignNodeCodeEnvsService.this.pubSubService.publish((DSSEvent)new CodeEnvChangedEvent(spec.envName, CodeEnvChangedEvent.ActionType.CREATED, authCtx.getIdentifier()));
                    DKUFileUtils.forceDelete((File)draftFolder);
                }
                catch (Exception e) {
                    logger.error((Object)"Env creation failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CREATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"create_r_env", (String)("Create R env: " + spec.envName));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvCreationResult>>(){});
    }

    private void updateSpecData(AuthCtx authCtx, String envName, CodeEnvModel.EnvLang envLang, boolean conda, File condaSpecData, File packagesSpecData) throws IOException {
        try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
            if (conda && condaSpecData.exists()) {
                t.writeBytes(new RelFile(new String[]{envLang.getFolderName(), envName, "spec", "environment.spec"}), IOUtils.toByteArray((URI)condaSpecData.toURI()));
            }
            if (packagesSpecData.exists()) {
                t.writeBytes(new RelFile(new String[]{envLang.getFolderName(), envName, "spec", envLang.getPackageFileName()}), IOUtils.toByteArray((URI)packagesSpecData.toURI()));
            }
            t.commit("Updated packages");
        }
    }

    private void createREnv(AuthCtx authCtx, CodeEnvModel.DesignNewREnvSpec spec, DKUtils.SmartLogTailBuilder tailBuilder, File log, CodeEnvModel.EnvCreationResult ret) throws Exception {
        logger.info((Object)("Creating R env: " + spec.envName));
        File targetEnvDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", CodeEnvModel.EnvLang.R.getFolderName(), spec.envName});
        DKUFileUtils.mkdirsParent((File)targetEnvDir);
        DKUFileUtils.mkdirsParent((File)log);
        if (spec.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DESIGN_NON_MANAGED || spec.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED) {
            logger.info((Object)"Creating a non managed env");
            CodeEnvModel.REnvDesc newDesc = new CodeEnvModel.REnvDesc();
            newDesc.owner = spec.owner;
            newDesc.usableByAll = true;
            newDesc.deploymentMode = spec.deploymentMode;
            newDesc.externalCondaEnvName = spec.externalCondaEnvName;
            try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
                t.writeObject(new RelFile(new String[]{CodeEnvModel.EnvLang.R.getFolderName(), spec.envName, "desc.json"}), (Object)newDesc);
                t.commit("Created non-managed R environment: " + spec.envName);
            }
            DKUFileUtils.mkdirs((File)this.actualEnvFolder(CodeEnvModel.EnvLang.R, spec.envName));
            return;
        }
        if (spec.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED) {
            logger.info((Object)"Creating an external conda env");
            CodeEnvModel.REnvDesc newDesc = new CodeEnvModel.REnvDesc();
            newDesc.owner = spec.owner;
            newDesc.usableByAll = true;
            newDesc.deploymentMode = spec.deploymentMode;
            newDesc.externalCondaEnvName = spec.externalCondaEnvName;
            try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
                t.writeObject(new RelFile(new String[]{CodeEnvModel.EnvLang.R.getFolderName(), spec.envName, "desc.json"}), (Object)newDesc);
                t.commit("Created non-managed R environment: " + spec.envName);
            }
            try {
                CondaEnvUtils.linkToCondaEnv(spec.externalCondaEnvName, this.actualEnvFolder(CodeEnvModel.EnvLang.R, spec.envName));
            }
            catch (IOException e) {
                logger.warn((Object)"Cannot link to conda", (Throwable)e);
                ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.WARN_CODEENV_CONDA_ENV_NOT_FOUND, "Cannot find environment '" + spec.externalCondaEnvName + "'.");
            }
            return;
        }
        GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings = CodeEnvPackageSystems.getCodeEnvSettings(spec);
        RCodeEnvUtils.createEmptyREnv(authCtx, spec, targetEnvDir, tailBuilder, log, envSettings);
        CodeEnvModel.REnvDesc initialDesc = (CodeEnvModel.REnvDesc)JSON.parse((String)JSON.json((Object)spec), CodeEnvModel.REnvDesc.class);
        initialDesc.usableByAll = true;
        initialDesc.versionTag = initialDesc.creationTag = VersionTag.increment(null, authCtx.getIdentifier());
        this.writeInitialEnvSnapshot(authCtx, CodeEnvModel.EnvLang.R, spec.envName, initialDesc, "Initial creation of env " + spec.envName, tailBuilder, log);
        CodeEnvModel.CodeEnvUpdateSettings initialUpdateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
        initialUpdateSettings.upgradeAllPackages = true;
        try {
            this.updateEnvAccordingToSpec(authCtx, CodeEnvModel.EnvLang.R, spec.envName, initialUpdateSettings, tailBuilder, log);
            this.updateEnvSnapshotFromActualData(authCtx, CodeEnvModel.EnvLang.R, spec.envName, "Installed initial package set into env " + spec.envName, tailBuilder, log);
        }
        catch (Exception e) {
            logger.error((Object)"Initial code env packages installation failed", (Throwable)e);
            ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, "Initial code env packages installation failed");
        }
        try {
            this.installJupyterSupportForEnv(authCtx, CodeEnvModel.EnvLang.R, spec.envName, tailBuilder, log, true);
        }
        catch (Exception e) {
            logger.error((Object)"Could not install Jupyter support", (Throwable)e);
            ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_INSTALL_FAILED, "Cannot install jupyter support");
        }
        this.writeContainerConfigDefaultValue(CodeEnvModel.EnvLang.R, initialDesc, spec.envName, authCtx);
    }

    private void recreateREnv(AuthCtx authCtx, String envName, CodeEnvModel.REnvDesc spec, DKUtils.SmartLogTailBuilder tailBuilder, File log) throws Exception {
        if (spec.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DESIGN_MANAGED || spec.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED || spec.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL) {
            tailBuilder.appendLine("Clearing code environment ...");
            CodeEnvUtilsBase.addLogHeader(authCtx, log, "clear environment", "");
            logger.info((Object)("Clear env " + envName + " to rebuild from scratch"));
            File targetEnvDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", CodeEnvModel.EnvLang.R.getFolderName(), envName});
            DKUFileUtils.forceDelete((File)targetEnvDir);
            DKUFileUtils.mkdirsParent((File)targetEnvDir);
            RCodeEnvUtils.createEmptyREnv(authCtx, spec, targetEnvDir, tailBuilder, log, CodeEnvPackageSystems.getCodeEnvSettings(spec));
        } else {
            logger.info((Object)("Not recreating non managed code env " + envName));
        }
    }

    public FutureResponse<CodeEnvModel.EnvUpdateResult> startInstallJupyterSupport(final AuthCtx authCtx, final CodeEnvModel.EnvLang envLang, final String envName) throws Exception {
        this.accessService.checkEnvExists(envLang, envName);
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvUpdateResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvUpdateResult compute() throws Exception {
                CodeEnvModel.EnvUpdateResult ret = new CodeEnvModel.EnvUpdateResult();
                try {
                    File log = ApplicationConfigurator.getFile((File)DesignNodeCodeEnvsService.this.logsRootDir, (String[])new String[]{envLang.getFolderName(), envName, "installJupyterSupport.log"});
                    DKUFileUtils.mkdirsParent((File)log);
                    DesignNodeCodeEnvsService.this.installJupyterSupportForEnv(authCtx, envLang, envName, logTailBuilder, log, false);
                    DesignNodeCodeEnvsService.this.addResourcesEnvVariablesToJupyterKernel(envLang, envName, logTailBuilder, log, true);
                }
                catch (Exception e) {
                    logger.error((Object)"Jupyter install failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_INSTALL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"install_jupyter_support", (String)("Install Jupyter support in env " + envName));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvUpdateResult>>(){});
    }

    public FutureResponse<CodeEnvModel.EnvUpdateResult> startRemoveJupyterSupport(final AuthCtx authCtx, final CodeEnvModel.EnvLang envLang, final String envName) throws Exception {
        this.accessService.checkEnvExists(envLang, envName);
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvUpdateResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvUpdateResult compute() throws Exception {
                CodeEnvModel.EnvUpdateResult ret = new CodeEnvModel.EnvUpdateResult();
                try {
                    File log = ApplicationConfigurator.getFile((File)DesignNodeCodeEnvsService.this.logsRootDir, (String[])new String[]{envLang.getFolderName(), envName, "removeJupyterSupport.log"});
                    DKUFileUtils.mkdirsParent((File)log);
                    DesignNodeCodeEnvsService.this.removeJupyterSupportForEnv(authCtx, envLang, envName, logTailBuilder, log);
                }
                catch (Exception e) {
                    logger.error((Object)"Jupyter removal failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_REMOVAL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"remove_jupyter_support", (String)("Remove Jupyter support in env " + envName));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvUpdateResult>>(){});
    }

    private void addResourcesEnvVariablesToJupyterKernel(CodeEnvModel.EnvLang envLang, String envName, DKUtils.SmartLogTailBuilder tailBuilder, File log, boolean forceAdd) {
        try (Transaction t = this.accessService.getTransactionProvider().retrieveOrBeginRead();){
            if (envLang != CodeEnvModel.EnvLang.PYTHON) {
                return;
            }
            RelFile descFile = new RelFile(new String[]{envLang.getFolderName(), envName, "desc.json"});
            CodeEnvModel.PythonEnvDesc pydesc = (CodeEnvModel.PythonEnvDesc)t.readObjectUnsafe(descFile, CodeEnvModel.PythonEnvDesc.class);
            if (!forceAdd && !pydesc.installJupyterSupport) {
                return;
            }
            FileUtils.writeStringToFile((File)log, (String)"Adding resources environment variables to Jupyter kernel.json ...", (Charset)StandardCharsets.UTF_8, (boolean)true);
            tailBuilder.appendLine("Adding resources environment variables to Jupyter kernel.json ...");
            File resourcesEnvFile = t.resolve(new RelFile(new String[]{envLang.getFolderName(), envName, "actual", "resources_env.json"}));
            if (resourcesEnvFile.exists()) {
                CodeEnvModel.CodeEnvResourcesEnvVariables resourcesEnvVariables = (CodeEnvModel.CodeEnvResourcesEnvVariables)JSON.parseFile((File)resourcesEnvFile, CodeEnvModel.CodeEnvResourcesEnvVariables.class);
                CodeEnvLanguages.addEnvToKernel(JupyterCodeEnvUtils.getKernelName(CodeEnvModel.EnvLang.PYTHON, envName, null, null, null), resourcesEnvVariables.resolve(this.getEnvResourcesDir(envLang, envName)));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to add resources environment variables to Jupyter kernel.json", (Throwable)e);
        }
    }

    private void installJupyterSupportForEnv(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, DKUtils.SmartLogTailBuilder tailBuilder, File log, boolean onlyIfNeeded) throws IOException, InterruptedException {
        CodeEnvModel.AbstractEnvDesc envDesc = this.getEnvDesc(envLang, envName);
        switch (envLang) {
            case PYTHON: {
                if (onlyIfNeeded && !((CodeEnvModel.PythonEnvDesc)envDesc).installJupyterSupport) break;
                CodeEnvLanguages.installJupyterSupport(authCtx, CodeEnvLanguages.PYTHON, envDesc, envName, null, null, tailBuilder, log, ((CodeEnvModel.PythonEnvDesc)envDesc).yarnPythonBin);
                break;
            }
            case R: {
                if (onlyIfNeeded && !((CodeEnvModel.REnvDesc)envDesc).installJupyterSupport) break;
                CodeEnvLanguages.installJupyterSupport(authCtx, CodeEnvLanguages.R, envDesc, envName, null, null, tailBuilder, log, ((CodeEnvModel.REnvDesc)envDesc).yarnRBin);
            }
        }
    }

    private void removeJupyterSupportForEnv(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, DKUtils.SmartLogTailBuilder tailBuilder, File log) throws IOException, InterruptedException {
        CodeEnvModel.AbstractEnvDesc envDesc = this.getEnvDesc(envLang, envName);
        switch (envLang) {
            case PYTHON: {
                CodeEnvLanguages.removeJupyterSupport(authCtx, CodeEnvLanguages.PYTHON, envDesc, envName, null, null, tailBuilder, log);
                break;
            }
            case R: {
                CodeEnvLanguages.removeJupyterSupport(authCtx, CodeEnvLanguages.R, envDesc, envName, null, null, tailBuilder, log);
            }
        }
    }

    private void addKernelSpecNameIfExists(String envName, CodeEnvModel.AbstractDesignUIEnv env) {
        try {
            for (JupyterService.KernelSpec kernelSpec : this.jupyterService.listKernelSpecs()) {
                if (!StringUtils.isNotBlank((String)kernelSpec.envName) || !kernelSpec.envName.equals(envName)) continue;
                env.kernelSpecName = kernelSpec.name;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get kernelSpecs", (Throwable)e);
            env.unknownKernelSpecStatus = true;
            env.kernelSpecsListingError = new SerializedError((Throwable)e, true);
        }
    }

    public CodeEnvModel.AbstractEnvDesc getEnvDesc(CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        return this.accessService.getEnvDesc(envLang, envName);
    }

    public CodeEnvModel.AbstractDesignUIEnv getEnvForUI(CodeEnvModel.EnvLang envLang, String envName, boolean withKernelSpec) throws IOException {
        switch (envLang) {
            case PYTHON: {
                return this.getPythonEnvForUI(envLang, envName, withKernelSpec);
            }
            case R: {
                return this.getREnvForUI(envLang, envName, withKernelSpec);
            }
        }
        throw new Error("unreachable");
    }

    private CodeEnvModel.AbstractDesignUIEnv getREnvForUI(CodeEnvModel.EnvLang envLang, String envName, boolean withKernelSpec) throws IOException {
        CodeEnvModel.DesignUIREnv upe = new CodeEnvModel.DesignUIREnv();
        upe.envName = envName;
        upe.envLang = CodeEnvModel.EnvLang.R;
        try (Transaction t = this.accessService.getTransactionProvider().retrieveOrBeginRead();){
            upe.desc = (CodeEnvModel.REnvDesc)t.readObjectUnsafe(new RelFile(new String[]{envLang.getFolderName(), envName, "desc.json"}), CodeEnvModel.REnvDesc.class);
            upe.deploymentMode = upe.desc.deploymentMode;
            upe.owner = upe.desc.owner;
            upe.usableByAll = upe.desc.usableByAll;
            upe.permissions = upe.desc.permissions;
            upe.allContainerConfs = upe.desc.allContainerConfs;
            upe.containerConfs = upe.desc.containerConfs;
            upe.allSparkKubernetesConfs = upe.desc.allSparkKubernetesConfs;
            upe.sparkKubernetesConfs = upe.desc.sparkKubernetesConfs;
            if (upe.desc.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED) {
                upe.path = this.actualEnvFolder(envLang, envName).getAbsolutePath();
            }
            if (upe.desc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DESIGN_MANAGED || upe.desc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED || upe.desc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL) {
                upe.actualCondaEnvironment = this.readIfExists((TransactionRef)t, new RelFile(new String[]{envLang.getFolderName(), envName, "actual", "environment.spec"}));
                upe.actualPackageList = this.readIfExists((TransactionRef)t, new RelFile(new String[]{envLang.getFolderName(), envName, "actual", envLang.getPackageFileName()}));
                upe.specCondaEnvironment = this.readIfExists((TransactionRef)t, new RelFile(new String[]{envLang.getFolderName(), envName, "spec", "environment.spec"}));
                upe.specPackageList = this.readIfExists((TransactionRef)t, new RelFile(new String[]{envLang.getFolderName(), envName, "spec", envLang.getPackageFileName()}));
                if (upe.desc.installCorePackages) {
                    if (upe.desc.conda) {
                        upe.mandatoryCondaEnvironment = CodeEnvPackageSystems.CONDA_R.getMandatoryPackageList(upe.desc);
                    }
                    upe.mandatoryPackageList = CodeEnvPackageSystems.R.getMandatoryPackageList(upe.desc);
                }
            }
        }
        if (withKernelSpec) {
            this.addKernelSpecNameIfExists(envName, upe);
        }
        return upe;
    }

    public CodeEnvModel.DesignUIPythonEnv getPythonEnvForUI(CodeEnvModel.EnvLang envLang, String envName, boolean withKernelSpec) throws IOException {
        CodeEnvModel.DesignUIPythonEnv upe = new CodeEnvModel.DesignUIPythonEnv();
        upe.envName = envName;
        upe.envLang = CodeEnvModel.EnvLang.PYTHON;
        try (Transaction t = this.accessService.getTransactionProvider().retrieveOrBeginRead();){
            upe.desc = (CodeEnvModel.PythonEnvDesc)t.readObject(new RelFile(new String[]{envLang.getFolderName(), envName, "desc.json"}), CodeEnvModel.PythonEnvDesc.class);
            if (upe.desc.corePackagesSet == null) {
                upe.desc.corePackagesSet = CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet.LEGACY_PANDAS023;
            }
            upe.deploymentMode = upe.desc.deploymentMode;
            upe.owner = upe.desc.owner;
            upe.usableByAll = upe.desc.usableByAll;
            upe.permissions = upe.desc.permissions;
            upe.allContainerConfs = upe.desc.allContainerConfs;
            upe.containerConfs = upe.desc.containerConfs;
            upe.allSparkKubernetesConfs = upe.desc.allSparkKubernetesConfs;
            upe.sparkKubernetesConfs = upe.desc.sparkKubernetesConfs;
            upe.rebuildDependentCodeStudioTemplates = upe.desc.rebuildDependentCodeStudioTemplates;
            upe.upstreamPreset = upe.desc.upstreamPreset;
            if (upe.desc.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED) {
                upe.path = this.actualEnvFolder(envLang, envName).getAbsolutePath();
            }
            if (upe.desc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DESIGN_MANAGED || upe.desc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED || upe.desc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL) {
                upe.info = (CodeEnvModel.PythonEnvInfo)t.readObjectUnsafe(new RelFile(new String[]{envLang.getFolderName(), envName, "actual", "info.json"}), CodeEnvModel.PythonEnvInfo.class);
                upe.actualCondaEnvironment = this.readIfExists((TransactionRef)t, new RelFile(new String[]{envLang.getFolderName(), envName, "actual", "environment.spec"}));
                upe.actualPackageList = this.readIfExists((TransactionRef)t, new RelFile(new String[]{envLang.getFolderName(), envName, "actual", envLang.getPackageFileName()}));
                upe.specCondaEnvironment = this.readIfExists((TransactionRef)t, new RelFile(new String[]{envLang.getFolderName(), envName, "spec", "environment.spec"}));
                upe.specPackageList = this.readIfExists((TransactionRef)t, new RelFile(new String[]{envLang.getFolderName(), envName, "spec", envLang.getPackageFileName()}));
                upe.resourcesInitScript = this.readIfExists((TransactionRef)t, new RelFile(new String[]{envLang.getFolderName(), envName, "spec", "resources_init.py"}));
                if (upe.desc.installCorePackages) {
                    if (upe.desc.conda) {
                        upe.mandatoryCondaEnvironment = CodeEnvPackageSystems.CONDA_PYTHON.getMandatoryPackageList(upe.desc);
                    }
                    upe.mandatoryPackageList = CodeEnvPackageSystems.PIP.getMandatoryPackageList(upe.desc);
                }
            }
        }
        if (withKernelSpec) {
            this.addKernelSpecNameIfExists(envName, upe);
        }
        return upe;
    }

    public String getMandatoryPackagesList(CodeEnvModel.AbstractEnvDesc desc) throws IOException {
        String mandatoryPackagesList = "";
        if (desc instanceof CodeEnvModel.PythonEnvDesc && ((CodeEnvModel.PythonEnvDesc)desc).installCorePackages) {
            mandatoryPackagesList = desc.conda ? CodeEnvPackageSystems.CONDA_PYTHON.getMandatoryPackageList(desc) : CodeEnvPackageSystems.PIP.getMandatoryPackageList(desc);
        } else if (desc instanceof CodeEnvModel.REnvDesc && ((CodeEnvModel.REnvDesc)desc).installCorePackages) {
            mandatoryPackagesList = desc.conda ? CodeEnvPackageSystems.CONDA_R.getMandatoryPackageList(desc) : CodeEnvPackageSystems.R.getMandatoryPackageList(desc);
        }
        return mandatoryPackagesList;
    }

    public void saveEnvForUI(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, CodeEnvModel.AbstractDesignUIEnv due, boolean mayUpdatePermissions) throws IOException {
        GeneralSettingsDAO.SecuritySettings securitySettings = ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafeAutoTXN().security;
        RelFile descFile = new RelFile(new String[]{envLang.getFolderName(), envName, "desc.json"});
        try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
            switch (envLang) {
                case PYTHON: {
                    CodeEnvModel.DesignUIPythonEnv upe = (CodeEnvModel.DesignUIPythonEnv)due;
                    CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)t.readObjectUnsafe(descFile, CodeEnvModel.PythonEnvDesc.class);
                    if (mayUpdatePermissions) {
                        desc.owner = upe.desc.owner;
                        desc.usableByAll = upe.usableByAll;
                        desc.permissions = upe.permissions;
                    }
                    desc.externalCondaEnvName = due.externalCondaEnvName;
                    desc.useReferenceSpec = upe.desc.useReferenceSpec;
                    desc.envSettings = (CodeEnvModel.CodeEnvSettings)JSON.deepCopy((Object)upe.desc.envSettings);
                    desc.yarnPythonBin = upe.desc.yarnPythonBin;
                    desc.installCorePackages = upe.desc.installCorePackages;
                    desc.corePackagesSet = upe.desc.corePackagesSet;
                    desc.installJupyterSupport = upe.desc.installJupyterSupport;
                    desc.allContainerConfs = upe.allContainerConfs;
                    desc.containerConfs = upe.containerConfs;
                    desc.allSparkKubernetesConfs = upe.allSparkKubernetesConfs;
                    desc.sparkKubernetesConfs = upe.sparkKubernetesConfs;
                    desc.rebuildDependentCodeStudioTemplates = upe.rebuildDependentCodeStudioTemplates;
                    desc.dockerImageResources = upe.desc.dockerImageResources;
                    if (desc.pythonInterpreter != upe.desc.pythonInterpreter) {
                        desc.pythonInterpreterChangeHistory.add(new CodeEnvModel.PythonInterpreterChange(desc.pythonInterpreter, t.readStringUTF8(new RelFile(new String[]{envLang.getFolderName(), envName, "spec", envLang.getPackageFileName()})), System.currentTimeMillis()));
                    }
                    desc.pythonInterpreter = upe.desc.pythonInterpreter;
                    desc.customInterpreter = upe.desc.customInterpreter;
                    desc.predefinedContainerHooks = upe.desc.predefinedContainerHooks;
                    desc.dockerfileAtStart = upe.desc.dockerfileAtStart;
                    desc.dockerfileBeforePackages = upe.desc.dockerfileBeforePackages;
                    desc.dockerfileAfterCondaPackages = upe.desc.dockerfileAfterCondaPackages;
                    desc.dockerfileAfterPackages = upe.desc.dockerfileAfterPackages;
                    desc.dockerfileAtEnd = upe.desc.dockerfileAtEnd;
                    desc.containerCacheBustingLocation = upe.desc.containerCacheBustingLocation;
                    desc.upstreamPreset = upe.upstreamPreset;
                    desc.updateResourcesApiNode = securitySettings.enableCodeEnvResources ? upe.desc.updateResourcesApiNode : false;
                    t.writeObject(descFile, (Object)desc);
                    if (upe.specCondaEnvironment != null) {
                        t.writeStringUTF8(new RelFile(new String[]{envLang.getFolderName(), envName, "spec", "environment.spec"}), upe.specCondaEnvironment);
                    }
                    if (upe.specPackageList != null) {
                        t.writeStringUTF8(new RelFile(new String[]{envLang.getFolderName(), envName, "spec", envLang.getPackageFileName()}), upe.specPackageList);
                    }
                    t.writeStringUTF8(new RelFile(new String[]{envLang.getFolderName(), envName, "spec", "resources_init.py"}), upe.resourcesInitScript);
                    break;
                }
                case R: {
                    CodeEnvModel.DesignUIREnv upe = (CodeEnvModel.DesignUIREnv)due;
                    CodeEnvModel.REnvDesc desc = (CodeEnvModel.REnvDesc)t.readObjectUnsafe(descFile, CodeEnvModel.REnvDesc.class);
                    if (mayUpdatePermissions) {
                        desc.owner = upe.desc.owner;
                        desc.usableByAll = upe.usableByAll;
                        desc.permissions = upe.permissions;
                    }
                    desc.externalCondaEnvName = due.externalCondaEnvName;
                    desc.envSettings = (CodeEnvModel.CodeEnvSettings)JSON.deepCopy((Object)upe.desc.envSettings);
                    desc.yarnRBin = upe.desc.yarnRBin;
                    desc.installCorePackages = upe.desc.installCorePackages;
                    desc.installJupyterSupport = upe.desc.installJupyterSupport;
                    desc.allContainerConfs = upe.allContainerConfs;
                    desc.containerConfs = upe.containerConfs;
                    desc.allSparkKubernetesConfs = upe.allSparkKubernetesConfs;
                    desc.sparkKubernetesConfs = upe.sparkKubernetesConfs;
                    desc.dockerfileAtStart = upe.desc.dockerfileAtStart;
                    desc.dockerfileBeforePackages = upe.desc.dockerfileBeforePackages;
                    desc.dockerfileAfterCondaPackages = upe.desc.dockerfileAfterCondaPackages;
                    desc.dockerfileAfterPackages = upe.desc.dockerfileAfterPackages;
                    desc.dockerfileAtEnd = upe.desc.dockerfileAtEnd;
                    desc.containerCacheBustingLocation = upe.desc.containerCacheBustingLocation;
                    t.writeObject(descFile, (Object)desc);
                    if (upe.specCondaEnvironment != null) {
                        t.writeStringUTF8(new RelFile(new String[]{envLang.getFolderName(), envName, "spec", "environment.spec"}), upe.specCondaEnvironment);
                    }
                    if (upe.specPackageList == null) break;
                    t.writeStringUTF8(new RelFile(new String[]{envLang.getFolderName(), envName, "spec", envLang.getPackageFileName()}), upe.specPackageList);
                }
            }
            t.commit("Updated settings of code env " + envName);
        }
    }

    public FutureResponse<CodeEnvModel.EnvUpdateResult> startUpdateEnvAccordingToSpec(AuthCtx authCtx, CodeEnvModel.EnvLang language, String envName, CodeEnvModel.CodeEnvUpdateSettings updateSettings) throws Exception {
        return this.startUpdateEnvAccordingToSpec(authCtx, language, envName, updateSettings, null);
    }

    public FutureResponse<CodeEnvModel.EnvUpdateResult> startUpdateEnvAccordingToSpec(final AuthCtx authCtx, final CodeEnvModel.EnvLang language, final String envName, final CodeEnvModel.CodeEnvUpdateSettings updateSettings, final String pluginId) throws Exception {
        this.accessService.checkEnvExists(language, envName);
        final DKUtils.SmartLogTailBuilder tailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvUpdateResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvUpdateResult compute() throws Exception {
                return DesignNodeCodeEnvsService.this.updateEnvAccordingToSpec(authCtx, language, envName, updateSettings, pluginId, tailBuilder, false, false);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"update_python_env", (String)("Update " + String.valueOf((Object)language) + " environment: " + envName));
            }

            public SmartLogTail getLog() {
                return tailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvUpdateResult>>(){});
    }

    public CodeEnvModel.EnvUpdateResult updateEnvAccordingToSpec(AuthCtx authCtx, CodeEnvModel.EnvLang language, String envName, CodeEnvModel.CodeEnvUpdateSettings updateSettings, String pluginId, DKUtils.SmartLogTailBuilder tailBuilder, boolean skipContainerImagesBuild, boolean skipJupyterInstall) {
        CodeEnvModel.EnvUpdateResult ret = new CodeEnvModel.EnvUpdateResult();
        try {
            File resourcesFolder;
            File envFolder;
            File descFolder;
            boolean successfulRun;
            File log = new File(this.getEnvLogsDir(language, envName), "updateEnvAccordingToSpec.log");
            DKUFileUtils.mkdirsParent((File)log);
            CodeEnvModel.AbstractEnvDesc desc = this.getEnvDesc(language, envName);
            if (language == CodeEnvModel.EnvLang.PYTHON && desc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL && ((CodeEnvModel.PythonEnvDesc)desc).useReferenceSpec()) {
                DSSInternalCodeEnvsService.DSSInternalCodeEnv dssInternalCodeEnv = DSSInternalCodeEnvsService.DSSInternalCodeEnv.fromName(envName);
                CodeEnvModel.PythonEnvDesc envDesc = (CodeEnvModel.PythonEnvDesc)desc;
                if (!dssInternalCodeEnv.isCompatibleWithInterpreter(envDesc.pythonInterpreter)) {
                    List<StandardPythonInterpreter> availablePythonInterpreters = this.availablePythonInterpretersService.getAvailablePythonInterpreters();
                    Optional<StandardPythonInterpreter> newInterpreter = DSSInternalCodeEnvsService.getPreferredInstalledInterpreterOrNull(dssInternalCodeEnv.codeEnvType, dssInternalCodeEnv.version, availablePythonInterpreters);
                    if (newInterpreter.isEmpty()) {
                        List<StandardPythonInterpreter> supportedInterpreters = DSSInternalCodeEnvsService.getSupportedInterpreters(dssInternalCodeEnv.codeEnvType, dssInternalCodeEnv.version);
                        String message = String.format("No supported interpreter is available on the machine to update the '%s' internal code env. Supported interpreters are: '%s'.", envName, supportedInterpreters.stream().map(Enum::toString).collect(Collectors.joining(", ")));
                        tailBuilder.appendLine(message);
                        throw new UnsupportedOperationException(message);
                    }
                    String message = String.format("Current interpreter '%s' for internal code env '%s' is not supported. Updating its Python interpreter to '%s' instead.", new Object[]{envDesc.pythonInterpreter, envName, newInterpreter.get()});
                    tailBuilder.appendLine(message);
                    logger.info((Object)message);
                    this.updateDescWithNewInterpreter(authCtx, envName, newInterpreter.get());
                    tailBuilder.appendLine("Interpreter updated successfully. Forcing rebuild.");
                    logger.info((Object)"Interpreter updated successfully. Forcing rebuild.");
                    updateSettings.forceRebuildEnv = true;
                }
                this.updateSpecFromInternalResources(authCtx, dssInternalCodeEnv, tailBuilder, log);
                updateSettings.upgradeAllPackages = true;
                updateSettings.updateResources = true;
            }
            if (updateSettings.forceRebuildEnv) {
                this.recreateEnvAccordingToSpec(authCtx, language, envName, tailBuilder, log);
            }
            CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> specData = this.updateEnvAccordingToSpec(authCtx, language, envName, updateSettings, tailBuilder, log);
            if (!skipJupyterInstall) {
                try {
                    this.installJupyterSupportForEnv(authCtx, language, envName, tailBuilder, log, true);
                }
                catch (Exception e) {
                    logger.error((Object)"Jupyter support installation failed", (Throwable)e);
                    ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_INSTALL_FAILED, "Cannot install jupyter support");
                }
            }
            if (language == CodeEnvModel.EnvLang.PYTHON && ((CodeEnvModel.PythonEnvDesc)desc).installCorePackages && updateSettings.updateResources && (successfulRun = PythonCodeEnvUtils.maybeRunResourcesInitScript(authCtx, specData.resourcesInitScript, envName, descFolder = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", language.getFolderName(), envName}), envFolder = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", language.getFolderName(), envName}), resourcesFolder = new File(DesignNodeCodeEnvsService.getResourcesPath(language, envName)), tailBuilder, log, ret.messages))) {
                this.updateEnvSnapshotFromActualData(authCtx, language, envName, "After resources init script", tailBuilder, log);
            }
            if (!skipJupyterInstall) {
                this.addResourcesEnvVariablesToJupyterKernel(language, envName, tailBuilder, log, false);
            }
            if (!skipContainerImagesBuild) {
                this.buildEnvDockerImage(desc, language, envName, tailBuilder, log, ret.messages, true);
                if (StringUtils.isNotBlank((String)pluginId)) {
                    this.cdeImageBuilderService.buildIfNeededOnPluginCodeEnvChange(pluginId, tailBuilder, ret.messages);
                }
            }
            ret.messages.withSuccess((InfoMessage.MessageCode)CodeEnvCodes.INFO_CODEENV_UPDATE_SUCCESS, "Code env '" + String.valueOf((Object)language) + "/" + envName + "' built with success");
        }
        catch (Exception e) {
            logger.error((Object)"Env update failed", (Throwable)e);
            ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        ret.messages.summarize();
        return ret;
    }

    private void updateDescWithNewInterpreter(AuthCtx authCtx, String envName, StandardPythonInterpreter newPythonInterpreter) throws IOException {
        RelFile descFile = new RelFile(new String[]{CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName, "desc.json"});
        try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
            CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)t.readObjectUnsafe(descFile, CodeEnvModel.PythonEnvDesc.class);
            if (desc.pythonInterpreter != newPythonInterpreter) {
                desc.pythonInterpreterChangeHistory.add(new CodeEnvModel.PythonInterpreterChange(desc.pythonInterpreter, t.readStringUTF8(new RelFile(new String[]{CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName, "spec", CodeEnvModel.EnvLang.PYTHON.getPackageFileName()})), System.currentTimeMillis()));
            }
            desc.pythonInterpreter = newPythonInterpreter;
            t.writeObject(descFile, (Object)desc);
            t.commit("Updated interpreter of code env " + envName);
        }
    }

    public FutureResponse<CodeEnvModel.EnvUpdateResult> startRecreateEnvAccordingToSpec(final AuthCtx authCtx, final CodeEnvModel.EnvLang language, final String envName) throws Exception {
        this.accessService.checkEnvExists(language, envName);
        final DKUtils.SmartLogTailBuilder tailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvUpdateResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvUpdateResult compute() {
                CodeEnvModel.EnvUpdateResult ret = new CodeEnvModel.EnvUpdateResult();
                try {
                    File log = new File(DesignNodeCodeEnvsService.this.getEnvLogsDir(language, envName), "updateEnvAccordingToSpec.log");
                    DKUFileUtils.mkdirsParent((File)log);
                    DesignNodeCodeEnvsService.this.recreateEnvAccordingToSpec(authCtx, language, envName, tailBuilder, log);
                }
                catch (Exception e) {
                    logger.error((Object)"Recreate env failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"recreate_python_env", (String)("Recreating " + String.valueOf((Object)language) + " environment: " + envName));
            }

            public SmartLogTail getLog() {
                return tailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvUpdateResult>>(){});
    }

    public FutureResponse<CodeEnvModel.EnvImageRebuildResult> startRebuildImage(AuthCtx authCtx, final CodeEnvModel.EnvLang language, final String envName) throws Exception {
        this.accessService.checkEnvExists(language, envName);
        final DKUtils.SmartLogTailBuilder tailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvImageRebuildResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvImageRebuildResult compute() throws Exception {
                CodeEnvModel.EnvImageRebuildResult ret = new CodeEnvModel.EnvImageRebuildResult();
                try {
                    ret.logFileName = "rebuildImage.log";
                    File log = new File(DesignNodeCodeEnvsService.this.getEnvLogsDir(language, envName), ret.logFileName);
                    DKUFileUtils.mkdirsParent((File)log);
                    if (log.exists()) {
                        log.delete();
                    }
                    CodeEnvModel.AbstractEnvDesc desc = DesignNodeCodeEnvsService.this.getEnvDesc(language, envName);
                    switch (desc.deploymentMode) {
                        case PLUGIN_NON_MANAGED: 
                        case AUTOMATION_NON_MANAGED_PATH: {
                            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Cannot build image for a non-managed environment");
                        }
                        case AUTOMATION_SINGLE: 
                        case AUTOMATION_VERSIONED: {
                            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal Python environment deployment kind");
                        }
                        case EXTERNAL_CONDA_NAMED: {
                            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UNSUPPORTED_OPERATION_FOR_ENV_TYPE, "Cannot build image for an external environment");
                        }
                        case PLUGIN_MANAGED: {
                            break;
                        }
                        case DESIGN_MANAGED: 
                        case DESIGN_NON_MANAGED: {
                            break;
                        }
                        default: {
                            throw new DSSInternalErrorException("Unsupported deployment mode " + String.valueOf((Object)desc.deploymentMode));
                        }
                    }
                    ret.imagesBuilt = DesignNodeCodeEnvsService.this.buildEnvDockerImage(desc, language, envName, tailBuilder, log, ret.messages, false);
                    if (!log.exists()) {
                        ret.logFileName = null;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Env image rebuild failed", (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_UPDATE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"rebuild_env_image", (String)("Rebuild image for " + String.valueOf((Object)language) + " environment: " + envName));
            }

            public SmartLogTail getLog() {
                return tailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvImageRebuildResult>>(){});
    }

    public <D extends CodeEnvModel.AbstractEnvDesc> CodeEnvModel.EnvSpecData<D> getEnvSpecData(CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        CodeEnvModel.EnvSpecData ret = new CodeEnvModel.EnvSpecData();
        try (Transaction t = this.accessService.getTransactionProvider().retrieveOrBeginRead();){
            ret.desc = (CodeEnvModel.AbstractEnvDesc)t.readObjectUnsafe(new RelFile(new String[]{envLang.getFolderName(), envName, "desc.json"}), envLang.getDescClazz());
            if (((CodeEnvModel.AbstractEnvDesc)ret.desc).deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DESIGN_MANAGED || ((CodeEnvModel.AbstractEnvDesc)ret.desc).deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED || ((CodeEnvModel.AbstractEnvDesc)ret.desc).deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL) {
                ret.condaEnvSpec = this.readIfExists((TransactionRef)t, new RelFile(new String[]{envLang.getFolderName(), envName, "spec", "environment.spec"}));
                ret.packageList = this.readIfExists((TransactionRef)t, new RelFile(new String[]{envLang.getFolderName(), envName, "spec", envLang.getPackageFileName()}));
                ret.resourcesInitScript = this.readIfExists((TransactionRef)t, new RelFile(new String[]{envLang.getFolderName(), envName, "spec", "resources_init.py"}));
            }
        }
        return ret;
    }

    public void updateSpecFromPlugin(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, File pluginEnvFolder) throws IOException {
        this.importSpecToDirectory(authCtx, envLang, envName, pluginEnvFolder);
    }

    public void updateSpecFromInternalResources(AuthCtx authCtx, DSSInternalCodeEnvsService.DSSInternalCodeEnv dssInternalCodeEnv, DKUtils.SmartLogTailBuilder tailBuilder, File log) throws IOException {
        tailBuilder.appendLine("Updating code environment spec from DSS internal resources ...");
        CodeEnvUtilsBase.addLogHeader(authCtx, log, "update internal code env spec", "");
        String envName = dssInternalCodeEnv.getCodeEnvName();
        File envFolder = dssInternalCodeEnv.getResourceSpecFolder();
        this.importSpecToDirectory(authCtx, CodeEnvModel.EnvLang.PYTHON, envName, envFolder, true, true);
    }

    private CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> updateEnvAccordingToSpec(AuthCtx authCtx, CodeEnvModel.EnvLang language, String envName, CodeEnvModel.CodeEnvUpdateSettings updateSettings, DKUtils.SmartLogTailBuilder tailBuilder, File log) throws Exception {
        tailBuilder.appendLine("Updating code environment according to spec ...");
        File actualEnvFolder = this.actualEnvFolder(language, envName);
        CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> specData = this.getEnvSpecData(language, envName);
        if (!FeatureFlags.isEnabled((String)"skipCodeEnvLocalBuild")) {
            switch (language) {
                case PYTHON: {
                    if (((CodeEnvModel.AbstractEnvDesc)specData.desc).conda) {
                        CodeEnvPackageSystems.CONDA_PYTHON.install(authCtx, actualEnvFolder, (CodeEnvModel.AbstractEnvDesc)specData.desc, true, specData.condaEnvSpec, true, ((CodeEnvModel.AbstractEnvDesc)specData.desc).conda, tailBuilder, log, CodeEnvPackageSystems.getCodeEnvSettings(specData.desc));
                    }
                    CodeEnvPackageSystems.PIP.install(authCtx, actualEnvFolder, (CodeEnvModel.AbstractEnvDesc)specData.desc, true, specData.packageList, updateSettings.upgradeAllPackages, ((CodeEnvModel.AbstractEnvDesc)specData.desc).conda, tailBuilder, log, CodeEnvPackageSystems.getCodeEnvSettings(specData.desc));
                    break;
                }
                case R: {
                    if (((CodeEnvModel.AbstractEnvDesc)specData.desc).conda) {
                        CodeEnvPackageSystems.CONDA_R.install(authCtx, actualEnvFolder, (CodeEnvModel.AbstractEnvDesc)specData.desc, true, specData.condaEnvSpec, true, ((CodeEnvModel.AbstractEnvDesc)specData.desc).conda, tailBuilder, log, CodeEnvPackageSystems.getCodeEnvSettings(specData.desc));
                    }
                    CodeEnvPackageSystems.R.install(authCtx, actualEnvFolder, (CodeEnvModel.AbstractEnvDesc)specData.desc, true, specData.packageList, updateSettings.upgradeAllPackages, ((CodeEnvModel.AbstractEnvDesc)specData.desc).conda, tailBuilder, log, CodeEnvPackageSystems.getCodeEnvSettings(specData.desc));
                }
            }
            this.updateEnvSnapshotFromActualData(authCtx, language, envName, "Updated packages", tailBuilder, log);
        } else {
            tailBuilder.appendLine("Skipping local build");
        }
        return specData;
    }

    private void recreateEnvAccordingToSpec(AuthCtx authCtx, CodeEnvModel.EnvLang language, String envName, DKUtils.SmartLogTailBuilder tailBuilder, File log) throws Exception {
        CodeEnvModel.EnvSpecData specData = this.getEnvSpecData(language, envName);
        switch (language) {
            case PYTHON: {
                this.recreatePythonEnv(authCtx, envName, (CodeEnvModel.PythonEnvDesc)specData.desc, tailBuilder, log);
                break;
            }
            case R: {
                this.recreateREnv(authCtx, envName, (CodeEnvModel.REnvDesc)specData.desc, tailBuilder, log);
            }
        }
    }

    public static String getResourcesPath(CodeEnvModel.EnvLang envLang, String envName) {
        return ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "resources", envLang.getFolderName(), envName}).getAbsolutePath();
    }

    public PythonCodeEnvUtils.AddResourcesZipResult uploadResourcesZip(CodeEnvModel.EnvLang envLang, String envName, String relativePath, InputStream resourcesInputStream, String resourcesFileName, boolean overwrite) throws IOException {
        File resourcesFolder = new File(DesignNodeCodeEnvsService.getResourcesPath(envLang, envName));
        return PythonCodeEnvUtils.addResourcesZip(resourcesFolder, relativePath, resourcesInputStream, resourcesFileName, overwrite);
    }

    public FSBrowsePath browseResourcesDir(CodeEnvModel.EnvLang envLang, String envName, String relativePath, boolean withDirectoriesSize) throws DKUSecurityException, IOException {
        return FSBrowsePath.browse((String)DesignNodeCodeEnvsService.getResourcesPath(envLang, envName), (String)relativePath, (boolean)withDirectoriesSize);
    }

    public void clearResourcesDir(CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        File resourcesDir = new File(DesignNodeCodeEnvsService.getResourcesPath(envLang, envName));
        if (resourcesDir.exists()) {
            DKUFileUtils.forceDelete((File)resourcesDir);
        }
    }

    public CodeEnvModel.CodeEnvResourcesEnvVariables getResourcesEnvVars(CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        CodeEnvModel.CodeEnvResourcesEnvVariables resourcesEnvVariables = new CodeEnvModel.CodeEnvResourcesEnvVariables();
        try (Transaction t = this.accessService.getTransactionProvider().retrieveOrBeginRead();){
            RelFile resourcesEnvRelFile;
            if (envLang == CodeEnvModel.EnvLang.PYTHON && t.exists(resourcesEnvRelFile = new RelFile(new String[]{envLang.getFolderName(), envName, "actual", "resources_env.json"}))) {
                resourcesEnvVariables = (CodeEnvModel.CodeEnvResourcesEnvVariables)JSON.parseFile((File)t.resolve(resourcesEnvRelFile), CodeEnvModel.CodeEnvResourcesEnvVariables.class);
            }
        }
        return resourcesEnvVariables;
    }

    public CodeEnvModel.CodeEnvResourcesModelsMeta getResourcesModelsMeta(String envName) throws IOException {
        CodeEnvModel.CodeEnvResourcesModelsMeta resourcesModelsMeta = new CodeEnvModel.CodeEnvResourcesModelsMeta();
        if (StringUtils.isNotBlank((String)envName)) {
            try (Transaction t = this.accessService.getTransactionProvider().retrieveOrBeginRead();){
                RelFile resourcesModelsMetaFile = new RelFile(new String[]{CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName, "actual", "models_meta.json"});
                if (t.exists(resourcesModelsMetaFile)) {
                    resourcesModelsMeta = (CodeEnvModel.CodeEnvResourcesModelsMeta)JSON.parseFile((File)t.resolve(resourcesModelsMetaFile), CodeEnvModel.CodeEnvResourcesModelsMeta.class);
                    IReflectedEventsService.ReflectedEvent event = new IReflectedEventsService.ReflectedEvent("codeenv-list-resources-models", JSON.toJsonObject(resourcesModelsMeta.getResourcesModelsMetaSizes()));
                    this.pubSubService.publish((DSSEvent)new ReflectedEventEvent(event));
                }
            }
        }
        return resourcesModelsMeta;
    }

    public void exportEnvDefToFS(CodeEnvModel.EnvLang envLang, String envName, ReadWriteFS targetFS) throws IOException {
        try (Transaction t = this.accessService.getTransactionProvider().retrieveOrBeginRead();){
            RelFile sourceEnvDir = new RelFile(new String[]{envLang.getFolderName(), envName});
            if (!t.exists(new RelFile(sourceEnvDir, new String[]{"desc.json"}))) {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV, "Code env '" + envName + "' doesn't exist");
            }
            logger.info((Object)("Exporting env from " + sourceEnvDir.getFullPath()));
            if (t.exists(new RelFile(sourceEnvDir, new String[]{"spec"}))) {
                targetFS.makeDirectory(new RelFile(new String[]{"spec"}));
            }
            if (t.exists(new RelFile(sourceEnvDir, new String[]{"actual"}))) {
                targetFS.makeDirectory(new RelFile(new String[]{"actual"}));
            }
            ArrayList toCopy = Lists.newArrayList();
            toCopy.add(new Pair((Object)new RelFile(sourceEnvDir, new String[]{"spec", "environment.spec"}), (Object)new RelFile(new String[]{"spec", "environment.spec"})));
            toCopy.add(new Pair((Object)new RelFile(sourceEnvDir, new String[]{"spec", envLang.getPackageFileName()}), (Object)new RelFile(new String[]{"spec", envLang.getPackageFileName()})));
            toCopy.add(new Pair((Object)new RelFile(sourceEnvDir, new String[]{"actual", "environment.spec"}), (Object)new RelFile(new String[]{"actual", "environment.spec"})));
            toCopy.add(new Pair((Object)new RelFile(sourceEnvDir, new String[]{"actual", envLang.getPackageFileName()}), (Object)new RelFile(new String[]{"actual", envLang.getPackageFileName()})));
            toCopy.add(new Pair((Object)new RelFile(sourceEnvDir, new String[]{"spec", "resources_init.py"}), (Object)new RelFile(new String[]{"spec", "resources_init.py"})));
            for (Pair pair : toCopy) {
                logger.info((Object)("Copying " + ((RelFile)pair.first).getFullPath() + " to " + ((RelFile)pair.second).getFullPath()));
                if (t.exists((RelFile)pair.first)) {
                    FSUtils.newRecursiveCopy().from((ReadOnlyFS)t, (RelFile)pair.first).to(targetFS, (RelFile)pair.second).run();
                    continue;
                }
                logger.info((Object)"  -> nothing to copy");
            }
            CodeEnvModel.AbstractEnvDesc desc = switch (envLang) {
                case CodeEnvModel.EnvLang.PYTHON -> (CodeEnvModel.AbstractEnvDesc)t.readObject(new RelFile(sourceEnvDir, new String[]{"desc.json"}), CodeEnvModel.PythonEnvDesc.class);
                case CodeEnvModel.EnvLang.R -> (CodeEnvModel.AbstractEnvDesc)t.readObject(new RelFile(sourceEnvDir, new String[]{"desc.json"}), CodeEnvModel.REnvDesc.class);
                default -> throw new Error("unreachable");
            };
            desc.owner = null;
            desc.usableByAll = true;
            desc.permissions.clear();
            targetFS.writeObjectNoMkdir(new RelFile(new String[]{"desc.json"}), (Object)desc);
        }
    }

    public void exportEnvDefToDirectory(CodeEnvModel.EnvLang envLang, String envName, File targetDirectory) throws IOException {
        logger.info((Object)("Exporting env " + envName + " to " + targetDirectory.getAbsolutePath()));
        this.exportEnvDefToFS(envLang, envName, (ReadWriteFS)NativeFS.from((File)targetDirectory).build());
    }

    public void exportEnvDefStandalone(CodeEnvModel.EnvLang envLang, String envName, File targetDirectory) throws IOException {
        File subTargetDirectory = new File(targetDirectory, envLang.getFolderName());
        subTargetDirectory.mkdir();
        this.exportEnvDefToDirectory(envLang, envName, subTargetDirectory);
    }

    public void importSpecToDirectory(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, File sourceDirectory) throws IOException {
        this.importSpecToDirectory(authCtx, envLang, envName, sourceDirectory, false, false);
    }

    public void importSpecToDirectory(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, String envName, File sourceDirectory, boolean syncPresetFields, boolean clearSpec) throws IOException {
        try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
            NativeFS sourceFS = NativeFS.from((File)sourceDirectory).build();
            RelFile targetEnvDir = new RelFile(new String[]{envLang.getFolderName(), envName});
            logger.info((Object)("Importing env from " + sourceDirectory.getAbsolutePath() + " to " + targetEnvDir.getFullPath()));
            RelFile specFolder = new RelFile(targetEnvDir, new String[]{"spec"});
            if (clearSpec) {
                t.deleteDirectory(specFolder);
            }
            ArrayList toCopy = Lists.newArrayList();
            toCopy.add(new Pair((Object)new RelFile(new String[]{"spec"}), (Object)specFolder));
            toCopy.add(new Pair((Object)new RelFile(new String[]{"spec", "environment.spec"}), (Object)new RelFile(specFolder, new String[]{"environment.spec"})));
            toCopy.add(new Pair((Object)new RelFile(new String[]{"spec", envLang.getPackageFileName()}), (Object)new RelFile(specFolder, new String[]{envLang.getPackageFileName()})));
            toCopy.add(new Pair((Object)new RelFile(new String[]{"spec", "resources_init.py"}), (Object)new RelFile(specFolder, new String[]{"resources_init.py"})));
            for (Pair pair : toCopy) {
                logger.info((Object)("Copying " + ((RelFile)pair.first).getFullPath() + " to " + ((RelFile)pair.second).getFullPath()));
                if (sourceFS.exists((RelFile)pair.first)) {
                    FSUtils.newRecursiveCopy().from((ReadOnlyFS)sourceFS, (RelFile)pair.first).to((ReadWriteFS)t, (RelFile)pair.second).run();
                    continue;
                }
                logger.info((Object)"  -> nothing to copy");
            }
            if (envLang == CodeEnvModel.EnvLang.PYTHON && syncPresetFields) {
                RelFile envDescFile = new RelFile(targetEnvDir, new String[]{"desc.json"});
                RelFile presetDescFile = new RelFile(new String[]{"desc.json"});
                if (sourceFS.exists(presetDescFile)) {
                    CodeEnvModel.PythonEnvDesc presetDesc = (CodeEnvModel.PythonEnvDesc)sourceFS.readObject(presetDescFile, CodeEnvModel.PythonEnvDesc.class);
                    if (t.exists(envDescFile)) {
                        CodeEnvModel.PythonEnvDesc envDesc = (CodeEnvModel.PythonEnvDesc)t.readObjectUnsafe(envDescFile, CodeEnvModel.PythonEnvDesc.class);
                        envDesc.corePackagesSet = presetDesc.corePackagesSet;
                        envDesc.installCorePackages = presetDesc.installCorePackages;
                        envDesc.predefinedContainerHooks = presetDesc.predefinedContainerHooks;
                        t.writeObject(envDescFile, (Object)envDesc);
                    } else {
                        logger.warnV("Code env desc file not found in %s: will import whole desc file from %s", new Object[]{targetEnvDir.getFullPath(), sourceDirectory.getAbsolutePath()});
                        presetDesc.owner = authCtx.getIdentifier();
                        presetDesc.usableByAll = true;
                        presetDesc.permissions.clear();
                        presetDesc.versionTag = presetDesc.creationTag = VersionTag.increment(null, authCtx.getIdentifier());
                        t.writeObject(envDescFile, (Object)presetDesc);
                    }
                } else {
                    throw new IllegalArgumentException("Unable to import predefined container hooks, no desc file found in " + sourceDirectory.getAbsolutePath());
                }
            }
            t.commit("Importing specs from " + sourceDirectory.getAbsolutePath());
        }
    }

    public FutureResponse<CodeEnvModel.EnvCreationResult> startImportEnvDefStandalone(AuthCtx authCtx, String owner, File zipFile, CodeEnvModel.CodeEnvUpdateSettings updateSettings) throws Exception {
        AutoDelete unzipDir = CodeEnvImportUtils.getTempImportFolder("import-" + zipFile.getName());
        ZipUnzipDir.extractFolder(zipFile, (File)unzipDir);
        CodeEnvModel.EnvLang envLang = null;
        File descDir = null;
        for (CodeEnvModel.EnvLang el : CodeEnvModel.EnvLang.values()) {
            if (!new File((File)unzipDir, el.getFolderName()).exists() || !new File(descDir = new File((File)unzipDir, el.getFolderName()), "desc.json").exists()) continue;
            envLang = el;
        }
        if (envLang == null) {
            throw new CodedException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INVALID_CODE_ENV_ARCHIVE, "No known code env type in the zip");
        }
        String envName = FilenameUtils.getBaseName((String)zipFile.getName());
        envName = envName.replaceAll("[^A-z0-9\\-_\\.]", "_");
        StringTransmogrifier st2 = new StringTransmogrifier();
        for (CodeEnvModel.CodeEnvListItem existing : this.listCodeEnvs()) {
            st2.addAlreadyTransmogrified(existing.envName);
        }
        String creationEnvName = st2.transmogrify(envName);
        logger.info((Object)("Importing a " + String.valueOf((Object)envLang) + " code env as " + creationEnvName));
        File descFile = new File(descDir, "desc.json");
        CodeEnvModel.AbstractEnvDesc spec = switch (envLang) {
            case CodeEnvModel.EnvLang.PYTHON -> (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.PythonEnvDesc.class);
            case CodeEnvModel.EnvLang.R -> (CodeEnvModel.AbstractEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.REnvDesc.class);
            default -> throw new Error("unreachable");
        };
        spec.owner = authCtx.getIdentifier();
        return this.startImportEnv(authCtx, owner, spec.deploymentMode, creationEnvName, envLang, descDir, (File)unzipDir, updateSettings);
    }

    private void writeInitialEnvSnapshot(AuthCtx authCtx, CodeEnvModel.EnvLang lang, String envName, CodeEnvModel.AbstractEnvDesc envDesc, String reason, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        switch (lang) {
            case PYTHON: {
                CodeEnvModel.PythonEnvActualData fullData = this.computePyEnvActualData(authCtx, envName, logTailBuilder, log);
                try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
                    this.writeInitialPackagesAndDesc(lang, envName, fullData, envDesc, t);
                    CodeEnvModel.PythonEnvInfo envInfo = new CodeEnvModel.PythonEnvInfo();
                    envInfo.pythonVersion = fullData.pythonVersion;
                    t.writeObject(new RelFile(new String[]{lang.getFolderName(), envName, "actual", "info.json"}), (Object)envInfo);
                    t.writeStringUTF8(new RelFile(new String[]{lang.getFolderName(), envName, "spec", "resources_init.py"}), "");
                    t.commit(reason);
                    break;
                }
            }
            case R: {
                CodeEnvModel.REnvActualData fullData = this.computeREnvActualData(authCtx, envName, logTailBuilder, log);
                try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
                    this.writeInitialPackagesAndDesc(lang, envName, fullData, envDesc, t);
                    t.commit(reason);
                    break;
                }
            }
        }
    }

    private void writeInitialPackagesAndDesc(CodeEnvModel.EnvLang envLang, String envName, CodeEnvModel.AbstractEnvActualData fullData, CodeEnvModel.AbstractEnvDesc envDesc, RWTransaction t) throws IOException {
        if (fullData.conda) {
            t.writeStringUTF8(new RelFile(new String[]{envLang.getFolderName(), envName, "spec", "environment.spec"}), "");
        }
        t.writeStringUTF8(new RelFile(new String[]{envLang.getFolderName(), envName, "spec", envLang.getPackageFileName()}), "");
        t.writeObject(new RelFile(new String[]{envLang.getFolderName(), envName, "desc.json"}), (Object)envDesc);
    }

    private void updateEnvSnapshotFromActualData(AuthCtx authCtx, CodeEnvModel.EnvLang lang, String envName, String reason, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        switch (lang) {
            case PYTHON: {
                CodeEnvModel.PythonEnvActualData fullData = this.computePyEnvActualData(authCtx, envName, logTailBuilder, log);
                try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
                    this.updateEnvSnapshotFromActualData(lang, envName, fullData, t);
                    CodeEnvModel.PythonEnvInfo envInfo = new CodeEnvModel.PythonEnvInfo();
                    envInfo.pythonVersion = fullData.pythonVersion;
                    t.writeObject(new RelFile(new String[]{lang.getFolderName(), envName, "actual", "info.json"}), (Object)envInfo);
                    t.commit(reason);
                    break;
                }
            }
            case R: {
                CodeEnvModel.REnvActualData fullData = this.computeREnvActualData(authCtx, envName, logTailBuilder, log);
                RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);
                try {
                    this.updateEnvSnapshotFromActualData(lang, envName, fullData, t);
                    t.commit(reason);
                    if (t == null) break;
                }
                catch (Throwable throwable) {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                t.close();
                break;
            }
        }
    }

    private void updateEnvSnapshotFromActualData(CodeEnvModel.EnvLang envLang, String envName, CodeEnvModel.AbstractEnvActualData fullData, RWTransaction t) throws IOException {
        if (fullData.conda) {
            t.writeStringUTF8(new RelFile(new String[]{envLang.getFolderName(), envName, "actual", "environment.spec"}), fullData.condaEnvSpec);
        }
        t.writeStringUTF8(new RelFile(new String[]{envLang.getFolderName(), envName, "actual", envLang.getPackageFileName()}), fullData.nocondaEnvSpec);
    }

    public List<String> buildEnvDockerImage(CodeEnvModel.AbstractEnvDesc spec, CodeEnvModel.EnvLang lang, String envName, DKUtils.SmartLogTailBuilder logTailBuilder, File log, InfoMessage.InfoMessages messages, boolean failIsError) throws IOException {
        ArrayList built = Lists.newArrayList();
        if (spec.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.DESIGN_MANAGED && spec.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED && spec.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL) {
            logger.debug((Object)("Not building Docker image for non-managed code env " + envName));
        } else {
            List<ContainerExecImagesBuilder> imageBuilders = ContainerExecImagesBuilder.getBuilders(spec, CodeEnvPackageSystems.getCodeEnvSettings(spec), this.getEnvSpecData(lang, envName), envName, null, messages);
            if (!imageBuilders.isEmpty()) {
                logger.info((Object)("Building Docker images for code environment " + envName));
            }
            for (ContainerExecImagesBuilder imageBuilder : imageBuilders) {
                try {
                    AutoDelete buildDir = DSSTempUtils.getTempFolder((String)"docker-image", (String)("codeenv-" + envName));
                    try {
                        switch (lang) {
                            case PYTHON: {
                                this.copyPythonResources((CodeEnvModel.PythonEnvDesc)spec, lang, envName, imageBuilder, (File)buildDir);
                                imageBuilder.prepareForPythonEnv((File)buildDir);
                                break;
                            }
                            case R: {
                                imageBuilder.prepareForREnv((File)buildDir);
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("Unsupported lang " + String.valueOf((Object)lang));
                            }
                        }
                        File dockerfileDump = new File(log.getParentFile(), "Dockerfile.dump");
                        String image = imageBuilder.build((File)buildDir, logTailBuilder, log, dockerfileDump);
                        logger.info((Object)("Built Docker image " + image));
                        built.add(image);
                    }
                    finally {
                        if (buildDir == null) continue;
                        buildDir.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Building of Docker image for code env " + envName + " failed"), (Throwable)e);
                    if (failIsError) {
                        messages.withError((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CONTAINER_IMAGE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                        continue;
                    }
                    messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CONTAINER_IMAGE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
        }
        return built;
    }

    public void copyPythonResources(CodeEnvModel.PythonEnvDesc spec, CodeEnvModel.EnvLang lang, String envName, ContainerExecDockerFilePreparer imageBuilder, File buildDir) throws IOException {
        File resourcesEnvJsonFile;
        File resourcesDirectory;
        CodeEnvModel.PythonEnvDesc.DockerImageResourcesOptions dockerImageResourcesOption = spec.dockerImageResources;
        if (dockerImageResourcesOption == CodeEnvModel.PythonEnvDesc.DockerImageResourcesOptions.COPY && (resourcesDirectory = this.getEnvResourcesDir(lang, envName)).exists()) {
            logger.info((Object)"Copying resources directory to build directory");
            DKUFileUtils.copyDirectory((File)resourcesDirectory, (File)DKUFileUtils.getWithin((File)buildDir, (String[])new String[]{imageBuilder.getResourcesDir()}));
        }
        if ((resourcesEnvJsonFile = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", lang.getFolderName(), envName, "actual", "resources_env.json"})).exists()) {
            logger.info((Object)"Copying resources environment variables to build directory");
            FileUtils.copyFile((File)resourcesEnvJsonFile, (File)DKUFileUtils.getWithin((File)buildDir, (String[])new String[]{imageBuilder.getResourcesEnvJsonFile()}));
        }
    }

    public CodeEnvModel.PythonEnvActualData computePyEnvActualData(AuthCtx authCtx, String envName, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        return PythonCodeEnvUtils.computePyEnvActualData(authCtx, this.actualEnvFolder(CodeEnvModel.EnvLang.PYTHON, envName), logTailBuilder, log);
    }

    public CodeEnvModel.REnvActualData computeREnvActualData(AuthCtx authCtx, String envName, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        return RCodeEnvUtils.computeREnvActualData(authCtx, this.actualEnvFolder(CodeEnvModel.EnvLang.R, envName), logTailBuilder, log);
    }

    private String readIfExists(TransactionRef t, RelFile rf) throws IOException {
        if (t.isFile(rf)) {
            return t.readStringUTF8(rf);
        }
        return "";
    }

    private File actualEnvFolder(CodeEnvModel.EnvLang envLang, String envName) {
        switch (envLang) {
            case PYTHON: {
                return ApplicationConfigurator.getFile((String[])new String[]{"code-envs", envLang.getFolderName(), envName});
            }
            case R: {
                return ApplicationConfigurator.getFile((String[])new String[]{"code-envs", envLang.getFolderName(), envName});
            }
        }
        throw new Error("unreachable");
    }

    public FutureResponse<CodeEnvModel.EnvDeletionResult> startEnvDelete(final AuthCtx authCtx, final CodeEnvModel.EnvLang envLang, final String envName) throws Exception {
        this.accessService.checkEnvExists(envLang, envName);
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<CodeEnvModel.EnvDeletionResult>(authCtx){

            @Override
            protected CodeEnvModel.EnvDeletionResult compute() throws Exception {
                CodeEnvModel.EnvDeletionResult result = DesignNodeCodeEnvsService.this.doDeleteCodeEnv(envLang, envName, authCtx, logTailBuilder);
                DesignNodeCodeEnvsService.this.pubSubService.publish((DSSEvent)new CodeEnvChangedEvent(envName, CodeEnvChangedEvent.ActionType.DELETED, authCtx.getIdentifier()));
                return result;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"delete_env", (String)("Delete env: " + envName));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<CodeEnvModel.EnvDeletionResult>>(){});
    }

    public CodeEnvModel.EnvDeletionResult doDeleteCodeEnv(CodeEnvModel.EnvLang envLang, String envName, AuthCtx authCtx, DKUtils.SmartLogTailBuilder logTailBuilder) {
        CodeEnvModel.EnvDeletionResult ret = new CodeEnvModel.EnvDeletionResult();
        try {
            File log = ApplicationConfigurator.getFile((File)this.logsRootDir, (String[])new String[]{envLang.getFolderName(), envName, "delete.log"});
            DKUFileUtils.mkdirsParent((File)log);
            CodeEnvModel.AbstractEnvDesc envDesc = this.getEnvDesc(envLang, envName);
            try {
                CodeEnvUtilsBase.removeCodeEnvImages(envDesc, envLang, envName);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to remove code env container images", (Throwable)e);
                ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.WARN_CODEENV_CONTAINER_IMAGE_DELETION_FAILED, "Failed to remove code env container images");
            }
            try {
                this.removeJupyterSupportForEnv(authCtx, envLang, envName, logTailBuilder, log);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to remove Jupyter kernel", (Throwable)e);
                if (envDesc instanceof CodeEnvModel.PythonEnvDesc && !((CodeEnvModel.PythonEnvDesc)envDesc).installJupyterSupport) {
                    logger.info((Object)"Ignoring Jupyter uninstallation error, was not supposed to be installed");
                }
                if (envDesc instanceof CodeEnvModel.REnvDesc && !((CodeEnvModel.REnvDesc)envDesc).installJupyterSupport) {
                    logger.info((Object)"Ignoring Jupyter uninstallation error, was not supposed to be installed");
                }
                ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_JUPYTER_SUPPORT_REMOVAL_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            try {
                File envDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", envLang.getFolderName(), envName});
                DKUFileUtils.forceDelete((File)envDir);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to clean env dir", (Throwable)e);
                ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_DELETION_FAILED, "Failed to clean env dir");
            }
            try {
                File logDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "logs", envLang.getFolderName(), envName});
                DKUFileUtils.forceDelete((File)logDir);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to clean log dir", (Throwable)e);
                ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_DELETION_FAILED, "Failed to clean log dir");
            }
            try {
                this.clearResourcesDir(envLang, envName);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to clean resources dir", (Throwable)e);
                ret.messages.withWarning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_DELETION_FAILED, "Failed to clean resources dir");
            }
            try (RWTransaction t = this.accessService.getTransactionProvider().beginWrite(authCtx);){
                RelFile descDir = new RelFile(new String[]{envLang.getFolderName(), envName});
                t.deleteDirectory(descDir);
                t.commit("Deleted environment: " + envName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Env deletion failed", (Throwable)e);
            ret.messages.withFatal((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_DELETION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }

    public List<LogsService.LogDesc> listLogs(CodeEnvModel.EnvLang envLang, String envName) {
        ArrayList logs = Lists.newArrayList();
        File logsFolder = ApplicationConfigurator.getFile((File)this.logsRootDir, (String[])new String[]{envLang.getFolderName(), envName});
        if (logsFolder.exists() && logsFolder.isDirectory()) {
            for (File logFile : logsFolder.listFiles()) {
                logs.add(new LogsService.LogDesc(logFile, logsFolder));
            }
        }
        return logs;
    }

    public File getLogFile(CodeEnvModel.EnvLang envLang, String envName, String logName) throws IOException {
        File logFile = ApplicationConfigurator.getFile((File)this.logsRootDir, (String[])new String[]{envLang.getFolderName(), envName, logName});
        if (logFile.exists() && logFile.isFile()) {
            return logFile;
        }
        return null;
    }

    public SmartLogTail getLog(CodeEnvModel.EnvLang envLang, String envName, String logName) throws IOException {
        File logFile = this.getLogFile(envLang, envName, logName);
        if (logFile != null) {
            return DKUtils.smartTailFile((File)logFile, (int)500);
        }
        throw new IOException("Log file doesn't exist");
    }

    public void streamLog(CodeEnvModel.EnvLang envLang, String envName, String logName, OutputStream os) throws IOException {
        block11: {
            File logFile = this.getLogFile(envLang, envName, logName);
            if (logFile != null) {
                logger.info((Object)"Start compressed stream");
                try (GZIPOutputStream zos = new GZIPOutputStream(os);
                     FileInputStream is = new FileInputStream(logFile);){
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                    break block11;
                }
            }
            throw new IOException("Log file doesn't exist");
        }
    }

    public File getEnvLogsDir(CodeEnvModel.EnvLang envLang, String envName) {
        return ApplicationConfigurator.getFile((File)this.logsRootDir, (String[])new String[]{envLang.getFolderName(), envName});
    }

    private File getEnvResourcesDir(CodeEnvModel.EnvLang envLang, String envName) {
        return ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "resources", envLang.getFolderName(), envName});
    }

    public String updatePackagesRequirements(String specPackageList, StandardPythonInterpreter interpreter) {
        return DesignNodeCodeEnvPackagePresets.updatePackagesRequirements(specPackageList.split("\\n"), interpreter);
    }

    private static class PythonEnvInformation {
        final PythonCodeEnvPackagesUtils.PythonEnvPackages packages;
        final Set<String> builtForContainerConfs;

        private PythonEnvInformation(PythonCodeEnvPackagesUtils.PythonEnvPackages packages, Set<String> builtForContainerConfs) {
            this.packages = packages;
            this.builtForContainerConfs = builtForContainerConfs;
        }
    }

    public static class EnvsCompatibilityWithMLTask {
        String builtinEnvDescription;
        String resolvedInheritDefaultCodeEnv;
        String resolvedInheritDefaultContainer;
        Set<String> builtinIncompatibilityReasons;
        List<EnvCompatibilityWithMLTask> envs = new ArrayList<EnvCompatibilityWithMLTask>();
    }

    private static class EnvCompatibilityWithMLTask {
        final String envName;
        final String description;
        final Set<String> incompatibilityReasons;
        final Set<String> builtForContainerConfs;

        EnvCompatibilityWithMLTask(String envName, String description, Set<String> incompatibilityReasons, Set<String> builtForContainerConfs) {
            this.envName = envName;
            this.description = description;
            this.incompatibilityReasons = incompatibilityReasons;
            this.builtForContainerConfs = builtForContainerConfs;
        }
    }

    public static class CodeEnvFromPresetResult {
        String envName;
        CodeEnvFromPresetAction action;
        String reason;
    }

    private static enum CodeEnvFromPresetAction {
        CREATE,
        UPDATE,
        NONE;

    }

    public static class CodeEnvDraftConfig {
        private final UUID id;
        private final String envName;
        private final CodeEnvModel.EnvLang envLang;

        public CodeEnvDraftConfig(UUID id, String envName, CodeEnvModel.EnvLang envLang) {
            this.id = id;
            this.envName = envName;
            this.envLang = envLang;
        }
    }

    public static class CodeEnvDraft {
        private final CodeEnvDraftConfig config;
        private final CodeEnvModel.AbstractEnvDesc env;

        public CodeEnvDraft(CodeEnvDraftConfig config, CodeEnvModel.AbstractEnvDesc env) {
            this.config = config;
            this.env = env;
        }
    }
}

