/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.admin.AdminEditionController;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ProjectLibPathHelper {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.code.projectLibs");

    public static ProjectLibsPaths preparePathsWithoutCopy(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        TransactionRef t = TransactionContext.retrieveRead();
        boolean localConfigIsARealFolder = t.resolve(RelFile.root()).isDirectory();
        if (!localConfigIsARealFolder) {
            throw new IOException("Cannot prepare paths from project without copy when config is not a real on-disk folder");
        }
        ProjectLibsPaths ret = new ProjectLibsPaths();
        ret.projectKey = projectKey;
        RelFile externalLibrariesFile = new RelFile(new String[]{"projects", projectKey, "lib", "external-libraries.json"});
        DSSGitModel.ExternalLibraries externalLibraries = (DSSGitModel.ExternalLibraries)t.readObjectDefault(externalLibrariesFile, DSSGitModel.ExternalLibraries.class);
        for (String foreignProjectKey : externalLibraries.getNonNullLibrariesFromProjects()) {
            ((IPermissionsService)SpringUtils.getBean(IPermissionsService.class)).checkProjectPrivileges(authCtx, foreignProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ProjectLibPathHelper.preparePathsFromProjectWithoutCopy(foreignProjectKey, ret);
        }
        ProjectLibPathHelper.preparePathsFromProjectWithoutCopy(projectKey, ret);
        return ret;
    }

    private static void preparePathsFromProjectWithoutCopy(String projectKeyToCopyFrom, ProjectLibsPaths outputAbsolutePaths) throws IOException {
        File chunkFolder;
        logger.debug((Object)("Preparing (no copy) paths from project " + projectKeyToCopyFrom));
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile libFolder = new RelFile(new String[]{"projects", projectKeyToCopyFrom, "lib"});
        RelFile externalLibrariesFile = libFolder.appendChildPath("external-libraries.json");
        DSSGitModel.ExternalLibraries externalLibraries = (DSSGitModel.ExternalLibraries)t.readObjectDefault(externalLibrariesFile, DSSGitModel.ExternalLibraries.class);
        for (String pythonPathChunk : externalLibraries.pythonPath) {
            chunkFolder = t.resolve(libFolder.appendChildPath(pythonPathChunk));
            outputAbsolutePaths.pythonPath.add(chunkFolder.getAbsolutePath());
        }
        for (String rsrcPathChunk : externalLibraries.rsrcPath) {
            chunkFolder = t.resolve(libFolder.appendChildPath(rsrcPathChunk));
            outputAbsolutePaths.rsrcPath.add(chunkFolder.getAbsolutePath());
        }
    }

    public static void preparePathsFromProjectCopyIfNeeded(String projectKeyToCopyFrom, File workDir, ProjectLibsPaths outputAbsolutePaths) throws IOException {
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead(IsolationLevel.YOLO);){
            File dst;
            RelFile chunkFolder;
            File destRFolderPath;
            File destPythonFolderPath;
            boolean localConfigIsARealFolder = t.resolve(RelFile.root()).isDirectory();
            RelFile libRoot = AdminEditionController.GlobalCodeZone.LIB.getPath(projectKeyToCopyFrom);
            RelFile externalLibrariesFile = libRoot.appendChildPath("external-libraries.json");
            DSSGitModel.ExternalLibraries externalLibraries = new DSSGitModel.ExternalLibraries();
            if (t.isFile(externalLibrariesFile)) {
                externalLibraries = (DSSGitModel.ExternalLibraries)t.readObject(externalLibrariesFile, DSSGitModel.ExternalLibraries.class);
            } else {
                logger.warn((Object)("External libraries file not found: " + String.valueOf(externalLibrariesFile)));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("External libs definition for " + projectKeyToCopyFrom + ": " + JSON.json((Object)externalLibraries)));
            }
            if (!(destPythonFolderPath = DKUFileUtils.getWithin((File)workDir, (String[])new String[]{"project-python-libs", projectKeyToCopyFrom})).exists()) {
                destPythonFolderPath.mkdirs();
            }
            if (!(destRFolderPath = DKUFileUtils.getWithin((File)workDir, (String[])new String[]{"project-r-src", projectKeyToCopyFrom})).exists()) {
                destRFolderPath.mkdirs();
            }
            NativeFS destPythonLibFolderFS = NativeFS.from((File)destPythonFolderPath).skipFileTypeCheck(false).atomicWrite(true).rejectSymlinks(true).build();
            NativeFS destRLibFolderFS = NativeFS.from((File)destRFolderPath).skipFileTypeCheck(false).atomicWrite(true).rejectSymlinks(true).build();
            for (String pythonPathChunk : externalLibraries.getNonNullPythonPaths()) {
                chunkFolder = libRoot.appendChildPath(pythonPathChunk);
                if (((IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class)).isEnabled() || !localConfigIsARealFolder) {
                    if (!t.isDirectory(chunkFolder)) continue;
                    dst = DKUFileUtils.getWithin((File)destPythonLibFolderFS.getRoot(), (String[])new String[]{pythonPathChunk});
                    logger.debugV("Copying project %s lib chunk %s to %s", new Object[]{projectKeyToCopyFrom, chunkFolder, dst});
                    FSUtils.newRecursiveSync().from((ReadOnlyFS)t, libRoot.appendChildPath(pythonPathChunk)).to((ReadWriteFS)destPythonLibFolderFS, pythonPathChunk).overwriteMode(FSUtils.OverwriteMode.SKIP_UNLESS_HASH_CHANGED).run();
                    outputAbsolutePaths.pythonPath.add(dst.getAbsolutePath());
                    continue;
                }
                outputAbsolutePaths.pythonPath.add(t.resolve(chunkFolder).getAbsolutePath());
            }
            for (String rsrcPathChunk : externalLibraries.getNonNullRSrcPaths()) {
                chunkFolder = libRoot.appendChildPath(rsrcPathChunk);
                if (((IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class)).isEnabled() || !localConfigIsARealFolder) {
                    if (!t.isDirectory(chunkFolder)) continue;
                    dst = DKUFileUtils.getWithin((File)destRLibFolderFS.getRoot(), (String[])new String[]{rsrcPathChunk});
                    logger.debugV("Copying project %s lib chunk %s to %s", new Object[]{projectKeyToCopyFrom, chunkFolder, dst});
                    FSUtils.newRecursiveSync().from((ReadOnlyFS)t, libRoot.appendChildPath(rsrcPathChunk)).to((ReadWriteFS)destRLibFolderFS, rsrcPathChunk).overwriteMode(FSUtils.OverwriteMode.SKIP_UNLESS_HASH_CHANGED).run();
                    outputAbsolutePaths.rsrcPath.add(dst.getAbsolutePath());
                    continue;
                }
                outputAbsolutePaths.rsrcPath.add(t.resolve(chunkFolder).getAbsolutePath());
            }
        }
    }

    public static class ProjectLibsPaths {
        public String projectKey;
        public List<String> pythonPath = new ArrayList<String>();
        public List<String> rsrcPath = new ArrayList<String>();
    }
}

